// GpsTrDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

// noch zu tun:
// Online-Hilfe: fr Menu und ToolBar


#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "TrackDoc.h"
#include "GpsDoc.h"
#include "GpsTrDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CReadGpsTrackDlg dialog

extern CDimDoc* 	ptDim;      
extern CInitDoc* 	ptInit;  


/************************************************************************
 *  GpsTrDlg.cpp			C R e a d F r o m G p s D l g  Constructor	*
 ************************************************************************/
CReadGpsTrackDlg::CReadGpsTrackDlg(CWnd* pParent, CTrackDoc* ptDoc, CGpsDoc* ptGpsDoc)
	: CDlgTool(CReadGpsTrackDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CReadGpsTrackDlg)
	m_nReadMode = -1;
	m_szGPS = _T("");
	m_szState = _T("");
	m_szTrkID = _T("");
	//}}AFX_DATA_INIT

m_ptDoc		= ptDoc;
m_ptGpsDoc	= ptGpsDoc;	
m_bTimeOut	= FALSE;
m_bStop		= FALSE;
m_bOK		= FALSE;
m_bConnected= FALSE;

m_ptGrmn			= NULL;
m_ptGrmnLink1		= NULL;
m_ptGrmnLink2		= NULL;
m_ptGrmnLink1Usb	= NULL;
m_ptNmea			= NULL;
m_nTrkID	= 0;
m_uTimer	= 0;
m_ptLogFile	= NULL;
m_lTimePrev	= 0;
m_nReadMode = READMODE_ALL;	

m_bHeaderReceived	= FALSE;
m_nRecords			= 0;
m_lRecordsReceived	= 0;
m_ptCachedTrackDoc	= NULL;
}

/************************************************************************
 *  GpsTrDlg.cpp		~ C R e a d F r o m G p s D l g		DESTRUCTOR	*
 ************************************************************************/
CReadGpsTrackDlg::~CReadGpsTrackDlg()
{
	if (m_ptGrmn != NULL)
	{
		m_ptGrmn->Close();
		delete m_ptGrmn;
		m_ptGrmn = NULL;
	}

	if (m_ptGrmnLink1 != NULL)
	{
		m_ptGrmnLink1->Close();
		delete m_ptGrmnLink1;
		m_ptGrmnLink1 = NULL;
	}

	if (m_ptGrmnLink2 != NULL)
	{
		m_ptGrmnLink2->Close();
		delete m_ptGrmnLink2;
		m_ptGrmnLink2 = NULL;
	}

	if (m_ptGrmnLink1Usb != NULL)
	{
		m_ptGrmnLink1Usb->Close();
		delete m_ptGrmnLink1Usb;
		m_ptGrmnLink1Usb = NULL;
	}


	if (m_ptNmea != NULL)
	{
		m_ptNmea->Close();
		delete m_ptNmea;
		m_ptNmea = NULL;
	}

	if (m_nReadMode == READMODE_ALL)
	{
		DeleteArrayOf(&m_CachedTrackDocs);
	}
	else
	{
		if (m_ptCachedTrackDoc != NULL)
		{
			delete m_ptCachedTrackDoc;
			m_ptCachedTrackDoc = NULL;
		}
	}

	if (m_ptLogFile != NULL)
	{
		m_ptLogFile->Close();
		delete m_ptLogFile;
		m_ptLogFile = NULL;
	}
}

/************************************************************************
 *  GpsTrDlg.cpp			D e l e t e A r r a y O f 					*
 ************************************************************************/
void CReadGpsTrackDlg::DeleteArrayOf (CPtrArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CTrackDoc* ptEntry;
	if ((ptEntry = (CTrackDoc*)ptArray->GetAt(i)) != NULL)
		{
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}                
 

void CReadGpsTrackDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CReadGpsTrackDlg)
	DDX_Radio(pDX, ID_GTREADALL, m_nReadMode);
	DDX_Text(pDX, ID_GTGPS, m_szGPS);
	DDX_Text(pDX, ID_GTSTATE, m_szState);
	DDX_Text(pDX, ID_GTNUM, m_szTrkID);
	//}}AFX_DATA_MAP

	if (pDX->m_bSaveAndValidate)
	{        
		if (m_szTrkID.GetLength() == 0)
			pDX->Fail();	// 	DDX_Text(pDX, ID_GTNUM, m_szTrkID); must be last DDX_...
		else
			m_nTrkID = this->ConvertToTrkNum(m_szTrkID);
	}
}


BEGIN_MESSAGE_MAP(CReadGpsTrackDlg, CDlgTool)
	//{{AFX_MSG_MAP(CReadGpsTrackDlg)
	ON_MESSAGE (WM_GPSEVENT, OnGpsEvent)
	ON_BN_CLICKED(ID_GTREADALL, OnReadModeAll)
	ON_BN_CLICKED(ID_GTREADSPEC, OnReadModeSpec)
	ON_BN_CLICKED(ID_GTREAD, OnReadTrack)
	ON_WM_TIMER()
	ON_WM_HELPINFO()
	ON_BN_CLICKED(ID_GTREADLAST, OnReadModeLast)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/************************************************************************
 *  GpsTrDlg.cpp			S a v e L a s t T r k						*
 ************************************************************************/
BOOL CReadGpsTrackDlg::SaveLastTrk(CTrackDoc* ptTrkDoc, short nTrkID)
{
	BOOL bSaved = FALSE;
	if (ptTrkDoc->GetCnt() > 0)
	{
									// first try to use date to get name
		CString szFullPath  = ptTrkDoc->GetPathName();
		if (CInitDoc::FileExists(szFullPath))		// if this file is already present,
		{										// use name: TrackXX.way
			CString szPath = ptInit->GetActualPath();	// without NameExt
			szFullPath.Format ("%sTrack%02d.trk", (LPCTSTR)szPath, nTrkID);
			ptTrkDoc->SetPathName (szFullPath);
		}

		bSaved = ptTrkDoc->OnSaveDocument(szFullPath);
		WaitTenthSec (WAIT_TIME);
	}

	return bSaved;
}


/************************************************************************
 *  GpsTrDlg.cpp			I n i t G P S S e r i a l					*
 ************************************************************************/
BOOL CReadGpsTrackDlg::InitGPSSerial(short nInpLen, short nOutLen) 
{
BOOL bInit = FALSE;

	if (m_ptGrmn != NULL)
	{
		m_ptGrmn->BinMode();
		bInit = m_ptGrmn->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink1 != NULL)
	{
		m_ptGrmnLink1->BinMode();
		bInit = m_ptGrmnLink1->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink2 != NULL)
	{
		m_ptGrmnLink2->BinMode();
		bInit = m_ptGrmnLink2->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink1Usb != NULL)
	{		// USB: m_ptGpsDoc->GetPortID() = 8, else 1-7
		bInit = m_ptGrmnLink1Usb->OpenUSB(m_ptGpsDoc->GetUsbListIndex(), nInpLen, nOutLen);

		short nLastEventFromGPS = CGarminLink1UsbEvent::Pid_Xfer_Cmplt;
		m_ptGrmnLink1Usb->SetStopThreadEvent(nLastEventFromGPS);
	}

	if (m_ptNmea != NULL)
	{
		m_ptNmea->BinMode();
		bInit = m_ptNmea->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	return bInit;
}

/************************************************************************
 *  GpsTrDlg.cpp	    R e c e i v e G a r m i n L i n k 1 T r a c k	*
 ************************************************************************/
BOOL CReadGpsTrackDlg::ReceiveGarminLink1Track (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
BOOL bTimeOut;
CGarminLink1Event GarminEvent;

bTimeOut = m_ptGrmnLink1->GetNextGarminEvent (&GarminEvent);

HandleGarminLink1Event(&GarminEvent, ptRequestIDCnt, ptOK, ptStop, ptConnected, ptFile);

if (bTimeOut && (*ptRequestIDCnt)>0 && (*ptRequestIDCnt)<3)
    {
    bTimeOut = FALSE;
	m_ptGrmnLink1->SendProductRqst ();
    (*ptRequestIDCnt)++;
    }

return bTimeOut;
}

/************************************************************************
 *  GpsTrDlg.cpp	    H a n d l e G a r m i n L i n k 1 E v e n t		*
 ************************************************************************/
BOOL CReadGpsTrackDlg::HandleGarminLink1Event (CGarminLink1Event* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
BOOL  bRead;
Product_Data_Type	productData;

switch (ptGarminEvent->GetFunction())
    {
    case CGarminLink1Event::Pid_Product_Data:
		m_nActTrkID		= -1;
		m_szActTrkName.Empty();
		m_bNameReceived = FALSE;
		*ptRequestIDCnt = 0;

		ptGarminEvent->OnReadProduct (&productData, ptFile);
		m_szGPS = productData.product_description;
		this->SetText(ID_GTGPS, m_szGPS);

		m_ptGrmnLink1->SetProtocols(productData.product_ID, 100.*productData.software_version);

		*ptConnected = TRUE;
		m_bPrev = FALSE;

		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
	
		WaitTenthSec (WAIT_TIME);
		m_ptGrmnLink1->SimulateProtocolArray();	// try to read protocol array or simulate event
		break;

	case CGarminLink1Event::Pid_Protocol_Array:
		if (m_ptGrmnLink1->IsRealCommand())
		{
			m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
			m_ptGrmnLink1->SplitProtocols (ptGarminEvent->GetDataPtr(), 
										ptGarminEvent->GetDataLen(), ptFile);
			m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		}
											// send main command
		m_ptGrmnLink1->SendCommand (CGarminLink1Event::Cmnd_Transfer_Trk);
		break;

	case CGarminLink1Event::Pid_Version_Terrain_DB:
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		break;

    case CGarminLink1Event::Pid_Records:
		m_nRecords = ptGarminEvent->SplitNumbOfCmds ();
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		m_lRecordsReceived = 0;
		m_nWptCnt = 0;
		break;

    case CGarminLink1Event::Pid_Trk_Hdr:
		m_lRecordsReceived++;

		if (m_nActTrkID >= 0 && m_nWptCnt > 1)
		{					// already one track received:
			if (m_nReadMode == READMODE_ALL)
			{
				m_CachedTrackDocs.Add(m_ptCachedTrackDoc);

				if (ptFile != NULL)
				{
					long    lLen;
					char	szBuffer[256];
					lLen = sprintf (szBuffer, "\r\nHandleGarminLink1Event: Total: %ld, Track=%d mit %d Punkten gelesen.\r\n\r\n", m_lRecordsReceived, m_nActTrkID, m_nWptCnt);
					if (ptFile != NULL)
						ptFile->Write ((const void*)szBuffer, (UINT)lLen);
				}
			}
		}

		if (m_ptGrmnLink1->GetTrkHdrProt() == D310_Trk_Hdr)
		{
			BOOL bDisplay;
			char cColor;
									// m_szActTrkName may be date like: "22-AUG-03"
			m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
			ptGarminEvent->SplitD310TrackHeader(ptFile, &bDisplay, &cColor, &m_szActTrkName);
				// for A301 Track Log Transfer Protocol only...
			m_nActTrkID++;
			m_bHeaderReceived=TRUE;
			m_bNameReceived = (m_szActTrkName.GetLength()>0);
		}

		if (m_ptGrmnLink1->GetTrkHdrProt() == D311_Trk_Hdr)
		{
			m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
			ptGarminEvent->SplitD311TrackHeader(ptFile, &m_nActTrkID);
			m_bHeaderReceived=TRUE;
		}

		if (m_ptGrmnLink1->GetTrkHdrProt() == D312_Trk_Hdr)
		{
			BOOL bDisplay;
			char cColor;
									// m_szActTrkName may be date like: "22-AUG-03"
			m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
			ptGarminEvent->SplitD312TrackHeader(ptFile, &bDisplay, &cColor, &m_szActTrkName);
			m_nActTrkID++;
			m_bHeaderReceived=TRUE;
			m_bNameReceived = (m_szActTrkName.GetLength()>0);
		}
		
		m_bFirstStopTrk = FALSE;
		m_nWptCnt = 0;

		m_szState = this->Format (IDF_RDTRKFOUND, m_nActTrkID);  
		this->SetText (ID_GTSTATE, m_szState);

		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);			
		break;

    case CGarminLink1Event::Pid_Trk_Data:
		{
			double dLat = NO_KOORD;
			double dLon = NO_KOORD;
			double dAlt_ft = 0;
			double dDist_m = 0;
			double dTemp_C = 0;

			unsigned long	lTime;
			BYTE	cHeartRate, cCadence;
			BOOL bAltitude = FALSE;
			BOOL bStart= FALSE;
			BOOL bStartLap = FALSE;
			BOOL bTime = TRUE;
			BOOL bTemp = FALSE;
			BOOL bDist = FALSE;
			BOOL bSplit = FALSE;

			m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);

			if (m_ptGrmnLink1->GetTrkPointProt() == D300_Trk_Point)
			{
				bSplit = ptGarminEvent->SplitD300TrackPoint (ptFile,
								&dLat, &dLon, &lTime, &bStart);
				dAlt_ft = 0;
			}

			if (m_ptGrmnLink1->GetTrkPointProt() == D301_Trk_Point)
			{
				bSplit = ptGarminEvent->SplitD301TrackPoint (ptFile,
								&dLat, &dLon, &lTime, &dAlt_ft, &bAltitude, &bStart);
			}

			if (m_ptGrmnLink1->GetTrkPointProt() == D302_Trk_Point)
			{
				bSplit = ptGarminEvent->SplitD302TrackPoint (ptFile,
								&dLat, &dLon, &lTime, &dAlt_ft, &bAltitude, 
								&dTemp_C, &bTemp, &bStart);
			}

			if (m_ptGrmnLink1->GetTrkPointProt() == D303_Trk_Point)
			{
				bSplit = ptGarminEvent->SplitD303TrackPoint (ptFile,
								&dLat, &dLon, &lTime, &dAlt_ft, &bAltitude, 
								&cHeartRate, &m_bFirstStopTrk, &bStartLap);
			}

			if (m_ptGrmnLink1->GetTrkPointProt() == D304_Trk_Point)
			{
				bSplit = ptGarminEvent->SplitD304TrackPoint (ptFile,
								&dLat, &dLon, &lTime, &dAlt_ft, &bAltitude, 
								&dDist_m, &bDist, 
								&cHeartRate, &cCadence, &m_bFirstStopTrk, &bStartLap);
			}

			m_lRecordsReceived++;

			if (bSplit && !bStartLap)
			{
				if (bStart && !m_bHeaderReceived)
				{		// start of track recognized by trackpoint and no header event available
					if (m_nReadMode == READMODE_ALL && m_nActTrkID > -1)
					{			// store cached track now!
						m_CachedTrackDocs.Add(m_ptCachedTrackDoc);

						if (ptFile != NULL)
						{
							long    lLen;
							char	szBuffer[256];
							lLen = sprintf (szBuffer, "\r\nHandleGarminLink1Event: Total: %ld, Track=%d mit %d Punkten gelesen.\r\n\r\n", m_lRecordsReceived, m_nActTrkID, m_nWptCnt);
							if (ptFile != NULL)
								ptFile->Write ((const void*)szBuffer, (UINT)lLen);
						}
					}

					m_nActTrkID++;			// replaces header event!

					m_nWptCnt = 0;
					m_szState = this->Format (IDF_RDTRKFOUND, m_nActTrkID);  
					this->SetText (ID_GTSTATE, m_szState);
				}


				if (m_nReadMode == READMODE_SPEC)
						bRead = (m_szTrkID.CompareNoCase(m_szActTrkName) == 0) ||
								(m_nTrkID == m_nActTrkID);
				else	bRead = TRUE;		// READMODE_ALL or READMODE_LAST


				if (bRead)
				{
					StoreTrackPointInCache(dLat, dLon, m_szActTrkName, m_bNameReceived, lTime, bTime, 
						dAlt_ft, bAltitude, dDist_m, bDist, dTemp_C, bStart, ptFile);
				}
			}  // bSplit

		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		}
		break;


    case CGarminLink1Event::Pid_Xfer_Cmplt:					// Cmnd_Transfer_Trk
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		
		*ptOK = OnTransferCompleted();

		*ptStop = TRUE;
		break;

    case CGarminLink1Event::Pid_Nak_Byte:
		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		*ptStop = TRUE;
		break;


    case CGarminLink1Event::Pid_Ack_Byte:
		ptGarminEvent->SplitAcknowledge ();
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		break;

    default:
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		break;
    }

return TRUE;
}


/************************************************************************
 *  GpsTrDlg.cpp	    S t o r e T r a c k P o i n t I n C a c h e 	*
 ************************************************************************/
BOOL CReadGpsTrackDlg::StoreTrackPointInCache(double dLat, double dLon, 
											  CString szName, BOOL bName,
											  unsigned long lTime, BOOL bTime,
											  double dAlt_ft, BOOL bAltitude,
											  double dDist_m, BOOL bDist, 
											  double dTemp_C, BOOL bStart, CFile* ptFile)
{
	BOOL	bStored = FALSE;
	char	szBuffer[256];
	long	lLen;
	double	dSpeed_kt;

	CTrackPoint TrkPt;
	dSpeed_kt = 0;

	if (m_nWptCnt == 0)
	{
		if (m_nReadMode == READMODE_LAST)
		{		// we only need the last track
			if (m_ptCachedTrackDoc != NULL)
			{	// delete the previously stored one
				delete m_ptCachedTrackDoc;
				m_ptCachedTrackDoc = NULL;
			}
		}

		m_ptCachedTrackDoc = new CTrackDoc();
		if (m_ptCachedTrackDoc == NULL)
		{
			AfxMessageBox("StoreTrackPointInCache: out of memory");
			return bStored;
		}
		else
		{
		if (bTime)
			m_ptCachedTrackDoc->SetName (lTime);
		if (bName)
			m_ptCachedTrackDoc->SetName (szName);
		}
		m_dDistTravelled_m = 0.;
	}

	if (m_bPrev && bTime)
	{					// calculate speed
		unsigned long lTimeDiff_s = lTime - m_lTimePrev;
		if (lTimeDiff_s > 0)
		{
			double dPrevTT, dDist_NM;
			CLatLon LLAct (dLat, dLon);
			dDist_NM = LLAct.LoxoDist (m_LLPrev, &dPrevTT);
			dSpeed_kt = dDist_NM * 3600/lTimeDiff_s;
			TrkPt.SetSpeed (dSpeed_kt, TRUE);	// use Speed = TRUE
			
			m_dDistTravelled_m += ptDim->ConvertDist (dDist_NM, DIM_NM, DIM_METER);
		}
	}

	if (bTime)
	{		// store actual lat, lon, time to calculate speed
		m_LLPrev.SetLat (dLat);
		m_LLPrev.SetLon (dLon);
		m_lTimePrev = lTime;
		m_bPrev = TRUE;
	}

	if (!bDist)
	{
		bDist = TRUE;
		dDist_m = m_dDistTravelled_m;
	}

	lLen = sprintf (szBuffer, "\nStoreTrackPointInCache: Lat=%f, Lon=%f, bStart=%d", dLat, dLon, bStart);
	if (ptFile != NULL)
		ptFile->Write ((const void*)szBuffer, (UINT)lLen);

			// copy track into TrackDoc here
	TrkPt.SetLatLon (dLat, dLon, TRUE);	// bLatLon = TRUE
	TrkPt.SetTime (lTime);
	TrkPt.SetAlt ((long)dAlt_ft, bAltitude);	// in DIM_FEET
	TrkPt.SetDist((long)dDist_m, bDist);		// in DIM_METER
	TrkPt.SetStart(bStart);

	m_ptCachedTrackDoc->SetDimensions (DIM_FEET, DIM_KT, DIM_METER);
	if (m_ptCachedTrackDoc->AppendWpt (TrkPt))
	{
		m_nWptCnt++;
		m_szState = this->Format (IDF_RDTRKWPT, m_nWptCnt);  
//		this->SetText (ID_GTSTATE, m_szState);	// better to show m_nActTrkID only

		lLen = sprintf (szBuffer, "\nStoreTrackPointInCache: Appended!\n\n");
		if (ptFile != NULL)
			ptFile->Write ((const void*)szBuffer, (UINT)lLen);

		bStored = TRUE;
	}

	return bStored;
}


/************************************************************************
 *  GpsTrDlg.cpp	    O n T r a n s f e r C o m p l e t e d			*
 ************************************************************************/
BOOL CReadGpsTrackDlg::OnTransferCompleted()
{
	BOOL bOK = FALSE;


	if (m_nRecords > 0)
	{
		CString szMsg;
		szMsg.Format (IDF_GPSRESULT, m_lRecordsReceived, m_nRecords);
		AfxMessageBox (szMsg);
	}
	

	if (m_nReadMode == READMODE_ALL)
	{		// if m_nReadMode == READMODE_ALL, there are only cached docs !!
		for (int i=0; i<m_CachedTrackDocs.GetSize(); i++)
		{		// store cached tracks and free temp events
			CTrackDoc* ptCachedTrackDoc = (CTrackDoc*)m_CachedTrackDocs.GetAt(i);
			if (ptCachedTrackDoc != NULL)
			{
				CString szTitle = ptCachedTrackDoc->GetTitle();
				m_szState = this->Format (IDF_RDTRKSAVE, (LPCTSTR)szTitle);  
				this->SetText (ID_GTSTATE, m_szState);
				SaveLastTrk(ptCachedTrackDoc, i);
			}
		}

		if (m_ptCachedTrackDoc != NULL)	// use operator = to copy last track wpts to current doc
			*m_ptDoc = *m_ptCachedTrackDoc;

		DeleteArrayOf(&m_CachedTrackDocs);	// this will also delete m_ptCachedTrackDoc!
	}
	else
	{
		if (m_ptCachedTrackDoc != NULL)	// use operator = to copy last track wpts to current doc
			*m_ptDoc = *m_ptCachedTrackDoc;
	}

	if (m_ptDoc->GetCnt() > 0)
	{
		m_ptDoc->SetModifiedFlag (TRUE);	// to enable save as in TrackDlg
		m_szState = this->Format (IDF_RDTRKCLOSE, (LPCTSTR)m_szTrkID);  
		this->SetText (ID_GTSTATE, m_szState);
		bOK = TRUE;
	}

	return bOK;
}

/************************************************************************
 *  GpsTrDlg.cpp    H a n d l e G a r m i n L i n k 1 U s b E v e n t	*
 ************************************************************************/
BOOL CReadGpsTrackDlg::HandleGarminLink1UsbEvent(CGarminLink1UsbEvent* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
BOOL  bRead;
Product_Data_Type	productData;

switch (ptGarminEvent->GetFunction())
    {
	case CGarminLink1UsbEvent::Pid_Data_Available:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		break;

    case CGarminLink1UsbEvent::Pid_Session_Started:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1Usb->SplitStartSession (ptGarminEvent->GetDataPtr(), 
										ptGarminEvent->GetDataLen(), ptFile);

		m_ptGrmnLink1Usb->SendProductRqst ();

		m_nWptCnt=0;
		break;

    case CGarminLink1UsbEvent::Pid_Product_Data:
		m_nActTrkID		= -1;
		m_szActTrkName.Empty();
		m_bNameReceived = FALSE;
		*ptRequestIDCnt = 0;

		ptGarminEvent->OnReadProduct (&productData, ptFile);
		m_szGPS = productData.product_description;
		this->SetText(ID_GTGPS, m_szGPS);

		m_ptGrmnLink1Usb->SetProtocols(productData.product_ID, 100.*productData.software_version);

		*ptConnected = TRUE;
		m_bPrev = FALSE;

		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
	
		WaitTenthSec (WAIT_TIME);
		m_ptGrmnLink1Usb->SimulateProtocolArray();	// try to read protocol array or simulate event
		break;

	case CGarminLink1UsbEvent::Pid_Version_Terrain_DB:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		break;

	case CGarminLink1UsbEvent::Pid_Protocol_Array:
		if (m_ptGrmnLink1Usb->IsRealCommand())
		{
			m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
			m_ptGrmnLink1Usb->SplitProtocols (ptGarminEvent->GetDataPtr(), 
										ptGarminEvent->GetDataLen(), ptFile);
		}
											// send main command
		m_ptGrmnLink1Usb->SendCommand (CGarminLink1UsbEvent::Cmnd_Transfer_Trk);

		break;


    case CGarminLink1UsbEvent::Pid_Records:
		m_nRecords = ptGarminEvent->SplitNumbOfCmds (ptFile);
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		m_lRecordsReceived = 0;
		m_nWptCnt = 0;
		break;

    case CGarminLink1UsbEvent::Pid_Trk_Hdr:
		m_lRecordsReceived++;

		if (m_nActTrkID >= 0 && m_nWptCnt > 1)
		{					// already one track received:
			if (m_nReadMode == READMODE_ALL)
			{
				m_CachedTrackDocs.Add(m_ptCachedTrackDoc);

				if (ptFile != NULL)
				{
					long    lLen;
					char	szBuffer[256];
					lLen = sprintf (szBuffer, "\r\nHandleGarminLink1UsbEvent: Total: %ld, Track=%d mit %d Punkten gelesen.\r\n\r\n", m_lRecordsReceived, m_nActTrkID, m_nWptCnt);
					if (ptFile != NULL)
						ptFile->Write ((const void*)szBuffer, (UINT)lLen);
				}
			}
		}

		if (m_ptGrmnLink1Usb->GetTrkHdrProt() == D310_Trk_Hdr)
		{
			BOOL bDisplay;
			char cColor;
									// m_szActTrkName may be date like: "22-AUG-03"
			m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
			ptGarminEvent->SplitD310TrackHeader(ptFile, &bDisplay, &cColor, &m_szActTrkName);
				// for A301 Track Log Transfer Protocol only...
			m_nActTrkID++;
			m_bHeaderReceived=TRUE;
			m_bNameReceived = (m_szActTrkName.GetLength()>0);

		}

		if (m_ptGrmnLink1Usb->GetTrkHdrProt() == D311_Trk_Hdr)
		{
			m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
			ptGarminEvent->SplitD311TrackHeader(ptFile, &m_nActTrkID);
			m_bHeaderReceived=TRUE;
		}

		if (m_ptGrmnLink1Usb->GetTrkHdrProt() == D312_Trk_Hdr)
		{
			BOOL bDisplay;
			char cColor;
									// m_szActTrkName may be date like: "22-AUG-03"
			m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
			ptGarminEvent->SplitD312TrackHeader(ptFile, &bDisplay, &cColor, &m_szActTrkName);
			m_nActTrkID++;
			m_bHeaderReceived=TRUE;
			m_bNameReceived = (m_szActTrkName.GetLength()>0);
		}

		
		m_bFirstStopTrk = FALSE;
		m_nWptCnt = 0;

		m_szState = this->Format (IDF_RDTRKFOUND, m_nActTrkID);  
		this->SetText (ID_GTSTATE, m_szState);
		break;

    case CGarminLink1UsbEvent::Pid_Trk_Data:
		{
			double dLat = NO_KOORD;
			double dLon = NO_KOORD;
			double dAlt_ft = 0;
			double dDist_m = 0;
			double dTemp_C = 0;
			unsigned long lTime = 0;
			BYTE	cHeartRate = 0;
			BYTE	cCadence = 0;

			BOOL bAltitude = FALSE;
			BOOL bStart= FALSE;
			BOOL bStartLap = FALSE;
			BOOL bTime = TRUE;
			BOOL bTemp = FALSE;
			BOOL bDist = FALSE;
			BOOL bSplit = FALSE;

			m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);

			if (m_ptGrmnLink1Usb->GetTrkPointProt() == D300_Trk_Point)
			{
				bSplit = ptGarminEvent->SplitD300TrackPoint (ptFile,
								&dLat, &dLon, &lTime, &bStart);
				dAlt_ft = 0;
			}

			if (m_ptGrmnLink1Usb->GetTrkPointProt() == D301_Trk_Point)
			{
				bSplit = ptGarminEvent->SplitD301TrackPoint (ptFile,
								&dLat, &dLon, &lTime, &dAlt_ft, &bAltitude, &bStart);
			}

			if (m_ptGrmnLink1Usb->GetTrkPointProt() == D302_Trk_Point)
			{
				bSplit = ptGarminEvent->SplitD302TrackPoint (ptFile,
								&dLat, &dLon, &lTime, &dAlt_ft, &bAltitude, 
								&dTemp_C, &bTemp, &bStart);
			}

			if (m_ptGrmnLink1Usb->GetTrkPointProt() == D303_Trk_Point)
			{
				bSplit = ptGarminEvent->SplitD303TrackPoint (ptFile,
								&dLat, &dLon, &lTime, &dAlt_ft, &bAltitude, 
								&cHeartRate, &m_bFirstStopTrk, &bStartLap);
			}

			if (m_ptGrmnLink1Usb->GetTrkPointProt() == D304_Trk_Point)
			{
				bSplit = ptGarminEvent->SplitD304TrackPoint (ptFile,
								&dLat, &dLon, &lTime, &dAlt_ft, &bAltitude, 
								&dDist_m, &bDist, 
								&cHeartRate, &cCadence, &m_bFirstStopTrk, &bStartLap);
			}

			m_lRecordsReceived++;


			if (bSplit && !bStartLap)
			{
				if (bStart && !m_bHeaderReceived)
				{		// start of track recognized by trackpoint and no header event available
					if (m_nReadMode == READMODE_ALL && m_nActTrkID > -1)
					{			// store cached track now!
						m_CachedTrackDocs.Add(m_ptCachedTrackDoc);

						if (ptFile != NULL)
						{
							long    lLen;
							char	szBuffer[256];
							lLen = sprintf (szBuffer, "\r\nHandleGarminLink1UsbEvent: Total: %ld, Track=%d mit %d Punkten gelesen.\r\n\r\n", m_lRecordsReceived, m_nActTrkID, m_nWptCnt);
							if (ptFile != NULL)
								ptFile->Write ((const void*)szBuffer, (UINT)lLen);
						}
					}

					m_nActTrkID++;			// replaces header event!

					m_nWptCnt = 0;
					m_szState = this->Format (IDF_RDTRKFOUND, m_nActTrkID);  
					this->SetText (ID_GTSTATE, m_szState);
				}


				if (m_nReadMode == READMODE_SPEC)
						bRead = (m_szTrkID.CompareNoCase(m_szActTrkName) == 0) ||
								(m_nTrkID == m_nActTrkID);
				else	bRead = TRUE;		// READMODE_ALL or READMODE_LAST


				if (bRead)
				{
					if(!StoreTrackPointInCache(dLat, dLon, m_szActTrkName, m_bNameReceived, lTime, bTime, 
						dAlt_ft, bAltitude, dDist_m, bDist, dTemp_C, bStart, ptFile))
					{		// out of memory
						*ptOK = FALSE;
						*ptStop = TRUE;
					}
				}
			}  // bSplit
		}
		break;


    case CGarminLink1UsbEvent::Pid_Xfer_Cmplt:					// Cmnd_Transfer_Trk
		{
			m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);

			*ptOK = OnTransferCompleted();
			*ptStop = TRUE;
		}
		break;


    default:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		return FALSE;
		break;
    }

return TRUE;
}


/************************************************************************
 *  GpsTrDlg.cpp	     R e c e i v e M a g e l l a n T r a c k		*
 ************************************************************************/
BOOL CReadGpsTrackDlg::ReceiveMagellanTrack (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
char		szBuffer[256];
BOOL 		bTimeOut = FALSE;
BOOL		bInvalid = FALSE;
CNmeaEvent 	NMEAData;	
BOOL		bStored = FALSE;  
BOOL		bStart;

do	{
	bTimeOut = m_ptNmea->GetNextNMEAEvent (&NMEAData, ptFile);
	*ptStop = bTimeOut;	   // evtl. test mouse down button here

	switch (NMEAData.GetFunction())
		{			
		case FM_MGN:
			{
			long	lLen;
			switch (NMEAData.GetMGNFunc ())
				{
				case MGN_CSM:
					{
					short nChkSum;
					NMEAData.SplitMGNCSM (&nChkSum);
					lLen = sprintf (szBuffer, "\nReceivedChk=%d", nChkSum);
					if (ptFile != NULL)
						ptFile->Write ((const void*)szBuffer, (UINT)lLen);
					}
					break;

				case MGN_CMD:
					{
					CString szCmd;
					NMEAData.SplitMGNCMD (&szCmd);

					if (szCmd.Compare ("END") == 0)			// end of track transfer
						{
						m_ptNmea->SendMGNCSM (&NMEAData);

						CNmeaEvent HandEvt(SN_PROP, FM_MGN, MGN_CMD, "HANDOFF");
						m_ptNmea->SendNMEAEvent (&HandEvt, ptFile);

						*ptOK = OnTransferCompleted();

						*ptStop = TRUE;
						}
					}
					break;

				case MGN_VER:
					{
						NMEA_MGNVER Vers;
						NMEAData.SplitMGNVER (&Vers);

						m_ptNmea->SendMGNCSM (&NMEAData);


						lLen = sprintf (szBuffer, "\nID=%d, Vers=%s, Model=%s", 
							Vers.nProdID, Vers.szRev, Vers.szModel);
						if (ptFile != NULL)
							ptFile->Write ((const void*)szBuffer, (UINT)lLen);

												// request Track
						CNmeaEvent GetTrk(SN_PROP, FM_MGN, MGN_CMD, "TRACK");
						m_ptNmea->SendNMEAEvent (&GetTrk, ptFile);

						bStart = TRUE;
						m_nWptCnt = 0;
						m_nActTrkID		= -1;
						*ptRequestIDCnt = 0;
						*ptConnected = TRUE;
						m_bPrev = FALSE;
						m_szActTrkName.Empty();
					}
					break;

				case MGN_TRK:
					{
						CTrackPoint TrkPt;		// used to convert time only
						NMEA_MGNTRK Track;
						NMEAData.SplitMGNTRK (&Track);

						m_ptNmea->SendMGNCSM (&NMEAData);

						m_lRecordsReceived++;

						if (Track.bTime)
							TrkPt.SetTime (Track.nHour, Track.nMin, Track.fSec);

						if (!bStart)
						{				// start new track if name changes
							if (Track.bName)
							{
								if (m_szActTrkName.CompareNoCase(Track.szName) != 0)
									bStart = TRUE;
							}
						}

						if (bStart)
						{
							if (m_nReadMode == READMODE_ALL && m_nActTrkID > -1)
							{			// store cached track now!
								m_CachedTrackDocs.Add(m_ptCachedTrackDoc);

								if (ptFile != NULL)
								{
									long    lLen;
									char	szBuffer[256];
									lLen = sprintf (szBuffer, "\r\nReceiveMagellanTrack: Total: %ld, Track=%d mit %d Punkten gelesen.\r\n\r\n", m_lRecordsReceived, m_nActTrkID, m_nWptCnt);
									if (ptFile != NULL)
										ptFile->Write ((const void*)szBuffer, (UINT)lLen);

								}
							}

							m_nActTrkID++;			// replaces header event!		
							if (Track.bName)
								m_szActTrkName = (CString)Track.szName;

							m_nWptCnt = 0;
							m_szState = this->Format (IDF_RDTRKFOUND, m_nActTrkID);  
							this->SetText (ID_GTSTATE, m_szState);
						}
						
						BOOL bRead;
						if (m_nReadMode == READMODE_SPEC)
								bRead = (m_nTrkID == m_nActTrkID);
						else	bRead = TRUE;

						if (bRead && Track.bLatLon)
						{						// store found wpt
							double dAlt_ft=0;
							double dDist_m=0;
							double dTemp_C=0;
							BOOL bDist = FALSE;

							if (Track.bAlt)
							{
								short nDim = (Track.cDim == 'F')? DIM_FEET : DIM_METER;
								double fConvert = ptDim->ConvertDist (Track.nAlt, nDim, DIM_FEET);
								dAlt_ft = (long)(fConvert+0.5);
							}

							StoreTrackPointInCache(Track.fLat, Track.fLon, 
									(CString)Track.szName, Track.bName, 
									TrkPt.GetSec(), Track.bTime, 
									dAlt_ft, Track.bAlt, dDist_m, bDist, dTemp_C, bStart, ptFile);
						}

						bStart = FALSE;
					}
					break;
					
				default:
					break;
				}
			}
			
		default:
			break;
		}
	} while (!*ptStop && !bStored && !bInvalid);

return bTimeOut;			
}

/////////////////////////////////////////////////////////////////////////////
// CReadGpsTrackDlg message handlers


/************************************************************************
 *  GpsTrDlg.cpp			O n I n i t D i a l o g						*
 ************************************************************************/
BOOL CReadGpsTrackDlg::OnInitDialog() 
{
	// TODO: Add extra initialization here
short nIndex;
if (m_ptGpsDoc->GetActGpsInd (&nIndex))
	{
	if (m_ptGpsDoc->GetGpsPtr (nIndex, &m_Gps))
		{
		m_nRequestIDCnt = 0;

		switch (m_Gps.GetProtocol())
		{
		case PR_GARMIN1:	// GPS100 ... GPS 100 AVD
			// no functions to read track
			break;

		case PR_GARMIN2:
			if(m_ptGpsDoc->IsUsbProtocol())
					m_ptGrmnLink1Usb = (CProtGarminLink1Usb*)new CProtGarminLink1Usb ();
			else	m_ptGrmnLink1 = (CProtGarminLink1*)new CProtGarminLink1 ();
			break;

		case PR_GARMIN3:	// GPS150
			// no functions to read track
			break;

		case PR_MAGELLAN:
			m_ptNmea = (CNmea*)new CNmea (m_Gps.GetBaudRate(),
									m_Gps.GetDataBits(),
									m_Gps.GetStopBits(), 
									NO);
			break;
		default:
			break;
		}

	    
		m_szGPS = m_Gps.GetName ();
		m_szState.LoadString (IDS_IDLE);

		m_szTrkID = m_ptGpsDoc->GetReadTrk (); 
		m_nTrkID = ConvertToTrkNum(m_szTrkID);

		if (m_nReadMode == READMODE_SPEC)
			this->SelectItem (ID_GTNUM);

		if (m_nReadMode == READMODE_ALL || m_nReadMode == READMODE_LAST)
			this->DisableControl(ID_GTNUM, TRUE);
		}
	}

CDlgTool::OnInitDialog();
	
return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  GpsTrDlg.cpp			C o n v e r t T o T r k N u m				*
 ************************************************************************/
short CReadGpsTrackDlg::ConvertToTrkNum(CString szTrkName)
{
	short nNum=0;
	if (szTrkName.GetLength() > 0)
		nNum = (short)atoi((LPCTSTR)szTrkName);
	return nNum;
}


/************************************************************************
 *  GpsTrDlg.cpp				M g n R e q u e s t I D					*
 ************************************************************************/
void CReadGpsTrackDlg::MgnRequestID(CFile* ptFile)
{
						// aktivate hand shake
	CNmeaEvent HandEvt(SN_PROP, FM_MGN, MGN_CMD, "HANDON");
	m_ptNmea->SendNMEAEvent (&HandEvt, ptFile);

						// request gps ID and version
	CNmeaEvent VersEvt(SN_PROP, FM_MGN, MGN_CMD, "VERSION");
	m_ptNmea->SendNMEAEvent (&VersEvt, ptFile);
}

/************************************************************************
 *  GpsTrDlg.cpp					O n G p s E v e n t					*
 ************************************************************************/
LONG CReadGpsTrackDlg::OnGpsEvent(UINT wParam, LONG lParam)
{
	BOOL bError = (wParam == 1);
	if (bError)
	{
		AfxMessageBox("Error received in OnGpsEvent");
		CDlgTool::OnCancel();
		return 0L;
	}


	CGarminLink1UsbEvent GarminEvent;
	short nLoops = 0;

	long lIndex = 0;		// always read first queue entry
	while (m_ptGrmnLink1Usb->GetQueueEvent (lIndex, &GarminEvent))
	{
		HandleGarminLink1UsbEvent (&GarminEvent, &m_nRequestIDCnt,
							&m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);

		CString szBuffer;
		if (m_bStop || m_bTimeOut)
		{
			if (m_ptGrmnLink1Usb != NULL)
			{
				if (m_ptGrmnLink1Usb->Close())
					this->DisableControl (ID_GTREAD, FALSE);
				if (m_ptGrmnLink1Usb->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

			if (m_bTimeOut)
			{
				short nStrID = (m_bOK)? IDS_GPSOK : IDS_GPSTIMEOUT;
				szBuffer.LoadString (nStrID);
				AfxMessageBox (szBuffer);
			}
			else
			{	// m_bStop, !m_bTimeOut
				if (m_bConnected && !m_bOK)
				{                               
					szBuffer = this->Format (IDF_RDTRKUNDEF, (LPCTSTR)m_szTrkID);
					AfxMessageBox (szBuffer);
				}
			}

			m_ptGpsDoc->SetReadTrk(m_szTrkID);
			if (m_ptLogFile != NULL)
			{
				m_ptLogFile->Close();
				delete m_ptLogFile;
				m_ptLogFile = NULL;
			}

			if (!m_ptGrmnLink1Usb->CloseReadThread(&szBuffer))
				AfxMessageBox ("Bad CloseReadThread: " + szBuffer);

			if (m_bOK)	CDlgTool::OnOK();		
				else	CDlgTool::OnCancel();
		}

		nLoops++;
		if (nLoops > 30000)
		{
			AfxMessageBox("CReadGpsTrackDlg::OnGpsEvent, nLoops > 30000");
			m_ptGrmnLink1Usb->CloseReadThread(&szBuffer);
			return 0L;
		}
	} // while Garmin Events in queue...

	return 0L;
}

/************************************************************************
 *  GpsTrDlg.cpp	  		O n R e a d M o d e A l l					*
 ************************************************************************/
void CReadGpsTrackDlg::OnReadModeAll() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->DisableControl(ID_GTNUM, TRUE);
}

/************************************************************************
 *  GpsTrDlg.cpp	  		O n R e a d M o d e L a s t					*
 ************************************************************************/
void CReadGpsTrackDlg::OnReadModeLast() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->DisableControl(ID_GTNUM, TRUE);
}

/************************************************************************
 *  GpsTrDlg.cpp	  		O n R e a d M o d e S p e c					*
 ************************************************************************/
void CReadGpsTrackDlg::OnReadModeSpec() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->DisableControl(ID_GTNUM, FALSE);
	this->SelectItem (ID_GTNUM);
}


/************************************************************************
 *  GpsTrDlg.cpp				O n R e a d T r a c k					*
 ************************************************************************/
void CReadGpsTrackDlg::OnReadTrack() 
{
	// TODO: Add your control notification handler code here
if (this->UpdateData (TRUE))
	{
//	if (TRUE) 
	if (m_ptDoc->IsDebug())
		{
		CString szFileTitle;
		szFileTitle = SaveAsTextBox (this, "Reading Track from GPS", "ReadTrk");

		if (szFileTitle.GetLength() > 0)
			{
			m_ptLogFile = new CFile ();
			m_ptLogFile->Open(szFileTitle, CFile::modeCreate | CFile::modeNoInherit | CFile::modeWrite, NULL); 
			}
		}

	if (this->InitGPSSerial(1024, 1024))
		{
		this->DisableControl (ID_GTREAD, TRUE);

		if (m_nReadMode == READMODE_ALL)
			m_szState.LoadString (IDS_RDTRKALL);
		if (m_nReadMode == READMODE_LAST)
			m_szState.LoadString (IDS_RDTRKLAST);
		if (m_nReadMode == READMODE_SPEC)
		    m_szState = this->Format (IDS_RDTRKOPEN, (LPCTSTR)m_szTrkID);  

		this->SetText (ID_GTSTATE, m_szState);


		BOOL bUsbProtocol = m_ptGpsDoc->IsUsbProtocol();
		m_bHeaderReceived = FALSE;

		switch (m_Gps.GetProtocol())
		{
		case PR_GARMIN1:		// GPS100 ... GPS 100 AVD
			m_bTimeOut = TRUE;
			break;
		case PR_GARMIN2:		// GPSLINK1
			if (bUsbProtocol)
			{
				m_ptGrmnLink1Usb->SetLogFilePtr(m_ptLogFile);
				m_ptGrmnLink1Usb->SendStartSession ();
				m_ptGrmnLink1Usb->StartReadThread(this);
				m_nRequestIDCnt++;
			}
			else
			{
				m_ptGrmnLink1->SetLogFilePtr(m_ptLogFile);
				m_ptGrmnLink1->SendProductRqst ();
				m_nRequestIDCnt++;
			}
			break;
		case PR_MAGELLAN:
			MgnRequestID(m_ptLogFile);
			break;
		default:
			m_bTimeOut = TRUE;
			break;
		}

		if (!bUsbProtocol)	
		{				// no timer for USB GPS, instead use thread event!!
			m_uTimer = SetTimer (GPS_TIMER, 500, NULL);
			if (m_uTimer == 0)
				{									/* 1/2 sec Timer	*/
				AfxMessageBox ("Bad Timer");
				CDlgTool::OnCancel();
				}
			}
		}
	}	
}

/************************************************************************
 *  GpsTrDlg.cpp				O n T i m e r							*
 ************************************************************************/
void CReadGpsTrackDlg::OnTimer(UINT nIDEvent) 
{
CString szBuffer;
BOOL	bFastMode = FALSE;

	// TODO: Add your message handler code here and/or call default
switch (nIDEvent)
	{
	case GPS_TIMER:
		this->KillTimer (m_uTimer);
;
		switch (m_Gps.GetProtocol())
		{
			case PR_GARMIN1:	// GPS100 ... GPS 100 AVD
				// no functions to read track
				break;
			case PR_GARMIN2:
				if (m_Gps.GetID() == GPSLINK1)
				{
					bFastMode = TRUE;
					m_bTimeOut = ReceiveGarminLink1Track (&m_nRequestIDCnt,
							&m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);
				}
				break;
			case PR_GARMIN3:	// GPSLINK2
				// no functions to read track
				break;
			case PR_MAGELLAN:
				if (m_Gps.GetID() == GPSMAGELLAN)
					m_bTimeOut = ReceiveMagellanTrack (&m_nRequestIDCnt,
							&m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);
				break;

			default:
				m_bTimeOut = TRUE;
				break;
		}
	
		if (m_bStop || m_bTimeOut)
		    {
			if (m_ptGrmn != NULL)
			{
				if (m_ptGrmn->Close())
					this->DisableControl (ID_GTREAD, FALSE);
				if (m_ptGrmn->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

			if (m_ptGrmnLink1 != NULL)
			{
				if (m_ptGrmnLink1->Close())
					this->DisableControl (ID_GTREAD, FALSE);
				if (m_ptGrmnLink1->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

			if (m_ptGrmnLink2 != NULL)
			{
				if (m_ptGrmnLink2->Close())
					this->DisableControl (ID_GTREAD, FALSE);
				if (m_ptGrmnLink2->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}


			if (m_ptNmea != NULL)
			{
				if (m_ptNmea->Close())
					this->DisableControl (ID_GTREAD, FALSE);
				if (m_ptNmea->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

		    if (m_bTimeOut)
				{
				short nStrID = (m_bOK)? IDS_GPSOK : IDS_GPSTIMEOUT;
				szBuffer.LoadString (nStrID);
				AfxMessageBox (szBuffer);
				}
		    else{	// m_bStop, !m_bTimeOut
				if (m_bConnected && !m_bOK)
				    {                               
					szBuffer = this->Format (IDF_RDTRKUNDEF, (LPCTSTR)m_szTrkID);
				    AfxMessageBox (szBuffer);
				    }
				}
	
			m_ptGpsDoc->SetReadTrk(m_szTrkID);
			if (m_ptLogFile != NULL)
				{
				m_ptLogFile->Close();
				delete m_ptLogFile;
				m_ptLogFile = NULL;
				}
	
			if (m_bOK)	CDlgTool::OnOK();		
				else	CDlgTool::OnCancel();
		    }
		else{
			if (bFastMode)	m_uTimer = SetTimer (GPS_TIMER, 100, NULL);
				else		m_uTimer = SetTimer (GPS_TIMER, 500, NULL);

		    if (m_uTimer == 0)
				{   // 0.5 sec Timer  
				AfxMessageBox ("Bad Timer");
				CDlgTool::OnCancel();
				}
		    }

		break;
	default:
		AfxMessageBox ("Unknown Timer in OnTimer");
		break;
	}
	
CDlgTool::OnTimer(nIDEvent);
}


/************************************************************************
 *  GpsTrDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CReadGpsTrackDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}


