#if !defined(AFX_TRGPSRT_H__4BA2B5C1_35AB_11D2_BFB4_DD4FD09F7F7F__INCLUDED_)
#define AFX_TRGPSRT_H__4BA2B5C1_35AB_11D2_BFB4_DD4FD09F7F7F__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// GpsTrDlg.h : header file
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

// CReadGpsTrackDlg dialog
#include "DlgTool.h"
#include "Garmin.h"						// includes GarminEv.h
#include "ProtGarminLink1.h"			// includes GarminLink1Ev.h
#include "ProtGarminLink2.h"			// includes GarminLink2Ev.h
#include "ProtGarminLink1Usb.h"			// includes GarminLink1UsbEv.h

class CTrackDoc;
//class CGpsDoc;
class CReadGpsTrackDlg : public CDlgTool
{
#define READMODE_ALL	0
#define READMODE_LAST	1
#define READMODE_SPEC	2

	// Construction
public:
	#define GPS_TIMER	2

	CReadGpsTrackDlg(CWnd* pParent=NULL, CTrackDoc* ptDoc=NULL, CGpsDoc* ptGpsDoc=NULL);   // standard constructor
	virtual ~CReadGpsTrackDlg();

// Dialog Data
	//{{AFX_DATA(CReadGpsTrackDlg)
	enum { IDD = IDD_GPSTRACKREADBOX };
	int		m_nReadMode;
	CString	m_szGPS;
	CString	m_szState;
	CString	m_szTrkID;
	//}}AFX_DATA

private:
	CTrackDoc*		m_ptDoc;
	CGpsDoc*		m_ptGpsDoc; 
	CGps			m_Gps;
	CGarmin*				m_ptGrmn;
	CProtGarminLink1*		m_ptGrmnLink1;
	CProtGarminLink2*		m_ptGrmnLink2;
	CProtGarminLink1Usb*	m_ptGrmnLink1Usb;
	CNmea*					m_ptNmea;

	short			m_nRequestIDCnt;
	BOOL			m_bTimeOut;
	BOOL			m_bStop;
	BOOL			m_bOK;
	BOOL			m_bConnected;
	UINT			m_uTimer;
	CFile*			m_ptLogFile;
	short			m_nRecords;
	long			m_lRecordsReceived;

	short			m_nTrkID;
	BOOL			m_bPrev;
	BOOL			m_bFirstStopTrk;
	short			m_nWptCnt;
	short  			m_nActTrkID;
	CString			m_szActTrkName;
	CLatLon			m_LLPrev;
	unsigned long	m_lTimePrev;
	BOOL			m_bHeaderReceived;
	BOOL			m_bNameReceived;
	double			m_dDistTravelled_m;
	CPtrArray		m_CachedTrackDocs;				// array of CTrackDoc*, used to cache tracks while downloading
	CTrackDoc*		m_ptCachedTrackDoc;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CReadGpsTrackDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
private:
	short ConvertToTrkNum(CString szTrkName);
	BOOL StoreTrackPointInCache(double dLat, double dLon, 
								CString szName, BOOL bName,
								unsigned long lTime, BOOL bTime,
								double dAlt_ft, BOOL bAltitude,
								double dDist_m, BOOL bDist, 
								double dTemp_C, BOOL bStart, CFile* ptFile);
	BOOL OnTransferCompleted();

	void DeleteArrayOf (CPtrArray* ptArray);
	BOOL SaveLastTrk(CTrackDoc* ptTrkDoc, short nTrkID);
	BOOL InitGPSSerial(short nInpLen, short nOutLen);


	BOOL ReceiveGarminLink1Track (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* FileSpec);

	BOOL HandleGarminLink1Event (CGarminLink1Event* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile);
	BOOL HandleGarminLink1UsbEvent(CGarminLink1UsbEvent* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile);

	void MgnRequestID(CFile* ptFile);
	BOOL ReceiveMagellanTrack (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile);


protected:

	// Generated message map functions
	//{{AFX_MSG(CReadGpsTrackDlg)
	afx_msg LONG OnGpsEvent(UINT wParam, LONG lParam);
	afx_msg void OnReadModeAll();
	afx_msg void OnReadModeSpec();
	afx_msg void OnReadTrack();
	afx_msg void OnTimer(UINT nIDEvent);
	virtual BOOL OnInitDialog();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnReadModeLast();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TRGPSRT_H__4BA2B5C1_35AB_11D2_BFB4_DD4FD09F7F7F__INCLUDED_)
