// GpsWptDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "LocDoc.h"
#include "GpsDoc.h"
#include "GpsWptDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CGpsWptDlg 

extern CDimDoc* 	ptDim;      
extern CInitDoc* 	ptInit;  

CGpsWptDlg::CGpsWptDlg(CWnd* pParent, CLocDoc* ptDoc, CGpsDoc* ptGpsDoc, BOOL bWrite)
	: CDlgTool(CGpsWptDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpsWptDlg)
	m_szState = _T("");
	m_szGPS = _T("");
	m_szFilePath = _T("");
	//}}AFX_DATA_INIT

	m_ptDoc		= ptDoc;
	m_ptGpsDoc	= ptGpsDoc; 
	m_bTimeOut	= FALSE;
	m_bStop		= FALSE;
	m_bOK		= FALSE;
	m_bConnected= FALSE;

	m_bWrite	= bWrite;

	m_ptGrmn			= NULL;
	m_ptGrmnLink1		= NULL;
	m_ptGrmnLink2		= NULL;
	m_ptGrmnLink1Usb	= NULL;
	m_ptNmea			= NULL;

	m_uTimer			= 0;
	m_ptLogFile			= NULL;
	m_nRecords			= 0;
	m_lRecordsReceived	= 0;

}

/************************************************************************
 *  GpsTrDlg.cpp		~ C G p s W p t D l g				DESTRUCTOR	*
 ************************************************************************/
CGpsWptDlg::~CGpsWptDlg()
{
	if (m_ptGrmn != NULL)
	{
		m_ptGrmn->Close();
		delete m_ptGrmn;
		m_ptGrmn = NULL;
	}

	if (m_ptGrmnLink1 != NULL)
	{
		m_ptGrmnLink1->Close();
		delete m_ptGrmnLink1;
		m_ptGrmnLink1 = NULL;
	}

	if (m_ptGrmnLink2 != NULL)
	{
		m_ptGrmnLink2->Close();
		delete m_ptGrmnLink2;
		m_ptGrmnLink2 = NULL;
	}

	if (m_ptGrmnLink1Usb != NULL)
	{
		m_ptGrmnLink1Usb->Close();
		delete m_ptGrmnLink1Usb;
		m_ptGrmnLink1Usb = NULL;
	}


	if (m_ptNmea != NULL)
	{
		m_ptNmea->Close();
		delete m_ptNmea;
		m_ptNmea = NULL;
	}

	if (m_ptLogFile != NULL)
	{
		m_ptLogFile->Close();
		delete m_ptLogFile;
		m_ptLogFile = NULL;
	}
}

void CGpsWptDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpsWptDlg)
	DDX_Text(pDX, ID_WPSTATE, m_szState);
	DDX_Text(pDX, ID_WPGPS, m_szGPS);
	DDX_Text(pDX, ID_WPFILENAME, m_szFilePath);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGpsWptDlg, CDialog)
	//{{AFX_MSG_MAP(CGpsWptDlg)
	ON_MESSAGE (WM_GPSEVENT, OnGpsEvent)
	ON_BN_CLICKED(ID_WPREAD, OnReadWptFromGPS)
	ON_BN_CLICKED(ID_WPWRITE, OnWriteWptToGPS)
	ON_WM_TIMER()
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/************************************************************************
 *  GpsTrDlg.cpp			S a v e L o c D o c							*
 ************************************************************************/
BOOL CGpsWptDlg::SaveLocDoc(CLocDoc* ptLocDoc)
{
	BOOL bSaved = FALSE;
	CString szFullPath  = ptLocDoc->GetPathName();
	bSaved = ptLocDoc->OnSaveDocument(szFullPath);
	WaitTenthSec (WAIT_TIME);

	return bSaved;
}

/************************************************************************
 *  GpsWptDlg.cpp			I n i t G P S S e r i a l					*
 ************************************************************************/
BOOL CGpsWptDlg::InitGPSSerial(short nInpLen, short nOutLen) 
{
BOOL bInit = FALSE;

	if (m_ptGrmn != NULL)
	{
		m_ptGrmn->BinMode();
		bInit = m_ptGrmn->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink1 != NULL)
	{
		m_ptGrmnLink1->BinMode();
		bInit = m_ptGrmnLink1->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink2 != NULL)
	{
		m_ptGrmnLink2->BinMode();
		bInit = m_ptGrmnLink2->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink1Usb != NULL)
	{		// USB: m_ptGpsDoc->GetPortID() = 8, else 1-7
		bInit = m_ptGrmnLink1Usb->OpenUSB(m_ptGpsDoc->GetUsbListIndex(), nInpLen, nOutLen);

		short nLastEventFromGPS;
		if (m_bWrite)	nLastEventFromGPS = CGarminLink1UsbEvent::Pid_Protocol_Array;
			else		nLastEventFromGPS = CGarminLink1UsbEvent::Pid_Xfer_Cmplt;
		m_ptGrmnLink1Usb->SetStopThreadEvent(nLastEventFromGPS);
	}

	if (m_ptNmea != NULL)
	{
		m_ptNmea->BinMode();
		bInit = m_ptNmea->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	return bInit;
}

/************************************************************************
 *  GpsWptDlg.cpp				O n A c k A 1 0 0 			 			*
 ************************************************************************/
BOOL CGpsWptDlg::OnAckA100(short nAckCmd, short nPidProt)
{
	BOOL bStop = FALSE;

	if (nPidProt == L001_Link)
	{
		switch (nAckCmd)
		{
		case CGarminLink1Event::Pid_Records:
			m_lRecordsReceived = 0;
			m_nWptCnt=0;
			// fall through !! 

		case CGarminLink1Event::Pid_Wpt_Data:
			m_lRecordsReceived++;
			if (m_nWptCnt < m_nRecords)
			{
				double	fAlt_m;
				short	nCC;

				CLocation Loc = m_ptDoc->GetLocation(WP_USER, m_nWptCnt);
				if (Loc.IsDefined())
				{
					CString szActLocName = Loc.GetName();
					m_szState = this->Format (IDS_WRRTEWPT, szActLocName);
					this->SetText (ID_WPSTATE, m_szState);

					fAlt_m = ptDim->ConvertDist ((double)Loc.GetAltitude(), Loc.GetElevDim(), DIM_METER);
					nCC = Loc.GetCC();

					m_ptGrmnLink1->SendWpt(Loc.GetLat(), Loc.GetLon(), Loc.GetName(),
							szActLocName, Loc.GetCategory(), fAlt_m, nCC);

					m_nWptCnt++;
				}
			}
			else
			{
				m_ptGrmnLink1->SendTransferCompleted(CGarminLink1Event::Cmnd_Transfer_Wpt);
			}
			break;

		case CGarminLink1Event::Pid_Xfer_Cmplt:
			bStop = TRUE;
			WaitTenthSec (WAIT_TIME);
			break;

		default:
			break;
		}
	}

/*	if (nPidProt == L002_Link)
	{
	switch (nAckCmd)
		{
		case CGarminLink2Event::Pid_Records:
			SendRouteHeader(nPidProt);
			break;

		case CGarminLink2Event::Pid_Rte_Hdr:
			m_nWptCnt = 0;
			// fall through !!

		case CGarminLink2Event::Pid_Rte_Wpt_Data:
			if (m_nWptCnt < m_ptDoc->GetWayPointCnt())
				this->WriteGarminD1xxWpt (m_nWptCnt++, m_szActLocName, nPidProt);
			else
				this->SendXferCompl(m_nWptCnt, nPidProt);
			break;

		case CGarminLink2Event::Pid_Xfer_Cmplt:
			bStop = TRUE;
			WaitTenthSec (WAIT_TIME);
			break;

		default:
			break;
		}
	}*/

	return bStop;
}

/************************************************************************
 *  GpsWptDlg.cpp	    R e c e i v e G a r m i n L i n k 1 W p t s		*
 ************************************************************************/
BOOL CGpsWptDlg::ReceiveGarminLink1Wpts (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
BOOL bTimeOut;
CGarminLink1Event GarminEvent;

bTimeOut = m_ptGrmnLink1->GetNextGarminEvent (&GarminEvent);

HandleGarminLink1Event(&GarminEvent, ptRequestIDCnt, ptOK, ptStop, ptConnected, ptFile);

if (bTimeOut && (*ptRequestIDCnt)>0 && (*ptRequestIDCnt)<3)
    {
    bTimeOut = FALSE;
	m_ptGrmnLink1Usb->SendStartSession ();
    (*ptRequestIDCnt)++;
    }

return bTimeOut;
}

/************************************************************************
 *  GpsWptDlg.cpp	    H a n d l e G a r m i n L i n k 1 E v e n t		*
 ************************************************************************/
BOOL CGpsWptDlg::HandleGarminLink1Event (CGarminLink1Event* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
Product_Data_Type	productData;
short	nPidProt;

switch (ptGarminEvent->GetFunction())
    {
    case CGarminLink1Event::Pid_Product_Data:
		*ptRequestIDCnt = 0;

		ptGarminEvent->OnReadProduct (&productData, ptFile);
		m_szGPS = productData.product_description;
		this->SetText(ID_WPGPS, m_szGPS);

		m_ptGrmnLink1->SetProtocols(productData.product_ID, 100.*productData.software_version);

		*ptConnected = TRUE;

		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
	
		WaitTenthSec (WAIT_TIME);
		m_ptGrmnLink1->SimulateProtocolArray();	// try to read protocol array or simulate event
		break;

	case CGarminLink1Event::Pid_Protocol_Array:
		if (m_ptGrmnLink1->IsRealCommand())
		{
			m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
			m_ptGrmnLink1->SplitProtocols (ptGarminEvent->GetDataPtr(), 
										ptGarminEvent->GetDataLen(), ptFile);
			m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		}

		if (m_bWrite)		// send main command		
		{
			m_nRecords = m_ptDoc->GetPlaceCnt(WP_USER);
			m_ptGrmnLink1->SendNumberOfRecords (m_ptGrmnLink1->CalcWptTransRecords(m_nRecords));
		}
		else
		{				// send main command
			m_ptGrmnLink1->SendCommand (CGarminLink1Event::Cmnd_Transfer_Wpt);
		}
		break;

	case CGarminLink1Event::Pid_Version_Terrain_DB:
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		break;

    case CGarminLink1Event::Pid_Records:
		m_nRecords = ptGarminEvent->SplitNumbOfCmds (ptFile);
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		m_lRecordsReceived = 0;
		m_nWptCnt = 0;
		break;

    case CGarminLink1Event::Pid_Wpt_Data:
		{
		    CLocation Wpt;
			char	szName[SIZEOF_ORT];
			char	szIndic[INDICATOR_SIZE];
			double	dLat, dLon;
			short	nCC;
		    unsigned char cCategory;
	
			if (ptInit->IsSaveSignal())
				MessageBeep (MB_OK);
	
			BOOL bSplit = FALSE;

			m_lRecordsReceived++;

			CGarminWpt wpt(m_ptGrmnLink1);
			bSplit = wpt.SplitRteWpt(ptGarminEvent->GetDataPtr(), ptGarminEvent->GetDataLen(),
								m_ptGrmnLink1->GetWptProt());
			CString Name, Ident;
			short nCategory;
			double dAlt_m;
			wpt.GetRteWpt(&dLat, &dLon, &Name, &Ident, &nCategory, &dAlt_m, &nCC);
			CLocation::SetName((LPSTR)szName, Name);
			CLocation::SetIndicator((LPSTR)szIndic, Ident);
			cCategory = (unsigned char)nCategory;

		
            if (ptFile != NULL)
            {
				char	szBuffer[256];
                long lLen;
                lLen = sprintf ((char*)szBuffer, 
                    "\r\nFacility=%s Indic=%s, Lat=%f, Lon=%f Alt=%fm CC=%d, Cat=%d\r\n",
                    szName, szIndic, dLat, dLon, dAlt_m, nCC, nCategory);
                ptFile->Write ((const void*)szBuffer, lLen);
            }


		    if (bSplit)
			{
				Wpt.SetLat(dLat);
				Wpt.SetLon(dLon);
				Wpt.SetCC (nCC);
				Wpt.SetCategory (cCategory);	
				Wpt.SetName ((*szName > 0)? szName : szIndic);
				if (Wpt.GetCategory() != WP_USER)
					Wpt.SetIndicator (szIndic);
 
 				Wpt.MarkNameForRte (szIndic);

				m_szState = this->Format (IDS_RDRTEWPT, szIndic);
				this->SetText (ID_WPSTATE, m_szState);
				
				if (dAlt_m == NO_ALT)
				{
					Wpt.SetElevDim(ptDim->Altitude());
					Wpt.SetAltitude ((long)ptDim->ConvertDist (5000.,
											DIM_FEET, ptDim->Altitude()));
				}
				else
				{
					Wpt.SetElevDim(DIM_METER);
					Wpt.SetAltitude((long)dAlt_m);
				}

				m_ptDoc->Add(Wpt);
				m_nWptCnt++;
			}
			m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
	    }
		break;


    case CGarminLink1Event::Pid_Xfer_Cmplt:	
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		
		*ptOK = OnTransferCompleted();
		*ptStop = TRUE;
		break;

    case CGarminLink1Event::Pid_Nak_Byte:
		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		*ptStop = TRUE;
		break;


    case CGarminLink1Event::Pid_Ack_Byte:
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		nPidProt = m_ptGrmnLink1->GetPidProt();

		*ptStop = OnAckA100(ptGarminEvent->SplitAcknowledge (), nPidProt);

		if (*ptStop)
			*ptOK = TRUE;
		break;

    default:
		m_ptGrmnLink1->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1->SendG55Reply (ptGarminEvent);
		break;
    }

return TRUE;
}

/************************************************************************
 *  GpsWptDlg.cpp	    O n T r a n s f e r C o m p l e t e d			*
 *  in read mode, copy received user waypoints to m_ptDoc				*
 ************************************************************************/
BOOL CGpsWptDlg::OnTransferCompleted()
{
	BOOL bOK = FALSE;

	if (!m_bWrite && m_nRecords>0)
	{
		CString szMsg;
		szMsg.Format (IDF_GPSRESULT, m_lRecordsReceived, m_nRecords);
		AfxMessageBox (szMsg);
	}

	if (m_nWptCnt > 0)
    {
		m_ptDoc->SetModifiedFlag (TRUE);	// to enable save as in TrackDlg
		m_szState = this->Format (IDS_RDWAYPOINTSCLOSE);  
		this->SetText (ID_WPSTATE, m_szState);
		if (!m_bWrite)
			SaveLocDoc(m_ptDoc);
		bOK = TRUE;
	}
	return bOK;
}


/************************************************************************
 *  GpsWptDlg.cpp	  H a n d l e G a r m i n L i n k 1 U s b E v e n t	*
 ************************************************************************/
BOOL CGpsWptDlg::HandleGarminLink1UsbEvent(CGarminLink1UsbEvent* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
Product_Data_Type	productData;

switch (ptGarminEvent->GetFunction())
    {
	case CGarminLink1UsbEvent::Pid_Data_Available:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		break;

    case CGarminLink1UsbEvent::Pid_Session_Started:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1Usb->SplitStartSession (ptGarminEvent->GetDataPtr(), 
										ptGarminEvent->GetDataLen(), ptFile);

		m_ptGrmnLink1Usb->SendProductRqst ();

		m_nWptCnt=0;
		break;

    case CGarminLink1UsbEvent::Pid_Product_Data:
		*ptRequestIDCnt = 0;

		ptGarminEvent->OnReadProduct (&productData, ptFile);
		m_szGPS = productData.product_description;
		this->SetText(ID_WPGPS, m_szGPS);

		m_ptGrmnLink1Usb->SetProtocols(productData.product_ID, 100.*productData.software_version);

		*ptConnected = TRUE;

		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
	
		WaitTenthSec (WAIT_TIME);
		m_ptGrmnLink1Usb->SimulateProtocolArray();	// try to read protocol array or simulate event
		break;

	case CGarminLink1UsbEvent::Pid_Version_Terrain_DB:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		break;

	case CGarminLink1UsbEvent::Pid_Protocol_Array:
		if (m_ptGrmnLink1Usb->IsRealCommand())
		{
			m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
			m_ptGrmnLink1Usb->SplitProtocols (ptGarminEvent->GetDataPtr(), 
										ptGarminEvent->GetDataLen(), ptFile);
		}

		if (m_bWrite)							// send main command		
		{
			m_nRecords = m_ptDoc->GetPlaceCnt(WP_USER);
			m_ptGrmnLink1Usb->SendNumberOfRecords (m_ptGrmnLink1Usb->CalcWptTransRecords(m_nRecords));
		
								// send all USER waypoints now...
			for (short i=0; i<m_nRecords; i++)
			{	
				CLocation Loc = m_ptDoc->GetLocation (WP_USER, i);
				if (Loc.IsDefined())
				{
					double	fAlt_m;
					short	nCC;

					CString szActLocName = Loc.GetName();
					m_szState = this->Format (IDS_WRRTEWPT, szActLocName);
					this->SetText (ID_WPSTATE, m_szState);

					fAlt_m = ptDim->ConvertDist ((double)Loc.GetAltitude(), Loc.GetElevDim(), DIM_METER);
					nCC = Loc.GetCC();

					m_ptGrmnLink1Usb->SendWpt(Loc.GetLat(), Loc.GetLon(), Loc.GetName(),
							szActLocName, Loc.GetCategory(), fAlt_m, nCC);
				}
			} 

			m_ptGrmnLink1Usb->SendTransferCompleted(CGarminLink1Event::Cmnd_Transfer_Wpt);

		    *ptOK = TRUE;
			*ptStop = TRUE;
		}
		else									// send main command
		{
			m_ptGrmnLink1Usb->SendCommand (CGarminLink1Event::Cmnd_Transfer_Wpt);
		}
		break;


    case CGarminLink1UsbEvent::Pid_Records:
		m_nRecords = ptGarminEvent->SplitNumbOfCmds (ptFile);
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		m_lRecordsReceived = 0;
		m_nWptCnt = 0;
		break;

    case CGarminLink1UsbEvent::Pid_Wpt_Data:
		{
		    CLocation Wpt;
			char	szName[SIZEOF_ORT];
			char	szIndic[INDICATOR_SIZE];
			double	dLat, dLon;
			short	nCC;
		    unsigned char cCategory;
	
			if (ptInit->IsSaveSignal())
				MessageBeep (MB_OK);
	
			BOOL bSplit = FALSE;

			m_lRecordsReceived++;

			CGarminWpt wpt(m_ptGrmnLink1);
			bSplit = wpt.SplitRteWpt(ptGarminEvent->GetDataPtr(), ptGarminEvent->GetDataLen(),
								m_ptGrmnLink1Usb->GetWptProt());
			CString Name, Ident;
			short nCategory;
			double dAlt_m;
			wpt.GetRteWpt(&dLat, &dLon, &Name, &Ident, &nCategory, &dAlt_m, &nCC);
			CLocation::SetName((LPSTR)szName, Name);
			CLocation::SetIndicator((LPSTR)szIndic, Ident);
			cCategory = (unsigned char)nCategory;

		
            if (ptFile != NULL)
            {
			    char	szBuffer[256];
                long lLen;
                lLen = sprintf ((char*)szBuffer, 
                    "\r\nFacility=%s Indic=%s, Lat=%f, Lon=%f Alt=%fm CC=%d, Cat=%d\r\n",
                    szName, szIndic, dLat, dLon, dAlt_m, nCC, nCategory);
                ptFile->Write ((const void*)szBuffer, lLen);
            }


		    if (bSplit)
			{
				Wpt.SetLat(dLat);
				Wpt.SetLon(dLon);
				Wpt.SetCC (nCC);
				Wpt.SetCategory (cCategory);	
				Wpt.SetName ((*szName > 0)? szName : szIndic);
				if (Wpt.GetCategory() != WP_USER)
					Wpt.SetIndicator (szIndic);
 
 				Wpt.MarkNameForRte (szIndic);
		
				m_szState = this->Format (IDS_RDRTEWPT, szIndic);
				this->SetText (ID_WPSTATE, m_szState);
		
				if (dAlt_m == NO_ALT)
				{
					Wpt.SetElevDim(ptDim->Altitude());
					Wpt.SetAltitude ((long)ptDim->ConvertDist (5000.,
											DIM_FEET, ptDim->Altitude()));
				}
				else
				{
					Wpt.SetElevDim(DIM_METER);
					Wpt.SetAltitude((long)dAlt_m);
				}

				m_ptDoc->Add(Wpt);
				m_nWptCnt++;
			}
	    }
		break;

    case CGarminLink1UsbEvent::Pid_Xfer_Cmplt:	
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);

		*ptOK = OnTransferCompleted();
		*ptStop = TRUE;
		break;


    default:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		return FALSE;
		break;
    }

return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CGpsWptDlg 

BOOL CGpsWptDlg::OnInitDialog() 
{
	short nIndex;
	if (m_ptGpsDoc->GetActGpsInd (&nIndex))
	{
		if (m_ptGpsDoc->GetGpsPtr (nIndex, &m_Gps))
		{
		m_nRequestIDCnt = 0;

		switch (m_Gps.GetProtocol())
			{
			case PR_GARMIN1:	// GPS100 ... GPS 100 AVD
				// no functions to read waypoint
				break;

			case PR_GARMIN2:
				if(m_ptGpsDoc->IsUsbProtocol())
						m_ptGrmnLink1Usb = (CProtGarminLink1Usb*)new CProtGarminLink1Usb ();
				else	m_ptGrmnLink1 = (CProtGarminLink1*)new CProtGarminLink1 ();
				break;

			case PR_GARMIN3:	// GPS150
				// no functions to read waypoint
				break;

			case PR_MAGELLAN:
			/*	m_ptNmea = (CNmea*)new CNmea (m_Gps.GetBaudRate(),
										m_Gps.GetDataBits(),
										m_Gps.GetStopBits(), 
										NO);*/
				break;
			default:
				break;
			}


			m_szGPS = m_Gps.GetName ();
			m_szState.LoadString (IDS_IDLE);
			m_szFilePath = m_ptDoc->GetActRegionName ();

			if (m_bWrite)
			{
				CString szText;
				szText.LoadString(IDS_WRITEINTOGPS);
				this->SetText(ID_WPMODE, szText);

				szText.LoadString(IDS_SOURCEFILE);
				this->SetText(ID_WPFILEPROMPT, szText);

				this->HideControl(ID_WPREAD, TRUE);
			}
			else
			{
				this->HideControl(ID_WPWRITE, TRUE);
			}
		}
	}

	CDialog::OnInitDialog();
	
	// TODO: Zustzliche Initialisierung hier einfgen

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

/************************************************************************
 *  GpsWptDlg.cpp					O n G p s E v e n t					*
 ************************************************************************/
LONG CGpsWptDlg::OnGpsEvent(UINT wParam, LONG lParam)
{
	BOOL bError = (wParam == 1);
	if (bError)
	{
		AfxMessageBox("Error received in OnGpsEvent");
		CDlgTool::OnCancel();
		return 0L;
	}

	
	CGarminLink1UsbEvent GarminEvent;

	long lIndex = 0;		// always read first queue entry
	while (m_ptGrmnLink1Usb->GetQueueEvent (lIndex, &GarminEvent))
	{
		HandleGarminLink1UsbEvent (&GarminEvent, &m_nRequestIDCnt,
							&m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);

		CString szBuffer;
		if (m_bStop || m_bTimeOut)
		{
			if (m_ptGrmn != NULL)
			{
				if (m_ptGrmn->Close())
					this->DisableControl (ID_WPREAD, FALSE);
				if (m_ptGrmn->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

			if (m_ptGrmnLink1Usb != NULL)
			{
				if (m_ptGrmnLink1Usb->Close())
					this->DisableControl (ID_WPREAD, FALSE);
				if (m_ptGrmnLink1Usb->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

			if (m_bTimeOut)
			{
				short nStrID = (m_bOK)? IDS_GPSOK : IDS_GPSTIMEOUT;
				szBuffer.LoadString (nStrID);
				AfxMessageBox (szBuffer);
			}
			else
			{	// m_bStop, !m_bTimeOut
				if (m_bConnected && !m_bOK)
				{                               
					AfxMessageBox (IDS_NOWAYPOINTS);
				}
			}

			if (m_ptLogFile != NULL)
			{
				m_ptLogFile->Close();
				delete m_ptLogFile;
				m_ptLogFile = NULL;
			}

			if (!m_ptGrmnLink1Usb->CloseReadThread(&szBuffer))
				AfxMessageBox ("Bad CloseReadThread: " + szBuffer);

			if (m_bOK)	CDlgTool::OnOK();		
				else	CDlgTool::OnCancel();
		}
	} // while Garmin Events in queue...

	return 0L;
}


/************************************************************************
 *  GpsWptDlg.cpp			S t a r t T r a n s m i s s i o n 			*
 ************************************************************************/
void CGpsWptDlg::StartTransmission(short nStateResID) 
{
	if (this->InitGPSSerial(1024, 1024))
	{
		if (m_bWrite)	this->DisableControl(ID_WPWRITE, TRUE);
			else		this->DisableControl(ID_WPREAD, TRUE);

		m_szState.LoadString (nStateResID);
		this->SetText (ID_WPSTATE, m_szState);


		BOOL bUsbProtocol = m_ptGpsDoc->IsUsbProtocol();

		switch (m_Gps.GetProtocol())
		{
		case PR_GARMIN1:		// GPS100 ... GPS 100 AVD
			m_bTimeOut = TRUE;
			break;
		case PR_GARMIN2:		// GPSLINK1
			if (bUsbProtocol)
			{
				m_ptGrmnLink1Usb->SendStartSession ();
				m_ptGrmnLink1Usb->StartReadThread(this);
				m_nRequestIDCnt++;
			}
			else
			{
				m_ptGrmnLink1->SendProductRqst ();
				m_nRequestIDCnt++;
			}
			break;
		case PR_MAGELLAN:
	//		MgnRequestID(m_ptLogFile);
			break;
		default:
			m_bTimeOut = TRUE;
			break;
		}

		if (!bUsbProtocol)	
		{				// no timer for USB GPS, instead use thread event!!
			m_uTimer = SetTimer (GPS_TIMER, 500, NULL);
			if (m_uTimer == 0)
			{									/* 1/2 sec Timer	*/
				AfxMessageBox ("Bad Timer");
				CDlgTool::OnCancel();
			}
		}
	}
}

/************************************************************************
 *  GpsWptDlg.cpp			O n R e a d W p t F r o m G P S 			*
 ************************************************************************/
void CGpsWptDlg::OnReadWptFromGPS() 
{
	// TODO: Add your control notification handler code here
	if (this->UpdateData (TRUE))
	{
		BOOL bDebug = FALSE;
		if (bDebug)
		{
			CString szFileTitle;
			szFileTitle = SaveAsTextBox (this, "Reading Waypoints from GPS", "ReadWpt");

			if (szFileTitle.GetLength() > 0)
			{
				m_ptLogFile = new CFile ();
				m_ptLogFile->Open(szFileTitle, CFile::modeCreate | CFile::modeNoInherit | CFile::modeWrite, NULL); 
				if (m_ptGrmnLink1 != NULL)
					m_ptGrmnLink1->SetLogFilePtr(m_ptLogFile);
				if (m_ptGrmnLink1Usb != NULL)
					m_ptGrmnLink1Usb->SetLogFilePtr(m_ptLogFile);
			}
		}
		StartTransmission(IDS_RDWAYPOINTS);
	}		
}

/************************************************************************
 *  GpsWptDlg.cpp			O n W r i t e W p t T o G P S 				*
 ************************************************************************/
void CGpsWptDlg::OnWriteWptToGPS() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	if (this->UpdateData (TRUE))
	{
		BOOL bDebug = FALSE;
		if (bDebug)
		{
			CString szFileTitle;
			szFileTitle = SaveAsTextBox (this, "Writing Waypoints to GPS", "ReadWpt");

			if (szFileTitle.GetLength() > 0)
			{
				m_ptLogFile = new CFile ();
				m_ptLogFile->Open(szFileTitle, CFile::modeCreate | CFile::modeNoInherit | CFile::modeWrite, NULL); 
				if (m_ptGrmnLink1 != NULL)
					m_ptGrmnLink1->SetLogFilePtr(m_ptLogFile);
				if (m_ptGrmnLink1Usb != NULL)
					m_ptGrmnLink1Usb->SetLogFilePtr(m_ptLogFile);
			}
		}
		StartTransmission(IDS_WRWAYPOINTS);
	}		
}

/************************************************************************
 *  GpsWptDlg.cpp				O n T i m e r							*
 ************************************************************************/
void CGpsWptDlg::OnTimer(UINT nIDEvent) 
{
	CString szBuffer;
	BOOL	bFastMode = FALSE;

		// TODO: Add your message handler code here and/or call default
	switch (nIDEvent)
	{
		case GPS_TIMER:
			this->KillTimer (m_uTimer);

			switch (m_Gps.GetProtocol())
			{
				case PR_GARMIN1:	// GPS100 ... GPS 100 AVD
					// no functions to read track
					break;
				case PR_GARMIN2:
					if (m_Gps.GetID() == GPSLINK1)
					{
						bFastMode = TRUE;
						m_bTimeOut = ReceiveGarminLink1Wpts (&m_nRequestIDCnt,
								&m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);
					}
					break;
				case PR_GARMIN3:	// GPSLINK2
					// no functions to read track
					break;
				case PR_MAGELLAN:
				//	if (m_Gps.GetID() == GPSMAGELLAN)
				//		m_bTimeOut = ReceiveMagellanWpts (&m_nRequestIDCnt,
				//				&m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);
					break;

				default:
					m_bTimeOut = TRUE;
					break;
			}
		
			if (m_bStop || m_bTimeOut)
				{
				if (m_ptGrmn != NULL)
				{
					if (m_ptGrmn->Close())
						this->DisableControl (ID_WPREAD, FALSE);
					if (m_ptGrmn->GetError() == SER_BADCLOSE)
						AfxMessageBox("bad Close Comm");
				}

				if (m_ptGrmnLink1 != NULL)
				{
					if (m_ptGrmnLink1->Close())
						this->DisableControl (ID_WPREAD, FALSE);
					if (m_ptGrmnLink1->GetError() == SER_BADCLOSE)
						AfxMessageBox("bad Close Comm");
				}

				if (m_ptGrmnLink2 != NULL)
				{
					if (m_ptGrmnLink2->Close())
						this->DisableControl (ID_WPREAD, FALSE);
					if (m_ptGrmnLink2->GetError() == SER_BADCLOSE)
						AfxMessageBox("bad Close Comm");
				}

				if (m_ptGrmnLink1Usb != NULL)
				{
					if (m_ptGrmnLink1Usb->Close())
						this->DisableControl (ID_WPREAD, FALSE);
					if (m_ptGrmnLink1Usb->GetError() == SER_BADCLOSE)
						AfxMessageBox("bad Close Comm");
				}

				if (m_ptNmea != NULL)
				{
					if (m_ptNmea->Close())
						this->DisableControl (ID_WPREAD, FALSE);
					if (m_ptNmea->GetError() == SER_BADCLOSE)
						AfxMessageBox("bad Close Comm");
				}

				if (m_bTimeOut)
					{
					short nStrID = (m_bOK)? IDS_GPSOK : IDS_GPSTIMEOUT;
					szBuffer.LoadString (nStrID);
					AfxMessageBox (szBuffer);
					}
				else{	// m_bStop, !m_bTimeOut
					if (m_bConnected && !m_bOK)
						{                               
						AfxMessageBox (IDS_NOWAYPOINTS);
						}
					}
		
				if (m_ptLogFile != NULL)
					{
					m_ptLogFile->Close();
					delete m_ptLogFile;
					m_ptLogFile = NULL;
					}
		
				if (m_bOK)	CDlgTool::OnOK();		
					else	CDlgTool::OnCancel();
				}
			else{
				if (bFastMode)	m_uTimer = SetTimer (GPS_TIMER, 100, NULL);
					else		m_uTimer = SetTimer (GPS_TIMER, 500, NULL);

				if (m_uTimer == 0)
					{   // 0.5 sec Timer  
					AfxMessageBox ("Bad Timer");
					CDlgTool::OnCancel();
					}
				}

			break;
		default:
			AfxMessageBox ("Unknown Timer in OnTimer");
			break;
	}
	
CDlgTool::OnTimer(nIDEvent);
}

/************************************************************************
 *  GpsWptDlg.cpp	  			O n H e l p I n f o						*
 ************************************************************************/
BOOL CGpsWptDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
