#if !defined(AFX_GPSWPTDLG_H__66F27435_49D1_46EC_8A3C_53E7DC7486BF__INCLUDED_)
#define AFX_GPSWPTDLG_H__66F27435_49D1_46EC_8A3C_53E7DC7486BF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// GpsWptDlg.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

// Dialogfeld CGpsWptDlg 
#include "DlgTool.h"
#include "Garmin.h"						// includes GarminEv.h
#include "ProtGarminLink1.h"			// includes GarminLink1Ev.h
#include "ProtGarminLink2.h"			// includes GarminLink2Ev.h
#include "ProtGarminLink1Usb.h"			// includes GarminLink1UsbEv.h

class CLocDoc;
class CGpsWptDlg : public CDlgTool
{
// Konstruktion
public:
	#define GPS_TIMER	2

	CGpsWptDlg(CWnd* pParent=NULL, CLocDoc* ptDoc=NULL, 
		CGpsDoc* ptGpsDoc=NULL, BOOL bWrite=TRUE);   // Standardkonstruktor
	virtual ~CGpsWptDlg();

// Dialogfelddaten
	//{{AFX_DATA(CGpsWptDlg)
	enum { IDD = IDD_GPSWAYPOINTSBOX };
	CString	m_szState;
	CString	m_szGPS;
	CString	m_szFilePath;
	//}}AFX_DATA

private:
	CLocDoc*		m_ptDoc;
	CGpsDoc*		m_ptGpsDoc; 
	BOOL			m_bWrite;

	CGps			m_Gps;
	CGarmin*				m_ptGrmn;
	CProtGarminLink1*		m_ptGrmnLink1;
	CProtGarminLink2*		m_ptGrmnLink2;
	CProtGarminLink1Usb*	m_ptGrmnLink1Usb;
	CNmea*					m_ptNmea;

	short			m_nRequestIDCnt;
	BOOL			m_bTimeOut;
	BOOL			m_bStop;
	BOOL			m_bOK;
	BOOL			m_bConnected;
	UINT			m_uTimer;
	CFile*			m_ptLogFile;
	short			m_nRecords;
	long			m_lRecordsReceived;

	short			m_nWptCnt;

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CGpsWptDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

private:
	BOOL SaveLocDoc(CLocDoc* ptLocDoc);
	BOOL InitGPSSerial(short nInpLen, short nOutLen);
	void StartTransmission(short nStateResID);
	BOOL OnAckA100(short nAckCmd, short nPidProt);


	BOOL ReceiveGarminLink1Wpts (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* FileSpec);

	BOOL HandleGarminLink1Event (CGarminLink1Event* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile);
	BOOL HandleGarminLink1UsbEvent(CGarminLink1UsbEvent* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile);
	BOOL OnTransferCompleted();


// Implementierung
protected:

	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CGpsWptDlg)
	afx_msg LONG OnGpsEvent(UINT wParam, LONG lParam);
	afx_msg void OnTimer(UINT nIDEvent);
	virtual BOOL OnInitDialog();
	afx_msg void OnReadWptFromGPS();
	afx_msg void OnWriteWptToGPS();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // AFX_GPSWPTDLG_H__66F27435_49D1_46EC_8A3C_53E7DC7486BF__INCLUDED_
