// GpsWrDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "WayDoc.h"
#include "GpsDoc.h"
#include "GpsWrDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWriteToGpsDlg dialog

extern CDimDoc* 	ptDim;      
extern CInitDoc* 	ptInit;  


/************************************************************************
 *  GpsWrDlg.cpp			C W r i t e T o G p s D l g    Constructor	*
 ************************************************************************/
CWriteToGpsDlg::CWriteToGpsDlg(CWnd* pParent, CWayDoc* ptDoc, CGpsDoc* ptGpsDoc)
	: CDlgTool(CWriteToGpsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWriteToGpsDlg)
	m_szGPS = _T("");
	m_szState = _T("");
	m_szRte = _T("");
	m_nRteID = 0;
	m_bStoreAsUserWpt = FALSE;
	//}}AFX_DATA_INIT

	m_ptDoc		= ptDoc;
	m_ptGpsDoc	= ptGpsDoc;	
	m_bTimeOut	= FALSE;
	m_bStop		= FALSE;
	m_bOK		= FALSE;
	m_bConnected= FALSE;

	m_ptGrmn			= NULL;
	m_ptGrmnLink1		= NULL;
	m_ptGrmnLink2		= NULL;
	m_ptGrmnLink1Usb	= NULL;
	m_ptNmea			= NULL;

	m_uTimer	= 0;
	m_ptLogFile	= NULL;
	m_nRecords			= 0;

	m_nTopCnt = 0;
	m_nBotCnt = 0;
}

/************************************************************************
 *  GpsWrDlg.cpp		~ C C W r i t e T o G p s D l g		DESTRUCTOR	*
 ************************************************************************/
CWriteToGpsDlg::~CWriteToGpsDlg()
{
	if (m_ptGrmn != NULL)
	{
		m_ptGrmn->Close();
		delete m_ptGrmn;
		m_ptGrmn = NULL;
	}

	if (m_ptGrmnLink1 != NULL)
	{
		m_ptGrmnLink1->Close();
		delete m_ptGrmnLink1;
		m_ptGrmnLink1 = NULL;
	}

	if (m_ptGrmnLink2 != NULL)
	{
		m_ptGrmnLink2->Close();
		delete m_ptGrmnLink2;
		m_ptGrmnLink2 = NULL;
	}

	if (m_ptGrmnLink1Usb != NULL)
	{
		m_ptGrmnLink1Usb->Close();
		delete m_ptGrmnLink1Usb;
		m_ptGrmnLink1Usb = NULL;
	}

	if (m_ptNmea != NULL)
	{
		m_ptNmea->Close();
		delete m_ptNmea;
		m_ptNmea = NULL;
	}

	if (m_ptLogFile != NULL)
	{
		m_ptLogFile->Close();
		delete m_ptLogFile;
		m_ptLogFile = NULL;
	}
}	

void CWriteToGpsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWriteToGpsDlg)
	DDX_Text(pDX, ID_GWGPS, m_szGPS);
	DDX_Text(pDX, ID_GWSTATE, m_szState);
	DDX_Text(pDX, ID_GWREQUEST, m_szRequest);
	DDX_Text(pDX, ID_GWWAY, m_szRte);
	DDX_Text(pDX, ID_GWNUM, m_szRteID);
	DDX_Check(pDX, ID_GWUSER, m_bStoreAsUserWpt);
	//}}AFX_DATA_MAP

	if (pDX->m_bSaveAndValidate)
	{        
		if (m_szRteID.GetLength() == 0)
			pDX->Fail();	// 	DDX_Text(pDX, ID_GWNUM, m_szRteID); must be last DDX_...
		else
			m_nRteID = this->ConvertToRteNum(m_szRteID);
	}

}


BEGIN_MESSAGE_MAP(CWriteToGpsDlg, CDlgTool)
	//{{AFX_MSG_MAP(CWriteToGpsDlg)
	ON_MESSAGE (WM_GPSEVENT, OnGpsEvent)
	ON_BN_CLICKED(ID_GWWRITE, OnWriteRte)
	ON_WM_TIMER()
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

	
/************************************************************************
 *  GpsWrDlg.cpp    		C h e c k R t e F o r G P S					*
 ************************************************************************/
BOOL CWriteToGpsDlg::CheckRteForGPS (CWayDoc* ptWayDoc)
{
BOOL	bOK = TRUE;
short	i;

short nCnt= ptWayDoc->GetWayPointCnt ();
for (i=0; i<nCnt && bOK; i++)
    {
	CWayPoint Wpt;
	if (ptWayDoc->GetWayPointPtr (i, &Wpt))
		{
		CString szLocName = Wpt.GetName();   
		short nType = Wpt.GetCategory();
			  
		if ((nType == WP_AIRPORT)   		// if this is a PreFlight airport 
		    && (m_Gps.GetWptType (nType) != m_Gps.GetWptType (WP_USER)))
		    {				     			// and GPS handles airports not like user wpts:
		    CString szIndic = Wpt.GetIndicator ();
		    if (szIndic.GetLength() == 0)	// => missing ICAO - abbreviation  
		    	{ 
	    		CString szBuffer = this->Format (IDF_BAD_APT_IND, szLocName);
                AfxMessageBox (szBuffer); 
                Wpt.SetCategory (WP_USER);
				ptWayDoc->ChangeWpt (i, Wpt);
	    		}  
	    	}


		if (((nType == WP_AIRPORT)   	||		// if this is a PreFlight airport 
			 (nType == WP_INTERSECTION)	||  	// or intersection
			 (nType == WP_NDB) 			||   	// or NDB
			 (nType == WP_VOR) )				// or VOR:
		    && (m_Gps.GetWptType (nType) != m_Gps.GetWptType (WP_USER)))
		    {				     			// and GPS handles airports not like user wpts:
		    CString szIndic = Wpt.GetIndicator ();
			if (szIndic.GetLength() > 0)	// => use ICAO - abbreviation  
		    	{ 
				CString szCC = Wpt.GetCountryCode();
		    	if (szCC.GetLength() == 0)
		    		{							// but there is no country code!!
		    		CString szBuffer = this->Format (IDF_MISSING_CC, szLocName);
                    AfxMessageBox (szBuffer);
		    		bOK = FALSE;
		    		}  
		    	}
		    }
		}
	}
return bOK;
}  

/************************************************************************
 *  GpsWrDlg.cpp			I n i t R t e W r i t e						*
 ************************************************************************/
BOOL CWriteToGpsDlg::InitRteWrite(short nInpLen, short nOutLen) 
{
	BOOL bInit=FALSE;

	if (m_ptGrmn != NULL)
	{
		m_ptGrmn->BinMode();
		bInit = m_ptGrmn->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink1 != NULL)
	{
		m_ptGrmnLink1->BinMode();
		bInit = m_ptGrmnLink1->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink2 != NULL)
	{
		m_ptGrmnLink2->BinMode();
		bInit = m_ptGrmnLink2->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink1Usb != NULL)
	{		// USB: m_ptGpsDoc->GetPortID() = 8, else 1-7
		bInit = m_ptGrmnLink1Usb->OpenUSB(m_ptGpsDoc->GetUsbListIndex(), nInpLen, nOutLen);

		short nLastEventFromGPS = CGarminLink1UsbEvent::Pid_Protocol_Array;
		m_ptGrmnLink1Usb->SetStopThreadEvent(nLastEventFromGPS);
	}

	if (m_ptNmea != NULL)
	{
		m_ptNmea->BinMode();
		bInit = m_ptNmea->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

return bInit;
}

/************************************************************************
 *  GpsWrDlg.cpp		     G e t W p t N a m e A n d C C				*
 ************************************************************************/
void CWriteToGpsDlg::GetWptNameAndCC (CWayPoint& Wpt, char* szActLocName, short* ptCC)
{
short nType = Wpt.GetCategory();
CString szIndic = Wpt.GetIndicator();
CString szName  = Wpt.GetName();

strcpy (szActLocName, (LPCTSTR)szName);   

if (((nType == WP_AIRPORT)   	|| 		// if this is a PreFlight airport
 	 (nType == WP_INTERSECTION) ||    	// or intersection
	 (nType == WP_NDB) 			||    	// or NDB
	 (nType == WP_VOR) )             	// or VOR:
   && (m_Gps.GetWptType (nType) != m_Gps.GetWptType (WP_USER)))
    {				     			// ... GPS handles airports not like user wpts:
    if (szIndic.GetLength() > 0)  // => use ICAO - abbreviation
		strcpy (szActLocName, (LPCTSTR)szIndic);
    }

if (nType == WP_USER)              // user way point:
   	{				     
    if (szIndic.GetLength() > 0)   		// => use ICAO - abbreviation
		strcpy (szActLocName, (LPCTSTR)szIndic);

	if (Wpt.IsUp())
		sprintf (szActLocName, "T%02d", m_nTopCnt+1);
	if (Wpt.IsDown())
		sprintf (szActLocName, "B%02d", m_nBotCnt+1);
    }

	if (nType == WP_REPORT)     // if this is a PreFlight reporting pt...
    {				     		  
		if (szIndic.GetLength() > 0)  // => use special abbreviation
		{
			strcpy (szActLocName, (LPCTSTR)szIndic);
        }
		else
		{							// => create abbreviation from name
			short nLen = szName.GetLength();
			if ((nLen > m_Gps.GetMaxWptChars()) &&
			(szName.GetAt(4) == '-') )	// Name like XXXX-D...
			{
				char	ch;
				short	i = 2;
				short	j = 0;
				do  {
					ch = szName.GetAt (i++);	// i already incremented
					if (i != 5)			// jump over '-'
						*(szActLocName+ j++) = ch;
					} while (i < nLen);
				*(szActLocName+ j) = 0;
			} 
		} 
    }

	
*ptCC = Wpt.GetCC ();	    // wpt handled like user waypoints        
if ((*ptCC == 0) ||
	(m_Gps.GetWptType (nType) == m_Gps.GetWptType (WP_USER)))
    strncpy ((char*)ptCC, "  ", 2);
}

/************************************************************************
 *  GpsWrDlg.cpp		     G e t D 1 x x W p t N a m e				*
 ************************************************************************/
void CWriteToGpsDlg::GetD1xxWptName (CWayPoint& Wpt, char* szActLocName)
{
	CString szName  = Wpt.GetName();
	CString szIndic = Wpt.GetIndicator();
	short nType = Wpt.GetCategory();

	strcpy (szActLocName, (LPCTSTR)szName);   


	if (nType == WP_USER)              // user way point:
   	{				     
		if (szIndic.GetLength() > 0)   		// => use ICAO - abbreviation
			strcpy (szActLocName, (LPCTSTR)szIndic);

		if (Wpt.IsUp())
			sprintf (szActLocName, "T%02d", m_nTopCnt+1);
		if (Wpt.IsDown())
			sprintf (szActLocName, "B%02d", m_nBotCnt+1);
    }
	else
	{
		if (szIndic.GetLength() > 0)  // => use ICAO - abbreviation
			strcpy (szActLocName, (LPCTSTR)szIndic);
	}

	if (nType == WP_REPORT)     // if this is a PreFlight reporting pt...
    {				     		  
		if (szIndic.GetLength() > 0)  // => use special abbreviation
		{
			strcpy (szActLocName, (LPCTSTR)szIndic);
        }
		else
		{							// => create abbreviation from name
			short nLen = szName.GetLength();
			if (szName.GetAt(4) == '-')		// Name like XXXX-D...
			{
				char	ch;
				short	i = 2;
				short	j = 0;
				do  {
					ch = szName.GetAt (i++);	// i already incremented
					if (i != 5)			// jump over '-'
						*(szActLocName+ j++) = ch;
					} while (i < nLen);
				*(szActLocName+ j) = 0;
			} 
		} 
    }
}

/************************************************************************
 *  GpsWrDlg.cpp			S e n d X f e r C o m p l					*
 ************************************************************************/
void CWriteToGpsDlg::SendXferCompl(short nWayNum, short nPidProt)
{
	short nWptCnt = m_ptDoc->GetWayPointCnt ();

    if (nWayNum >= m_Gps.GetMaxRteWpts() && nWayNum < nWptCnt)
	{
		MessageBeep (MB_ICONHAND);
		m_szState.LoadString (IDS_WRRTEFULL);
	}
	else
	{
		m_szState = this->Format(IDS_WRRTE_NAME_SENT, (LPCTSTR)m_szRteID);
	}

	this->SetText (ID_GWSTATE, m_szState);

	if (nPidProt == L001_Link)
	{
		if (m_ptGpsDoc->IsUsbProtocol())
			m_ptGrmnLink1Usb->SendTransferCompleted(CGarminLink1Event::Cmnd_Transfer_Rte);
		else
			m_ptGrmnLink1->SendTransferCompleted(CGarminLink1Event::Cmnd_Transfer_Rte);
	}

	if (nPidProt == L002_Link)
		m_ptGrmnLink2->SendTransferCompleted(CGarminLink2Event::Cmnd_Transfer_Rte);
}



/************************************************************************
 *  GpsWrDlg.cpp			W r i t e G a r m i n D 1 x x W p t			*
 ************************************************************************/
void CWriteToGpsDlg::WriteGarminD1xxWpt (short nWayNum,
										char* szActLocName, short nPidProt)
{
	short nWptCnt = m_ptDoc->GetWayPointCnt ();
	if (nWayNum < nWptCnt && nWayNum < m_Gps.GetMaxRteWpts())
    {
		CWayPoint Wpt;
		if (m_ptDoc->GetWayPointPtr (nWayNum, &Wpt))
		{
			double	fAlt_m;
			short	nCC;
		
			this->GetD1xxWptName (Wpt, szActLocName);
		
			m_szState = this->Format (IDS_WRRTEWPT, szActLocName);
			this->SetText (ID_GWSTATE, m_szState);
		
			fAlt_m = ptDim->ConvertDist ((double)Wpt.GetActAlt_ft(), DIM_FEET, DIM_METER);
			nCC = Wpt.GetCC();

			if (nPidProt == L001_Link)
			{
				if (m_ptGpsDoc->IsUsbProtocol())
					m_ptGrmnLink1Usb->SendRteWpt(Wpt.GetLat(), Wpt.GetLon(), Wpt.GetName(),
						szActLocName, Wpt.GetCategory(), fAlt_m, nCC, m_bStoreAsUserWpt);
				else
					m_ptGrmnLink1->SendRteWpt(Wpt.GetLat(), Wpt.GetLon(), Wpt.GetName(),
						szActLocName, Wpt.GetCategory(), fAlt_m, nCC, m_bStoreAsUserWpt);
			}
			if (nPidProt == L002_Link)
				m_ptGrmnLink2->SendRteWpt(Wpt.GetLat(), Wpt.GetLon(), Wpt.GetName(),
					szActLocName, Wpt.GetCategory(), fAlt_m, nCC, m_bStoreAsUserWpt);
		}
    }
}

/************************************************************************
 *  GpsDevice.cpp			G e t R t e H d r							*
 ************************************************************************/
CString CWriteToGpsDlg::GetRteHdr()
{
	CString szHeader;
	short nFirstID, nLastID;
	
	nFirstID = 0;
	nLastID = m_ptDoc->GetWayPointCnt() - 1;

	if (nLastID > nFirstID)
	{
		CWayPoint wpt;
		if (m_ptDoc->GetWayPointPtr(nFirstID, &wpt))
			szHeader = wpt.GetIndicator();
		szHeader += "-";
		if (m_ptDoc->GetWayPointPtr(nLastID, &wpt))
			szHeader += wpt.GetIndicator();
	}

	return szHeader;
}

/************************************************************************
 *  ProtGarminLink1.cpp		S e n d D 2 0 0 R t e H d r	  (see page 44)	*
 ************************************************************************/
BOOL CWriteToGpsDlg::SendD200RteHdr(short nPidProt)
{
	BOOL bSent = FALSE;
	unsigned char ptData[32];
	short nLen = sizeof (D200_Rte_Hdr_Type);

	D200_Rte_Hdr_Type hdr;
	memset (&hdr, 0, sizeof(D200_Rte_Hdr_Type));
	hdr = (unsigned char)m_nRteID;

	memcpy (ptData, &hdr, nLen);

	if (nPidProt == L001_Link)
	{
		if (m_ptGpsDoc->IsUsbProtocol())
			bSent = m_ptGrmnLink1Usb->SendCommand (CGarminLink1Event::Pid_Rte_Hdr, ptData, nLen);
		else
			bSent = m_ptGrmnLink1->SendCommand (CGarminLink1Event::Pid_Rte_Hdr, ptData, nLen);
	}
	if (nPidProt == L002_Link)
		bSent = m_ptGrmnLink2->SendCommand (CGarminLink2Event::Pid_Rte_Hdr, ptData, nLen);
	return bSent;
}

/************************************************************************
 *  ProtGarminLink1.cpp		S e n d D 2 0 1 R t e H d r	 (see page 44)	*
 ************************************************************************/
BOOL CWriteToGpsDlg::SendD201RteHdr(short nPidProt)
{
	BOOL bSent = FALSE;
	unsigned char ptData[32];
	short nLen = sizeof (D201_Rte_Hdr_Type);

	D201_Rte_Hdr_Type hdr;
	memset (&hdr, 0, sizeof(D201_Rte_Hdr_Type));
	hdr.nmbr = (unsigned char)m_nRteID;

	CString szRteForGps = GetRteHdr();
	if (szRteForGps.GetLength() == 9)	// use name like EDFE-EDDK
		strcpy (hdr.cmnt, (LPCTSTR)szRteForGps);
	else								// use name of document
		strcpy (hdr.cmnt, (LPCTSTR)m_szRte);

	memcpy (ptData, &hdr, nLen);

	if (nPidProt == L001_Link)
	{
		if (m_ptGpsDoc->IsUsbProtocol())
			bSent = m_ptGrmnLink1Usb->SendCommand (CGarminLink1Event::Pid_Rte_Hdr, ptData, nLen);
		else
			bSent = m_ptGrmnLink1->SendCommand (CGarminLink1Event::Pid_Rte_Hdr, ptData, nLen);
	}
	if (nPidProt == L002_Link)
		bSent = m_ptGrmnLink2->SendCommand (CGarminLink2Event::Pid_Rte_Hdr, ptData, nLen);
	return bSent;
}

/************************************************************************
 *  ProtGarminLink1.cpp		S e n d D 2 0 2 R t e H d r	  (see page 44)	*
 ************************************************************************/
BOOL CWriteToGpsDlg::SendD202RteHdr(short nPidProt)
{
	BOOL bSent = FALSE;
	unsigned char ptData[256];
	short nLen;

	CString szRteForGps;
	
	if (m_szRte.GetLength() > 0)
		 szRteForGps = m_szRteID;		// use name of route
	else szRteForGps = GetRteHdr();		// use name like EDFE-EDDK


	nLen = szRteForGps.GetLength() + 1;

	memset (ptData, 0, nLen);
	strcpy ((char*)ptData, (LPCTSTR)szRteForGps);

	if (nPidProt == L001_Link)
	{
		if (m_ptGpsDoc->IsUsbProtocol())
			bSent = m_ptGrmnLink1Usb->SendCommand (CGarminLink1Event::Pid_Rte_Hdr, ptData, nLen);
		else
			bSent = m_ptGrmnLink1->SendCommand (CGarminLink1Event::Pid_Rte_Hdr, ptData, nLen);
	}

	if (nPidProt == L002_Link)
		bSent = m_ptGrmnLink2->SendCommand (CGarminLink2Event::Pid_Rte_Hdr, ptData, nLen);
	return bSent;
}

/************************************************************************
 *  ProtGarminLink1.cpp		S e n d R o u t e H e a d e r				*
 ************************************************************************/
BOOL CWriteToGpsDlg::SendRouteHeader(short nPidProt)
{
	BOOL bSent = false;

	short nHdr;

	if (nPidProt == L001_Link)
	{
		if (m_ptGpsDoc->IsUsbProtocol())
			nHdr = m_ptGrmnLink1Usb->GetRteHdrProt();
		else
			nHdr = m_ptGrmnLink1->GetRteHdrProt();
	}

	if (nPidProt == L002_Link)
		nHdr = m_ptGrmnLink2->GetRteHdrProt();


	if (nHdr == D200_Rte_Hdr)
		bSent = SendD200RteHdr(nPidProt);
	if (nHdr == D201_Rte_Hdr)
		bSent = SendD201RteHdr(nPidProt);
	if (nHdr == D202_Rte_Hdr)
		bSent = SendD202RteHdr(nPidProt);

	return bSent;
}

/************************************************************************
 *  GpsWrDlg.cpp				O n A c k A 2 0 0 			 			*
 ************************************************************************/
BOOL CWriteToGpsDlg::OnAckA200(short nAckCmd, short nPidProt)
{
	BOOL bStop = FALSE;

	if (nPidProt == L001_Link)
	{
		switch (nAckCmd)
		{
		case CGarminLink1Event::Pid_Records:
			SendRouteHeader(nPidProt);
			break;

		case CGarminLink1Event::Pid_Rte_Hdr:
			m_nWayNum = 0;
			/* fall through !! */

		case CGarminLink1Event::Pid_Rte_Wpt_Data:
			if (m_nWayNum < m_ptDoc->GetWayPointCnt())
				this->WriteGarminD1xxWpt (m_nWayNum++, m_szActLocName, nPidProt);
			else
				this->SendXferCompl(m_nWayNum, nPidProt);
			break;

		case CGarminLink1Event::Pid_Xfer_Cmplt:
			bStop = TRUE;
			WaitTenthSec (WAIT_TIME);
			break;

		default:
			break;
		}
	}

	if (nPidProt == L002_Link)
	{
	switch (nAckCmd)
		{
		case CGarminLink2Event::Pid_Records:
			SendRouteHeader(nPidProt);
			break;

		case CGarminLink2Event::Pid_Rte_Hdr:
			m_nWayNum = 0;
			/* fall through !! */

		case CGarminLink2Event::Pid_Rte_Wpt_Data:
			if (m_nWayNum < m_ptDoc->GetWayPointCnt())
				this->WriteGarminD1xxWpt (m_nWayNum++, m_szActLocName, nPidProt);
			else
				this->SendXferCompl(m_nWayNum, nPidProt);
			break;

		case CGarminLink2Event::Pid_Xfer_Cmplt:
			bStop = TRUE;
			WaitTenthSec (WAIT_TIME);
			break;

		default:
			break;
		}
	}

	return bStop;
}

/************************************************************************
 *  ProtGarminLink1.cpp			O n A c k A 2 0 1 			 			*
 ************************************************************************/
BOOL CWriteToGpsDlg::OnAckA201(short nAckCmd, short nPidProt)
{
	BOOL bStop = FALSE;

	if (nPidProt == L001_Link)
	{
		switch (nAckCmd)
		{
		case CGarminLink1Event::Pid_Records:
			SendRouteHeader (nPidProt);
			break;

		case CGarminLink1Event::Pid_Rte_Hdr:
			m_nWayNum = 0;
			this->WriteGarminD1xxWpt (m_nWayNum++, m_szActLocName, nPidProt);
			break;


		case CGarminLink1Event::Pid_Rte_Wpt_Data:
			if (m_nWayNum < m_ptDoc->GetWayPointCnt())
				m_ptGrmnLink1->SendRouteLinkData();
			else
				this->SendXferCompl(m_nWayNum, nPidProt);
			break;

		case CGarminLink1Event::Pid_Rte_Link_Data:
			this->WriteGarminD1xxWpt (m_nWayNum++, m_szActLocName, nPidProt);
			break;


		case CGarminLink1Event::Pid_Xfer_Cmplt:
			bStop = TRUE;
			WaitTenthSec (WAIT_TIME);
			break;

		default:
			break;
		}
	}

	if (nPidProt == L002_Link)
	{
		switch (nAckCmd)
		{
		case CGarminLink2Event::Pid_Records:
			SendRouteHeader (nPidProt);
			break;

		case CGarminLink2Event::Pid_Rte_Hdr:
			m_nWayNum = 0;
			this->WriteGarminD1xxWpt (m_nWayNum++, m_szActLocName, nPidProt);
			break;


		case CGarminLink2Event::Pid_Rte_Wpt_Data:
			if (m_nWayNum < m_ptDoc->GetWayPointCnt())
				this->WriteGarminD1xxWpt (m_nWayNum++, m_szActLocName, nPidProt);
			else
				this->SendXferCompl(m_nWayNum, nPidProt);
			break;

		case CGarminLink2Event::Pid_Xfer_Cmplt:
			bStop = TRUE;
			WaitTenthSec (WAIT_TIME);
			break;

		default:
			break;
		}
	}



	return bStop;
}

/************************************************************************
 *  GpsWrDlg.cpp		  W r i t e G a r m i n L i n k 1 				*
 ************************************************************************/
BOOL CWriteToGpsDlg::WriteGarminLink1 (short nRteID,
										short* ptRequestIDCnt,
										BOOL* ptOK, BOOL* ptStop, BOOL* ptConnected,
										CFile* ptFile)
{
BOOL bTimeOut;
CGarminLink1Event GarminEvent;
Product_Data_Type	productData;
short	nPidProt;

bTimeOut = m_ptGrmnLink1->GetNextGarminEvent (&GarminEvent);
switch (GarminEvent.GetFunction())
    {
    case CGarminLink1Event::Pid_Product_Data:
		*m_szActLocName = 0;
		*ptRequestIDCnt = 0;
		*ptConnected = TRUE;

		GarminEvent.OnReadProduct (&productData, ptFile);	
		m_szGPS = productData.product_description;
		this->SetText(ID_GWGPS, m_szGPS);

		m_ptGrmnLink1->SetProtocols(productData.product_ID, 100.*productData.software_version);

		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
	
		WaitTenthSec (WAIT_TIME);
		m_ptGrmnLink1->SimulateProtocolArray();	// try to read protocol array or 
		break;								// simulate event after timed out

	case CGarminLink1Event::Pid_Protocol_Array:
		if (m_ptGrmnLink1->IsRealCommand())
		{
			m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
			m_ptGrmnLink1->SplitProtocols (GarminEvent.GetDataPtr(), 
										GarminEvent.GetDataLen(), ptFile);
			m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		}
											// send main command	
		m_nRecords = m_ptGrmnLink1->CalcRteTransRecords(m_ptDoc->GetWayPointCnt());
		m_ptGrmnLink1->SendNumberOfRecords (m_nRecords);
		break;

	case CGarminLink1Event::Pid_Version_Terrain_DB:
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		break;

    case CGarminLink1Event::Pid_Ack_Byte:
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
		nPidProt = m_ptGrmnLink1->GetPidProt();

		switch (m_ptGrmnLink1->GetRteTrans())
		{
			case A200_RteTrans:
				*ptStop = OnAckA200(GarminEvent.SplitAcknowledge (), nPidProt);
				break;
			case A201_RteTrans:
				*ptStop = OnAckA201(GarminEvent.SplitAcknowledge (), nPidProt);
				break;
		}

		if (*ptStop)
			*ptOK = TRUE;
		break;

    case CGarminLink1Event::Pid_Nak_Byte:
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
	
	    *ptStop = TRUE;
	
	    if (*m_szActLocName > 0)
			{
			CString szBuffer = this->Format (IDS_GPSQUIT, m_szActLocName);
			AfxMessageBox (szBuffer);
			}
		break;

    default:
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
		break;
    }

if (bTimeOut && (*ptRequestIDCnt)>0 && (*ptRequestIDCnt)<3)
    {
    bTimeOut = FALSE;
	m_ptGrmnLink1->SendProductRqst ();
    (*ptRequestIDCnt)++;
    }

return bTimeOut;
}

/************************************************************************
 *  GpsWrDlg.cpp		  W r i t e G a r m i n L i n k 2 				*
 ************************************************************************/
BOOL CWriteToGpsDlg::WriteGarminLink2 (short nRteID,
										short* ptRequestIDCnt,
										BOOL* ptOK, BOOL* ptStop, BOOL* ptConnected,
										CFile* ptFile)
{
BOOL bTimeOut;
CGarminLink2Event GarminEvent;
Product_Data_Type	productData;
short nPidProt;

bTimeOut = m_ptGrmnLink2->GetNextGarminEvent (&GarminEvent);
switch (GarminEvent.GetFunction())
    {
    case CGarminLink2Event::Pid_Product_Data:
		*m_szActLocName = 0;
		*ptRequestIDCnt = 0;
		*ptConnected = TRUE;

		GarminEvent.OnReadProduct (&productData, ptFile);	
		m_szGPS = productData.product_description;
		this->SetText(ID_GWGPS, m_szGPS);

		m_ptGrmnLink2->SetProtocols(productData.product_ID, 100.*productData.software_version);

		m_ptGrmnLink2->SendG55Reply (&GarminEvent);
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
	
		WaitTenthSec (WAIT_TIME);
		m_ptGrmnLink2->SimulateProtocolArray();	// try to read protocol array or 
		break;								// simulate event after timed out

	case CGarminLink2Event::Pid_Protocol_Array:
		if (m_ptGrmnLink2->IsRealCommand())
		{
			m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
			m_ptGrmnLink2->SplitProtocols (GarminEvent.GetDataPtr(), 
										GarminEvent.GetDataLen(), ptFile);
			m_ptGrmnLink2->SendG55Reply (&GarminEvent);
		}
											// send main command	
		m_nRecords = m_ptGrmnLink2->CalcRteTransRecords(m_ptDoc->GetWayPointCnt());
		m_ptGrmnLink2->SendNumberOfRecords (m_nRecords);
		break;

    case CGarminLink2Event::Pid_Ack_Byte:
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
		nPidProt = m_ptGrmnLink2->GetPidProt();

		switch (m_ptGrmnLink2->GetRteTrans())
		{
			case A200_RteTrans:
				*ptStop = OnAckA200(GarminEvent.SplitAcknowledge (), nPidProt);
				break;
			case A201_RteTrans:
				*ptStop = OnAckA201(GarminEvent.SplitAcknowledge (), nPidProt);
				break;
		}

		if (*ptStop)
			*ptOK = TRUE;
		break;

    case CGarminLink2Event::Pid_Nak_Byte:
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
		m_ptGrmnLink2->SendG55Reply (&GarminEvent);
	
	    *ptStop = TRUE;
	
	    if (*m_szActLocName > 0)
			{
			CString szBuffer = this->Format (IDS_GPSQUIT, m_szActLocName);
			AfxMessageBox (szBuffer);
			}
		break;

    default:
		m_ptGrmnLink2->SendG55Reply (&GarminEvent);
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
		break;
    }

if (bTimeOut && (*ptRequestIDCnt)>0 && (*ptRequestIDCnt)<3)
    {
    bTimeOut = FALSE;
	m_ptGrmnLink2->SendProductRqst ();
    (*ptRequestIDCnt)++;
    }

return bTimeOut;
}

/************************************************************************
 *  GpsWrDlg.cpp		W r i t e G 1 0 0 U s e r W p t					*
 ************************************************************************/
BOOL CWriteToGpsDlg::WriteG100UserWpt (short* ptWayNum, char* szActLocName)
{
BOOL	bUserWptSent = FALSE;
BOOL	bLastWpt = FALSE;
BOOL	bUserWptFound = FALSE;

short nWptCnt = m_ptDoc->GetWayPointCnt ();
if (*ptWayNum < nWptCnt && *ptWayNum < m_Gps.GetMaxRteWpts())
    {
	CWayPoint Wpt;
    do	{			// search for next user waypoint
		if (m_ptDoc->GetWayPointPtr ((*ptWayNum)++, &Wpt))
			{
			bUserWptFound =
			(m_Gps.GetWptType (Wpt.GetCategory()) == m_Gps.GetWptType (WP_USER));
			}
		bLastWpt = ((*ptWayNum) == nWptCnt);
		} while (!bLastWpt && !bUserWptFound);

    if (bUserWptFound)
		{
		long	lAlt;
		short	nCC;
	
		this->GetWptNameAndCC (Wpt, szActLocName, &nCC);
	
	    //	lAlt = (long)ConvertDist ((double)theWay.ActAlt, DIM_FEET, Prefs.nAltDim);
		*((unsigned char*)&lAlt + 0) = 0xFF;
		*((unsigned char*)&lAlt + 1) = 0xFF;
		*((unsigned char*)&lAlt + 2) = 0x7F;
		*((unsigned char*)&lAlt + 3) = 0x7F;
	
		m_ptGrmn->SendG100UserWpt (szActLocName, m_Gps.GetMaxWptChars (),
				      Wpt.GetLat(), Wpt.GetLon(),
				      lAlt);
		bUserWptSent = TRUE;
		}
    }

return bUserWptSent;
}

/************************************************************************
 *  GpsWrDlg.cpp			  S e n d G a r m i n 1 0 0					*
 ************************************************************************/
BOOL CWriteToGpsDlg::SendGarmin100 (short nRteID, BOOL* ptOK, BOOL* ptStop, BOOL* ptConnected)
{
BOOL bTimeOut, bUserWptSent;
short	nState;

short nWptCnt = m_ptDoc->GetWayPointCnt ();

*ptStop = FALSE;
*ptOK = FALSE;			    // complete route sent

bTimeOut = m_ptGrmn->GetGarmin100State (&nState);

switch (nState)
    {
    case GE100_WAITS:		    // start sending route
		m_nWayNum = 0;
		*m_szActLocName = 0;
		m_bSendG100UserWpts = TRUE;
		*ptConnected = TRUE;
		// fall through

    case GE100_REPLY:
		if (m_bSendG100UserWpts)
		    {			    // send next user waypoint
		    bUserWptSent = this->WriteG100UserWpt (&m_nWayNum, m_szActLocName);
		    if (!bUserWptSent)
				{
				m_bSendG100UserWpts = FALSE;
				m_nWayNum = 0;
				}
		    }
	
		if (!bUserWptSent)
		    {
		    short   nOffs;
		    short   nWayCnt = nWptCnt;
		    if (nWayCnt > m_Gps.GetMaxRteWpts())
				nWayCnt = m_Gps.GetMaxRteWpts();
	
			m_nRecords = nWayCnt;

		    nOffs = m_ptGrmn->SetG100RteHeader (nRteID, nWayCnt);
	
		    for (m_nWayNum=0;
				m_nWayNum<nWptCnt && m_nWayNum < m_Gps.GetMaxRteWpts();
				m_nWayNum++)
				{
				CWayPoint Wpt;
				if (m_ptDoc->GetWayPointPtr (m_nWayNum, &Wpt))
				    {
				    short   nCC;
		
				    this->GetWptNameAndCC (Wpt, m_szActLocName, &nCC);
		
				    m_szState = this->Format (IDS_WRRTEWPT, m_szActLocName);
				    this->SetText (ID_GWSTATE, m_szState);
		
				    nOffs += m_ptGrmn->SetG100RteWpt (nOffs,
									  m_szActLocName, m_Gps.GetMaxWptChars (),
									  nCC, m_Gps.GetWptType (Wpt.GetCategory()));
				    WaitTenthSec (WAIT_TIME/2);
				    }
				}
	
		    m_ptGrmn->SendG100RteWpts (nOffs);
	
		    if (m_nWayNum >= m_Gps.GetMaxRteWpts() && m_nWayNum < nWptCnt)
				{
				MessageBeep (MB_ICONHAND);
				m_szState.LoadString (IDS_WRRTEFULL);
				}
		    else{
				*ptOK = TRUE;
				m_szState = this->Format (IDS_WRRTE_ID_SENT, nRteID);
				}
		    this->SetText (ID_GWSTATE, m_szState);
	
		    *ptStop = TRUE;
		    WaitTenthSec (WAIT_TIME);
		    }
		break;

    default:
		*ptStop = TRUE;
		break;
    }	// switch nState...

return bTimeOut;
}


/************************************************************************
 *  GpsWrDlg.cpp    H a n d l e G a r m i n L i n k 1 U s b E v e n t	*
 ************************************************************************/
BOOL CWriteToGpsDlg::HandleGarminLink1UsbEvent(CGarminLink1UsbEvent* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
Product_Data_Type	productData;

switch (ptGarminEvent->GetFunction())
    {
	case CGarminLink1UsbEvent::Pid_Data_Available:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		break;

    case CGarminLink1UsbEvent::Pid_Session_Started:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1Usb->SplitStartSession (ptGarminEvent->GetDataPtr(), 
										ptGarminEvent->GetDataLen(), ptFile);

		m_ptGrmnLink1Usb->SendProductRqst ();
		break;

    case CGarminLink1UsbEvent::Pid_Product_Data:
		m_nRteID		= -1;
		*m_szActLocName = 0;
		*ptRequestIDCnt = 0;

		ptGarminEvent->OnReadProduct (&productData, ptFile);
		m_szGPS = productData.product_description;
		this->SetText(ID_GWGPS, m_szGPS);

		m_ptGrmnLink1Usb->SetProtocols(productData.product_ID, 100.*productData.software_version);

		*ptConnected = TRUE;

		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
	
		WaitTenthSec (WAIT_TIME);
		m_ptGrmnLink1Usb->SimulateProtocolArray();	// try to read protocol array or simulate event
		break;

	case CGarminLink1UsbEvent::Pid_Version_Terrain_DB:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		break;

	case CGarminLink1UsbEvent::Pid_Protocol_Array:
		{
			if (m_ptGrmnLink1Usb->IsRealCommand())
			{
				m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
				m_ptGrmnLink1Usb->SplitProtocols (ptGarminEvent->GetDataPtr(), 
											ptGarminEvent->GetDataLen(), ptFile);
			}
												// send main command
			m_nRecords = m_ptGrmnLink1Usb->CalcRteTransRecords(m_ptDoc->GetWayPointCnt());
			m_ptGrmnLink1Usb->SendNumberOfRecords (m_nRecords);

			short nPidProt = L001_Link;

			SendRouteHeader(nPidProt);

									// send all route waypoints now...
			m_nWayNum=0;
			for (short i=0; i<m_ptDoc->GetWayPointCnt(); i++)
			{	
				switch (m_ptGrmnLink1Usb->GetRteTrans())
				{
					case A200_RteTrans:
						this->WriteGarminD1xxWpt (m_nWayNum++, m_szActLocName, nPidProt);
						break;
					case A201_RteTrans:
						this->WriteGarminD1xxWpt (m_nWayNum++, m_szActLocName, nPidProt);
						if (i<m_ptDoc->GetWayPointCnt()-1)	// link btn two waypoints
							m_ptGrmnLink1Usb->SendRouteLinkData();
						break;
				}
			} 

			this->SendXferCompl(m_nWayNum, nPidProt);

			*ptOK = TRUE;
			*ptStop = TRUE;
		}
		break;


    case CGarminLink1UsbEvent::Pid_Records:
		m_nRecords = ptGarminEvent->SplitNumbOfCmds (ptFile);
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		break;

 
    case CGarminLink1UsbEvent::Pid_Xfer_Cmplt:		// Cmnd_Transfer_Trk
		{
			m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);

	//		*ptOK = OnTransferCompleted();
			*ptStop = TRUE;
		}
		break;


    default:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		return FALSE;
		break;
    }

return TRUE;
}

/************************************************************************
 *  GpsWrDlg.cpp			W r i t e M a g e l l a n W p l				*
 *	WPL,4957.600,N,00838.600,E,0384,F,EDFE,,							*
 ************************************************************************/
BOOL CWriteToGpsDlg::WriteMagellanWpl (	short nWayNum,
										char* szActLocName, 
										CFile* ptFile)
{
	BOOL bSent = FALSE;

	short nWptCnt = m_ptDoc->GetWayPointCnt ();
	if (nWayNum < nWptCnt && nWayNum < m_Gps.GetMaxRteWpts())
    {
		CWayPoint Wpt;
		if (m_ptDoc->GetWayPointPtr (nWayNum, &Wpt))
		{
			short	nCC;
		
			this->GetWptNameAndCC (Wpt, szActLocName, &nCC);
		
			m_szState = this->Format (IDS_WRRTEWPT, szActLocName);
			this->SetText (ID_GWSTATE, m_szState);
		
			char szIndic[INDICATOR_SIZE];
			Wpt.GetIndicator(szIndic);
			BOOL bUseIndic = (strlen(szIndic) > 0);

			CNmeaEvent NewWpt(SN_PROP, FM_MGN, MGN_WPL);
			NewWpt.AppendLat(Wpt.GetLat());
			NewWpt.AppendLon(Wpt.GetLon());
			NewWpt.AppendAlt(Wpt.GetActAlt_ft(), 'F');
			NewWpt.AppendName ((bUseIndic)? szIndic : szActLocName);
			NewWpt.AppendText ("");
			NewWpt.AppendText ("h");

			bSent = m_ptNmea->SendNMEAEvent (&NewWpt, ptFile);
		}
    }

	return bSent;
}

/************************************************************************
 *  GpsWrDlg.cpp			W r i t e M a g e l l a n R t e				*
 *	RTE,5,1,c,3,EDFE,FEJ												*
 ************************************************************************/
BOOL CWriteToGpsDlg::WriteMagellanRte (CString szRte, short nWayNum, char* szActLocName, CFile* ptFile)
{								

	BOOL bSent = FALSE;

	short nWptCnt = m_ptDoc->GetWayPointCnt ();
	if (nWayNum < nWptCnt && nWayNum < m_Gps.GetMaxRteWpts())
    {	
		CWayPoint Wpt;
		if (m_ptDoc->GetWayPointPtr (nWayNum, &Wpt))
		{
			short	nCC;
		
			this->GetWptNameAndCC (Wpt, szActLocName, &nCC);
		
			m_szState = this->Format (IDS_WRRTEWPT, szActLocName);
			this->SetText (ID_GWSTATE, m_szState);
		
			char szIndic[INDICATOR_SIZE];
			Wpt.GetIndicator(szIndic);
			BOOL bUseIndic = (strlen(szIndic) > 0);

			CNmeaEvent WptPair(SN_PROP, FM_MGN, MGN_RTE);
														// nWptCnt=2 => 1 msg
			short nMaxMsgCnt = (short)((nWptCnt+1)/2);	// nWptCnt=5 => 3 msgs
			short nActMsg = (nWayNum+2) / 2;			// nActMsg = 1,2,3
			WptPair.AppendShort(nMaxMsgCnt);
			WptPair.AppendShort(nActMsg);
			WptPair.AppendChar('c');

			WptPair.AppendText ((char*)(LPCTSTR)szRte);	// name of route
			WptPair.AppendName ((bUseIndic)? szIndic : szActLocName);

			if (nWayNum+1 < nWptCnt)
			{					// use next wpt name to make pair
				if (m_ptDoc->GetWayPointPtr (nWayNum+1, &Wpt))
				{
					this->GetWptNameAndCC (Wpt, szActLocName, &nCC);
		
					m_szState = this->Format (IDS_WRRTEWPT, szActLocName);
					this->SetText (ID_GWSTATE, m_szState);
		
					Wpt.GetIndicator(szIndic);
					bUseIndic = (strlen(szIndic) > 0);
					WptPair.AppendName ((bUseIndic)? szIndic : szActLocName);
				}
			}
			else
			{					// use dummy to make pair
				WptPair.AppendText ("");
			}

			bSent = m_ptNmea->SendNMEAEvent (&WptPair, ptFile);

		}
	}

	return bSent;
}

/************************************************************************
 *  GpsWrDlg.cpp		  S e n d M a g e l l a n R t e					*
 ************************************************************************/
BOOL CWriteToGpsDlg::SendMagellanRte (short nRteID,
										short* ptRequestIDCnt,
										BOOL* ptOK, BOOL* ptStop, BOOL* ptConnected,
										CFile* ptFile)
{
	BOOL bTimeOut;
	char		szBuffer[256];
	CNmeaEvent 	NMEAData;	
	BOOL		bWpl=FALSE;
	BOOL		bRte=FALSE;
	CString		szRte;

	szRte.Format ("%02d", nRteID);		// convert Rte ID to String

	do	
	{
		bTimeOut = m_ptNmea->GetNextNMEAEvent (&NMEAData, ptFile);
		*ptStop = bTimeOut;	   // evtl. test mouse down button here

		switch (NMEAData.GetFunction())
		{			
			case FM_MGN:
			{
				long	lLen;
				switch (NMEAData.GetMGNFunc ())
				{
					case MGN_CSM:
					{
						short nChkSum;
						NMEAData.SplitMGNCSM (&nChkSum);
						lLen = sprintf (szBuffer, "\nReceivedChk=%d", nChkSum);
						if (ptFile != NULL)
							ptFile->Write ((const void*)szBuffer, (UINT)lLen);

						if (bWpl)
						{
							if (!this->WriteMagellanWpl (m_nWayNum++, m_szActLocName, ptFile))
							{		// all route waypoints sent. Now send PMGNRTE
								bWpl=FALSE;
								bRte=TRUE;

								m_nWayNum=0;
								this->WriteMagellanRte (szRte, m_nWayNum, m_szActLocName, ptFile);
								m_nWayNum += 2;		// pair of wpts written
							}
						}

						if (bRte)
						{
							if (this->WriteMagellanRte (szRte, m_nWayNum, m_szActLocName, ptFile))
							{
								m_nWayNum += 2;		// pair of wpts written
							}
							else
							{	// end of route transfer, stop sending data
								CNmeaEvent HandEvt(SN_PROP, FM_MGN, MGN_CMD, "HANDOFF");
								*ptOK = m_ptNmea->SendNMEAEvent (&HandEvt, ptFile);

								*ptStop = TRUE;
							}
						}
					}
					break;

					case MGN_CMD:
					{
						CString szCmd;
						NMEAData.SplitMGNCMD (&szCmd);

						m_ptNmea->SendMGNCSM (&NMEAData);

						lLen = sprintf (szBuffer, "\nMGN_CMD %s sent", (LPCTSTR)szCmd);
						if (ptFile != NULL)
							ptFile->Write ((const void*)szBuffer, (UINT)lLen);

						if (szCmd.Compare("END")==0)	// shouldn't happen
							*ptStop = TRUE;
						
					}
					break;

					case MGN_VER:
					{
						NMEA_MGNVER Vers;
						NMEAData.SplitMGNVER (&Vers);

						m_ptNmea->SendMGNCSM (&NMEAData);


						lLen = sprintf (szBuffer, "\nID=%d, Vers=%s, Model=%s", 
							Vers.nProdID, Vers.szRev, Vers.szModel);
						if (ptFile != NULL)
							ptFile->Write ((const void*)szBuffer, (UINT)lLen);

												// start sending Rte waypoints
						bWpl = TRUE;
						*m_szActLocName = 0;
						*ptRequestIDCnt = 0;
						*ptConnected = TRUE;

						m_nWayNum = 0;
						this->WriteMagellanWpl (m_nWayNum++, m_szActLocName, ptFile);
					}
					break;

					case MGN_RTE:
					{
					}
					break;

					case MGN_WPL:
					{
					}
					break;
					
					default:
					break;
				}
			}
			break;

			case FN_WPL:
			{
				long lLen = sprintf (szBuffer, "\nNMEA WPL message received!");
				if (ptFile != NULL)
					ptFile->Write ((const void*)szBuffer, (UINT)lLen);

				//m_ptNmea->SendMGNCSM (&NMEAData);

			}
			break;

			default:
			break;
		}
	} while (!*ptStop);


if (bTimeOut && (*ptRequestIDCnt)>0 && (*ptRequestIDCnt)<3)
    {
    bTimeOut = FALSE;
	this->MgnRequestID (ptFile);
    (*ptRequestIDCnt)++;
    }
	
return bTimeOut;
}


/////////////////////////////////////////////////////////////////////////////
// CWriteToGpsDlg message handlers


/************************************************************************
 *  GpsWrDlg.cpp			O n I n i t D i a l o g						*
 ************************************************************************/
BOOL CWriteToGpsDlg::OnInitDialog() 
{
	// TODO: Add extra initialization here
BOOL bHideStoreAsUser = TRUE;
short nIndex;
if (m_ptGpsDoc->GetActGpsInd (&nIndex))
	{
	if (m_ptGpsDoc->GetGpsPtr (nIndex, &m_Gps))
		{
		m_nRequestIDCnt = 0;

		switch (m_Gps.GetProtocol())
		{
		case PR_GARMIN1:	// GPS100 ... GPS 100 AVD
			m_ptGrmn = (CGarmin*)new CGarmin (m_Gps.GetBaudRate(), 
								  m_Gps.GetDataBits(), 
								  m_Gps.GetStopBits(), 
								  NO);
			break;
		case PR_GARMIN2:
			if(m_ptGpsDoc->IsUsbProtocol())
					m_ptGrmnLink1Usb = (CProtGarminLink1Usb*)new CProtGarminLink1Usb ();
			else	m_ptGrmnLink1 = (CProtGarminLink1*)new CProtGarminLink1 ();
			bHideStoreAsUser = FALSE;
			break;
		case PR_GARMIN3:	// GPS 150
			m_ptGrmnLink2 = (CProtGarminLink2*)new CProtGarminLink2 ();
			bHideStoreAsUser = FALSE;
			break;
		case PR_MAGELLAN:
			m_ptNmea = (CNmea*)new CNmea (m_Gps.GetBaudRate(), 
								  m_Gps.GetDataBits(), 
								  m_Gps.GetStopBits(), 
								  NO);
			break;
		default:
			break;
		}


		if (bHideStoreAsUser)
			this->HideControl(ID_GWUSER, bHideStoreAsUser);

		
	    m_szRequest.LoadString (IDS_WRREQUESTNAM);  


		m_szRte = m_ptDoc->GetTitle();		// name of document file
		
		m_szRteID = m_szRte;			   
		short nDot = m_szRte.Find('.');		// remove ext from file.ext
		if (nDot > 0) m_szRteID = m_szRte.Left(nDot);

		m_szGPS = m_Gps.GetName ();
		m_szState.LoadString (IDS_IDLE);

		m_szRteID = m_ptGpsDoc->GetWrittenRte (); 
		m_nRteID = ConvertToRteNum(m_szRteID);
		this->SelectItem (ID_GWNUM);
		}
	}

CDlgTool::OnInitDialog();
	
return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  GpsWrDlg.cpp			C o n v e r t T o R t e N u m				*
 ************************************************************************/
short CWriteToGpsDlg::ConvertToRteNum(CString szRteName)
{
	short nNum=0;
	if (szRteName.GetLength() > 0)
		nNum = (short)atoi((LPCTSTR)szRteName);
	return nNum;
}

/************************************************************************
 *  GpsWrDlg.cpp				M g n R e q u e s t I D					*
 ************************************************************************/
void CWriteToGpsDlg::MgnRequestID(CFile* ptFile)
{
						// aktivate hand shake
	CNmeaEvent HandEvt(SN_PROP, FM_MGN, MGN_CMD, "HANDON");
	m_ptNmea->SendNMEAEvent (&HandEvt, ptFile);

						// request gps ID and version
	CNmeaEvent VersEvt(SN_PROP, FM_MGN, MGN_CMD, "VERSION");
	m_ptNmea->SendNMEAEvent (&VersEvt, ptFile);
}

/************************************************************************
 *  GpsWrDlg.cpp					O n G p s E v e n t					*
 ************************************************************************/
LONG CWriteToGpsDlg::OnGpsEvent(UINT wParam, LONG lParam)
{
	CString szBuffer;
	BOOL bError = (wParam == 1);
	if (bError)
	{
		if (m_ptLogFile != NULL)
		{
			m_ptLogFile->Close();
			delete m_ptLogFile;
			m_ptLogFile = NULL;
		}

		if (!m_ptGrmnLink1Usb->CloseReadThread(&szBuffer))
			AfxMessageBox ("Bad CloseReadThread: " + szBuffer);

		AfxMessageBox("Error received in OnGpsEvent");
		CDlgTool::OnCancel();
		return 0L;
	}


	CGarminLink1UsbEvent GarminEvent;

	long lIndex = 0;		// always read first queue entry
	while (m_ptGrmnLink1Usb->GetQueueEvent (lIndex, &GarminEvent))
	{
		HandleGarminLink1UsbEvent (&GarminEvent, &m_nRequestIDCnt,
							&m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);

		if (m_bStop || m_bTimeOut)
		{
			if (m_ptGrmnLink1Usb != NULL)
			{
				if (m_ptGrmnLink1Usb->Close())
					this->DisableControl (ID_GWWRITE, FALSE);
				if (m_ptGrmnLink1Usb->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

			if (m_bTimeOut)
			{
				short nStrID = (m_bOK)? IDS_GPSOK : IDS_GPSTIMEOUT;
				szBuffer.LoadString (nStrID);
				AfxMessageBox (szBuffer);
			}

			m_ptGpsDoc->SetWrittenRte(m_szRteID);
			if (m_ptLogFile != NULL)
			{
				m_ptLogFile->Close();
				delete m_ptLogFile;
				m_ptLogFile = NULL;
			}

			if (!m_ptGrmnLink1Usb->CloseReadThread(&szBuffer))
				AfxMessageBox ("Bad CloseReadThread: " + szBuffer);

			if (m_bOK)	CDlgTool::OnOK();		
				else	CDlgTool::OnCancel();
		}
	} // while Garmin Events in queue...

	return 0L;
}


/************************************************************************
 *  GpsWrDlg.cpp				O n W r i t e R t e						*
 ************************************************************************/
void CWriteToGpsDlg::OnWriteRte() 
{
	// TODO: Add your control notification handler code here
	if (this->UpdateData (TRUE))
	{
		BOOL bDebug = FALSE;
		BOOL bRteOK = CheckRteForGPS (m_ptDoc);

		CString szTestGPS;	// debug gps data transfer if route title starts with TestGPS
		szTestGPS.LoadString(IDS_TESTGPS);
		bDebug = (m_ptDoc->GetTitle().Find((LPCTSTR)szTestGPS) == 0);
		if (bDebug)
		{
			CString szFileTitle;
			szFileTitle = SaveAsTextBox (this, "Writing Route", "WriteRte");

			if (szFileTitle.GetLength() > 0)
			{
				m_ptLogFile = new CFile ();
				m_ptLogFile->Open(szFileTitle, CFile::modeCreate | CFile::modeNoInherit | CFile::modeWrite, NULL); 
			}
		}

		if (bRteOK && this->InitRteWrite(256, 256))
		{
			this->DisableControl (ID_GWWRITE, TRUE);
		
			m_szState = this->Format (IDS_WRSEND_RTE_NAME, (LPCTSTR)m_szRteID);

			this->SetText (ID_GWSTATE, m_szState);   

			BOOL bUsbProtocol = m_ptGpsDoc->IsUsbProtocol();

			switch (m_Gps.GetProtocol())
			{
			case PR_GARMIN1:	// GPS100 ... GPS 100 AVD
				m_ptGrmn->SetLogFilePtr(m_ptLogFile);
				// directly start timer
				break;
			case PR_GARMIN2:
				if (bUsbProtocol)
				{
					m_ptGrmnLink1Usb->SetLogFilePtr(m_ptLogFile);
					m_ptGrmnLink1Usb->SendStartSession ();
					m_ptGrmnLink1Usb->StartReadThread(this);
					m_nRequestIDCnt++;
				}
				else
				{
					m_ptGrmnLink1->SetLogFilePtr(m_ptLogFile);
					m_ptGrmnLink1->SendProductRqst ();
					m_nRequestIDCnt++;
				}
				break;
			case PR_GARMIN3:	// GPS 150
				m_ptGrmnLink2->SetLogFilePtr(m_ptLogFile);
				m_ptGrmnLink2->SendProductRqst ();
				m_nRequestIDCnt++;
				break;
			case PR_MAGELLAN:
				MgnRequestID(m_ptLogFile);
				break;
			default:
				break;
			}

			if (!bUsbProtocol)	
			{				// no timer for USB GPS, instead use thread event!!
				m_uTimer = SetTimer (GPS_TIMER, 500, NULL);
				if (m_uTimer == 0)
				{									/* 1/2 sec Timer	*/
					AfxMessageBox ("Bad Timer");
					CDlgTool::OnCancel();
				}
			}
		}
		else
		{
		CDlgTool::OnCancel();
		}
	}	
}


/************************************************************************
 *  GpsWrDlg.cpp					O n T i m e r						*
 ************************************************************************/
void CWriteToGpsDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	BOOL bFastMode = FALSE;

	switch (nIDEvent)
	{
	case GPS_TIMER:
		this->KillTimer (m_uTimer);

		switch (m_Gps.GetProtocol())
		{
		case PR_GARMIN1:
			m_bTimeOut = this->SendGarmin100 (m_nRteID, &m_bOK, &m_bStop, &m_bConnected);
			break;

		case PR_GARMIN2:
			if (m_Gps.GetID() == GPSLINK1)
				{		
					bFastMode = TRUE;
					m_bTimeOut = this->WriteGarminLink1 (m_nRteID,
					   &m_nRequestIDCnt,
					   &m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);
				}
		
	 		if (m_Gps.GetID() == GPSOTHER)
	 			m_bTimeOut = TRUE;
			break;

		case PR_GARMIN3:
			if (m_Gps.GetID() == GPSLINK2)
				{		
				m_bTimeOut = this->WriteGarminLink2 (m_nRteID,
					   &m_nRequestIDCnt,
					   &m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);
				}
			break;

		case PR_MAGELLAN:			
			m_bTimeOut = this->SendMagellanRte(m_nRteID,
									   &m_nRequestIDCnt,
									   &m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);
			break;

		default:
			m_bTimeOut = TRUE;
			break;
		}
	
		if (m_bStop || m_bTimeOut)
		    {
			if (m_ptGrmn != NULL)
			{
				if (m_ptGrmn->Close())
					this->DisableControl (ID_GWWRITE, FALSE);

			    if (m_ptGrmn->GetError() == SER_BADCLOSE)
				    AfxMessageBox("bad Close Comm");
			}

			if (m_ptGrmnLink1 != NULL)
			{
				if (m_ptGrmnLink1->Close())
					this->DisableControl (ID_GWWRITE, FALSE);

			    if (m_ptGrmnLink1->GetError() == SER_BADCLOSE)
				    AfxMessageBox("bad Close Comm");
			}

			if (m_ptGrmnLink2 != NULL)
			{
				if (m_ptGrmnLink2->Close())
					this->DisableControl (ID_GWWRITE, FALSE);

			    if (m_ptGrmnLink2->GetError() == SER_BADCLOSE)
				    AfxMessageBox("bad Close Comm");
			}

			if (m_ptNmea != NULL)
			{
				if (m_ptNmea->Close())
					this->DisableControl (ID_GWWRITE, FALSE);
				if (m_ptNmea->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

		    if (m_bTimeOut)
				{  
				CString szBuffer;
				short nStrID = (m_bOK)? IDS_GPSOK : IDS_GPSTIMEOUT;
				szBuffer.LoadString (nStrID);
				AfxMessageBox (szBuffer);
				}
	
			m_ptGpsDoc->SetWrittenRte(m_szRteID);
			if (m_ptLogFile != NULL)
				{
				m_ptLogFile->Close();
				delete m_ptLogFile;
				m_ptLogFile = NULL;
				}
	
			if (m_bOK)	CDlgTool::OnOK();		
				else	CDlgTool::OnCancel();
		    }
		else{
				if (bFastMode)	m_uTimer = SetTimer (GPS_TIMER, 100, NULL);
					else		m_uTimer = SetTimer (GPS_TIMER, 500, NULL);

				if (m_uTimer == 0)
				{   // 0.5 sec Timer  
				AfxMessageBox ("Bad Timer");
				CDlgTool::OnCancel();
				}
		    }	 
		break;
	default:
		AfxMessageBox ("Unknown Timer in OnTimer");
		break;
	}
		
CDlgTool::OnTimer(nIDEvent);
}


/************************************************************************
 *  GpsWrDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CWriteToGpsDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}

