#if !defined(AFX_WRGPSRT_H__4BA2B5C2_35AB_11D2_BFB4_DD4FD09F7F7F__INCLUDED_)
#define AFX_WRGPSRT_H__4BA2B5C2_35AB_11D2_BFB4_DD4FD09F7F7F__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// GpsWrDlg.h : header file
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

// CWriteToGpsDlg dialog
#include "DlgTool.h"
#include "Garmin.h"						// includes GarminEv.h
#include "ProtGarminLink1.h"			// includes GarminLink1Ev.h
#include "ProtGarminLink2.h"			// includes GarminLink2Ev.h
#include "ProtGarminLink1Usb.h"			// includes GarminLink1UsbEv.h

class CWayDoc;
//class CGpsDoc;
class CWriteToGpsDlg : public CDlgTool
{
// Construction

public:
	#define GPS_TIMER	2

	CWriteToGpsDlg(CWnd* pParent=NULL, CWayDoc* ptDoc=NULL, CGpsDoc* ptGpsDoc=NULL);   // standard constructor
	virtual ~CWriteToGpsDlg();

// Dialog Data
	//{{AFX_DATA(CWriteToGpsDlg)
	enum { IDD = IDD_GPSRTEWRITEBOX };
	CString	m_szGPS;
	CString	m_szState;
	CString m_szRequest;
	CString	m_szRte;
	CString	m_szRteID;
	BOOL	m_bStoreAsUserWpt;
	//}}AFX_DATA

private:
	CWayDoc*	m_ptDoc;
	CGpsDoc*	m_ptGpsDoc;
  	CGps		m_Gps;
	CGarmin*				m_ptGrmn;
	CProtGarminLink1*		m_ptGrmnLink1;
	CProtGarminLink2*		m_ptGrmnLink2;
	CProtGarminLink1Usb*	m_ptGrmnLink1Usb;
	CNmea*					m_ptNmea;

	short		m_nRteID;

	short		m_nRequestIDCnt;
	BOOL		m_bTimeOut;
	BOOL		m_bStop;
	BOOL		m_bOK;
	BOOL		m_bConnected;
	UINT		m_uTimer;
	CFile*		m_ptLogFile;
	short		m_nRecords;


	short		m_nWayNum;
	short		m_nTopCnt;
	short		m_nBotCnt;
	char		m_szActLocName[SIZEOF_ORT];
	BOOL		m_bSendG100UserWpts;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWriteToGpsDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
private:
	short ConvertToRteNum(CString szRteName);
	BOOL CheckRteForGPS (CWayDoc* ptWayDoc);
	BOOL InitRteWrite(short nInpLen, short nOutLen); 
	void GetWptNameAndCC (CWayPoint& Wpt, char* szActLocName, short* ptCC);
	void GetD1xxWptName (CWayPoint& Wpt, char* szActLocName);
	void SendXferCompl(short nWayNum, short nPidProt);
	void WriteGarminD1xxWpt (short nWayNum, char* szActLocName, short nPidProt);

	CString GetRteHdr();
	BOOL SendRouteHeader(short nPidProt);
	BOOL SendD200RteHdr(short nPidProt);
	BOOL SendD201RteHdr(short nPidProt);
	BOOL SendD202RteHdr(short nPidProt);
	BOOL OnAckA200(short nAckCmd, short nPidProt);
	BOOL OnAckA201(short nAckCmd, short nPidProt);

	BOOL WriteGarminLink1 (short nRteID, short* ptRequestIDCnt,
							BOOL* ptOK, BOOL* ptStop, BOOL* ptConnected, CFile* ptFile);
	BOOL WriteGarminLink2 (short nRteID, short* ptRequestIDCnt,
							BOOL* ptOK, BOOL* ptStop, BOOL* ptConnected, CFile* ptFile);

	BOOL WriteG100UserWpt (short* ptWayNum, char* szActLocName);
	BOOL SendGarmin100 (short nRteID, BOOL* ptOK, BOOL* ptStop, BOOL* ptConnected);

	BOOL HandleGarminLink1UsbEvent(CGarminLink1UsbEvent* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile);

	void MgnRequestID(CFile* ptFile);
	BOOL WriteMagellanWpl (short nWayNum,
										char* szActLocName, 
										CFile* ptFile);
	BOOL WriteMagellanRte (CString szRte, short nWayNum, char* szActLocName, CFile* ptFile);
	BOOL SendMagellanRte (short nRteID, short* ptRequestIDCnt,
										BOOL* ptOK, BOOL* ptStop, BOOL* ptConnected,
										CFile* ptFile);

protected:

	// Generated message map functions
	//{{AFX_MSG(CWriteToGpsDlg)
	afx_msg LONG OnGpsEvent(UINT wParam, LONG lParam);
	afx_msg void OnWriteRte();
	afx_msg void OnTimer(UINT nIDEvent);
	virtual BOOL OnInitDialog();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WRGPSRT_H__4BA2B5C2_35AB_11D2_BFB4_DD4FD09F7F7F__INCLUDED_)
