// gpsdlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h" 

#include "GpsDoc.h"
#include "gpsdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CGpsChooseDlg dialog
#define USB_PORT	8


CGpsChooseDlg::CGpsChooseDlg(CWnd* pParent, CGpsDoc* ptDoc)
	: CDlgTool(CGpsChooseDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpsChooseDlg)
	m_nActPortID = -1;
	//}}AFX_DATA_INIT
	
m_ptGpsDoc	= ptDoc;	
m_nActGpsID = ptDoc->GetGpsListIndex ();
m_nActUsbID = ptDoc->GetUsbListIndex();
m_nActPortID= ptDoc->GetPortID() - 1;
}

void CGpsChooseDlg::GetGpsSpec (CGpsDoc* ptDoc)
{
ptDoc->SetGpsListIndex (m_nActGpsID);
ptDoc->SetUsbListIndex(m_nActUsbID);
ptDoc->SetPortID (m_nActPortID+1);
}

void CGpsChooseDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpsChooseDlg)
	DDX_Control(pDX, ID_GCUSBLIST, m_USBList);
	DDX_Control(pDX, ID_GCLIST, m_GpsList);
	DDX_Radio(pDX, ID_GCCOM1, m_nActPortID);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGpsChooseDlg, CDlgTool)
	//{{AFX_MSG_MAP(CGpsChooseDlg)
	ON_LBN_SELCHANGE(ID_GCLIST, OnSelchangeGPS)
	ON_LBN_DBLCLK(ID_GCLIST, OnDblclkGPS)
	ON_WM_HELPINFO()
	ON_LBN_SELCHANGE(ID_GCUSBLIST, OnSelchangeUSB)
	ON_BN_CLICKED(ID_GCUSB, OnSelUsbPort)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CGpsChooseDlg message handlers

/*********************************************************************
 *  GpsDlg.cpp				O n S e l c h a n g e G P S			     *
 *********************************************************************/
void CGpsChooseDlg::OnSelchangeGPS()
{
	// TODO: Add your control notification handler code here  
	char	szText[128];
	short nIndex = m_GpsList.GetCurSel();
	m_GpsList.GetText (nIndex, (LPTSTR)szText);
		
	m_nActGpsID = nIndex;		// list index starts with 1, first GPS enum = 0

	if (m_nActGpsID-1 == GPSLINK1)			// GPSLINK1 = 2
	{			// USB not possible
		this->DisableControl(ID_GCUSB, FALSE);
	}
	else
	{			// USB not possible

		short nBtnId = this->GetCheckedRadioButton(ID_GCCOM1, ID_GCUSB);
		m_nActPortID = nBtnId - ID_GCCOM1;

		if (m_nActPortID == USB_PORT)
		{							// switch to first COM port
			m_nActPortID = 0;		
									// first, last, actual
			this->CheckRadioButton(ID_GCCOM1, ID_GCUSB, ID_GCCOM1 + m_nActPortID);
		}

		this->DisableControl(ID_GCUSB, TRUE);
	}
}

/*********************************************************************
 *  GpsDlg.cpp				O n S e l c h a n g e U S B			     *
 *********************************************************************/
void CGpsChooseDlg::OnSelchangeUSB() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
char	szText[128];
short nIndex = m_USBList.GetCurSel();
m_USBList.GetText (nIndex, (LPTSTR)szText);
	
m_nActUsbID = nIndex;
	
}

/*********************************************************************
 *  GpsDlg.cpp				O n D b l c l k G P S				     *
 *********************************************************************/
void CGpsChooseDlg::OnDblclkGPS()
{
	// TODO: Add your control notification handler code here
this->OnOK();	
}

/************************************************************************
 *  GpsDlg.cpp			F i l l G P S C h o o s e L i s t				*
 ************************************************************************/
void CGpsChooseDlg::FillGPSChooseList ()
{
	if (m_ptGpsDoc != NULL)
	{
		CString szText;
		szText.LoadString (IDS_GPS_NONE);
		m_GpsList.AddString ((LPCTSTR)szText); 		/* first entry: no GPS	*/

		short i;
		for (i=0; i<m_ptGpsDoc->GetGpsCnt(); i++)		/* fill list box	*/
		{    
			LPGPS ptGPS = m_ptGpsDoc->GetGpsPtr(i); 
			m_GpsList.AddString ((LPCSTR)ptGPS->szName);
		}
	}
}   

/*********************************************************************
 *  GpsDlg.cpp				O n I n i t D i a l o g				     *
 *********************************************************************/
BOOL CGpsChooseDlg::OnInitDialog()
{
	CDlgTool::OnInitDialog();
	
		// TODO: Add extra initialization here  
	this->FillGPSChooseList ();

	m_GpsList.SetCurSel(m_nActGpsID);     

	CSerCom Ser (4800, 8, (float)1.0, NO);

	short	i, nActSel;
	short	nOpenCnt = 0;
	short	nSelectPort = 0;

	for (i=ID_GCCOM1; i<=ID_GCCOM8; i++)
    {
		short nPortID = i-ID_GCCOM1+1;		// nPortID: 1...8

		if (Ser.IsAvailable(nPortID))		// opens and closes connection
		{
			if ((nOpenCnt==0) || (nPortID == m_nActPortID+1))
				nSelectPort = nPortID;
			nOpenCnt++;
		}
	    else
		{
			this->DisableControl (i, TRUE);
		}
    }
	
	if (m_nActPortID != USB_PORT)			
	{						// nSelectPort:  1...8
		if (nOpenCnt > 0)
			 m_nActPortID = nSelectPort-1;			// m_nActPortID: 0...7 (RS-232)
		else m_nActPortID = USB_PORT;				// USB (8)
	}

	nActSel = ID_GCCOM1 + m_nActPortID;
		
       
						// fill USB list
	m_Usb.EnumInterfaceDevices("{2C9C45C2-8E7D-4C08-A12D-816BBAE722C0}");

	for (i=0; i<m_Usb.GetDeviceCnt(); i++)
	{
		CUsbDevice* ptUsbDevice = m_Usb.GetDevicePtr(i);
		if (ptUsbDevice != NULL)
		{
			m_USBList.AddString ((LPCSTR)ptUsbDevice->GetDescription());
		}
	}

	if (m_Usb.GetDeviceCnt() == 0)
	{
		m_nActUsbID = -1;
		if (m_nActPortID == USB_PORT)	// USB was selected, but no device present:
			nActSel = ID_GCCOM1;
	}
	else
	{							// USB device available
		if (m_nActUsbID >= m_Usb.GetDeviceCnt())
			m_nActUsbID = 0;

		if (m_nActUsbID < 0)	// but no device selected
			m_nActUsbID = 0;	// select first device
	}

								// first, last, actual
	this->CheckRadioButton(ID_GCCOM1, ID_GCUSB, nActSel);

	m_USBList.SetCurSel(m_nActUsbID);     



this->OnSelchangeGPS();			// sets actual GPS protocol 
this->OnSelchangeUSB();			// sets actual USB device

return TRUE;  // return TRUE  unless you set the focus to a control
}


/************************************************************************
 *  GpsDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CGpsChooseDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}

void CGpsChooseDlg::OnSelUsbPort() 
{
								// jsut switched from COM port to USB port:
	if (m_Usb.GetDeviceCnt() > 0)	
	{							// USB devices present:
		if (m_nActUsbID < 0)	// but no device selected
		{
			m_nActUsbID = 0;	// select first device
			m_USBList.SetCurSel(m_nActUsbID);   
		}
	}
}
