/************************************************************************
 *  							G p s D o c . c p p  					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "GpsDlg.h"				// dialog to set GPS specification
#include "GpsDoc.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpsDoc
IMPLEMENT_DYNCREATE(CGpsDoc, CDocument)

BEGIN_MESSAGE_MAP(CGpsDoc, CDocument)
	//{{AFX_MSG_MAP(CGpsDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpsDoc construction/destruction

CGpsDoc::CGpsDoc()
{                                      
m_ActGPS.nGpsID = 0; 	    // GPS_LIST...
m_ActGPS.nUsbID = 0;		// USB_LIST...
m_ActGPS.nPortID = 1;	    // ID of COM port (1-8), USB(9)
strcpy(m_ActGPS.szLastWrittenRte, "1");
strcpy(m_ActGPS.szLastReadRte, "1");
strcpy(m_ActGPS.szLastReadTrk, "0");


short	i;
for (i=0; i<GPSCNT; i++)
    { 
    GPSTYPE* ptGPS = new GPSTYPE;
	if (ptGPS != NULL)
		{
		CString szGpsSpec;
		szGpsSpec.LoadString (IDS_GPSG100STD+i);  
		if (SplitGpsSpec (szGpsSpec, ptGPS))
     		m_GpsList.Add (ptGPS);		// add new Element    
		}
    }
}

CGpsDoc::~CGpsDoc()
{         
this->DeleteArrayOf (&m_GpsList);
}
       
/************************************************************************
 *  GpsDoc.cpp				S p l i t G p s S p e c						*
 ************************************************************************/
BOOL CGpsDoc::SplitGpsSpec (CString szGpsSpec, GPSTYPE* ptGPS)
{      
char	szBuffer[256];
short	i;
char* ptToken = NULL;

strcpy (szBuffer, (LPCTSTR)szGpsSpec);

ptToken = strtok (szBuffer, ";");
if (ptToken != NULL)
    strcpy (ptGPS->szName, ptToken);	// SIZEOF_GPS = 128
else return FALSE;

ptToken = strtok (NULL, ";");
if (ptToken != NULL)
    ptGPS->nGpsID = atoi(ptToken);
else return FALSE;

ptToken = strtok (NULL, ";");
if (ptToken != NULL)
    ptGPS->nMaxRouteCnt = atoi(ptToken);
else return FALSE;

ptToken = strtok (NULL, ";");
if (ptToken != NULL)
    ptGPS->nMaxRteWpts	= atoi(ptToken);
else return FALSE;

ptToken = strtok (NULL, ";");
if (ptToken != NULL)
    ptGPS->nMaxWptChars = atoi(ptToken);
else return FALSE;

ptToken = strtok (NULL, ";");
if (ptToken != NULL)
    ptGPS->nMaxTrackCnt = atoi(ptToken);
else return FALSE;

ptToken = strtok (NULL, ";");
if (ptToken != NULL)
    ptGPS->nProtocol = atoi(ptToken);
else return FALSE;

ptToken = strtok (NULL, ";");
if (ptToken != NULL)
    ptGPS->nBaudRate = atoi(ptToken);
else return FALSE;

ptToken = strtok (NULL, ";");
if (ptToken != NULL)
    ptGPS->nDataBits = atoi(ptToken);
else return FALSE;

ptToken = strtok (NULL, ";");
if (ptToken != NULL)
    ptGPS->nStopBits = atoi(ptToken);
else return FALSE;

for (i=0; i<6; i++)
    {
    ptToken = strtok (NULL, ";");
    if (ptToken != NULL)
	ptGPS->cWptType[i+1] = (*ptToken != ' ')?
			       (unsigned char)*ptToken :
			       (unsigned char)0xFF;
    else return FALSE;
    }

return TRUE;
}    

/************************************************************************
 *  GpsDoc.cpp					I s U s b P r o t o c o l 				*
 ************************************************************************/
BOOL CGpsDoc::IsUsbProtocol()
{
	return (m_ActGPS.nPortID == 9);	    // ID of COM port (1-8), USB(9)
}

/************************************************************************
 *  GpsDoc.cpp					G e t G p s C n t						*
 ************************************************************************/
short CGpsDoc::GetGpsCnt ()
{
	return m_GpsList.GetSize();
}

/************************************************************************
 *  GpsDoc.cpp					G e t G p s P t r						*
 ************************************************************************/
LPGPS CGpsDoc::GetGpsPtr (short nIndex)
{
LPGPS lpGps = NULL;

if (nIndex>=0 && nIndex<m_GpsList.GetSize())
	{
	lpGps = (LPGPS)m_GpsList.GetAt (nIndex);  
	} 
return lpGps;      
}
 
/************************************************************************
 *  GpsDoc.cpp					G e t G p s P t r						*
 ************************************************************************/
BOOL CGpsDoc::GetGpsPtr (short nIndex, CGps* ptGps)
{
BOOL bOK = FALSE;

if (nIndex >= 0 && nIndex < m_GpsList.GetSize())
	{
	LPGPS lpGps = (LPGPS)m_GpsList.GetAt(nIndex);
	ptGps->SetPtr (lpGps);
	bOK = TRUE;
	}

return bOK;
}

/************************************************************************
 *  GpsDoc.cpp				G e t A c t G p s I n d						*
 ************************************************************************/
BOOL CGpsDoc::GetActGpsInd (short* ptInd)
{  
BOOL bOK=FALSE;

short nActGpsInd = this->GetGpsListIndex () - 1;   
if (nActGpsInd >= 0)
	{
	*ptInd = nActGpsInd;
	bOK = TRUE;
	}
return bOK;
}
                        
/************************************************************************
 *  GpsDoc.cpp				G e t A c t G p s N a m e  					*
 ************************************************************************/
CString CGpsDoc::GetActGpsName ()
{  
short nActGpsID = this->GetGpsListIndex () - 1;   
CGps Gps ((LPGPS)m_GpsList.GetAt(nActGpsID));
return Gps.GetName();
}

/************************************************************************
 *  GpsDoc.cpp				A c t G p s C a n S t o r e T r a c k 		*
 ************************************************************************/
BOOL CGpsDoc::ActGpsCanStoreTrack()
{
	BOOL bStoreTrack = FALSE;
	short nGpsIndex;
	if (this->GetActGpsInd (&nGpsIndex))
	{
		CGps ActGPS;
		if (this->GetGpsPtr(nGpsIndex, &ActGPS))
		{
			bStoreTrack = (ActGPS.GetMaxTrackCnt() > 0);
		}
	}
	return bStoreTrack;
}

/************************************************************************
 *  KoordDoc.cpp			D e l e t e A r r a y O f 					*
 ************************************************************************/
void CGpsDoc::DeleteArrayOf (CPtrArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	GPSTYPE* ptEntry;
	if ((ptEntry = (GPSTYPE*)ptArray->GetAt(i)) != NULL)
		{
		TRACE ("Deleting GPS List %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}                                     

/************************************************************************
 *  GpsDoc.cpp	  		 		 C h a n g e 							*
 ************************************************************************/
void CGpsDoc::Change(CWnd* ptWnd)
{
CGpsChooseDlg GpsChooseDlg(ptWnd, this);
   
int RetVal = GpsChooseDlg.DoModal();

switch (RetVal)
	{
	case IDOK:   
		GpsChooseDlg.GetGpsSpec (this);    
 		ptWnd->InvalidateRect(NULL);

		break;
	case IDCANCEL:
		break;
	}	
} 


/************************************************************************
 *  GpsDoc.cpp				S e t W r i t t e n R t e					*
 ************************************************************************/
void CGpsDoc::SetWrittenRte(CString szName)
{    
	_fstrcpy (m_ActGPS.szLastWrittenRte, (LPCTSTR)szName); 
}     

/************************************************************************
 *  GpsDoc.cpp				S e t R e a d R t e							*
 ************************************************************************/
void CGpsDoc::SetReadRte(CString szName)
{    
	_fstrcpy (m_ActGPS.szLastReadRte, (LPCTSTR)szName); 
}             

/************************************************************************
 *  GpsDoc.cpp				S e t R e a d T r k							*
 ************************************************************************/
void CGpsDoc::SetReadTrk(CString szName)
{    
	_fstrcpy (m_ActGPS.szLastReadTrk, (LPCTSTR)szName); 
}             
        

/************************************************************************
 *  GpsDoc.cpp    		 		G e t W r i t t e n R t e 				*
 ************************************************************************/
CString CGpsDoc::GetWrittenRte()
{         
	CString szName = (CString)m_ActGPS.szLastWrittenRte;
	return szName;
}

/************************************************************************
 *  GpsDoc.cpp    		 		G e t R e a d R t e						*
 ************************************************************************/
CString CGpsDoc::GetReadRte()
{         
	CString szName = (CString)m_ActGPS.szLastReadRte;
	return szName;
}

/************************************************************************
 *  GpsDoc.cpp    		 		G e t R e a d T r k						*
 ************************************************************************/
CString CGpsDoc::GetReadTrk()
{         
	CString szName = (CString)m_ActGPS.szLastReadTrk;
	return szName;
}


/************************************************************************
 *  GpsDoc.cpp	  		 		 S e r i a l i z e 						*
 ************************************************************************/
void CGpsDoc::Serialize(CArchive& ar, short nVersion)
{    
	if (ar.IsStoring())
	{
			// TODO: add storing code here   
		ar.Write (&m_ActGPS, sizeof (GPSCHOOSED));		   
	}
	else
	{
			// TODO: add loading code here  
		if (nVersion <= 32)
		{
			GPSCHOOSED32 oldGPS;
			ar.Read (&oldGPS, sizeof (GPSCHOOSED32));
			m_ActGPS.nGpsID				= oldGPS.nGpsID;
			m_ActGPS.nUsbID				= 0;
			m_ActGPS.nPortID			= oldGPS.nPortID;

			memset(m_ActGPS.szLastWrittenRte, 0, RTE_TRK_NAME_SIZE);
			memset(m_ActGPS.szLastReadRte, 0, RTE_TRK_NAME_SIZE);
			memset(m_ActGPS.szLastReadTrk, 0, RTE_TRK_NAME_SIZE);

			sprintf(m_ActGPS.szLastWrittenRte, "%d", oldGPS.nLastWrittenRte);
			sprintf(m_ActGPS.szLastReadRte, "%d", oldGPS.nLastReadRte);
			sprintf(m_ActGPS.szLastReadTrk, "%d", oldGPS.nLastReadTrk);
		}
		else
		{		
			ar.Read (&m_ActGPS, sizeof (GPSCHOOSED));
		}
	}
}


 