#ifndef __GPSDOC__
#define __GPSDOC__

/************************************************************************
 *  							G p s D o c . h 	 					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "Gps.h"						// defines GPSTYPE

#define RTE_TRK_NAME_SIZE	32

class CGpsDoc : public CDocument
{ 
protected: // create from serialization only
	DECLARE_DYNCREATE(CGpsDoc)

protected:   
	#define GPS_BUFF_SIZE 256
	#define GPSCNT (IDS_GPSOTHER - IDS_GPSG100STD + 1)


// Attributes
public:                      

typedef struct
	{
	short	nGpsID; 	    // GPS_LIST...
	short	nPortID;	    // ID of COM port (1-8), USB (9)
	short	nLastWrittenRte;
	short	nLastReadRte;
	short	nLastReadTrk;
	} GPSCHOOSED32;

	
typedef struct
	{
	short	nGpsID; 	    // GPS_LIST...
	short	nUsbID;			// USB_LIST...
	short	nPortID;	    // ID of COM port (1-8), USB (9)
	char	szLastWrittenRte[RTE_TRK_NAME_SIZE];
	char	szLastReadRte[RTE_TRK_NAME_SIZE];
	char	szLastReadTrk[RTE_TRK_NAME_SIZE];
	} GPSCHOOSED;
	

	GPSCHOOSED	m_ActGPS;	 
    CPtrArray 	m_GpsList;  			// array of GPSTYPE

	// Operations
public:
	CGpsDoc();	
	~CGpsDoc();   

	short GetGpsCnt ();
	LPGPS GetGpsPtr (short nIndex);
	BOOL GetGpsPtr (short nIndex, CGps* ptGps);
	BOOL GetActGpsInd (short* ptInd);

	CString GetActGpsName ();
	BOOL ActGpsCanStoreTrack();

	void Change (CWnd* ptWnd);
	void Serialize(CArchive& ar, short nVersion);
     
     
    void SetGpsListIndex (short nID){m_ActGPS.nGpsID = nID;}
    void SetUsbListIndex (short nID){m_ActGPS.nUsbID = nID;}
	void SetPortID (short nID){m_ActGPS.nPortID = nID;}
	void SetWrittenRte(CString szName);
	void SetReadRte(CString szName);
	void SetReadTrk(CString szName);

 	short	GetGpsListIndex (){return m_ActGPS.nGpsID;}   
 	short	GetUsbListIndex (){return m_ActGPS.nUsbID;}   
	short	GetPortID (){return m_ActGPS.nPortID;}   
	BOOL IsUsbProtocol();

	CString GetWrittenRte();
	CString GetReadRte();
	CString GetReadTrk();
	  
// Implementation
protected:          
	BOOL SplitGpsSpec (CString szGpsSpec, GPSTYPE* ptGPS);
  	void DeleteArrayOf (CPtrArray* ptArray);

	// Generated message map functions
protected:
	//{{AFX_MSG(CGpsDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 
