// Import.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de


#include "stdafx.h"
#include "resource.h"
#include "Import.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// class CImport 


/************************************************************************
 *  Import.cpp					C I m p o r t			Constructor	*
 ************************************************************************/
CImport::CImport()
{
	strcpy (m_szDel, "\t");
	m_szImportFile = _T("");
	m_ptParamFile	= NULL;
	m_nLine			= 0;
	m_nStaticColumnIndex = 0;
}

/************************************************************************
 *  Import.cpp				~ C I m p o r t					Destructor	*
 ************************************************************************/
CImport::~CImport()
{
	if (m_ptParamFile != NULL)
	{
		m_ptParamFile->Close();
		delete m_ptParamFile;
		m_ptParamFile = NULL;
	}

	if (m_Values.GetSize() > 0)		// remove parameters of last line
		m_Values.RemoveAll();
	
	this->DeleteArrayOf (&m_Columns);
}

/************************************************************************
 *  Import.cpp			D e l e t e A r r a y O f 						*
 ************************************************************************/
void CImport::DeleteArrayOf (CPtrArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	COLUMNINFO* ptEntry;
	if ((ptEntry = (COLUMNINFO*)ptArray->GetAt(i)) != NULL)
		{
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}                

/****************************************************************************
 *  Import.cpp			GetSourceFileName				*
 ****************************************************************************/
BOOL CImport::GetSourceFileName(CWnd* ptParentWnd) 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	BOOL bOK = FALSE;
	static char szFilter[] = "Import (*.txt)|*.txt||"; 

	CFileDialog dlg(TRUE, 	  					// File Open dialog
					NULL,						// no default extension
					"*.txt",					// initial filename
					OFN_HIDEREADONLY |	  		// dwFlags
					OFN_OVERWRITEPROMPT,
					szFilter,
					ptParentWnd);				// parent window

	//CString szPath = this->GetActPathName();	// without NameExt
	//dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;

	int ret = dlg.DoModal();
	if (ret == IDOK)
	{
		m_szImportFile = dlg.GetPathName();
		bOK = TRUE;
	}

	return bOK;
}


/****************************************************************************
 *  Import.cpp					S p l i t L i n e							*
 ****************************************************************************/
long CImport::SplitLine (CString szLine, CStringArray* ptTokens)
{
	char	szBuffer[512];
	BOOL	bStop = FALSE;
	short	nLineLen=0;
	short	nStartIndex = 0;
	short	nDelIndex = -1;

	strcpy (szBuffer, (LPCTSTR)szLine);
	nLineLen = strlen (szBuffer);

	do	
	{
		if (nStartIndex < nLineLen)
		{
			char* ptDel = strstr(szBuffer+nStartIndex, m_szDel);
			if (ptDel != NULL)	nDelIndex = ptDel - szBuffer;
				else			nDelIndex = nLineLen;	// no delimiter after last token

			bStop = (nStartIndex > nDelIndex);
		}
		else
		{							// no delimiter after last token 				
			bStop = TRUE;
		}

		if (!bStop)
		{
			short nTokenLen = nDelIndex - nStartIndex;
				
			CString szToken;
			szToken = szLine.Mid(nStartIndex, nTokenLen);
			szToken.TrimLeft();			// remove leading spaces
			szToken.TrimRight();		// remove trailing spaces
			ptTokens->Add (szToken);

			nStartIndex = nDelIndex+1;
		}

	} while (!bStop);

	return (long)ptTokens->GetSize();
}


/****************************************************************************
 *  Import.cpp				S p l i t V a l u e P a r a m					*
 *  Input: szPair = "Value=Param"											*
 *	Output: szValue = "Value", szParam = "Param"							*
 *  returns TRUE, if szParam is defined										*
 ****************************************************************************/
BOOL CImport::SplitValueParam(CString szPair, CString* ptValue, CString* ptParam)
{
	BOOL bParam=FALSE;

	short nCutIndex = szPair.Find ('=');
	if (nCutIndex > 0)
	{
		*ptValue = szPair.Left(nCutIndex);
		*ptParam = szPair.Right(szPair.GetLength()-nCutIndex-1);
		bParam = TRUE;
	}
	else
	{
		*ptValue = szPair;
		*ptParam = "NONE";
	}

	ptValue->TrimLeft();		// remove leading spaces
	ptValue->TrimRight();		// remove trailing spaces
	ptParam->TrimLeft();		// remove leading spaces
	ptParam->TrimRight();		// remove trailing spaces

	return bParam;
}


/****************************************************************************
 *  Import.cpp						O p e n									*
 *  Purpose: Opens text file and reads DELIMITER and token order			*
 ****************************************************************************/
BOOL CImport::Open()
{
	BOOL bOK = FALSE;
	BOOL bStop = FALSE;

	if (m_szImportFile.GetLength() > 0)
	{							// name of input file defined
		m_nLine=0;

		m_ptParamFile = new CStdioFile((LPCTSTR)m_szImportFile, CFile::modeRead | CFile::typeText);

								
		CString szLine, szValue, szParam;
		while (!bStop && m_nLine<2 && m_ptParamFile->ReadString(szLine))
		{						
			m_nLine++;

			if (m_nLine==1)		// reading delimiter
			{
				this->SplitValueParam(szLine, &szValue, &szParam);
				if (szValue.Compare("DELIMITER") == 0)
				{
					if (szParam.GetLength()==1)
						 strcpy (m_szDel, (LPCTSTR)szParam);
					else bStop = TRUE;
				}
				else
				{
					bStop = TRUE;
				}

				if (bStop)
				{
					CString szMsg;
					szMsg.Format (IDF_IMP_DELIMITER, m_nLine);
					AfxMessageBox (szMsg);							
				}
			}

			if (m_nLine==2)		// reading tokens
			{
				CStringArray szTokens;
				m_nDefinedTokenCnt = (short)this->SplitLine(szLine, &szTokens);
				bStop = (m_nDefinedTokenCnt > m_Columns.GetSize());
	
				if (bStop)
				{			
					CString szMsg;
					szMsg.Format (IDF_IMP_COLUMNS,  m_nLine, m_nDefinedTokenCnt, m_Columns.GetSize());
					AfxMessageBox (szMsg);
				}
			
				for (int i=0; i<m_nDefinedTokenCnt && !bStop; i++)
				{				// get array of TOKEN=DEFAULT pairs
					BOOL	bFound = FALSE;
					CString szPair;
					szPair = (CString)szTokens.GetAt(i);

					this->SplitValueParam(szPair, &szValue, &szParam);

					for (int j=0; j<m_Columns.GetSize() && !bFound; j++)
					{
						COLUMNINFO* ptColumn = (COLUMNINFO*)m_Columns.GetAt(j);
						if (ptColumn != NULL)
						{
							if (ptColumn->szName.Compare(szValue) == 0)
							{
								bFound = TRUE;
								ptColumn->nDynamicIndex = i;	// actual index for this token
								ptColumn->szDefaultValue = szParam;
							}
						}
					}
					
					if (!bFound)
					{
						CString szMsg;
						szMsg.Format (IDF_IMP_UNKNOWN, m_nLine, i, (LPCTSTR)szValue);
						AfxMessageBox (szMsg);
						bStop = TRUE;
					}
				}
			}
		}

		bOK = ((m_nLine==2) && !bStop);
	}
return bOK;
}


/****************************************************************************
 *  Import.cpp					P a r s e L i n e							*
 ****************************************************************************/
BOOL CImport::ParseLine(BOOL* ptAborted)
{
	BOOL bOK = FALSE;

	if (m_ptParamFile != NULL && !(*ptAborted))
	{							// name of input file defined
		CString szLine;
		short nActTokenCnt;
		
		if (m_ptParamFile->ReadString(szLine))
		{						
			m_nLine++;

			if (m_nLine>2)		// reading data
			{
				if (m_Values.GetSize() > 0)		// remove parameters of last line
					m_Values.RemoveAll();

				nActTokenCnt = (short)this->SplitLine(szLine, &m_Values);
				bOK = ( nActTokenCnt == m_nDefinedTokenCnt &&		// tokens in line 2
						nActTokenCnt <= m_Columns.GetSize());		// max. nuber of columns
				
				if (!bOK)
					(*ptAborted) = TRUE;
			}
		}

		if (szLine.GetLength() > 0 && !bOK)
		{
			if (nActTokenCnt != m_nDefinedTokenCnt)
			{
				CString szMsg;
				szMsg.Format (IDF_IMP_TOKENS, m_nLine, nActTokenCnt, m_nDefinedTokenCnt);
				AfxMessageBox (szMsg);			
			}
			else
			{
				if (nActTokenCnt > m_Columns.GetSize())
				{
					CString szMsg;
					szMsg.Format (IDF_IMP_COLUMNS, m_nLine, nActTokenCnt, m_Columns.GetSize());
					AfxMessageBox (szMsg);			
				}
			}			
		}

		m_nStaticColumnIndex = 0;

	}

	return bOK;
}

/****************************************************************************
 *  Import.cpp					A d d C o l u m n N a m e					*
 ****************************************************************************/
void CImport::AddColumnName (CString szName)
{
	COLUMNINFO* ptColumn = new COLUMNINFO;
	ptColumn->nDynamicIndex	= -1;
	ptColumn->szName		= szName;
	ptColumn->szDefaultValue= (CString)"NONE";

	m_Columns.Add (ptColumn);
}


/****************************************************************************
 *  Import.cpp					G e t C o l u m n P a r a m 				*
 *  must be called after ParseLine each possible column						*
 ****************************************************************************/
BOOL CImport::GetColumnParam (CString* ptParam)
{
	BOOL bOK = FALSE;
	if (m_nStaticColumnIndex >=0 && m_nStaticColumnIndex < m_Columns.GetSize())
	{
		BOOL bUseDefault = TRUE;

		COLUMNINFO* ptColumn = (COLUMNINFO*)m_Columns.GetAt(m_nStaticColumnIndex++);

		if (ptColumn->nDynamicIndex >= 0)
		{				// use actual data
			*ptParam = m_Values.GetAt(ptColumn->nDynamicIndex);	// use data column index
			bUseDefault = (ptParam->GetLength() == 0);
		}


		if (bUseDefault)
		{				// use default value
			*ptParam = ptColumn->szDefaultValue;
		}

		bOK = (ptParam->Compare("NONE") != 0);
	}

	return bOK;
}
