#ifndef __IMPORT_DATA__
#define __IMPORT_DATA__

// Import.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

typedef struct
{
	CString szName;
	CString szDefaultValue;
	short	nDynamicIndex;
} COLUMNINFO;

/////////////////////////////////////////////////////////////////////////////
// class CImport 

class CImport
{
// Konstruktion
public:
	CImport();   // Standardkonstruktor
	~CImport();

	void DeleteArrayOf (CPtrArray* ptArray);
	BOOL GetSourceFileName(CWnd* ptParentWnd); 
	BOOL SplitValueParam(CString szPair, CString* ptValue, CString* ptParam);
	long SplitLine (CString szLine, CStringArray* ptTokens);
	BOOL Open();
	BOOL ParseLine(BOOL* ptAborted);
	void AddColumnName (CString szName);
	BOOL GetColumnParam (CString* ptParam);


private:
	char			m_szDel[2];
	CString			m_szImportFile;
	CPtrArray		m_Columns;		// array of COLUMNINFO
	CStdioFile*		m_ptParamFile;
	CStringArray	m_Values;		// array of CString for one data line

	short			m_nLine;
	short			m_nStaticColumnIndex;
	short			m_nDefinedTokenCnt;		// number of tokens specified in line 2
};

#endif // __IMPORT_DATA__
