// initdlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"  

#include "DimDoc.h"         
#include "InitDoc.h" 
#include "LocDoc.h"      
#include "PlaneDoc.h"
#include "ElevDoc.h"
#include "ElevArrayDoc.h"
#include "initdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL bDemo;

/////////////////////////////////////////////////////////////////////////////
// CInitDlg dialog


CInitDlg::CInitDlg(CWnd* pParent, CInitDoc* ptInit, 
						CLocDoc*	ptLocDoc, 
						CPlaneDoc*	ptPlaneDoc,
						CElevDoc*	ptElevDoc,
						CElevArrayDoc*	ptElevArrayDoc,

						CElevColorDoc*	ptSeaElevColorDoc,
						CElevColorDoc*	ptFlightElevColorDoc)
	: CDialog(CInitDlg::IDD, pParent)
{
//{{AFX_DATA_INIT(CInitDlg)
m_szName = "";
m_szLoc = "";
	//}}AFX_DATA_INIT
	          
m_szName = ptInit->GetCustName ();
m_szLoc	 = ptInit->GetCustLoc ();

m_ptInit			= ptInit;
m_ptLocDoc			= ptLocDoc;	    
m_ptPlaneDoc		= ptPlaneDoc;	   
m_ptElevDoc			= ptElevDoc; 
m_ptElevArrayDoc	= ptElevArrayDoc; 

m_ptSeaElevColorDoc		= ptSeaElevColorDoc;
m_ptFlightElevColorDoc	= ptFlightElevColorDoc;

m_bTimerKilled 		= FALSE;
m_bInitialized 		= FALSE;

ptInit->SetElevDocPtr(ptElevDoc);
ptInit->SetElevArrayDocPtr(ptElevArrayDoc);

ptInit->SetElevColorDocPtr(ptSeaElevColorDoc, CElevColorDoc::SEA_BASED);
ptInit->SetElevColorDocPtr(ptFlightElevColorDoc, CElevColorDoc::FLIGHT_BASED);
}

void CInitDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInitDlg)
	DDX_Text(pDX, IDC_TINAME, m_szName);
	DDV_MaxChars(pDX, m_szName, 30);
	DDX_Text(pDX, IDC_TIORT, m_szLoc);
	DDV_MaxChars(pDX, m_szLoc, 20);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CInitDlg, CDialog) 
	ON_COMMAND(IDC_TINAME, OnStartInit)

	//{{AFX_MSG_MAP(CInitDlg)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CInitDlg message handlers

BOOL CInitDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
    
    this->PostMessage (WM_COMMAND, (WPARAM)IDC_TINAME, (LPARAM)0);
   	this->SetTimer (INITIAL_TIMER, 3000, NULL);
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}   


void CInitDlg::OnStartInit()
{
  	// do time consuming initialization here
	short nActRegIndex;
	
    m_ptLocDoc->SetPathName ((LPCTSTR)m_ptInit->GetLocDocPath ());

								// to inizialize CNameList !!
	CQuickFind* ptQuickFind = m_ptInit->GetQuickFindPtr();
	//CComboBox* ptComboRegion = (CComboBox*)GetDlgItem (IDC_TIREGION);
	

	ptQuickFind->SetLocDocPtr (m_ptLocDoc);		// must be set first!! 

	CStringArray Regions;
	nActRegIndex = ptQuickFind->CheckRegionNames(&Regions, m_ptInit->GetLocDocPath());
	if (m_ptInit->IsJustInstalled ())
		ptQuickFind->ActivateRegion (nActRegIndex);

	ptQuickFind->Update(nActRegIndex);


	if (m_ptInit->IsJustInstalled() || bDemo)
	{				// normally this is done in CInitDoc::Serialize
		CAirspaceRegionsDoc* ptAirspaceRegionsDoc = m_ptInit->GetAirspaceRegionsDocPtr();
		if (ptAirspaceRegionsDoc != NULL)
		{				// for each activated loc region, activate the airspace
			CObArray*  ptLocRegions = ptQuickFind->GetRegionsPtr();
			if (ptLocRegions != NULL)
			{				// actualize airspace regions
				CString szPath = m_ptInit->GetAirspaceDocPath ();
				ptAirspaceRegionsDoc->ReadBordersFrom(szPath);
				ptAirspaceRegionsDoc->ActivateFor(ptLocRegions);
				ptAirspaceRegionsDoc->CheckAirspacePath(szPath);
			}
		}
	}


	BOOL bAddToMRU = FALSE;
    m_ptPlaneDoc->SetPathName ((LPCTSTR)m_ptInit->GetPlaneDocPath (), bAddToMRU);
    m_ptPlaneDoc->OnOpenDocument (m_ptPlaneDoc->GetPathName());       


    m_ptElevDoc->SetPathName ((LPCTSTR)m_ptInit->GetElevDocPath (), bAddToMRU);
    m_ptElevDoc->OnOpenDocument (m_ptElevDoc->GetPathName());       

    m_ptElevArrayDoc->SetPathName ((LPCTSTR)m_ptInit->GetElevArrayDocPath (), bAddToMRU);
    m_ptElevArrayDoc->OnOpenDocument (m_ptElevArrayDoc->GetPathName());       
   
	m_ptSeaElevColorDoc->SetPathName ((LPCTSTR)m_ptInit->GetSeaElevColDocPath (), bAddToMRU);
	if (CInitDoc::FileExists(m_ptSeaElevColorDoc->GetPathName()))
		m_ptSeaElevColorDoc->OnOpenDocument (m_ptSeaElevColorDoc->GetPathName());       	

    m_ptFlightElevColorDoc->SetPathName ((LPCTSTR)m_ptInit->GetFlightElevColDocPath (), bAddToMRU);
	if (CInitDoc::FileExists(m_ptFlightElevColorDoc->GetPathName()))
	    m_ptFlightElevColorDoc->OnOpenDocument (m_ptFlightElevColorDoc->GetPathName());       	



	CLocation HomeBase;
	if (m_ptInit->IsJustInstalled())
		{
		if (bDemo)
		{
			if (!ptQuickFind->GetHomeBase("EDFE", &HomeBase))	// try to find EDFE in demo data base
				HomeBase = m_ptInit->CreateHomeBase ();			// else: use hardcoded values for EDFE
		}
		else
		{
			if (!ptQuickFind->GetHomeBase(&HomeBase))	// try to find first airport in data base
				HomeBase = m_ptInit->CreateHomeBase ();			// else: use hardcoded values for EDFE
		}

		m_ptInit->SetHomeBase (HomeBase);
		}
    m_bInitialized = TRUE;
	if (m_bTimerKilled)
		this->OnOK();
}

void CInitDlg::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	if (nIDEvent == INITIAL_TIMER)
		{
		this->KillTimer (nIDEvent);
		m_bTimerKilled = TRUE;
		}        
	if (m_bInitialized)
		this->OnOK();

	CDialog::OnTimer(nIDEvent);
}
