// InitDoc.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "..\CppTools\DirBrDlg.h"
#include "InitDoc.h"
 
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL bDemo;

/////////////////////////////////////////////////////////////////////////////
// CInitDoc

IMPLEMENT_SERIAL(CInitDoc, CDocument, 0 /* schema number*/ )

/************************************************************************
 *  InitDoc.cpp 				C I n i t D o c	  			Constructor	*
 ************************************************************************/
CInitDoc::CInitDoc()
{      
//_getcwd (buffer, len);
//SetPathName ((LPCTSTR)szFileName);
m_bFirst		= TRUE;					   // used in IsJustInstalled
m_bOldIniVers	= FALSE;
m_nVers = ACT_INI_VERS;

m_ptMainWnd = NULL;

time_t	ActualTime;				// get actual time
time (&ActualTime);
m_lTime	= (long)ActualTime;
lstrcpy (m_szSerNum, (LPCTSTR)"4711");

lstrcpy (m_szPlane, (LPCTSTR)"C150");
m_szRegion		= "Germany";

m_ptFontTool	= new CFontDoc;
m_ptDim 		= new CDimDoc;    
m_ptLoad		= new CLoadDoc;      
m_ptCalc		= new CCalcDoc;  
m_ptAppend		= new CAppendixDoc; 
m_ptGps			= new CGpsDoc;        
m_ptQuickFind	= new CQuickFind;
m_ptLocation	= new CLocation;	// constructor needs m_ptDim !!	
m_ptColor		= new CColorDoc;  
m_ptMapDoc		= new CMapDoc;
m_ptMovingMapDoc= new CMovingMapDoc;
m_ptAirspaceRegionsDoc = new CAirspaceRegionsDoc;

m_ptLLtoCenter  = new CLatLon (NO_KOORD, NO_KOORD);

										// define name and ext of plane doc path
CString szFileExt;

m_bSaveSignal = FALSE;
									
	  	          				// get path name for application
m_szActualPath.Empty();
char szIniPath[256];
if (GetCurrentDirectory (256, szIniPath))
	m_szActualPath = (CString)szIniPath + "\\";

								   // store path name of PF.ini file
szFileExt.LoadString (IDS_INI_FILE);		// "PF.ini"
CString szFullPath = m_szActualPath + szFileExt;
this->SetPathName (szFullPath);


szFileExt.LoadString (IDS_PLANE_FILE);		// "PFplanes.pln"
m_szPlaneDocPath = m_szActualPath + szFileExt;

szFileExt.LoadString (IDS_ELEV_FILE);		// "PFelev.lev"
m_szElevDocPath = m_szActualPath + szFileExt;

szFileExt.LoadString (IDS_ELEV_ARRAY_FILE);		// "PFelev.ela"
m_szElevArrayDocPath = m_szActualPath + szFileExt;

		// path to search for airspace documents:
m_szAirspaceDocPath = m_szActualPath + "Airspaces\\";


szFileExt.LoadString (IDS_SEA_ELEV_FILE);		// "SeaElev.ctb"
m_szSeaElevColDocPath = m_szActualPath + szFileExt;

szFileExt.LoadString (IDS_FLIGHT_ELEV_FILE);	// "FlightElev.ctb"
m_szFlightElevColDocPath = m_szActualPath + szFileExt;


m_szLocDocPath = m_szActualPath + m_szRegion + ".krd";
}


/************************************************************************
 *  InitDoc.cpp						F i l e E x i s t s					*
 ************************************************************************/
BOOL CInitDoc::FileExists (CString szFileName)
{
BOOL	bFileOK = FALSE;
CFileStatus status;

if( CFile::GetStatus(szFileName, status ) )   // static function
	{
	bFileOK = TRUE;
	}

return bFileOK;
}

/********************************************************************************
 *	PF.cpp				G e t F i l e F r o m P a t h							*
 ********************************************************************************/
CString CInitDoc::GetFileFromPath(CString& szPath)
{
    CString szFile;

    short nSlash = szPath.ReverseFind('\\');
    if (nSlash > 0)
        szFile = szPath.Right(szPath.GetLength()-nSlash-1);
    else
        szFile = szPath;

    return szFile;
}

/********************************************************************************
 *	PF.cpp				G e t E x t F r o m P a t h								*
 ********************************************************************************/
CString CInitDoc::GetExtFromPath(CString& szPath)
{
	CString szExt;
	
	short nDot = szPath.ReverseFind('.') + 1;
	if (nDot > 0) 
	{
		short nLen = szPath.GetLength() - nDot;
		szExt = szPath.Right(nLen);
	}
	else
	{
		szExt = "";
	}

	return szExt;
}

/************************************************************************
 *  InitDoc.cpp 			O n N e w D o c u m e n t					*
 ************************************************************************/
BOOL CInitDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

BOOL CInitDoc::OnSaveDocument( LPCTSTR lpszPathName )
{
BOOL bSaved;
CFileStatus status;

BOOL bFileExists = CInitDoc::FileExists (lpszPathName);
if (bFileExists)
	{
	CFile::GetStatus(lpszPathName, status );

	status.m_attribute = CFile::normal;
	CFile::SetStatus(lpszPathName, status );
	}

bSaved = CDocument::OnSaveDocument(lpszPathName);

if (bSaved)
	{
	if (!bFileExists)
		{			// get status of new created file
		bFileExists = TRUE;
		CFile::GetStatus (lpszPathName, status);
		}

	status.m_attribute = CFile::hidden;
	CFile::SetStatus(lpszPathName, status );
	}

return bSaved;
}

/************************************************************************
 *  InitDoc.cpp 			~ C I n i t D o c	  			Destructor	*
 ************************************************************************/
CInitDoc::~CInitDoc()
{			  
delete m_ptFontTool;
delete m_ptDim;
delete m_ptLoad;   
delete m_ptCalc; 
delete m_ptAppend; 
delete m_ptGps;
delete m_ptQuickFind;
delete m_ptLocation;	
delete m_ptColor; 
delete m_ptMapDoc;
delete m_ptMovingMapDoc;
delete m_ptAirspaceRegionsDoc;
delete m_ptLLtoCenter;
}


BEGIN_MESSAGE_MAP(CInitDoc, CDocument)
	//{{AFX_MSG_MAP(CInitDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/************************************************************************
 *  InitDoc.cpp			S e t E l e v C o l o r D o c P t r				*
 ************************************************************************/
void CInitDoc::SetElevColorDocPtr(CElevColorDoc* ptDoc, short nMode)
{
	switch (nMode)
	{
	case CElevColorDoc::SEA_BASED:
		m_ptElevColDocSea = ptDoc;
		break;
	case CElevColorDoc::FLIGHT_BASED:
		m_ptElevColDocFlight = ptDoc;
		break;
	}
}

/************************************************************************
 *  InitDoc.cpp			G e t E l e v C o l o r D o c P t r				*
 ************************************************************************/
CElevColorDoc* CInitDoc::GetElevColorDocPtr(short nMode)
{
	CElevColorDoc* ptDoc = NULL;

	switch (nMode)
	{
	case CElevColorDoc::SEA_BASED:
		ptDoc = m_ptElevColDocSea;
		break;
	case CElevColorDoc::FLIGHT_BASED:
		ptDoc = m_ptElevColDocFlight;
		break;
	}

	return ptDoc;
}



/************************************************************************
 *  InitDoc.cpp				S e t L a t L o n T o C e n t e r			*
 ************************************************************************/
void CInitDoc::SetLatLonToCenter(double dLat, double dLon)
{
	m_ptLLtoCenter->SetLatLon(dLat, dLon);	// change latlon to center
}

/************************************************************************
 *  InitDoc.cpp				S e t L a t L o n T o C e n t e r			*
 ************************************************************************/
CLatLon CInitDoc::GetLatLonToCenter()
{
	return *m_ptLLtoCenter;
}


/************************************************************************
 *  InitDoc.cpp			R e s e t L a t L o n T o C e n t e r			*
 ************************************************************************/
void CInitDoc::ResetLatLonToCenter()
{
	m_ptLLtoCenter->SetLatLon(NO_KOORD, NO_KOORD);	// invalidate latlon to center
}


/************************************************************************
 *  InitDoc.cpp			I s L a t L o n T o C e n t e r V a l i d 		*
 ************************************************************************/
BOOL CInitDoc::IsLatLonToCenterValid()
{
	return m_ptLLtoCenter->IsValid();
}


/************************************************************************
 *  InitDoc.cpp				S e t L o c D o c P a t h					*
 ************************************************************************/
void CInitDoc::SetLocDocPath(CString szPath)
{
short nNameIndex = szPath.ReverseFind('\\') + 1;
short nDotIndex = szPath.ReverseFind ('.');   
CString szName = szPath.Mid (nNameIndex, nDotIndex-nNameIndex);

m_szLocDocPath = szPath;
m_szRegion = szName;
}

/************************************************************************
 *  InitDoc.cpp				S e t P l a n e N a m e						*
 ************************************************************************/
void CInitDoc::SetPlaneName(CString szPlane)
{
lstrcpy (m_szPlane, (LPCTSTR)szPlane);
}     


/************************************************************************
 *  InitDoc.cpp				C r e a t e H o m e B a s e					*
 ************************************************************************/
CLocation CInitDoc::CreateHomeBase()
{
CLocation HomeBase;

HomeBase.CreateHomeBase();

return HomeBase;
}


/************************************************************************
 *  InitDoc.cpp				S e t H o m e B a s e						*
 ************************************************************************/
void CInitDoc::SetHomeBase (CLocation Loc) 
{
*m_ptLocation = Loc;	
}   
	
/************************************************************************
 *  InitDoc.cpp				G e t H o m e B a s e 						*
 ************************************************************************/
CLocation CInitDoc::GetHomeBase ()
{ 
return *m_ptLocation; 
}

/************************************************************************
 *  InitDoc.cpp				G e t L o c D o c P a t h					*
 ************************************************************************/
CString CInitDoc::GetLocDocPath ()
{    
return m_szLocDocPath;
}
 
/************************************************************************
 *  InitDoc.cpp					G e t C u s t N a m e					*
 ************************************************************************/
CString CInitDoc::GetCustName (void)
{
return (CString)m_szName;
}  

/************************************************************************
 *  InitDoc.cpp					G e t C u s t L o c						*
 ************************************************************************/
CString CInitDoc::GetCustLoc (void)
{
return (CString)m_szLoc;
}


/////////////////////////////////////////////////////////////////////////////
// CInitDoc serialization

void CInitDoc::Serialize(CArchive& ar)
{    
	WORD Word;
	char szInit[16];
	UINT uLen = wsprintf ((LPSTR)szInit, (LPSTR)"PF_INIT")+1;
	m_bOldIniVers = FALSE;

	if (ar.IsStoring())
	{
			// TODO: add storing code here  
		ar.Write (szInit, uLen);  
		ar << m_nVers;
		ar.Write (m_szName, (UINT)CUSTNAME_SIZE);
		ar.Write (m_szLoc, (UINT)LOC_SIZE);
		ar << m_lTime;	
		ar << (WORD)m_CopyCnt;
		ar.Write (m_szSerNum, (UINT)SERNUM_SIZE);

										// installation path
		ar << m_szBasePath;				// C:
		ar << m_szNewDir;				// PF
		
										// icon path
		ar << m_szBaseGroup;			// C:\\Startmenu\\Programme\\...
		ar << m_szNewGroup;				// PreFlight Navigation


		if (m_nVers == ACT_INI_VERS)
		{
			ar << m_szRegion;					// "Germany"
 			ar.Write (m_szPlane, PLANE_SIZE);  	// "C150"
			ar << m_bSaveSignal; 

			m_ptLocation->Serialize (ar);
			m_ptFontTool->Serialize(ar);
			m_ptDim->Serialize (ar);  
			m_ptLoad->Serialize (ar);  
			m_ptCalc->Serialize (ar, ACT_INI_VERS); 
			m_ptAppend->Serialize (ar);  
			m_ptGps->Serialize(ar, ACT_INI_VERS);
			m_ptQuickFind->Serialize(ar);
 			m_ptColor->Serialize (ar); 
 			m_ptMapDoc->Serialize (ar);
 			m_ptMovingMapDoc->Serialize(ar);
			m_ptAirspaceRegionsDoc->Serialize(ar, ACT_INI_VERS);
		}
	}
	else
	{
		// TODO: add loading code here  
		char szTest[16];
		ar.Read (szTest, uLen);  
		if (_fstrcmp ((LPSTR)szTest, szInit) == 0)
		{
			ar >> m_nVers;
			ar.Read (m_szName, (UINT)CUSTNAME_SIZE);
			ar.Read (m_szLoc, (UINT)LOC_SIZE);
			ar >> m_lTime;	
			ar >> Word;		m_CopyCnt = (short)Word;
			ar.Read (m_szSerNum, (UINT)SERNUM_SIZE);

											// installation path
			ar >> m_szBasePath;				// C:
			ar >> m_szNewDir;				// PF
			 
// development environment only
//			m_szBasePath = "D:\\Code\\Cpp_Win";
//			m_szNewDir ="PF";
// development environment only

// m_szActualPath is alredy set in constructor!!!
//			m_szActualPath=m_szBasePath;
//			if (m_szNewDir.GetLength()>0)
//				m_szActualPath += "\\" + m_szNewDir;
//			m_szActualPath += "\\";	 

											// icon path
			ar >> m_szBaseGroup;			// C:\\Startmenu\\Programme\\...
			ar >> m_szNewGroup;				// PreFlight Navigation


			if (m_nVers == 0)
				{				 // no conversion required !!
				}				 // use values set in Constructors

			if (m_nVers == 30 ||
				m_nVers == 32 ||
				m_nVers == ACT_INI_VERS)
				{
				ar >> m_szRegion;					// "Germany"
				ar.Read (m_szPlane, PLANE_SIZE);   
 				ar >> m_bSaveSignal; 

				m_ptLocation->Serialize (ar, ACT_KOORD_VERS);
				m_ptFontTool->Serialize(ar);
				m_ptDim->Serialize (ar);   
				m_ptLoad->Serialize (ar);
				m_ptCalc->Serialize (ar, m_nVers);    
				m_ptAppend->Serialize (ar); 
				m_ptGps->Serialize(ar, m_nVers);     
 				m_ptQuickFind->Serialize(ar);
 				m_ptColor->Serialize (ar); 
 				m_ptMapDoc->Serialize (ar);
 				m_ptMovingMapDoc->Serialize(ar);
				m_ptAirspaceRegionsDoc->Serialize(ar, m_nVers);

				m_bFirst = FALSE;			 // used in IsJustInstalled
				}

			m_nVers = ACT_INI_VERS;
		}
		else
		{			// Vers 1.1, 2.0, 2.1, 2.2 Ini file:
			m_bOldIniVers = TRUE;
		}

	}
}

/******************************* for update installation ************************/

void CInitDoc::AddBackslashIfMissing(CString* ptPath)
{
	short nSlashIndex = ptPath->GetLength()-1;
	char cSlash = ptPath->GetAt(nSlashIndex);
	if (cSlash != '\\')			// add "\" if missing
		*(ptPath) += "\\";
}

/********************************************************************************
 *  InitDoc.cpp			S e l e c t O l d P a t h	 							*
 *  Manual version to get path to PF.ini of previous version					*
 ********************************************************************************/
BOOL CInitDoc::SelectOldPath(CWnd* ptWnd, CString* ptIniPath)
{
    BOOL	bUseOldData = FALSE;
    BOOL	bOldPathFound = FALSE;
    BOOL	bSelectPath = true;
    
    CString szMsg;
    BOOL bOpen = true;			// select existing folder
            
//    CDirSelDlg dlg(ptWnd, bOpen);	
    szMsg.LoadString (IDS_SELOLDPATH);
//    dlg.SetTitle(szMsg);
    
	CDirSelectDlg dlg(szMsg);
    do
    {
        if(dlg.DoModal() == IDOK)		// get source for old pf.ini
        {			// user allways has to select actual path
            dlg.GetDirectory(m_szOldActualPath);
			CInitDoc::AddBackslashIfMissing(&m_szOldActualPath);

            CString szTestDir(m_szOldActualPath);
            szTestDir += "PF.ini";
         
                            // try to find PF.ini on selected dir
            bOldPathFound = CInitDoc::FileExists(szTestDir);
      
        
			if (bOldPathFound)
			{				// good old path found
				*ptIniPath = m_szOldActualPath;
				*ptIniPath += "PF.ini";
				bUseOldData = TRUE;
				bSelectPath = FALSE;	// stop selecting more paths
			}
			else
			{				// bad dir selected
				szMsg.LoadString (IDS_BADOLDPATH);
				if (AfxMessageBox(IDS_BADOLDPATH, MB_YESNO) == IDYES)
				{
					bSelectPath = TRUE;	// try to select an other path
				}
				else
				{					// stop loop, no old vers available!
					bSelectPath = FALSE;
				}
			}
        }  // CDirSelectDlg returns OK
		else
		{
			bSelectPath = FALSE;
		}
    } while (bSelectPath);
    
    return bUseOldData;
}


/************************************************************************
 *  WayDoc.cpp				O n O p e n D o c u m e n t					*
 ************************************************************************/
BOOL CInitDoc::OnOpenDocument(LPCTSTR pszPathName)
{
	BOOL bFileAvailable = FALSE;

//virtual void SetPathName( LPCTSTR lpszPathName, BOOL bAddToMRU = TRUE );
//this->SetPathName (pszPathName);

	if (CInitDoc::FileExists (pszPathName))
		bFileAvailable = CDocument::OnOpenDocument(pszPathName); 

	if (m_bOldIniVers)		
	{							// serialize has read nothing !!
		if (this->ReadOldNameAndLoc(pszPathName, m_szName, m_szLoc))
		{

		}
	}


	return bFileAvailable;
}


/************************************************************************
 *  InitDoc.cpp			R e a d O l d N a m e A n d L o c				*
 ************************************************************************/
BOOL CInitDoc::ReadOldNameAndLoc (LPCTSTR pszPathName, char* szName, char* szLoc)
{
BOOL bRead = FALSE;

BOOL	bSeek = FALSE;

CFile f;
CFileException e;
if( !f.Open( pszPathName, CFile::modeRead, &e ) )    
	{
	#ifdef _DEBUG    
	afxDump << "File could not be opened " << e.m_cause << "\n";
	#endif    
	}
else{				// try vers 1.1 and 2.0
	long lOffs = 0x66;		// DateSize = (long)1234
	long lSeek = 0;

	TRY
		{
		lSeek = (long)f.Seek(lOffs, CFile::begin);
		bSeek = TRUE;
		}
	CATCH( CFileException, e )
		{
		bSeek = FALSE;
		#ifdef _DEBUG
			afxDump << "bad seek, cause = " << e->m_cause << "\n";
		#endif
		}
	END_CATCH

	if (bSeek)
		{
		long lDateSize = 0;
		UINT uRead = f.Read(&lDateSize, 4);
		if ((uRead == 4) && (lDateSize == 1234))
			{							// vers 1.1 or 2.0
			lOffs = 0x34;
			lSeek = (long)f.Seek(lOffs, CFile::begin);
			if (lSeek == lOffs)
				{
				uRead = f.Read (szName, CUSTNAME_SIZE);
				bRead = (uRead == CUSTNAME_SIZE);
				uRead = f.Read (szLoc, LOC_SIZE);
				bRead = (bRead && (uRead == LOC_SIZE));
				}
			}
		else{							// vers 2.0 or 2.2 ?
			lOffs = 0x7C;
			TRY
				{
				lSeek = (long)f.Seek(lOffs, CFile::begin);
				bSeek = TRUE;
				}
			CATCH( CFileException, e )
				{
				bSeek = FALSE;
				#ifdef _DEBUG
					afxDump << "bad seek, cause = " << e->m_cause << "\n";
				#endif
				}
			END_CATCH

			if (bSeek)
				{
				UINT uRead = f.Read(&lDateSize, 4);
				if ((uRead == 4) && (lDateSize == 1234))
					{							// vers 2.1 or 2.2
					lOffs = 0x4A;
					lSeek = (long)f.Seek(lOffs, CFile::begin);
					if (lSeek == lOffs)
						{
						uRead = f.Read (szName, CUSTNAME_SIZE);
						bRead = (uRead == CUSTNAME_SIZE);
						uRead = f.Read (szLoc, LOC_SIZE);
						bRead = (bRead && (uRead == LOC_SIZE));
						}
					}
				}
			}
		}


	lOffs = 0;
	if (bSeek)
		lSeek = (long)f.Seek(lOffs, CFile::begin);

	f.Close();
	}

return bRead;
}

/********************************************************************************
 *  InitDoc.cpp			S e t C u s t N a m e				*
 ********************************************************************************/
void CInitDoc::SetCustName (CString szName)
{
_fstrcpy ((LPSTR)m_szName, (LPCTSTR)szName);
}  

/********************************************************************************
 *  InitDoc.cpp			S e t C u s t L o c				*
 ********************************************************************************/
void CInitDoc::SetCustLoc (CString szLoc)
{
_fstrcpy ((LPSTR)m_szLoc, (LPCTSTR)szLoc);
}  

/********************************************************************************
 *  InitDoc.cpp			S e t S e r N u m				*
 ********************************************************************************/
void CInitDoc::SetSerNum (CString szNum)
{
_fstrcpy ((LPSTR)m_szSerNum, (LPCTSTR)szNum);
}  

/********************************************************************************
 *  InitDoc.cpp			G e t S e r N u m				*
 ********************************************************************************/
CString CInitDoc::GetSerNum(void)
{
return (CString)m_szSerNum;
}


/////////////////////////////////////////////////////////////////////////////
// CInitDoc commands
