#ifndef __INITIAL__
#define __INITIAL__

/////////////////////////////////////////////////////////////////////////////
// CInitDoc document
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "..\CPPTOOLS\FontDoc.h"
#include "Location.h"
#include "DimDoc.h"
#include "LoadDoc.h"   
#include "CalcDoc.h" 
#include "ColorDoc.h"
#include "MapDoc.h"
#include "AppndDoc.h"
#include "GpsDoc.h"  
#include "FlPlDoc.h"
#include "ScMpDoc.h"
#include "QFind.h"    
#include "MovingMp.h"
#include "ElevDoc.h"
#include "ElevArrayDoc.h"
#include "ColTbDoc.h"
#include "ElevColDoc.h"
#include "AirspaceRegionsDoc.h"    


#define PFINI_HOMEFIELD     1
#define PFINI_CUSTNUM	    2
#define PFINI_CUSTOMER	    3
#define PFINI_CUSTLOC	    4
#define PFINI_DATESIZE	    5
#define PFINI_KOORDFILE     6
#define PFINI_FONT	    	7
#define PFINI_PLANE	    	8
#define PFINI_PREFS	    	9
#define PFINI_GPS	    	10
	
class CInitDoc : public CDocument
{
	DECLARE_SERIAL(CInitDoc)
protected:

// Attributes
public:  
	#define CUSTNAME_SIZE	30
	#define LOC_SIZE		20	
	#define SERNUM_SIZE		10	
	#define PLANE_SIZE		12
	#define ACT_INI_VERS	40

	BOOL			m_bFirst;
	 
 	int				m_nVers;
	char			m_szName[CUSTNAME_SIZE];
	char			m_szLoc[LOC_SIZE];
	long			m_lTime;
    short 			m_CopyCnt;
	char			m_szSerNum[SERNUM_SIZE];
	BOOL			m_bSaveSignal;
 
 	CString			m_szBasePath;			// C:
	CString			m_szNewDir;				// PF30
	 
	CString			m_szBaseGroup;			// C:\\Startmenu\\Programme\\...
	CString			m_szNewGroup;			// PreFlight Navigation
 
    CString			m_szActualPath;		// from GetCurrentDirectory in CInitDoc::CInitDoc()
	CString			m_szRegion;
    char			m_szPlane[PLANE_SIZE];

	CFrameWnd*		m_ptMainWnd;

 	CLocation* 		m_ptLocation; 
 	CFontDoc*		m_ptFontTool;
    CDimDoc*		m_ptDim;
    CLoadDoc*		m_ptLoad;  
    CCalcDoc*		m_ptCalc; 
    CAppendixDoc*	m_ptAppend;
    CGpsDoc*		m_ptGps;
	CQuickFind*		m_ptQuickFind;
	CColorDoc*		m_ptColor;
 	CMapDoc*		m_ptMapDoc;
	CMovingMapDoc*	m_ptMovingMapDoc;
	CAirspaceRegionsDoc* m_ptAirspaceRegionsDoc;

	CElevDoc*		m_ptElevDoc;
	CElevArrayDoc*	m_ptElevArrayDoc;
	CElevColorDoc*	m_ptElevColDocSea;
	CElevColorDoc*	m_ptElevColDocFlight;

	CLatLon*		m_ptLLtoCenter;

	CString			m_szLocDocPath;
	CString			m_szPlaneDocPath;
	CString			m_szElevDocPath;
	CString			m_szElevArrayDocPath;
	CString			m_szAirspaceDocPath;	

	CString			m_szSeaElevColDocPath;
	CString			m_szFlightElevColDocPath;	// path to search for airspace documents


	CString			m_szOldActualPath;			// for update
	BOOL			m_bOldIniVers;

// Operations
public:
	CInitDoc();
 	~CInitDoc();
	
	BOOL IsJustInstalled () { return m_bFirst; }
 	void SetLocDocPath(CString szPath); 
    void SetPlaneName(CString szPlane);

	CLocation CreateHomeBase();
	void SetHomeBase (CLocation Loc); 
	CLocation GetHomeBase ();

	BOOL	IsSaveSignal () { return m_bSaveSignal; }
	void	SetSaveSignal (BOOL bSet) { m_bSaveSignal = bSet; }
	void	SetMainWndPtr (CFrameWnd* ptWnd) { m_ptMainWnd = ptWnd; }
	CFrameWnd*	GetMainWndPtr () { return m_ptMainWnd; }

	CString GetActualPath () {return m_szActualPath;}
	CString GetLocDocPath();
	CString GetPlaneDocPath () { return m_szPlaneDocPath; }   
	CString GetElevDocPath () { return m_szElevDocPath; }
	CString GetElevArrayDocPath () { return m_szElevArrayDocPath; }
	CString GetAirspaceDocPath () { return m_szAirspaceDocPath; }

	CString GetSeaElevColDocPath () { return m_szSeaElevColDocPath; }
	CString GetFlightElevColDocPath () { return m_szFlightElevColDocPath; }

	CString GetPlaneName (){return (CString)m_szPlane;} 
    CString GetCustName();
	CString GetCustLoc();

	void SetElevDocPtr(CElevDoc* ptDoc) { m_ptElevDoc = ptDoc; }
	void SetElevArrayDocPtr(CElevArrayDoc* ptDoc) { m_ptElevArrayDoc = ptDoc; }
	void SetVers (short nVers) { m_nVers = nVers; }
                   
	void SetElevColorDocPtr(CElevColorDoc* ptDoc, short nMode);
	CElevColorDoc* GetElevColorDocPtr(short nMode);

	void SetLatLonToCenter(double dLat, double dLon);
	CLatLon GetLatLonToCenter();
	void ResetLatLonToCenter();
	BOOL IsLatLonToCenterValid();

	CFontDoc* 		GetFontPtr(){ return m_ptFontTool; }
	CDimDoc* 		GetDimPtr(){ return m_ptDim; }
	CLoadDoc* 		GetLoadPtr(){ return m_ptLoad; }
	CCalcDoc* 		GetCalcPtr(){ return m_ptCalc; }
	CAppendixDoc*	GetAppendixPtr(){ return m_ptAppend; } 
	CGpsDoc*		GetGpsPtr(){ return m_ptGps; } 
	CQuickFind*		GetQuickFindPtr(){ return m_ptQuickFind; } 
	CNameList*		GetNameListPtr(){ return m_ptQuickFind->GetNameListPtr(); } 
	CLaLoList*		GetLaLoListPtr() { return m_ptQuickFind->GetLaLoListPtr(); }
	CColorDoc* 		GetColorPtr(){ return m_ptColor; }
	CMapDoc*		GetMapDocPtr() { return m_ptMapDoc; }
	CMovingMapDoc*	GetMovingMapDocPtr() { return m_ptMovingMapDoc; }
	CAirspaceRegionsDoc*	GetAirspaceRegionsDocPtr() { return m_ptAirspaceRegionsDoc; }

	CElevDoc*		GetElevDocPtr() { return m_ptElevDoc; }
	CElevArrayDoc*	GetElevArrayDocPtr() { return m_ptElevArrayDoc; }

	static BOOL FileExists (CString szFileName);
	static CString GetFileFromPath(CString& szPath);
	static CString GetExtFromPath(CString& szPath);

	virtual BOOL OnSaveDocument( LPCTSTR lpszPathName );

	                                                // for update
    virtual BOOL OnOpenDocument(LPCTSTR szPathName);
	static void AddBackslashIfMissing(CString* ptPath);
    BOOL SelectOldPath(CWnd* ptWnd, CString* ptIniPath);
    BOOL ReadOldNameAndLoc (LPCTSTR szPathName, char* szName, char* szLoc);
    void SetCustName (CString szName);
    void SetCustLoc (CString szLoc);
    void SetSerNum (CString szNum);
    CString GetSerNum(void);
    CString GetOldActualPath() { return	m_szOldActualPath; }	// .../PFDIR/ 

private:

    
// Implementation
protected:             
	virtual void Serialize(CArchive& ar);	// overridden for document i/o
	virtual	BOOL OnNewDocument();

	// Generated message map functions
protected:
	//{{AFX_MSG(CInitDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 
