#ifndef __INTERMAP__
#define __INTERMAP__

// InterMap.h : Header-Datei
//

/////////////////////////////////////////////////////////////////////////////
// Ansicht CInteractiveMap 
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

//class CWayPoint;
class CWayDoc;
class CLaLoList;
class CInteractiveMap : public CObject
{
public:
	CInteractiveMap(CWnd* ptWnd=NULL);      // Dynamische Erstellung verwendet geschtzten Konstruktor
	virtual ~CInteractiveMap();
	DECLARE_DYNAMIC(CInteractiveMap)


// Attribute
private:
	CWnd*		m_ptWnd;
	CWayDoc*	m_ptWayDoc;

	double	m_dLon;
	double	m_dLat;

	CLaLoList*	m_ptLaLoList;	// list of possible map entries
	CMapDoc*	m_ptMapDoc;

	CMenu*	m_ptWayMenu;
	CMenu*	m_ptMapMenu;

	CObArray*	m_ptMapLocs;
	CObArray*	m_ptMapNavs;
	CObArray*	m_ptMapAirspaces;

	CObArray*	m_ptRteWpts;

	BOOL	m_bMapLocs;			// for preparing map menu
	BOOL	m_bMapNavs;
	BOOL	m_bRteWpts;
	UINT	m_uTimer;

// Operationen
public:
	void SetLatLon	(double dLat, double dLon);
	void StartPosChangedTimer(short nTenthSec);
	void StopPosChangedTimer();
	long GetInitialPlannedAlt(CLocation* ptLoc, short nActWptIndex, short nAltDim);

	void ShowWayPopupMenu (CPoint point, CWayDoc* ptWayDoc);
	void ShowMapPopupMenu (CPoint point);

	void OnMenuMeEditMapLoc(UINT nID);		// ID_ME_LOCEDIT_FIRST
	void OnMenuMeEditAirspace(UINT nID, CWayDoc* ptWayDoc);	// ID_ME_AIRSPACEEDIT_FIRST

	void OnMenuAppMapLoc(UINT nID); 	// ID_WY_APP_FIRST
	void OnMenuInsMapLoc(UINT nID);		// ID_WY_INS_FIRST
	void OnMenuBearMapNav(UINT nID);	// ID_WY_BEAR_FIRST
	void OnMenuDelRteWpt(UINT nID); 	// ID_WY_DEL_FIRST
	void OnMenuActRteWpt(UINT nID); 	// ID_WY_ACT_FIRST
	void OnMenuPlAltRteWpt(UINT nID);	// ID_WY_PLALT_FIRST

	void OnUpdateWyApp(CCmdUI* pCmdUI); 
	void OnUpdateWyIns(CCmdUI* pCmdUI); 
	void OnUpdateWyBear(CCmdUI* pCmdUI); 
	void OnUpdateWyDel(CCmdUI* pCmdUI); 
	void OnUpdateWyAct(CCmdUI* pCmdUI); 
	void OnUpdateWyPlAlt(CCmdUI* pCmdUI); 
	void OnUpdateWyLocEdit(CCmdUI* pCmdUI); 

	BOOL IsMouseOnLeg (CWayPoint& WayPtA, CWayPoint& WayPtB, double* ptDist);
	double DistMouseToWpt (CWayPoint& WayPt);
	void OnShowScannedMap (double dLat, double dLon, CWnd* ptParentWnd, WORD wCmdID);
	void OnActivateLeg(CWayDoc* ptDoc); 

private:
	void DeleteArrayOfLocs (CObArray* ptArray);
	void DeleteArrayOfAirspaces (CObArray* ptArray);
	void DeleteArrayOfWpts (CObArray* ptArray);
	BOOL SearchMapLocs(CObArray* ptMapLocs, CObArray* ptMapNavs); 
	BOOL SearchMapAirspaces(CObArray* ptMapAirspaces);

	BOOL SearchRteWpts(CObArray* ptRteWpts);

	void NewMapLocsMenu(CMenu* ptMenu, short nSubMenuIndex, 
					long lFirstID, long lLastID, CObArray* ptMapLocs); 
	void NewMapAirspacesMenu(CMenu* ptMenu, short nSubMenuIndex, 
					long lFirstID, long lLastID, CObArray* ptMapAirspaces);
	void NewRteWptsMenu(CMenu* ptMenu, short nSubMenuIndex, 
					long lFirstID, long lLastID, CObArray* ptRteWpts); 

	void CheckSymbolsMenu (long lRsrcID, BOOL bCheck);

};


/////////////////////////////////////////////////////////////////////////////

#endif // __INTERMAP__
