// koorddlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"  

#include "InitDoc.h"
#include "DimDoc.h"    
     
#include "LocDoc.h"
#include "KoordDlg.h"

#include <afxpriv.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;  

/////////////////////////////////////////////////////////////////////////////
// CKoordDlg dialog


/************************************************************************
 *  KoordDlg.cpp  		 		 C K o o r d D l g						*
 *	ptLoc != NULL and bShowLoc = TRUE => use ptLoc to initialize dlg	*
 *  ptLoc != NULL and bShowLoc = FALSE=> use ptLoc to return selection	*
 ************************************************************************/
CKoordDlg::CKoordDlg(CWnd* pParent, CLocDoc* ptDoc, CLocation* ptLoc, BOOL bShowLoc)
	: CDlgTool(CKoordDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CKoordDlg)
	m_nCatIndex = -1;
	m_szCountryCode = "";
	m_szName = "";
	m_szIndicator = "";
	m_dLat = 0;
	m_dLon = 0;
	m_lElevation = 0;
	m_dVAR = 0;
	m_fFreq = (float)0.;
	m_bGras = FALSE;
	m_lRange = 0;
	m_nRwyLen = 0;
	m_nTopography = -1;
	m_lElevDiff = 0;
	m_nListIndex = -1;
	m_nRegIndex = -1;
	m_nDiffDim = -1;
	m_nElevDim = -1;
	m_nLenDim = -1;
	m_nRangeDim = -1;
	m_nRwyDir = -1;
	//}}AFX_DATA_INIT
	
m_ptDoc = ptDoc;
m_ptLoc	= ptLoc;
m_bShowLoc = bShowLoc;
if (ptLoc == NULL)	// bShowLoc MUST be FALSE, if ptLoc = NULL!!
	m_bShowLoc = FALSE;
m_bChanged = FALSE;
m_bSubListsChanged = FALSE;           
m_bInsert = FALSE;

this->CopyDataBaseIntoDlg ();

m_nCatIndex = (int)this->GetInitialCatIndex();
if (m_bShowLoc)
	m_nCatIndex = (short)m_ptDoc->CategoryToIndex (m_ptLoc->GetCategory());

m_ptActList = this->GetActListPtr(m_nCatIndex); 
}

CKoordDlg::~CKoordDlg()
{
this->DeleteDataBase();
}

/************************************************************************
 *  KoordDlg.cpp	  		D e l e t e D a t a B a s e					*
 ************************************************************************/
void CKoordDlg::DeleteDataBase()
{  
short i;
for (i=0; i<CT_CNT; i++)
	m_ptDoc->DeleteArrayOf (&m_SubList[i]);
}

/************************************************************************
 *  KoordDlg.cpp	  	C o p y D a t a B a s e I n t o D l g			*
 ************************************************************************/
void CKoordDlg::CopyDataBaseIntoDlg()
{                   					// copy database from Doc to Dlg
m_ptDoc->GetDataBase (m_SubList);
m_bSubListsChanged = FALSE;
m_ptDoc->SetModifiedFlag(FALSE);
}

/************************************************************************
 *  KoordDlg.cpp	  	C o p y  D a t a B a s e I n t o D o c 			*
 ************************************************************************/
BOOL CKoordDlg::CopyDataBaseIntoDoc()
{ 				
	BOOL	bCopied = FALSE;				  
	if (m_bSubListsChanged || m_ptDoc->WasConverted() || m_ptDoc->WasSorted())
	{              
			// ask user to save here, NOT in SaveDocument!!
			// To confirm the save action, don't use the message box of OnSaveDocument.
			// instead, use DoReallySave to ask BEFORE the CKoordDlg data are copied into CLocDoc.

			// Confirming within OnSaveDocument AFTER CLocDoc got the dialog data
			// will cause an update of the current background view.
			// And if that view is the MapView, it will overwrite the just updated CLocDoc
			// while reading the airports of the different regions to be drawn.
			// So, when Serialize is called, the previously changed region will be saved,
			// but the region will NOT contain the changes made in CKoordDlg!

		if (m_ptDoc->DoReallySave())
		{					// copy database from Dlg to Doc
			m_ptDoc->SetDataBase (m_SubList);  
			m_ptDoc->SetActCatIndex ((CATEGORYINDEX)m_nCatIndex);
			m_ptDoc->SetModifiedFlag(TRUE);  
			bCopied = TRUE;
		}
	}               
return bCopied;
}


/************************************************************************
 *  KoordDlg.cpp	  		G e t I n i t i a l C a t e g o r y			*
 ************************************************************************/
CATEGORYINDEX CKoordDlg::GetInitialCatIndex()
{   
short i;
for (i=0; i<CT_CNT; i++)
	{
	if (m_SubList[i].GetSize() > 0)
		return (CATEGORYINDEX)i;     
	}   
	
return CT_AIRPORT;
}
 
/************************************************************************
 *  KoordDlg.cpp	  		 G e t A c t L i s t P t r					*
 ************************************************************************/
CPtrArray* CKoordDlg::GetActListPtr (short nCategory)
{ 
return &m_SubList[nCategory];
}

/************************************************************************
 *  KoordDlg.cpp	  		 	S e t D a t a  							*
 ************************************************************************/
void CKoordDlg::SetData (CLocation& Location)
{  
m_nElevDim = ptDim->GetPUIndex (ALTITUDE, Location.GetElevDim());
m_nRangeDim = ptDim->GetPUIndex (DISTANCE, Location.GetDistDim());
m_nLenDim = ptDim->GetPUIndex (RWYLENGTH, Location.GetLenDim());
m_nDiffDim = ptDim->GetPUIndex (ALTITUDE, Location.GetDiffDim());    

m_nCatIndex = m_ptDoc->CategoryToIndex(Location.GetCategory());	        

m_szName 		= Location.GetName();
m_szIndicator	= Location.GetIndicator(); 
m_szCountryCode = Location.GetCountryCode();
m_dLat 			= Location.GetLat();
m_dLon 			= Location.GetLon();  
m_dVAR			= (double)Location.GetVariation();   
m_bGras 		= Location.IsGras();

switch (Location.GetTopography())
	{
	case Country:	m_nTopography = 0;	break;
	case City:		m_nTopography = 1;	break;
	case bigCity:	m_nTopography = 2;	break;
	}
	
Location.GetAltitude(&m_lElevation); 
Location.GetFrequency(&m_fFreq); 

if (Location.IsAirport ())
	{
	switch (Location.GetRwyDir())
		{
		case  1:	m_nRwyDir = 0;	break;	 //Rwy 01/19 => 1. PU entry: Index=0
		case  2:	m_nRwyDir = 1;	break;
		case  3:	m_nRwyDir = 2;	break;
		case  4:	m_nRwyDir = 3;	break;
		case  5:	m_nRwyDir = 4;	break;
		case  6:	m_nRwyDir = 5;	break;
		case  7:	m_nRwyDir = 6;	break;
		case  8:	m_nRwyDir = 7;	break;
		case  9:	m_nRwyDir = 8;	break;
		case 10:	m_nRwyDir = 9;	break;
		case 11:	m_nRwyDir =10;	break;
		case 12:	m_nRwyDir =11;	break;
		case 13:	m_nRwyDir =12;	break;
		case 14:	m_nRwyDir =13;	break;
		case 15:	m_nRwyDir =14;	break;
		case 16:	m_nRwyDir =15;	break;
		case 17:	m_nRwyDir =16;	break;
		case  0:	m_nRwyDir =17;	break;
		default:	m_nRwyDir = NO_RWYDIR; break;
		}

	HideControl (IDC_KORANGE_TXT, TRUE);
	HideControl (IDC_KORANGE, TRUE);
	HideControl (IDC_KORANGEDIM, TRUE);

	HideControl (IDC_KORWYDIR_TXT, FALSE);
	HideControl (IDC_KORWYDIR, FALSE);
	}
else{
	Location.GetRange(&m_lRange);
	HideControl (IDC_KORWYDIR_TXT, TRUE);
	HideControl (IDC_KORWYDIR, TRUE);

	HideControl (IDC_KORANGE_TXT, FALSE);
	HideControl (IDC_KORANGE, FALSE);
	HideControl (IDC_KORANGEDIM, FALSE);
	}

Location.GetRwyLen(&m_nRwyLen); 
Location.GetElevDiff(&m_lElevDiff);   
}	

/************************************************************************
 *  KoordDlg.cpp	  		 	G e t D a t a  							*
 ************************************************************************/
void CKoordDlg::GetData (CLocation* ptLocation)
{                                         
ptLocation->SetElevDim(ptDim->GetPUDim (ALTITUDE, m_nElevDim));
ptLocation->SetDistDim(ptDim->GetPUDim (DISTANCE, m_nRangeDim));
ptLocation->SetLenDim(ptDim->GetPUDim (RWYLENGTH, m_nLenDim));
ptLocation->SetDiffDim(ptDim->GetPUDim (ALTITUDE, m_nDiffDim));    
	                  
	                  		// dont change category of existing entry
short nCategory = (m_bInsert)? m_nCatIndex : m_nOldCategory;
ptLocation->SetCategory(m_ptDoc->IndexToCategory((CATEGORYINDEX)nCategory));		
	
ptLocation->SetName(m_szName);
ptLocation->SetIndicator(m_szIndicator); 
ptLocation->SetCountryCode(m_szCountryCode); 
	
ptLocation->SetLat(m_dLat);
ptLocation->SetLon(m_dLon);  
ptLocation->SetVariation((short)m_dVAR);   
ptLocation->SetGras(m_bGras);

short nTopo;
switch (m_nTopography)
	{
	case 0: nTopo = Country;	break;
	case 1: nTopo = City;		break;
	case 2: nTopo = bigCity;	break;
	}
ptLocation->SetTopography(nTopo);

ptLocation->SetAltitude(m_lElevation); 
ptLocation->SetFrequency(m_fFreq); 
ptLocation->SetRwyLen(m_nRwyLen);				// must be set before calling IsAirport!!
ptLocation->SetElevDiff(m_lElevDiff);    

if (ptLocation->IsAirport ())
	{
	short nRwyDir;
	switch (m_nRwyDir)
		{
		case  0:	nRwyDir = 1;	break;		// 1. PU entry: Index=0 => Rwy 01/19 
		case  1:	nRwyDir = 2;	break;	 
		case  2:	nRwyDir = 3;	break;
		case  3:	nRwyDir = 4;	break;
		case  4:	nRwyDir = 5;	break;
		case  5:	nRwyDir = 6;	break;
		case  6:	nRwyDir = 7;	break;
		case  7:	nRwyDir = 8;	break;
		case  8:	nRwyDir = 9;	break;
		case  9:	nRwyDir =10;	break;
		case 10:	nRwyDir =11;	break;
		case 11:	nRwyDir =12;	break;
		case 12:	nRwyDir =13;	break;
		case 13:	nRwyDir =14;	break;
		case 14:	nRwyDir =15;	break;
		case 15:	nRwyDir =16;	break;
		case 16:	nRwyDir =17;	break;
		case 17:	nRwyDir = 0;	break;
		case 18:
		default:	nRwyDir = NO_RWYDIR; break;
		}

	ptLocation->SetRwyDir(nRwyDir);	
	}
else{
	ptLocation->SetRange(m_lRange);
	}
}	

/************************************************************************
 *  KoordDlg.cpp	  		 	F i l l R e g i o n P U					*
 ************************************************************************/
void CKoordDlg::FillRegionPU()
{
	CComboBox* ptComboRegion = (CComboBox*)GetDlgItem (IDC_KOREGION);	
		  
	          					// get path name for koord database
	CString szFullName = m_ptDoc->GetPathName();  
	short	nNameIndex = szFullName.ReverseFind('\\') + 1;
	CString szPath = szFullName.Left (nNameIndex);
	szPath += (CString)"*.krd";             

	CStringArray Regions;			// get CString array with long file names
	short nCnt = CQuickFind::EnumFiles (&Regions, szPath);  

	short i;
	for (i=0; i<nCnt; i++)			// copy string array into pop up 
	{
		CString szName;

		CString szNameExt = Regions.GetAt(i);
		short nDotIndex = szNameExt.ReverseFind ('.');
		if (nDotIndex > 0)			// remove extension from filenames        
				szName = szNameExt.Left(nDotIndex);
		else	szName = szNameExt;

		ptComboRegion->AddString((LPCTSTR)szName);
	}

	nCnt = ptComboRegion->GetCount();             
	if (nCnt > 0)
	{	        									// set actual region
		CString szRegion = m_ptDoc->GetActRegionName();	// Germany
		m_nRegIndex = ptComboRegion->FindString (-1, (LPCTSTR)szRegion);


		if (m_bShowLoc)
		{
			CString szNewRegion = m_ptLoc->GetRegionName();
			short nNewRegIndex = ptComboRegion->FindString (-1, (LPCTSTR)szNewRegion);

			if (m_nRegIndex != nNewRegIndex)
			{
				OnChangeDocument(szNewRegion, nNewRegIndex);
			}
		}
	}	
}		

/************************************************************************
 *  KoordDlg.cpp	  		 	F i l l C a t P U 						*
 ************************************************************************/
void CKoordDlg::FillCatPU ()
{      
CComboBox* ptCategory = (CComboBox*)GetDlgItem (IDC_KOCATEGORY);

CString szText;
short i;
for (i=0; i<CT_CNT; i++)
	{
	szText.LoadString (ID_CA_AIRPORT + i);  
	ptCategory->AddString((LPCTSTR)szText);  
	}
} 


/************************************************************************
 *  KoordDlg.cpp	  		 	F i l l R w y D i r P U					*
 ************************************************************************/
void CKoordDlg::FillRwyDirPU ()
{      
CComboBox* ptRwyDir = (CComboBox*)GetDlgItem (IDC_KORWYDIR);

CString szText;
short i;
for (i=0; i<19; i++)
	{
	szText.LoadString (ID_RD_01 + i);  
	ptRwyDir->AddString((LPCTSTR)szText);  
	}
}                                                                           
                                                                          

/************************************************************************
 *  KoordDlg.cpp	  		 	F i l l M i n A l t P U 				*
 ************************************************************************/
void CKoordDlg::FillMinAltPU ()
{
CComboBox* ptTopography = (CComboBox*)GetDlgItem (IDC_KOTOPO);
CString szText;
short i;
for (i=0; i<3; i++)
	{
	szText.LoadString (ID_TO_COUNTRY + i);  
	ptTopography->AddString((LPCTSTR)szText);  
	}
}

/************************************************************************
 *  KoordDlg.cpp	  		 F i l l L o c a t i o n L i s t 			*
 ************************************************************************/
void CKoordDlg::FillLocationList (CPtrArray* ptLocations)
{
CListBox* ptList = (CListBox*)GetDlgItem (IDC_KOLIST);    
ptList->ResetContent();

CString szText;
short i;
for (i=0; i<ptLocations->GetSize(); i++)
	{      
	CLocation Location((LPKOORD)ptLocations->GetAt(i));
	szText = Location.GetName();
	ptList->AddString((LPCTSTR)szText);  
	}              
}                             

/************************************************************************
 *  KoordDlg.cpp	  		 	O n N e w L i s t		 				*
 ************************************************************************/
short CKoordDlg::OnNewList (CPtrArray* ptLocations)
{
this->FillLocationList(ptLocations);   

BOOL bData = (ptLocations->GetSize() > 0);
short nListIndex = bData? 0 : -1;     
this->DisableControl (IDC_KOCHANGE, !bData);  
this->DisableControl (IDC_KODEL, !bData);  
return nListIndex;
}

/************************************************************************
 *  KoordDlg.cpp	  			 M a p L o c O f f		 				*
 ************************************************************************/
void CKoordDlg::MapLocOff()
{
	m_bShowLoc = FALSE;			// no longer use loc selected from map
	this->DisableControl (IDC_KOCHANGE, FALSE);  
	this->DisableControl (IDC_KODEL, FALSE);  
	this->DisableControl (IDOK, FALSE);
}


/************************************************************************
 *  KoordDlg.cpp	  		 D o D a t a E x c h a n g e 				*
 ************************************************************************/
void CKoordDlg::DoDataExchange(CDataExchange* pDX)
{   
this->ActivateDimGroups();

if (pDX->m_bSaveAndValidate)
		{  
		m_nOldIndex 	= m_nListIndex;	  
		m_nOldCategory	= m_nCatIndex;
		}
    else{   
	 	LPKOORD lpLoadKoord = NULL;
		if (m_nListIndex >= 0 && m_nListIndex<m_ptActList->GetSize())	
			lpLoadKoord = (LPKOORD)m_ptActList->GetAt(m_nListIndex);   
	
		if ((lpLoadKoord != NULL) && !m_bShowLoc)
			{
			CLocation Location(lpLoadKoord); 
			this->SetData (Location);    
	        }
		else{			// to switch ctrl from rwy direction to range in SetData 
			if (m_bShowLoc)
				{
				this->SetData(*m_ptLoc);
				if (m_nListIndex == -1)
					{
					this->DisableControl (IDC_KOCHANGE, TRUE);  
					this->DisableControl (IDC_KODEL, TRUE);  
					this->DisableControl (IDOK, TRUE);  
					}
				}
			else{
				CLocation Dummy;
				Dummy.SetLatLon	(0,0);
				Dummy.SetVariation (0);
				Dummy.SetCategory(m_ptDoc->IndexToCategory((CATEGORYINDEX)m_nCatIndex));		
				this->SetData(Dummy);
				}
			}
    	}
    	
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CKoordDlg)
	DDX_CBIndex(pDX, IDC_KOCATEGORY, m_nCatIndex);
	DDX_Text(pDX, IDC_KOCC, m_szCountryCode);
	DDV_MaxChars(pDX, m_szCountryCode, 2);
	DDX_Text(pDX, IDC_KOINDICATOR, m_szIndicator);
	DDV_MaxChars(pDX, m_szIndicator, 5);
	DDX_Latitude(pDX, IDC_KOLAT, m_dLat);
	DDV_Angle(pDX, m_dLat, -90., 90.);
	DDX_Longitude(pDX, IDC_KOLON, m_dLon);
	DDV_Angle(pDX, m_dLon, -180., 180.);
	DDX_Alt(pDX, IDC_KOELEV, m_lElevation);
	DDV_AltOptional(pDX, m_lElevation, -5000, 10000);
	DDX_Variation(pDX, IDC_KOVAR, m_dVAR);
	DDV_Angle(pDX, m_dVAR, -180., 180.);
	DDX_Freq(pDX, IDC_KOFRQ, m_fFreq);
	DDV_FreqOptional(pDX, m_fFreq, 108.f, 1750.f);
	DDX_Check(pDX, IDC_KOGRAS, m_bGras);
	DDX_Dist(pDX, IDC_KORANGE, m_lRange);
	DDV_DistOptional(pDX, m_lRange, 0, 255);
	DDX_RwyOpt(pDX, IDC_KORWYLEN, m_nRwyLen);
	DDV_RwyOpt(pDX, m_nRwyLen, 100, 6000);
	DDX_CBIndex(pDX, IDC_KOTOPO, m_nTopography);
	DDX_Alt(pDX, IDC_KOELEVDIFF, m_lElevDiff);
	DDV_AltOptional(pDX, m_lElevDiff, -250, 250);
	DDX_LBIndex(pDX, IDC_KOLIST, m_nListIndex);
	DDX_CBIndex(pDX, IDC_KOREGION, m_nRegIndex);
	DDX_CBIndex(pDX, IDC_KODIFFDIM, m_nDiffDim);
	DDX_CBIndex(pDX, IDC_KOELEVDIM, m_nElevDim);
	DDX_CBIndex(pDX, IDC_KOLENDIM, m_nLenDim);
	DDX_CBIndex(pDX, IDC_KORANGEDIM, m_nRangeDim);
	DDX_CBIndex(pDX, IDC_KORWYDIR, m_nRwyDir);
	DDX_Text(pDX, IDC_KONAME, m_szName);
	DDV_MaxChars(pDX, m_szName, 17);
	//}}AFX_DATA_MAP

if (pDX->m_bSaveAndValidate)
	{        
	if (m_bInsert)
		{  
		CLocation NewKoord;
		this->GetData (&NewKoord);  
		if (!this->InsertSorted (&NewKoord))   // checks for double names
			pDX->Fail();       // 	DDX_Text(pDX, IDC_KONAME, m_szName); must be last DDX_...
		}
	else{
		if (m_nOldIndex>=0 && m_nOldIndex<m_ptActList->GetSize())
			{
			LPKOORD lpOldKoord = (LPKOORD)m_ptActList->GetAt(m_nOldIndex);   
			
			CLocation NewKoord;
			this->GetData (&NewKoord);  

			if (!NewKoord.IsEqual(lpOldKoord))
				{  									// data has been changed !!
							// check if new name already used at other position in this array
				short nTestIndex = this->LocNameToIndex	(NewKoord.GetName());
				if ((nTestIndex > -1) && (nTestIndex != m_nOldIndex))
					{
					AfxMessageBox (IDS_SAME_NAME);
					pDX->Fail();
					}
				else{
					this->InsertSorted (&NewKoord);  	// save new data     
					delete lpOldKoord;                  // free old data
					}
				}
          	} 
     // else list was empty
		}
    }
}


BEGIN_MESSAGE_MAP(CKoordDlg, CDlgTool)
	//{{AFX_MSG_MAP(CKoordDlg)
	ON_LBN_SELCHANGE(IDC_KOLIST, OnSelchangeList)
	ON_CBN_SELCHANGE(IDC_KOCATEGORY, OnSelchangeCategory)
	ON_CBN_SELCHANGE(IDC_KOREGION, OnSelchangeRegion)
	ON_BN_CLICKED(IDC_KOINS, OnInsert)
	ON_BN_CLICKED(IDC_KODEL, OnDelete)
	ON_BN_CLICKED(IDC_KOCHANGE, OnChange)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CKoordDlg message handlers

/************************************************************************
 *  KoordDlg.cpp	  		 O n I n i t D i a l o g	 				*
 ************************************************************************/
BOOL CKoordDlg::OnInitDialog()
{             
this->FillRegionPU();
this->FillCatPU ();
this->FillRwyDirPU ();
this->FillMinAltPU ();


this->AddDimGroup (IDC_KOELEV, IDC_KOELEVDIM);
this->AddDimGroup (IDC_KORANGE, IDC_KORANGEDIM);
this->AddDimGroup (IDC_KORWYLEN, IDC_KOLENDIM);
this->AddDimGroup (IDC_KOELEVDIFF, IDC_KODIFFDIM);
      
this->FillDimPU (IDC_KOELEVDIM, ALTITUDE);
this->FillDimPU (IDC_KORANGEDIM, DISTANCE);
this->FillDimPU (IDC_KOLENDIM, RWYLENGTH);
this->FillDimPU (IDC_KODIFFDIM, ALTITUDE);    


m_nListIndex = this->OnNewList (m_ptActList);
if (m_bShowLoc)
	m_nListIndex = GetSortedIndex (m_ptLoc)-1;

// TODO: Add extra initialization here   
	CDlgTool::OnInitDialog();
	

return TRUE;  // return TRUE  unless you set the focus to a control
}

/************************************************************************
 *  KoordDlg.cpp	  		 G e t S o r t e d I n d e x 				*
 ************************************************************************/
short CKoordDlg::GetSortedIndex (CLocation* ptLocation)
{
BOOL	bInsAfter;  
long	IndMin, IndMax, i, OldTestInd;

        								// get new name to insert 
CString	szNewName = ptLocation->GetName();

IndMin  = 0;
IndMax  = m_ptActList->GetSize();		/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;				/* i always < cnt !!	*/

if (m_ptActList->GetSize() > 0)
   {
   do	{  
        LPKOORD lpTestKoord = (LPKOORD)m_ptActList->GetAt((int)i);
        CLocation	TestKoord (lpTestKoord);
        CString szTestName = TestKoord.GetName();
        
        int iCmp = szNewName.CompareNoCase ((LPCTSTR)szTestName);

	    if (iCmp >=0)	bInsAfter = TRUE;
	    		else	bInsAfter = FALSE;

		if (bInsAfter)	IndMin = i;
				else	IndMax = i;
				
		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }                     
 
return (short)i;
}


/************************************************************************
 *  KoordDlg.cpp	  		 L o c N a m e T o I n d e x 				*
 ************************************************************************/
short CKoordDlg::LocNameToIndex (CString szName)
{
short	nIndex = -1;
long	IndMin, IndMax, i, OldTestInd;

IndMin  = 0;
IndMax  = m_ptActList->GetSize();		/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;				/* i always < cnt !!	*/

if (m_ptActList->GetSize() > 0)
   {
   do	{  
        LPKOORD lpTestKoord = (LPKOORD)m_ptActList->GetAt((int)i);
        CLocation	TestKoord (lpTestKoord);
        CString szTestName = TestKoord.GetName();
        
        int iCmp = szName.CompareNoCase ((LPCTSTR)szTestName);

	    if (iCmp >=0)	IndMin = i;
	    		else	IndMax = i;

		if (iCmp == 0)
			nIndex = (short)i;					// store found index

		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while ((i != OldTestInd) && (nIndex == -1));

   }                     
 
return nIndex;
}

/************************************************************************
 *  KoordDlg.cpp	  G e t I n d e x O f F i r s t N a m e L i k e		*
 ************************************************************************/
short CKoordDlg::GetIndexOfFirstNameLike (CString szPartOfName)
{	
	BOOL bStop = FALSE;
	short nIndex = -1;

	for (int i=0; i<m_ptActList->GetSize() && !bStop; i++)
	{
        LPKOORD lpTestKoord = (LPKOORD)m_ptActList->GetAt((int)i);
        CLocation	TestKoord (lpTestKoord);
        CString szTestName = TestKoord.GetName();
        
		int nCmpLen = szPartOfName.GetLength();
		if (szTestName.GetLength() > nCmpLen)
		{		// test name longer than part specified => cut rest of test name
			szTestName = szTestName.Left(nCmpLen);
		}
						// iCmp = (szPartOfName > szTestName)
        int iCmp = szPartOfName.CompareNoCase ((LPCTSTR)szTestName);

		if (szTestName.GetLength() == nCmpLen)
		{
			if (iCmp == 0)
			{
				bStop = TRUE;
				nIndex = i;
			}
		}


	    if (iCmp < 0)	
			bStop = TRUE;
	}                     
 
	return nIndex;
}

/************************************************************************
 *  KoordDlg.cpp	  		 I n s e r t S o r t e d					*
 ************************************************************************/
BOOL CKoordDlg::InsertSorted(CLocation* ptLocation)	
{	
short nNewIndex;

if (m_bInsert)
	{
	nNewIndex = this->GetSortedIndex (ptLocation); 

	if (nNewIndex > 0)
		{
 		CLocation PrevLoc((LPKOORD)m_ptActList->GetAt(nNewIndex-1));
		CString szPrevName = PrevLoc.GetName();
		CString szNewName = ptLocation->GetName();

		if (szNewName.Compare (szPrevName) == 0)
			{
			AfxMessageBox (IDS_SAME_NAME);
			return FALSE;
			}
		}

	m_ptActList->InsertAt (nNewIndex, ptLocation->CreatePtr());	// insert new
	m_nListIndex = nNewIndex;
	}
else{		  			 // m_nOldIndex defined in DoDataExchange  
	m_ptActList->RemoveAt (m_nOldIndex); 	// delete old database entry 
	nNewIndex = this->GetSortedIndex (ptLocation);  
	m_ptActList->InsertAt (nNewIndex, ptLocation->CreatePtr());	// insert new

	if (nNewIndex > m_nOldIndex)
		if (m_nListIndex > m_nOldIndex && m_nListIndex <= nNewIndex)
			m_nListIndex--;   

	if (nNewIndex < m_nOldIndex)
		if (m_nListIndex >=	nNewIndex  && m_nListIndex < m_nOldIndex)
			m_nListIndex++;
	}
		
m_bSubListsChanged = TRUE;           
if (ptInit->IsSaveSignal())
	MessageBeep(MB_OK);	
	              			// compare listbox entries         
CListBox* ptList = (CListBox*)GetDlgItem (IDC_KOLIST);    
CString szNewName = ptLocation->GetName();        

if (m_bInsert)
	{
	ptList->InsertString(nNewIndex, (LPCTSTR)szNewName);    
	}
else{
	CString szOldName;
	ptList->GetText (m_nOldIndex, szOldName);
			
	if (szNewName.CompareNoCase((LPCTSTR)szOldName) != 0)
		{                		// change listbox entry	
		ptList->DeleteString(m_nOldIndex);
		ptList->InsertString(nNewIndex, (LPCTSTR)szNewName);  
		}   
	}

return TRUE;
}

/************************************************************************
 *  KoordDlg.cpp	  		 O n S e l c h a n g e L i s t				*
 ************************************************************************/
void CKoordDlg::OnSelchangeList()
{
	// TODO: Add your control notification handler code here
CListBox* ptList = (CListBox*)GetDlgItem (IDC_KOLIST);    
short nNewIndex = ptList->GetCurSel ();

if (m_bShowLoc)
	this->MapLocOff();

if (m_nListIndex != nNewIndex)
	{	
	if (this->UpdateData(TRUE))
		{      
 		this->UpdateData(FALSE);
		}      
	else{				// bad input, reset selection to bad entry 
	    m_nListIndex = m_nOldIndex;
		ptList->SetCurSel (m_nListIndex);		  
		}
	}
else{	// check if new data different from old, then confirm dlg.
	this->UpdateData (FALSE);
	}
}

/************************************************************************
 *  KoordDlg.cpp	  	O n S e l c h a n g e C a t e g o r y			*
 ************************************************************************/
void CKoordDlg::OnSelchangeCategory()
{
	// TODO: Add your control notification handler code here
CComboBox* ptCategory = (CComboBox*)GetDlgItem (IDC_KOCATEGORY);
short nNewCat = ptCategory->GetCurSel();

if (m_nCatIndex != nNewCat)
	{                                     
				// old cat index was airport and new cat index is reporting point?
	BOOL bSelectFirstReportOfAirport = ((m_nCatIndex == CT_AIRPORT) && (nNewCat == CT_REPORT));
	
	BOOL bClearToChange = TRUE;
	if (m_ptActList->GetSize() > 0)				// data available
	    {                      
		if (!this->UpdateData(TRUE)) 	// data avail, but DDV_... returns false
			bClearToChange = FALSE;   
        }

	if (bClearToChange || m_bShowLoc)	
		{	     								
		CString szICAO;
		if (bSelectFirstReportOfAirport)
		{					// store indicator of current airport
			this->GetText(IDC_KOINDICATOR, szICAO);
		}
			
		m_nCatIndex = nNewCat;
		m_ptActList = this->GetActListPtr(m_nCatIndex);   
		m_nListIndex= this->OnNewList (m_ptActList);

		if (bSelectFirstReportOfAirport)
		{
			short nNewListIndex = GetIndexOfFirstNameLike (szICAO);
			if (nNewListIndex >=0)
				m_nListIndex = nNewListIndex; 
		}

		if (m_bShowLoc)
		{
			m_ptLoc->SetCategory(m_ptDoc->IndexToCategory((CATEGORYINDEX)nNewCat));
			m_nListIndex = GetSortedIndex (m_ptLoc)-1;
		}

		this->UpdateData(FALSE);	
		}
	else{				// bad input, reset selection to bad entry
		ptCategory->SetCurSel (m_nCatIndex);
		}
	}
}

/************************************************************************
 *  KoordDlg.cpp	  		O n C h a n g e D o c u m e n t				*
 ************************************************************************/
void CKoordDlg::OnChangeDocument(CString szRegion, short nNewIndex)
{
	CString szPath = ptInit->GetActualPath ();

	m_ptDoc->OnNewDocument(); 			// deletes old structures
	m_ptDoc->SetRegionIndex (nNewIndex); 
	m_ptDoc->SetTitle(szRegion);
	m_ptDoc->OnOpenDocument (szPath + m_ptDoc->GetActRegionName() + (CString)".krd");
	
	this->DeleteDataBase();
	this->CopyDataBaseIntoDlg ();   

	m_nRegIndex 	= nNewIndex;
}


/************************************************************************
 *  KoordDlg.cpp	  		 O n S e l c h a n g e R e g i o n			*
 ************************************************************************/
void CKoordDlg::OnSelchangeRegion()
{
	// TODO: Add your control notification handler code here
CString szNewRegion;

CComboBox* ptComboRegion = (CComboBox*)GetDlgItem (IDC_KOREGION);
short nNewIndex = ptComboRegion->GetCurSel();    

if (m_nRegIndex != nNewIndex)
	{     
	BOOL bClearToChange = TRUE;
                         				// get path of koord data base files
	CString szPath = ptInit->GetActualPath ();
	if (this->UpdateData(TRUE))
		{     
		CString szOldNameExt = m_ptDoc->GetActRegionName() + (CString)".krd";  // Germany.krd
		if (this->CopyDataBaseIntoDoc())		// get confirmation from user before copying data to doc
			{
			BOOL bConfirm = FALSE;				// don't confirm within OnSaveDocument
			// this avoids updating background view. 
			// If view is DrawMap, this doc would be used to get airports of diffenent regions to be drawn.
			m_ptDoc->OnSaveDocument (szPath + szOldNameExt, bConfirm); 
			m_bChanged = TRUE;
			}
		}      
	else{					// data avail, but DDV_... returns false
		bClearToChange = FALSE;   
		}
		
	if (bClearToChange)
	    {
		CString szRegion;   
		ptComboRegion->GetLBText (nNewIndex, szRegion); 

		OnChangeDocument(szRegion, nNewIndex);

		if (!m_bShowLoc)
			m_nCatIndex 	= this->GetInitialCatIndex();
		m_ptActList 	= this->GetActListPtr(m_nCatIndex);
		m_nListIndex	= this->OnNewList (m_ptActList);
		this->UpdateData(FALSE);	
		}    
	else{				// bad input, reset selection to bad entry 
		ptComboRegion->SetCurSel (m_nRegIndex);
		}
	}
}

/************************************************************************
 *  KoordDlg.cpp	  			 O n I n s e r t 						*
 ************************************************************************/
void CKoordDlg::OnInsert()
{
	// TODO: Add your control notification handler code here  
if (m_bShowLoc)
	this->MapLocOff();

m_bInsert = TRUE;
if (this->UpdateData(TRUE))
	{
	this->UpdateData (FALSE);
	if (m_ptActList->GetSize() == 1)
		{
		this->DisableControl (IDC_KOCHANGE, FALSE);  
		this->DisableControl (IDC_KODEL, FALSE);  
		}
	this->SelectItem (IDC_KONAME);
	}

m_bInsert = FALSE;	
}

/************************************************************************
 *  KoordDlg.cpp	  			 O n C h a n g e		 				*
 ************************************************************************/
void CKoordDlg::OnChange()
{
	// TODO: Add your control notification handler code here
if (m_bShowLoc)
	this->MapLocOff();

if (this->UpdateData(TRUE))
	{
	this->UpdateData (FALSE);
	}
}
	


/************************************************************************
 *  KoordDlg.cpp	  			 O n D e l e t e						*
 ************************************************************************/
void CKoordDlg::OnDelete()
{
	// TODO: Add your control notification handler code here
if (m_bShowLoc)
	this->MapLocOff();

CListBox* ptList = (CListBox*)GetDlgItem (IDC_KOLIST);    
short nDeleteIndex = ptList->GetCurSel (); 
LPKOORD lpKoord = (LPKOORD)m_ptActList->GetAt(nDeleteIndex); 
delete lpKoord;
m_ptActList->RemoveAt (nDeleteIndex); 
m_bSubListsChanged = TRUE;           

ptList->DeleteString (nDeleteIndex);

if (m_ptActList->GetSize() > 0)
	{ 
	m_nListIndex = (nDeleteIndex > 0)? nDeleteIndex - 1 : 0; 
	this->UpdateData(FALSE);
	}
else{
	this->DisableControl (IDC_KOCHANGE, TRUE);
	this->DisableControl (IDC_KODEL, TRUE);
	m_nListIndex = -1;  
	}	
}

/************************************************************************
 *  KoordDlg.cpp	  		G e t S e l e c t e d L o c a t i o n 		*
 ************************************************************************/
void CKoordDlg::GetSelectedLocation(CLocation* ptLoc) 
{	
	this->GetData (ptLoc);  
}


/************************************************************************
 *  KoordDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CKoordDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
