#ifndef __KOORDDLG__
#define	__KOORDDLG__
// koorddlg.h : header file
//
//#include "Locdoc.h"			// defines CT_CNT
#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// CKoordDlg dialog     
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

class CLocDoc;
class CKoordDlg : public CDlgTool
{
// Construction
public:   
	
	CKoordDlg(CWnd* pParent = NULL, CLocDoc* ptDoc=NULL, 
									CLocation* ptLoc=NULL,
									BOOL bShowLoc = FALSE);	// standard constructor
	~CKoordDlg();   
	void CopyDataBaseIntoDlg();
	BOOL CopyDataBaseIntoDoc();

// Dialog Data
	//{{AFX_DATA(CKoordDlg)
	enum { IDD = IDD_KOORDBOX };
	int		m_nCatIndex;
	CString	m_szCountryCode;
	CString	m_szName;
	CString	m_szIndicator;
	double	m_dLat;
	double	m_dLon;
	long	m_lElevation;
	double	m_dVAR;
	float	m_fFreq;
	BOOL	m_bGras;
	long	m_lRange;
	short	m_nRwyLen;
	int		m_nTopography;
	long	m_lElevDiff;
	int		m_nListIndex;
	int		m_nRegIndex;
	int		m_nDiffDim;
	int		m_nElevDim;
	int		m_nLenDim;
	int		m_nRangeDim;
	int		m_nRwyDir;
	//}}AFX_DATA

BOOL		m_bInsert;
CLocDoc* 	m_ptDoc;
CPtrArray	m_SubList[CT_CNT];	// array of APT, VOR, NDB, REP, INT, USR, SAIL, HELI
CPtrArray*	m_ptActList;		// points to one of the previous arrays
short		m_nOldIndex;
short		m_nOldCategory;
BOOL		m_bChanged;  
BOOL		m_bSubListsChanged;         

private:
	CLocation*	m_ptLoc;
	BOOL		m_bShowLoc;
 
// Implementation
public:
	void GetSelectedLocation(CLocation* ptLoc); 

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support  
	void DeleteDataBase();
	CATEGORYINDEX GetInitialCatIndex();
	CPtrArray* GetActListPtr (short nCategory);
	void SetData (CLocation& Location);
	void GetData (CLocation* ptLocation);
	void FillRegionPU();
	void FillCatPU ();
	void FillMinAltPU (); 
	void FillRwyDirPU ();
               
	void FillLocationList (CPtrArray* ptLocations);   
	short OnNewList (CPtrArray* ptLocations);
	void MapLocOff();

	BOOL InsertSorted(CLocation* ptLocation);	
	short GetSortedIndex (CLocation* ptLocation);
	short LocNameToIndex (CString szName);
	short GetIndexOfFirstNameLike (CString szPartOfName);


	// Generated message map functions
	//{{AFX_MSG(CKoordDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeList();
	afx_msg void OnSelchangeCategory();
	afx_msg void OnSelchangeRegion();
	afx_msg void OnInsert();
	afx_msg void OnDelete();
	afx_msg void OnChange();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	void OnChangeDocument(CString szRegion, short nNewIndex);

};

#endif
