// LaLoList.h : interface of the CLaLoList class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

// DRECT is defined in LatLon.h

typedef int (* COMPFUNC)(void far *,void far *);
void lqsort(void far *base, long n, unsigned size, COMPFUNC compar);

typedef struct
	{
	float	fLat;
	float	fLon;
	short	nCategory;
	short	nIndex;
	short	nRegionIndex;
	} LALOINDEXTYPE;

class CLocDoc;	
class CLaLoList : public CObject
{         
DECLARE_SERIAL(CLaLoList)

private:
	LALOINDEXTYPE*	m_ptLaLoList;
	long			m_lLaLoListMax; 
	long			m_lLaLoListIndex;

	CLocDoc*		m_ptDoc;
	CObArray*		m_ptRegions;	// to convert ListIndex to CLocation
	 
	CString			m_szLocPath;
	short			m_nAddRegionIndex;

	float			m_EPS_wi;	/* Genauigkeit zum Winkelvergleich	*/

	long			m_lStartIndex;	/* for drawing map area			*/
	long			m_lEndIndex;
	long			m_lNextIndex;
	BOOL*			m_ptRegDrawn;
	BOOL			m_bSearchNewRegion;

	short			m_nActRegion;	
	CString			m_szActRegion;		// will be sent via CLocation to KoordDlg
	BOOL			m_bInitRegionUsed;

	// Operations
public:           
	CLaLoList();
	virtual ~CLaLoList();  

	void SetLocDocPtr (CLocDoc* ptLocDoc) { m_ptDoc = ptLocDoc; }
 	void SetRegionPtr (CObArray* ptRegions) { m_ptRegions = ptRegions; }     

	BOOL Alloc (long lCnt);
	void Free ();				 

	void SetRegionIndex (short nIndex) { m_nAddRegionIndex = nIndex; }
	void SetLaLoEntry (LALOINDEXTYPE* ptSL, float fLat, float fLon,
			short nCategory, short nIndex, short nRegIndex);
	void AddEntry (CLocation* ptLocation, short nSubListIndex);

	long GetSize(){return m_lLaLoListIndex;}
	LALOINDEXTYPE* GetEntryPtr (long i){return m_ptLaLoList + i;}

	short SetActRegIndex (CLocation& Loc);

	void Sort ();
    						  
	BOOL GetIndexRange (float fLat, float fLon, long* ptFirst, long* ptLast);

	short LatLonCmp (float fLat1, float fLon1, 
							float fLat2, float fLon2);

	BOOL GetSortedInd (float fLat, float fLon, long* ptIndex);
	BOOL GetStartIndex (DRECT& rLatLon, long* ptIndex);
	BOOL GetEndIndex (DRECT& rLatLon, long* ptIndex);

	void IndexToRange (long* ptFirstInd, long nIndex, long* ptLastInd);
	BOOL GetSortedIndexRange (float fLat, float fLon, long* ptFirst, long* ptLast);

	void SetLocPath (CString szPath) { m_szLocPath = szPath; }
	BOOL GetLoc (CLocation* ptLoc, long lIndex, short* ptActRegInd);

	BOOL LoadRegion (short nRegIndex);
	BOOL PrepareGetLoc (DRECT& ptLatLon);
	BOOL GetLocationInRect (CLocation* ptLoc, DRECT& rLatLon, short* ptActRegInd);

	
};

/////////////////////////////////////////////////////////////////////////////
