// LamCalDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "ScMpDoc.h"
#include "LamCalDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScMpCalibDlg dialog


CScMpCalibDlg::CScMpCalibDlg(CWnd* pParent, CScanMapDoc* ptDoc)
	: CDlgTool(CScMpCalibDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CScMpCalibDlg)
	m_dLat_BL = 0;
	m_dLat_BR = 0;
	m_dLat_TL = 0;
	m_dLat_TR = 0;
	m_dLon_BL = 0;
	m_dLon_BR = 0;
	m_dLon_TL = 0;
	m_dLon_TR = 0;
	m_szDescription = _T("");
	m_szInfo = _T("");
	m_bState_BL = FALSE;
	m_bState_BR = FALSE;
	m_bState_TL = FALSE;
	m_bState_TR = FALSE;
	//}}AFX_DATA_INIT

m_ptDoc = ptDoc;
m_ptScannedMap = NULL;				 //CScannedMap*
m_nActCalibIndex = -1;
}


/************************************************************************
 *  LamCalDlg.cpp				S e t D a t a			 				*
 ************************************************************************/
void CScMpCalibDlg::SetData ()
{
short i;

m_szDescription = m_ptScannedMap->GetName();
if (m_szDescription.GetLength() == 0)
	m_szDescription = m_ptScannedMap->GetPath();


if (m_nActCalibIndex >= 0)
	{
	m_szInfo.LoadString (IDS_LAM_CALIB_INFO_TL+m_nActCalibIndex);
	}
else{
	if (m_ptScannedMap->IsCalibrated())
			m_szInfo.LoadString (IDS_CALIB_INFO_OK);
	else	m_szInfo.LoadString (IDS_CALIB_INFO_NEW);
	}

for (i=0; i<m_ptScannedMap->GetFixPtCnt(); i++)
	{
	BOOL bAntipod = m_ptScannedMap->IsAntipod();
	CMapFixPt* ptFixPt = m_ptScannedMap->GetFixPtPtr (i);
	if (ptFixPt != NULL)
		{
		switch ((CALIBRATEPOS)i)
			{
			case CALPOS_TL:
				m_bState_TL = ptFixPt->IsDefinedLP();
				this->DisableControl (IDC_MCAL_STATE_TL, !m_bState_TL);
				if (ptFixPt->GetLat() != NO_KOORD)
					{
					m_dLat_TL = ptFixPt->GetLat();
					m_dLon_TL = ptFixPt->GetLon();
					}

				m_dLat_TR = m_dLat_TL;
				m_dLon_BL = m_dLon_TL;
				break;
			case CALPOS_TR:
				m_bState_TR = ptFixPt->IsDefinedLP();
				this->DisableControl (IDC_MCAL_STATE_TR, !m_bState_TR);
				if (ptFixPt->GetLon() != NO_KOORD)
					{
					m_dLon_TR = ptFixPt->GetLon();
					if (bAntipod) m_dLon_TR = m_dLon_TR - 360;	//convert 181.5 to -178.5
					// has no own input field for lat
					}
				m_dLon_BR = m_dLon_TR;
				break;
			case CALPOS_BR:
				m_bState_BR = ptFixPt->IsDefinedLP();
				this->DisableControl (IDC_MCAL_STATE_BR, !m_bState_BR);
				if (ptFixPt->GetLat() != NO_KOORD)
					m_dLat_BR = ptFixPt->GetLat();
				// has no own input field for lon

				m_dLat_BL = m_dLat_BR;
				break;
			case CALPOS_BL:
				m_bState_BL = ptFixPt->IsDefinedLP();
				this->DisableControl (IDC_MCAL_STATE_BL, !m_bState_BL);
				// has no own input fields for lat lon
				break;
			}
		}
	}
}


/************************************************************************
 *  LamCalDlg.cpp			D o D a t a E x c h a n g e	 				*
 ************************************************************************/
void CScMpCalibDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CScMpCalibDlg)
	DDX_Latitude(pDX, IDC_MCAL_LAT_BL, m_dLat_BL);
	DDX_Latitude(pDX, IDC_MCAL_LAT_BR, m_dLat_BR);
	DDX_Latitude(pDX, IDC_MCAL_LAT_TL, m_dLat_TL);
	DDX_Latitude(pDX, IDC_MCAL_LAT_TR, m_dLat_TR);
	DDX_Longitude(pDX, IDC_MCAL_LON_BL, m_dLon_BL);
	DDX_Longitude(pDX, IDC_MCAL_LON_BR, m_dLon_BR);
	DDX_Longitude(pDX, IDC_MCAL_LON_TL, m_dLon_TL);
	DDX_Longitude(pDX, IDC_MCAL_LON_TR, m_dLon_TR);
	DDX_Text(pDX, IDC_MCAL_MAP, m_szDescription);
	DDV_MaxChars(pDX, m_szDescription, 256);
	DDX_Text(pDX, IDC_MCAL_INFO, m_szInfo);
	DDV_MaxChars(pDX, m_szInfo, 256);
	DDX_Check(pDX, IDC_MCAL_STATE_BL, m_bState_BL);
	DDX_Check(pDX, IDC_MCAL_STATE_BR, m_bState_BR);
	DDX_Check(pDX, IDC_MCAL_STATE_TL, m_bState_TL);
	DDX_Check(pDX, IDC_MCAL_STATE_TR, m_bState_TR);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CScMpCalibDlg, CDlgTool)
	//{{AFX_MSG_MAP(CScMpCalibDlg)
	ON_BN_CLICKED(IDC_MCAL_STATE_BL, OnCalStateBL)
	ON_BN_CLICKED(IDC_MCAL_STATE_BR, OnCalStateBR)
	ON_BN_CLICKED(IDC_MCAL_STATE_TL, OnCalStateTL)
	ON_BN_CLICKED(IDC_MCAL_STATE_TR, OnCalStateTR)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/************************************************************************
 *  LamCalDlg.cpp			S e a r c h N e x t C a l i b I n d e x		*
 ************************************************************************/
short CScMpCalibDlg::SearchNextCalibIndex ()
{
short nCalibIndex = -1;

if (!m_bState_BL) nCalibIndex = 3;
if (!m_bState_BR) nCalibIndex = 2;
if (!m_bState_TR) nCalibIndex = 1;
if (!m_bState_TL) nCalibIndex = 0;

return nCalibIndex;
}


/////////////////////////////////////////////////////////////////////////////
// CScMpCalibDlg message handlers


/************************************************************************
 *  LamCalDlg.cpp				O n I n i t D i a l o g 				*
 ************************************************************************/
BOOL CScMpCalibDlg::OnInitDialog() 
{
short nSelItem = IDOK;

short nActMapInd = m_ptDoc->GetActMapIndex	();
if (nActMapInd > -1)
	{
	m_ptScannedMap = m_ptDoc->GetMapPtr(nActMapInd);		  // CScannedMap
	if (m_ptScannedMap != NULL)
		{
		if (m_ptScannedMap->GetFixPtCnt() == 0)
			{
			short i;
			short nFixPtCnt=4;		
			
			for (i=0; i<nFixPtCnt; i++)
				{					// allocate memory for fixpoints
				CMapFixPt* ptFixPt = new CMapFixPt();
				m_ptScannedMap->AppendFixPt (ptFixPt);
				}
			}

										// set cursor to last marked lat lon
		m_nActCalibIndex = m_ptScannedMap->GetActCalIndex();




		switch ((CALIBRATEPOS)m_nActCalibIndex)						 
			{
			case CALPOS_TL:
				nSelItem = IDC_MCAL_LAT_TL;
				break;
			case CALPOS_TR:
				nSelItem = IDC_MCAL_LON_TR;
				break;
			case CALPOS_BR:
				nSelItem = IDC_MCAL_LAT_BR;
				break;
			case CALPOS_BL:
   				nSelItem = IDOK;
				break;
			}

		this->SetData ();    
		} // m_ptScannedMap != NULL;
	}


CDlgTool::OnInitDialog();

this->SelectItem (nSelItem);	// setting focus here !!
	// TODO: Add extra initialization here

return FALSE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

   
void CScMpCalibDlg::OnCalStateTL() 
{
	// TODO: Add your control notification handler code here
if (this->UpdateData (TRUE))
	{
	if (!m_bState_TL)
		{
	    m_szInfo.LoadString (IDS_CALIB_INFO_INVAL);
		this->UpdateData(FALSE);
		}	
	}	
}

void CScMpCalibDlg::OnCalStateTR() 
{
	// TODO: Add your control notification handler code here
if (this->UpdateData (TRUE))
	{
	if (!m_bState_TR)
		{
	    m_szInfo.LoadString (IDS_CALIB_INFO_INVAL);
		this->UpdateData(FALSE);
		}	
	}	
}


void CScMpCalibDlg::OnCalStateBR() 
{
	// TODO: Add your control notification handler code here
if (this->UpdateData (TRUE))
	{
	if (!m_bState_BR)
		{
	    m_szInfo.LoadString (IDS_CALIB_INFO_INVAL);
		this->UpdateData(FALSE);
		}	
	}	
}


void CScMpCalibDlg::OnCalStateBL() 
{
	// TODO: Add your control notification handler code here
if (this->UpdateData (TRUE))
	{
	if (!m_bState_BL)
		{
	    m_szInfo.LoadString (IDS_CALIB_INFO_INVAL);
		this->UpdateData(FALSE);
		}
	}	
}


/************************************************************************
 *  LamCalDlg.cpp					O n O K								*
 ************************************************************************/
void CScMpCalibDlg::OnOK() 
{
	// TODO: Add extra validation here

if (this->UpdateData(TRUE))
	{
	short i;
	for (i=0; i<m_ptScannedMap->GetFixPtCnt(); i++)
		{							// set lat lon values into all fix points:
		CMapFixPt* ptFixPt = m_ptScannedMap->GetFixPtPtr (i);
		if (ptFixPt != NULL)
			{
			double dLat, dLon;		// get lat lon from real input fields
			switch ((CALIBRATEPOS)i)
				{
				case CALPOS_TL:
					if (!m_bState_TL) ptFixPt->EraseLP();
					dLat = m_dLat_TL;
					dLon = m_dLon_TL;
					break;
				case CALPOS_TR:
					if (!m_bState_TR) ptFixPt->EraseLP();
					dLat = m_dLat_TL;
					dLon = m_dLon_TR;
					break;
				case CALPOS_BR:
					if (!m_bState_BR) ptFixPt->EraseLP();
					dLat = m_dLat_BR;
					dLon = m_dLon_TR;
					break;
				case CALPOS_BL:
					if (!m_bState_BL) ptFixPt->EraseLP();
					dLat = m_dLat_BR;
					dLon = m_dLon_TL;
					break;
				}				  // and put them into fix points
			ptFixPt->SetLatLon (dLat, dLon);
			}
		}

		BOOL bCalibrated = m_ptScannedMap->TryToCalibrate();
		m_nActCalibIndex = this->SearchNextCalibIndex ();
		m_ptScannedMap->SetActCalIndex(m_nActCalibIndex);

		BOOL bBadCalib = (m_nActCalibIndex == -1) && !bCalibrated;

		if (bBadCalib)
		{				
		    m_szInfo.LoadString (IDS_LAM_RETRY_CALIB);
			SetText (IDC_MCAL_INFO , m_szInfo);
		}
		else
		{
			CDlgTool::OnOK();
		}
	}
}

/************************************************************************
 *  LamCalDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CScMpCalibDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
