#ifndef __LATLON__      
#define __LATLON__

// Latlon.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "..\CPPTOOLS\Vektor.h"

typedef struct
	{
	double top;
	double left;
	double bottom;
	double right;
	} DRECT;



#define LATLON_DDMM 1
#define LATLON_FLPL	2
#define LATLON_STAT 3


class CLatLon : public CObject
{
DECLARE_SERIAL(CLatLon)

#define DB180 180.		
#define DB360 360. 
#define NO_KOORD	1000.	/* undefined val of Lat or Lon		*/


// Attributes
private:    

// Operations
protected:
    double	m_dLat;
	double	m_dLon;

// Implementation
public:
	CLatLon();		
	CLatLon(const CLatLon& Source);
	CLatLon(double dLat, double dLon);
	~CLatLon();        


	void SetLatLon(double dLat, double dLon);
	void CreateLatLonStr(CString* ptLatLon, short nDest=LATLON_DDMM);	// LATLON_xxx

	void Serialize(CArchive& ar);

	const CLatLon& operator=(const CLatLon& Source);                                        
	BOOL IsValid ();
	BOOL IsNear(CLatLon& TestLocation);
	BOOL IsEqual(CLatLon& TestLocation);
	static DRECT RadiusToDRECT (double dLat, double dLon, double dDegrees);

	double WiRadY ();
	static double YtoLat (double dY);
	static double XtoLon(double dX);
	static double FlightAngle (double A, double B);
	static BOOL GetMapLon(double dLonLeft, double dLon, double dLonRight, double* ptMapLon);
	static BOOL IsLatLonInRect (double dLat, double dLon, DRECT& rLatLon, double* ptMapLon=NULL);
	double LoxoDist (double dLat, double dLon, double* ptCourse=NULL);
	double LoxoDist (CLatLon& Dest, double* ptCourse=NULL);
	static CLatLon PointOnLoxoLegAtDist (double dDist, CLatLon& LL1, CLatLon& LL2);
	static CLatLon PointOnOrthoLegAtDist (double dDist, CLatLon& LL1, CLatLon& LL2);
	static void AngleToDMS (double angle, BOOL bLat,
		short* ptDegr, short* ptMin, short* ptSec, short* ptDir);
	void AngleToDisplay (double angle, BOOL bLat,
		short* ptDegr, short* ptCentMin, short* ptSec, short* ptDir);

	void ToXYZ (CVektor* ptOrt);
	void FromXYZ (CVektor& vLoc);
	double Distance (CLatLon& Loc, double* ptKurs);
	void FromRelKoords (CLatLon& BaseLoc, short nRWK, double Dist);

	double GetLat () const { return m_dLat; }
	double GetLon () const { return m_dLon; }
	void SetLat (double dLat) { m_dLat = dLat; }
	void SetLon (double dLon) { m_dLon = dLon; }

};
#endif 

