// LinCalDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "ScMpDoc.h"
#include "LinCalDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;

/////////////////////////////////////////////////////////////////////////////
// CLinearCalibDlg dialog


CLinearCalibDlg::CLinearCalibDlg(CWnd* pParent, CScanMapDoc* ptDoc)
	: CDlgTool(CLinearCalibDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLinearCalibDlg)
	m_dLat_BR = 0;
	m_dLat_TL = 0;
	m_dLon_BR = 0;
	m_dLon_TL = 0;
	m_szDescription = _T("");
	m_szInfo = _T("");
	m_bState_BR = FALSE;
	m_bState_TL = FALSE;
	m_dDist = 0.0;
	m_nDistDim = -1;
	m_nDefineMode = -1;
	m_nCourse = 0;
	//}}AFX_DATA_INIT

m_ptDoc = ptDoc;
m_ptScannedMap = NULL;				 //CScannedMap*
m_nActCalibIndex = -1;
m_dLat_TL = NO_KOORD;
m_dLon_TL = NO_KOORD;
m_dLat_BR = NO_KOORD;
m_dLon_BR = NO_KOORD;
}


/************************************************************************
 *  LinCalDlg.cpp			G e t A b s o l u t e B R					*
 ************************************************************************/
void CLinearCalibDlg::GetAbsoluteBR(double* ptLat, double* ptLon)
{
	short nDistDim = ptDim->GetPUDim (DISTANCE, m_nDistDim);    
	double dDist_NM = ptDim->ConvertDist (m_dDist, nDistDim, DIM_NM);
	CLatLon PtTL (m_dLat_TL, m_dLon_TL);
	CLatLon PtBR;
	PtBR.FromRelKoords(PtTL, m_nCourse, dDist_NM);

	*ptLat = PtBR.GetLat();
	*ptLon = PtBR.GetLon();
}

/************************************************************************
 *  LinCalDlg.cpp			G e t R e l a t i v B R						*
 ************************************************************************/
void CLinearCalibDlg::GetRelativBR(int* ptCourse, double* ptDist, int* ptDistDim)
{
	CLatLon PtTL (m_dLat_TL, m_dLon_TL);
	CLatLon PtBR (m_dLat_BR, m_dLon_BR);

	if (PtTL.IsValid() && PtBR.IsValid())
	{
		double dDist_NM, dCourse;
		dDist_NM = PtTL.LoxoDist(PtBR, &dCourse);
		short nDistDim = ptDim->Distance();
		*ptDist = ptDim->ConvertDist(dDist_NM, DIM_NM, nDistDim);
		*ptCourse = (int)(dCourse + .5);
		*ptDistDim = ptDim->GetPUIndex (DISTANCE, nDistDim);
	}
}

/************************************************************************
 *  LinCalDlg.cpp				S e t D a t a			 				*
 ************************************************************************/
void CLinearCalibDlg::SetData ()
{
	if (m_ptScannedMap != NULL)
	{
		short i;

		m_nDefineMode = (m_ptScannedMap->IsPt2Relativ())? PT2_RELATIV : PT2_ABSOLUT;
		m_nDistDim = ptDim->GetPUIndex (DISTANCE, m_ptScannedMap->GetDistDim());
		m_dDist = m_ptScannedMap->GetDistToPt2();
		m_nCourse = m_ptScannedMap->GetCourseToPt2();

		m_szDescription = m_ptScannedMap->GetName();
		if (m_szDescription.GetLength() == 0)
			m_szDescription = m_ptScannedMap->GetPath();


		if (m_nActCalibIndex >= 0)
		{
			CALIBRATEPOS CalPos = m_ptScannedMap->FixPtIndexToCalibPos(m_nActCalibIndex);
			short nStrOffset = (CalPos == CALPOS_BR)? 1:0;
			m_szInfo.LoadString (IDS_LIN_CALIB_INFO_TL+nStrOffset);
		}
		else
		{
			if (m_ptScannedMap->IsCalibrated())
					m_szInfo.LoadString (IDS_CALIB_INFO_OK);
			else	m_szInfo.LoadString (IDS_CALIB_INFO_NEW);
		}

		for (i=0; i<m_ptScannedMap->GetFixPtCnt(); i++)
		{
			BOOL bAntipod = m_ptScannedMap->IsAntipod();
			CMapFixPt* ptFixPt = m_ptScannedMap->GetFixPtPtr (i);
			if (ptFixPt != NULL)
			{
				CALIBRATEPOS CalPos = m_ptScannedMap->FixPtIndexToCalibPos(i);
				switch (CalPos)						 
				{
				case CALPOS_TL:
					m_bState_TL = ptFixPt->IsDefinedLP();
					this->DisableControl (IDC_LIN_STATE_TL, !m_bState_TL);
					m_dLat_TL = ptFixPt->GetLat();
					m_dLon_TL = ptFixPt->GetLon();
					break;
				case CALPOS_BR:
					m_bState_BR = ptFixPt->IsDefinedLP();
					this->DisableControl (IDC_LIN_STATE_BR, !m_bState_BR);
					if (m_ptScannedMap->IsPt2Relativ())
					{
						m_nDefineMode = PT2_RELATIV;
						// default course, dist, dim defined in first lines of SetData
					}
					else
					{
						m_nDefineMode = PT2_ABSOLUT;
						m_dLat_BR = ptFixPt->GetLat();
						m_dLon_BR = ptFixPt->GetLon();
						if (bAntipod) m_dLon_BR = m_dLon_BR - 360;	//convert 181.5 to -178.5
					}
					break;
				}
			}
		}

		if (m_ptScannedMap->IsCalibrated())
		{
			if (m_nDefineMode == PT2_RELATIV)
					this->GetAbsoluteBR (&m_dLat_BR, &m_dLon_BR);
			else	this->GetRelativBR(&m_nCourse, &m_dDist, &m_nDistDim);
		}
	}
}

/************************************************************************
 *  LinCalDlg.cpp			D o D a t a E x c h a n g e	 				*
 ************************************************************************/
void CLinearCalibDlg::DoDataExchange(CDataExchange* pDX)
{
this->ActivateDimGroups();

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLinearCalibDlg)
	DDX_Latitude(pDX, IDC_LIN_LAT_BR, m_dLat_BR);
	DDX_Latitude(pDX, IDC_LIN_LAT_TL, m_dLat_TL);
	DDX_Longitude(pDX, IDC_LIN_LON_BR, m_dLon_BR);
	DDX_Longitude(pDX, IDC_LIN_LON_TL, m_dLon_TL);
	DDX_Text(pDX, IDC_LIN_MAP, m_szDescription);
	DDV_MaxChars(pDX, m_szDescription, 256);
	DDX_Text(pDX, IDC_LIN_INFO, m_szInfo);
	DDV_MaxChars(pDX, m_szInfo, 256);
	DDX_Check(pDX, IDC_LIN_STATE_BR, m_bState_BR);
	DDX_Check(pDX, IDC_LIN_STATE_TL, m_bState_TL);
	DDX_Text(pDX, IDC_LIN_DIST, m_dDist);
	DDV_MinMaxDouble(pDX, m_dDist, 0.01, 9999.);
	DDX_CBIndex(pDX, IDC_LIN_DISTDIM, m_nDistDim);
	DDX_Radio(pDX, IDC_LIN_ABSOLUT, m_nDefineMode);
	DDX_Text(pDX, IDC_LIN_COURSE, m_nCourse);
	DDV_MinMaxInt(pDX, m_nCourse, 10, 350);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLinearCalibDlg, CDlgTool)
	//{{AFX_MSG_MAP(CLinearCalibDlg)
	ON_BN_CLICKED(IDC_LIN_STATE_BR, OnCalStateBR)
	ON_BN_CLICKED(IDC_LIN_STATE_TL, OnCalStateTL)
	ON_BN_CLICKED(IDC_LIN_RELATIV, OnLinRelativ)
	ON_BN_CLICKED(IDC_LIN_ABSOLUT, OnLinAbsolut)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/************************************************************************
 *  LinCalDlg.cpp			S e a r c h N e x t C a l i b I n d e x		*
 ************************************************************************/
short CLinearCalibDlg::SearchNextCalibIndex ()
{
	short nCalibIndex = -1;

	if (!m_bState_BR) nCalibIndex = 1;
	if (!m_bState_TL) nCalibIndex = 0;

	return nCalibIndex;
}


/////////////////////////////////////////////////////////////////////////////
// CLinearCalibDlg message handlers


/************************************************************************
 *  LinCalDlg.cpp				O n I n i t D i a l o g 				*
 ************************************************************************/
BOOL CLinearCalibDlg::OnInitDialog() 
{
	short nSelItem = IDOK;

	this->AddDimGroup (IDC_LIN_DIST, IDC_LIN_DISTDIM);
      
	this->FillDimPU (IDC_LIN_DISTDIM, DISTANCE);

	short nActMapInd = m_ptDoc->GetActMapIndex	();
	if (nActMapInd > -1)
	{
		m_ptScannedMap = m_ptDoc->GetMapPtr(nActMapInd);		  // CScannedMap
		if (m_ptScannedMap != NULL)
		{
			if (m_ptScannedMap->GetFixPtCnt() == 0)
			{
				short i;		
				short nFixPtCnt = 2;
				
				for (i=0; i<nFixPtCnt; i++)
				{					// allocate memory for fixpoints
					CMapFixPt* ptFixPt = new CMapFixPt();
					m_ptScannedMap->AppendFixPt (ptFixPt);
				}
			}

										// set cursor to last marked lat lon
			m_nActCalibIndex = m_ptScannedMap->GetActCalIndex();
			CALIBRATEPOS CalPos = m_ptScannedMap->FixPtIndexToCalibPos(m_nActCalibIndex);
			switch (CalPos)						 
				{
				case CALPOS_TL:
					nSelItem = IDC_LIN_LAT_TL;
					break;
				case CALPOS_BR:
					nSelItem = IDC_LIN_LAT_BR;
					break;
			}

			this->SetData ();    
		} // m_ptScannedMap != NULL;
	}


	CDlgTool::OnInitDialog();

	this->SelectItem (nSelItem);	// setting focus here !!
	// TODO: Add extra initialization here

return FALSE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

   
void CLinearCalibDlg::OnCalStateTL() 
{
	// TODO: Add your control notification handler code here
if (this->UpdateData (TRUE))
	{
	if (!m_bState_TL)
		{
	    m_szInfo.LoadString (IDS_CALIB_INFO_INVAL);
		SetText (IDC_LIN_INFO , m_szInfo);
		}	
	}	
}


void CLinearCalibDlg::OnCalStateBR() 
{
	// TODO: Add your control notification handler code here
if (this->UpdateData (TRUE))
	{
	if (!m_bState_BR)
		{
	    m_szInfo.LoadString (IDS_CALIB_INFO_INVAL);
		SetText (IDC_LIN_INFO , m_szInfo);
		}	
	}	
}


/************************************************************************
 *  LinCalDlg.cpp					O n O K								*
 ************************************************************************/
void CLinearCalibDlg::OnOK() 
{
	// TODO: Add extra validation here

	if (this->UpdateData(TRUE))
	{
		short i;
		for (i=0; i<m_ptScannedMap->GetFixPtCnt(); i++)
		{							// set lat lon values into all fix points:
			CMapFixPt* ptFixPt = m_ptScannedMap->GetFixPtPtr (i);
			if (ptFixPt != NULL)
			{
				double dLat, dLon;		// get lat lon from real input fields

				CALIBRATEPOS CalPos = m_ptScannedMap->FixPtIndexToCalibPos(i);
				switch (CalPos)						 
				{
				case CALPOS_TL:
					if (!m_bState_TL) ptFixPt->EraseLP();
					dLat = m_dLat_TL;
					dLon = m_dLon_TL;
					break;
				case CALPOS_BR:
					if (!m_bState_BR) ptFixPt->EraseLP();
					if (m_nDefineMode == PT2_RELATIV)
						this->GetAbsoluteBR (&m_dLat_BR, &m_dLon_BR);
					dLat = m_dLat_BR;
					dLon = m_dLon_BR;
					break;
				}				  // and put them into fix points
				ptFixPt->SetLatLon (dLat, dLon);
			}
		}

		m_ptScannedMap->SetPt2Relativ(m_nDefineMode == PT2_RELATIV);
		m_ptScannedMap->SetCourseToPt2((short)m_nCourse);
		m_ptScannedMap->SetDistToPt2(m_dDist);

		short nDistDim = ptDim->GetPUDim (DISTANCE, m_nDistDim);    
		m_ptScannedMap->SetDistDim(nDistDim);

		BOOL bCalibrated = m_ptScannedMap->TryToCalibrate();
		m_nActCalibIndex = this->SearchNextCalibIndex ();
		m_ptScannedMap->SetActCalIndex(m_nActCalibIndex);
		
		BOOL bBadCalib = (m_nActCalibIndex == -1) && !bCalibrated;

		if (bBadCalib)
		{			
		    m_szInfo.LoadString (IDS_LIN_RETRY_CALIB);
			SetText (IDC_LIN_INFO , m_szInfo);
		}
		else
		{
			CDlgTool::OnOK();
		}
	}
}


void CLinearCalibDlg::OnLinAbsolut() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	SelectItem(IDC_LIN_LAT_BR);	
}

void CLinearCalibDlg::OnLinRelativ() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	SelectItem(IDC_LIN_COURSE);	
}


/************************************************************************
 *  LinCalDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CLinearCalibDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
