#if !defined(__LINCAL_DLG__)
#define __LINCAL_DLG__

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// LinCalDlg.h : header file
//

#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// CLinearCalibDlg dialog
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#define PT2_ABSOLUT 0
#define PT2_RELATIV 1

class CScannedMap;
class CScanMapDoc;
class CLinearCalibDlg : public CDlgTool
{
// Construction

public:
	CLinearCalibDlg(CWnd* pParent, CScanMapDoc* ptDoc); 

// Dialog Data
	//{{AFX_DATA(CLinearCalibDlg)
	enum { IDD = IDD_LINEARCALIB };
	double	m_dLat_BR;
	double	m_dLat_TL;
	double	m_dLon_BR;
	double	m_dLon_TL;
	CString	m_szDescription;
	CString	m_szInfo;
	BOOL	m_bState_BR;
	BOOL	m_bState_TL;
	double	m_dDist;
	int		m_nDistDim;
	int		m_nDefineMode;
	int		m_nCourse;
	//}}AFX_DATA

private:
	CScanMapDoc* m_ptDoc;
	CScannedMap* m_ptScannedMap;
	short		 m_nActCalibIndex;
				 
private:
	short SearchNextCalibIndex ();
	void GetAbsoluteBR(double* ptLat, double* ptLon);
	void GetRelativBR(int* ptCourse, double* ptDist, int* ptDistDim);
	void SetData();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CLinearCalibDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CLinearCalibDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnCalStateBR();
	afx_msg void OnCalStateTL();
	afx_msg void OnLinRelativ();
	afx_msg void OnLinAbsolut();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(__LINCAL_DLG__)
