// LoadDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "DimDoc.h"         
#include "LoadDoc.h" 
#include "LoadDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc* ptDim;


/////////////////////////////////////////////////////////////////////////////
// CLoadDlg dialog


CLoadDlg::CLoadDlg(CWnd* pParent, CLoadDoc* ptLoad)
	: CDlgTool(CLoadDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLoadDlg)    
	m_lMassRow0 = 0;
	m_lMassRow1 = 0;
	m_lMassLug1 = 0;
	m_nMassDim = -1;
	//}}AFX_DATA_INIT

m_ptDoc = ptLoad;
	
	m_nMassDim = ptDim->GetPUIndex (MASS, ptLoad->GetMassDim());  

	m_lMassRow0 = ptLoad->GetRowMass(0);
	m_lMassRow1 = ptLoad->GetRowMass(1);
	m_lMassRow2 = ptLoad->GetRowMass(2);
	m_lMassRow3 = ptLoad->GetRowMass(3);
	m_lMassRow4 = ptLoad->GetRowMass(4);
 	
	m_lMassLug0 = ptLoad->GetLugMass(0);
	m_lMassLug1 = ptLoad->GetLugMass(1);
	m_lMassLug2 = ptLoad->GetLugMass(2);
	m_lMassLug3 = ptLoad->GetLugMass(3);
	m_lMassLug4 = ptLoad->GetLugMass(4);

	m_nMaxFuel = ptLoad->UseMaxFuel()? FUELMAX : FUELPCENT;  
	
	m_fTankFakt0 = ptLoad->GetTankFakt(0);
	m_fTankFakt1 = ptLoad->GetTankFakt(1);
	m_fTankFakt2 = ptLoad->GetTankFakt(2); 
}
    
/************************************************************************
 *  LoadDlg.cpp					G e t L o a d 							*
 ************************************************************************/
void CLoadDlg::GetLoad (CLoadDoc* ptLoad)
{
ptLoad->SetMassDim(ptDim->GetPUDim (MASS, m_nMassDim));
    
ptLoad->SetRowMass (0, (short)m_lMassRow0);
ptLoad->SetRowMass (1, (short)m_lMassRow1);
ptLoad->SetRowMass (2, (short)m_lMassRow2);
ptLoad->SetRowMass (3, (short)m_lMassRow3);
ptLoad->SetRowMass (4, (short)m_lMassRow4);
	
ptLoad->SetLugMass(0, (short)m_lMassLug0);
ptLoad->SetLugMass(1, (short)m_lMassLug1);
ptLoad->SetLugMass(2, (short)m_lMassLug2);
ptLoad->SetLugMass(3, (short)m_lMassLug3);
ptLoad->SetLugMass(4, (short)m_lMassLug4);
	
if (m_nMaxFuel == FUELMAX)
	{  
	m_fTankFakt0 = m_fTankFakt1 = m_fTankFakt2 = NO_PCENT;
    }
  
ptLoad->SetTankFakt(0, m_fTankFakt0);
ptLoad->SetTankFakt(1, m_fTankFakt1);
ptLoad->SetTankFakt(2, m_fTankFakt2); 
}    
    
void CLoadDlg::DoDataExchange(CDataExchange* pDX)
{
this->ActivateDimGroups();    

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLoadDlg)
	DDX_Mass(pDX, ID_WTROW0, m_lMassRow0);
	DDV_Mass(pDX, m_lMassRow0, 30, 200); 
	DDX_MassOpt(pDX, ID_WTROW1, m_lMassRow1);
	DDV_MassOpt(pDX, m_lMassRow1, 0, 200);
	DDX_MassOpt(pDX, ID_WTROW2, m_lMassRow2);
	DDV_MassOpt(pDX, m_lMassRow2, 0, 200);
	DDX_MassOpt(pDX, ID_WTROW3, m_lMassRow3);
	DDV_MassOpt(pDX, m_lMassRow3, 0, 200);
	DDX_MassOpt(pDX, ID_WTROW4, m_lMassRow4);
	DDV_MassOpt(pDX, m_lMassRow4, 0, 200);
	DDX_MassOpt(pDX, ID_WTLUG0, m_lMassLug0);
	DDV_MassOpt(pDX, m_lMassLug0, 0, 100);
	DDX_MassOpt(pDX, ID_WTLUG1, m_lMassLug1);
	DDV_MassOpt(pDX, m_lMassLug1, 0, 100);
	DDX_MassOpt(pDX, ID_WTLUG2, m_lMassLug2);
	DDV_MassOpt(pDX, m_lMassLug2, 0, 100);
	DDX_MassOpt(pDX, ID_WTLUG3, m_lMassLug3);
	DDV_MassOpt(pDX, m_lMassLug3, 0, 100);
	DDX_MassOpt(pDX, ID_WTLUG4, m_lMassLug4);
	DDV_MassOpt(pDX, m_lMassLug4, 0, 100);      
	DDX_Radio(pDX, ID_WTFUELMAX, m_nMaxFuel);
	DDX_TankDegreeOpt(pDX, ID_WTFUELTANK1, m_fTankFakt0);
	DDV_TankDegreeOpt(pDX, m_fTankFakt0, 0.f, 100.f);
	DDX_TankDegreeOpt(pDX, ID_WTFUELTANK2, m_fTankFakt1);
	DDV_TankDegreeOpt(pDX, m_fTankFakt1, 0.f, 100.f);
	DDX_TankDegreeOpt(pDX, ID_WTFUELTANK3, m_fTankFakt2);
	DDV_TankDegreeOpt(pDX, m_fTankFakt2, 0.f, 100.f);
	DDX_CBIndex(pDX, ID_WTDIMMASS, m_nMassDim);
	//}}AFX_DATA_MAP
	
if (pDX->m_bSaveAndValidate)
	{        
	this->GetLoad (m_ptDoc);     
    }
}

BEGIN_MESSAGE_MAP(CLoadDlg, CDlgTool)
	//{{AFX_MSG_MAP(CLoadDlg)
	ON_BN_CLICKED(ID_WTFUELMAX, OnFuelMax)
	ON_BN_CLICKED(ID_WTFUELPCENT, OnFuelPerCent)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLoadDlg message handlers
 
void CLoadDlg::OnFuelMax()
{
	// TODO: Add your control notification handler code here
//m_fTankFakt0 = m_fTankFakt1 = m_fTankFakt2 = NO_PCENT;
this->EraseText (ID_WTFUELTANK1);	
this->EraseText (ID_WTFUELTANK2);	
this->EraseText (ID_WTFUELTANK3);	
}



void CLoadDlg::OnFuelPerCent()
{
	// TODO: Add your control notification handler code here
this->SelectItem (ID_WTFUELTANK1);	
}

/************************************************************************
 *  LoadDlg.cpp	  			 O n I n i t D i a l o g	 				*
 ************************************************************************/
BOOL CLoadDlg::OnInitDialog()
{
this->AddDimGroup (ID_WTROW0, ID_WTDIMMASS);
this->AddDimGroup (ID_WTROW1, ID_WTDIMMASS);
this->AddDimGroup (ID_WTROW2, ID_WTDIMMASS);
this->AddDimGroup (ID_WTROW3, ID_WTDIMMASS);
this->AddDimGroup (ID_WTROW4, ID_WTDIMMASS);  
             
this->AddDimGroup (ID_WTLUG0, ID_WTDIMMASS);   
this->AddDimGroup (ID_WTLUG1, ID_WTDIMMASS);   
this->AddDimGroup (ID_WTLUG2, ID_WTDIMMASS);   
this->AddDimGroup (ID_WTLUG3, ID_WTDIMMASS);   
this->AddDimGroup (ID_WTLUG4, ID_WTDIMMASS);   

this->FillDimPU (ID_WTDIMMASS, MASS); 

// TODO: Add extra initialization here
CDlgTool::OnInitDialog();
return TRUE;  // return TRUE  unless you set the focus to a control
}


/************************************************************************
 *  LoadDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CLoadDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
