/************************************************************************
 *  						L o a d D o c . c p p  						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "DimDoc.h"

#include "LoadDlg.h"				// dialog to set loading parameters
#include "LoadDoc.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc* 		ptDim;

/////////////////////////////////////////////////////////////////////////////
// CLoadDoc
IMPLEMENT_DYNCREATE(CLoadDoc, CDocument)

BEGIN_MESSAGE_MAP(CLoadDoc, CDocument)
	//{{AFX_MSG_MAP(CLoadDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CLoadDoc::CLoadDoc()
{ 
m_nMassDim = DIM_KG;

short i;							// reset all values
for (i=0; i<MAX_ROW_CNT; i++)
	m_nRowMass[i] = 0;
for (i=0; i<MAX_LUG_CNT; i++)
	m_nLugMass[i] = 0;
for (i=0; i<MAX_TANK_CNT; i++)
	m_fTankFakt[i] = NO_PCENT;		// set button to "use max fuel"
//	m_fTankFakt[i] = (float)1; 		// set 100% for each tank
	
this->SetRowMass (0, 150);			// use this setting after installation
this->SetLugMass (0, 5);
}

CLoadDoc::~CLoadDoc()
{
}


/************************************************************************
 *  LoadDoc.cpp	  		 	G e t P e r s o n C n t						*
 *  Try to calculate number of persons on board							*
 ************************************************************************/
short CLoadDoc::GetPersonCnt () 
{							 
short nCnt, nMass, i;

nCnt = 0;
for (i=0; i<MAX_ROW_CNT; i++)
	{
 	nMass = this->GetRowMass (i);
	if (nMass > 40) nCnt++;
	if (nMass > 110) nCnt++;
	}
return nCnt;
}

/************************************************************************
 *  LoadDoc.cpp	  		 	G e t R o w M a s s							*
 ************************************************************************/
short CLoadDoc::GetRowMass (short nIndex)
{
return m_nRowMass[nIndex];
}

/************************************************************************
 *  LoadDoc.cpp	  		 	G e t L u g M a s s							*
 ************************************************************************/
short CLoadDoc::GetLugMass (short nIndex)
{         
return m_nLugMass[nIndex];
}                                

/************************************************************************
 *  LoadDoc.cpp	  		 	G e t T a n k F a k t						*
 ************************************************************************/
float CLoadDoc::GetTankFakt (short nIndex)
{
return m_fTankFakt[nIndex];
}      

/************************************************************************
 *  LoadDoc.cpp	  		 	U s e M a x F u e l							*
 ************************************************************************/
BOOL CLoadDoc::UseMaxFuel ()
{      
BOOL	bMaxFuel = TRUE;
short i;
for (i=0; i<MAX_TANK_CNT; i++)
    if (m_fTankFakt[i] != NO_PCENT) 
    	bMaxFuel = FALSE;    
return bMaxFuel;
}

/************************************************************************
 *  LoadDoc.cpp	  		 	S e t R o w M a s s							*
 ************************************************************************/
void CLoadDoc::SetRowMass (short nIndex, short nRowMass)
{     
m_nRowMass[nIndex] = nRowMass;
}

/************************************************************************
 *  LoadDoc.cpp	  		 	S e t L u g M a s s							*
 ************************************************************************/
void CLoadDoc::SetLugMass (short nIndex, short nLugMass)
{
m_nLugMass[nIndex] = nLugMass;
}                                

/************************************************************************
 *  LoadDoc.cpp	  		 	S e t T a n k F a k t						*
 ************************************************************************/
void CLoadDoc::SetTankFakt (short nIndex, float fFakt)
{
m_fTankFakt[nIndex] = fFakt;
}

/************************************************************************
 *  LoadDoc.cpp	  		 		 C h a n g e 							*
 ************************************************************************/
int CLoadDoc::Change(CWnd* ptWnd)
{
CLoadDlg LoadDlg(ptWnd, this);

int RetVal = LoadDlg.DoModal();
switch (RetVal)
	{
	case IDOK:   
		break;
	case IDCANCEL:
		break;
	}	
return RetVal;
} 


/************************************************************************
 *  LoadDoc.cpp	  		 		 S e r i a l i z e 						*
 ************************************************************************/
void CLoadDoc::Serialize(CArchive& ar)
{    
WORD	Word;
short i;

if (ar.IsStoring())
	{
		// TODO: add storing code here         
	ar << (WORD)m_nMassDim;
	
	for (i=0; i<MAX_ROW_CNT; i++)
		ar << (WORD)m_nRowMass[i];
	for (i=0; i<MAX_LUG_CNT; i++)
		ar << (WORD)m_nLugMass[i];
	for (i=0; i<MAX_TANK_CNT; i++)  
		{    
		short nPerCent = (short)m_fTankFakt[i] * 100;
		ar.Write (&nPerCent, sizeof(short));	
		}  
	}
else{
		// TODO: add loading code here  
	ar >> Word;		m_nMassDim  = (short)Word; 
	  
	for (i=0; i<MAX_ROW_CNT; i++) 
		{ 
		ar >> Word;		
		m_nRowMass[i]  = (short)Word;   
		}
	for (i=0; i<MAX_LUG_CNT; i++) 
		{ 
		ar >> Word;		
		m_nLugMass[i]  = (short)Word;   
		}
	for (i=0; i<MAX_TANK_CNT; i++) 
		{   
		short nPerCent;
		ar.Read (&nPerCent, sizeof(short));	
		m_fTankFakt[i] = (float)nPerCent/100;   
		}
	}
}


/************************************************************************
 *  LoadDoc.cpp			    C o n v e r t L o a d i n g					*
 *  Purpose: Converts actual loadings into kg							*
 ************************************************************************/
void CLoadDoc::ConvertLoading (float* ptRow_kg, float* ptLug_kg, short nCnt)
{
short	i;
			
for (i=0; i<nCnt; i++)
    {
    if ((i < MAX_ROW_CNT) && (m_nRowMass[i] != NO_MASS))
		 *(ptRow_kg + i) = (float)ptDim->ConvertMass (m_nRowMass[i], m_nMassDim, DIM_KG);
    else *(ptRow_kg + i) = (float)0;

    if ((i < MAX_LUG_CNT) && (m_nLugMass[i] != NO_MASS))
		 *(ptLug_kg + i) = (float)ptDim->ConvertMass (m_nLugMass[i], m_nMassDim, DIM_KG);
    else *(ptLug_kg + i) = (float)0;
    }
}
 