#ifndef __LOADDOC__
#define __LOADDOC__

/************************************************************************
 *  						L o a d D o c . h 	 						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de


class CLoadDoc : public CDocument
{ 
protected:					// create from serialization only
	DECLARE_DYNCREATE(CLoadDoc)

protected:
	#define MAX_ROW_CNT		5
	#define MAX_LUG_CNT		5 
	#define MAX_TANK_CNT	3
// Attributes
public:
	short	m_nMassDim;  
	short	m_nRowMass[MAX_ROW_CNT];
	short	m_nLugMass[MAX_LUG_CNT];
    float	m_fTankFakt[MAX_TANK_CNT];
// Operations
public:
	CLoadDoc();	
	~CLoadDoc();   
	short GetPersonCnt (); 
	short GetRowMass (short nIndex);
	short GetLugMass (short nIndex);
	float GetTankFakt (short nIndex);     
	BOOL UseMaxFuel ();

	void SetMassDim (short nDim){m_nMassDim = nDim;}
	short GetMassDim() { return m_nMassDim; }
	
	void SetRowMass (short nIndex, short nRowMass);
	void SetLugMass (short nIndex, short nLugMass);
	void SetTankFakt (short nIndex, float fFakt);
	int Change (CWnd* ptWnd);
	void Serialize(CArchive& ar);
    
	void ConvertLoading (float* ptRow_kg, float* ptLug_kg, short nCnt);
	short GetMaxRowCnt() { return MAX_ROW_CNT; }	   // unused

// Implementation
protected:

	// Generated message map functions
protected:
	//{{AFX_MSG(CLoadDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 
