// LocView.cpp : implementation of the CLocView class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "LocDoc.h"
#include "LocView.h"
   
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* ptInit;
extern CFontDoc* ptFontTool;
extern CDimDoc* ptDim;

extern CLocDoc*		ptLocDoc;

extern BOOL bMMText;

/////////////////////////////////////////////////////////////////////////////
// CLocView

IMPLEMENT_DYNCREATE(CLocView, CTextViewTool)

BEGIN_MESSAGE_MAP(CLocView, CTextViewTool)
	//{{AFX_MSG_MAP(CLocView)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CTextViewTool::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTextViewTool::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLocView construction/destruction

CLocView::CLocView()
{
	// TODO: add construction code here
ptFontTool->GetParams (m_FontName, &m_wPointSize);

m_CharX = m_LineY = 0;
m_BCharX = m_BLineY = 0;

CreateBoldFont(&m_BoldFont);
CreateNewFont(&m_PlainFont);
}

CLocView::~CLocView()
{
m_PlainFont.DeleteObject ();
m_BoldFont.DeleteObject ();
}

/************************************************************************
 *  LocView.cpp				U p d a t e F o n t s 						*
 ************************************************************************/
void CLocView::UpdateFonts (CDC* pDC)
{
ptFontTool->GetParams (m_FontName, &m_wPointSize);
m_lfHeight = this->Y_PointToLP (pDC, m_wPointSize);  

m_PlainFont.DeleteObject ();
CreateNewFont(&m_PlainFont);
this->GetCharSize (pDC, &m_PlainFont, &m_CharX, &m_LineY); 

m_BoldFont.DeleteObject ();
CreateBoldFont(&m_BoldFont);
this->GetCharSize (pDC, &m_BoldFont, &m_BCharX, &m_BLineY); 
}

/************************************************************************
 *  LocView.cpp			O n I n i t i a l U p d a t e					*
 ************************************************************************/
void CLocView::OnInitialUpdate()
{
	CTextViewTool::OnInitialUpdate();
	// TODO: calculate the total size of this view

CDC* pDC = GetDC();    
//pDC->SetMapMode(MM_LOMETRIC);

//this->UpdateFonts (pDC);

ReleaseDC(pDC);     
}


/************************************************************************
 *  LocView.cpp    	 	 D r a w P a g e H e a d e r 					*
 ************************************************************************/
void CLocView::DrawPageHeader (CDC* pDC, CLocDoc* ptDoc, int LineY, 
								int* ptY, int dX, BOOL bDraw)
{
CString szTitle;
CString szText;
CFont*	ptOldFont;

ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);

(*ptY) += 4*LineY;
pDC->SetTextAlign (TA_LEFT | TA_TOP);
szTitle = ptDoc->GetActRegionName();	

szText = this->Format (IDF_LOCDATA, (LPCTSTR)szTitle);
if (bDraw) pDC->TextOut (m_Xleft, *ptY, szText);
(*ptY) += LineY;

(*ptY) += LineY/2;
if (bDraw) pDC->MoveTo (m_Xleft, *ptY);
if (bDraw) pDC->LineTo (m_Xleft + dX, *ptY);
(*ptY) += 3*LineY/2;

pDC->SelectObject (ptOldFont);
}

/************************************************************************
 *  LocView.cpp    	 	 D r a w P a g e F o o t e r 					*
 ************************************************************************/
void CLocView::DrawPageFooter (CDC* pDC, int nPage, int LineY, 
								int* ptY, int dX, BOOL bDraw)
{
CString szText;

(*ptY) += LineY;
if (bDraw) pDC->MoveTo (m_Xleft, *ptY);
if (bDraw) pDC->LineTo (m_Xleft + dX, *ptY);

(*ptY) += LineY/2;
szText = this->Format (IDF_PAGENUM, nPage);
this->TextAlignCenter (pDC, dX/2, *ptY, szText);
}       

/************************************************************************
 *  KoordVw.c				D r a w A n g l e							*
 ************************************************************************/
void CLocView::DrawAngle (CDC* pDC, int X, int Y, CLocation* ptLocation, BOOL bLat)
{   
double	fAngle;
short	Grad, Min, Sec, Dir;
int	nLen;

if (bLat) 	fAngle = ptLocation->GetLat();
	else	fAngle = ptLocation->GetLon();
 		           
TEXTMETRIC	tm;
pDC->GetTextMetrics (&tm);
int CapsX = tm.tmMaxCharWidth;

ptLocation->AngleToDMS (fAngle, bLat, &Grad, &Min, &Sec, &Dir);

CString szFormat;      
char	szBuffer[64];


LATLONFORM LatLonForm;
LatLonForm = ptDim->GetLatLonFormat();
if (LatLonForm == LLF_GGGMMSS)
	{
	szFormat.LoadString (IDS_F_DMS);
	nLen = sprintf (szBuffer, (LPCTSTR)szFormat, Grad, Min, Sec);
	pDC->TextOut (X-CapsX, Y, (LPSTR)szBuffer, nLen);
	}
else{		// if (LatLonForm == LLF_GGGMMm
	double dMin = Min + (float)Sec/60;
	szFormat.LoadString (IDS_F_DMM);
	nLen = sprintf (szBuffer, (LPCTSTR)szFormat, Grad, dMin);
	pDC->TextOut (X-CapsX, Y, (LPSTR)szBuffer, nLen);
	}

szFormat.LoadString (IDS_F_CHAR);
nLen = sprintf (szBuffer, (LPCTSTR)szFormat, Dir);
pDC->TextOut (X, Y, (LPSTR)szBuffer, nLen);
}      

/************************************************************************
 *  KoordVw.c				D r a w V a r i a t i o n					*
 ************************************************************************/
void CLocView::DrawVariation (CDC* pDC, int X, int Y, int CapsX, short nVar)
{   
short	Grad, Dir;
int	nLen;

if (nVar < 0)	Dir = 'W';
	else	Dir = 'E';

if (nVar < 0) nVar *=-1;
Grad = nVar;
 		           
CString szFormat;      
char	szBuffer[64];
szFormat.LoadString (IDS_F_VAR);
nLen = sprintf (szBuffer, (LPCTSTR)szFormat, Grad);
pDC->TextOut (X-CapsX, Y, (LPSTR)szBuffer, nLen);

szFormat.LoadString (IDS_F_CHAR);
nLen = sprintf (szBuffer, (LPCTSTR)szFormat, Dir);
pDC->TextOut (X, Y, (LPSTR)szBuffer, nLen);
}      
                   
/************************************************************************
 *  LocView.cpp    		 	 D r a w K o o r d 							*
 ************************************************************************/
BOOL CLocView::DrawKoord (CDC* pDC, CLocDoc* ptDoc, 
						DWORD* ptIndex,
					    int* ptY, BOOL bDraw)
{
BOOL	bEndOfPage = FALSE;
CString szBuffer;
short	nLen;
DWORD	nCnt, i;
CATEGORYINDEX   nCatIndex = ptDoc->GetActCatIndex();  

//short	Y_SEP;
//CString szText;

ActivateDrawing (bDraw);

CFont* ptOldFont;
ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);


pDC->SetTextAlign (TA_LEFT | TA_TOP);
szBuffer.LoadString (IDS_PLACE);
if (bDraw) pDC->TextOut (m_Xloc, *ptY, szBuffer);
szBuffer.LoadString (IDS_INDIC);
if (bDraw) pDC->TextOut (m_Xindic, *ptY, szBuffer);

pDC->SetTextAlign (TA_RIGHT | TA_TOP);
szBuffer.LoadString (IDS_LAT);
if (bDraw) pDC->TextOut (m_Xlat, *ptY, szBuffer);
szBuffer.LoadString (IDS_LON);
if (bDraw) pDC->TextOut (m_Xlon, *ptY, szBuffer);

szBuffer.LoadString (IDS_ALT);         
if (bDraw) pDC->TextOut (m_Xalt, *ptY, szBuffer);
szBuffer.LoadString (IDS_VAR);
if (bDraw) pDC->TextOut (m_Xvar, *ptY, szBuffer);
szBuffer.LoadString (IDS_FREQ);
if (bDraw) pDC->TextOut (m_Xfreq, *ptY, szBuffer);
                               ;
szBuffer.LoadString (IDS_RANGE);
if (bDraw) pDC->TextOut (m_Xrange, *ptY, szBuffer);
szBuffer.LoadString (IDS_RWY);
if (bDraw) pDC->TextOut (m_Xrwylen, *ptY, szBuffer);
szBuffer.LoadString (IDS_GRAS);
if (bDraw) pDC->TextOut (m_Xgras, *ptY, szBuffer); 

szBuffer.LoadString (IDS_ELEVDIFF);
if (bDraw) pDC->TextOut (m_Xelevdiff, *ptY, szBuffer);
szBuffer.LoadString (IDS_GEL);
if (bDraw) pDC->TextOut (m_Xgel, *ptY, szBuffer);
szBuffer.LoadString (IDS_CATEGORY);
if (bDraw) pDC->TextOut (m_Xcat, *ptY, szBuffer);

(*ptY) += m_LineY;

ptDim->GetDimCstring (&szBuffer, ptDim->Altitude());
if (bDraw) pDC->TextOut (m_Xalt, *ptY, szBuffer);
if (bDraw) pDC->TextOut (m_Xelevdiff, *ptY, szBuffer);
ptDim->GetDimCstring (&szBuffer, ptDim->Distance());
if (bDraw) pDC->TextOut (m_Xrange, *ptY, szBuffer);
ptDim->GetDimCstring (&szBuffer, ptDim->RwyLength());
if (bDraw) pDC->TextOut (m_Xrwylen, *ptY, szBuffer);

(*ptY) += m_LineY;

nCnt = ptDoc->GetPlaceCnt((CATEGORYINDEX)nCatIndex);

for (i=*ptIndex; i<nCnt && !bEndOfPage; i++)
	{ 
	char	szBuffer[64];   
	double	fConvert;
	CLocation Location (ptDoc->GetLocationPtr(nCatIndex, (short)i));
	
	if (bDraw) 
		{           
		pDC->SetTextAlign (TA_LEFT | TA_TOP);
		pDC->TextOut (m_Xloc, *ptY, Location.GetName());
 		pDC->TextOut (m_Xindic, *ptY, Location.GetIndicator());
 		           
 		pDC->SetTextAlign (TA_RIGHT | TA_TOP);
 		DrawAngle (pDC, m_Xlat, *ptY, &Location, TRUE);
		DrawAngle (pDC, m_Xlon, *ptY, &Location, FALSE);
          
        long lAltitude;    
        if (Location.GetAltitude(&lAltitude))
        	{  
        	CString szFormat;      
			szFormat.LoadString (IDS_F_ALT); 
			
   			fConvert = ptDim->ConvertDist (lAltitude, Location.GetElevDim(), ptDim->Altitude());
			nLen = sprintf (szBuffer, (LPCTSTR)szFormat, (long)(fConvert+0.5));
            pDC->TextOut (m_Xalt, *ptY, szBuffer, nLen); 
            }
       
        DrawVariation (pDC, m_Xvar, *ptY, m_CharX, Location.GetVariation());  
        
        float fFreq;
        if (Location.GetFrequency(&fFreq))
        	{  
        	CString szFormat;      
			szFormat.LoadString (IDF_7K3F);
			nLen = sprintf (szBuffer, (LPCTSTR)szFormat, fFreq);
            pDC->TextOut (m_Xfreq, *ptY, szBuffer, nLen); 
            }         
                          
        long lRange;
        if (Location.GetRange(&lRange))
        	{ 
   	//		fConvert = ptDim->ConvertDist (lRange, Location.GetDistDim(), ptDim->Distance());
       		fConvert = ptDim->ConvertToPref (DISTANCE, lRange, Location.GetDistDim());
         	nLen = sprintf (szBuffer, "%d", (short)fConvert);  
        	pDC->TextOut (m_Xrange, *ptY, szBuffer, nLen); 
            }
                                
        short nRwyLen;
        if (Location.GetRwyLen(&nRwyLen))
        	{
   	//		fConvert = ptDim->ConvertDist (nRwyLen, Location.GetLenDim(), ptDim->RwyLength());
   	    	fConvert = ptDim->ConvertToPref (RWYLENGTH, nRwyLen, Location.GetLenDim());
        	nLen = sprintf (szBuffer, "%d", (short)fConvert);  
         	pDC->TextOut (m_Xrwylen, *ptY, szBuffer, nLen); 
            }            
            
        if (Location.IsGras())
        	{
        	nLen = sprintf (szBuffer, "x");
          	pDC->TextOut (m_Xgras, *ptY, szBuffer, nLen); 
            }
 
		long	lElevDiff;
        if (Location.GetElevDiff(&lElevDiff))
        	{
   	//		fConvert = ptDim->ConvertDist (lElevDiff, Location.GetElevDim(), ptDim->Altitude());
	       	fConvert = ptDim->ConvertToPref (ALTITUDE, lElevDiff, Location.GetElevDim());
        	nLen = sprintf (szBuffer, "%d", (short)fConvert);  
         	pDC->TextOut (m_Xelevdiff, *ptY, szBuffer, nLen); 
            }            
   
        short nTopo = Location.GetTopography();
	    if (nTopo == Country)	szBuffer[0] = 'L';
	    if (nTopo == City)	    szBuffer[0] = 'O';
	    if (nTopo == bigCity)	szBuffer[0] = 'S';
	    szBuffer[1] = 0;  
	    pDC->TextOut (m_Xgel, *ptY, szBuffer, strlen (szBuffer)); 
             
        short nCat = Location.GetCategory();
        if (nCat == WP_AIRPORT) 	szBuffer[0] = 'A';
        if (nCat == WP_REPORT) 		szBuffer[0] = 'R';
        if (nCat == WP_INTERSECTION)szBuffer[0] = 'I';
        if (nCat == WP_NDB) 		szBuffer[0] = 'N';
        if (nCat == WP_VOR) 		szBuffer[0] = 'V';
        if (nCat == WP_USER) 		szBuffer[0] = 'U';
	    szBuffer[1] = 0;  
	    pDC->TextOut (m_Xcat, *ptY, szBuffer, strlen (szBuffer)); 
  		}
	(*ptY) += m_LineY;     
	            
 	if (m_bForPrinter)
		{
		int NextY = m_LineY;
		bEndOfPage = (bMMText)? 
				((DWORD)(*ptY + 1*m_LineY + NextY) > (m_dwLinesPerPage * m_LineY)) :
				((DWORD)(*ptY + 1*m_LineY + NextY) < (m_dwLinesPerPage * m_LineY))	;

		if (bEndOfPage)
			{
			if (i<nCnt-1)	*ptIndex = i+1;
				else		bEndOfPage = FALSE;
			}
		}
    }

//DrawHorzLine (pDC, *ptY+m_LineY/2);
//DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
(*ptY) += m_LineY;

if (!m_bDraw && !m_bForPrinter)
	{
	this->SetTotalHeight (*ptY);
	this->SetTotalWidth (m_Xright + m_Xleft);
	}

pDC->SelectObject (ptOldFont);
   

return bEndOfPage;
}                       

/************************************************************************
 *  LocView.cpp   				  S e t X T a b s 						*
 ************************************************************************/
void CLocView::SetXTabs (CDC* pDC, CLocDoc* ptDoc, int CharX)
{
int X_TAB, LogPixXToUse, LogPixYToUse;
GetLogPixToUse(pDC, (int*)&LogPixXToUse, (int*)&LogPixYToUse);   

X_TAB = 2*CharX;

m_dY = LogPixYToUse;
m_Xleft  = X_TAB;

CATEGORYINDEX CatIndex = ptDoc->CategoryToIndex (WP_AIRPORT);
short nMaxNameLen = ptDoc->GetMaxLocNameLen (CatIndex, pDC); 

int BCapsX = CharX;   		// test ++++++

m_Xloc = m_Xleft;  

if (nMaxNameLen == 0)                        
	nMaxNameLen = GetRightPos (pDC, 0, IDS_PLACE);

short n=1;

m_Xindic = m_Xloc + nMaxNameLen + BCapsX; 	// left side of indicator field 
                                            // X_help: right side of indicator field
int X_help = GetRightPos (pDC, m_Xindic, IDS_INDIC);
m_Xlat	= GetRightPos (pDC, X_help + 1*BCapsX, IDS_LAT); 
m_Xlon = GetRightPos (pDC, m_Xlat+n*BCapsX, IDS_LON);
m_Xalt = GetRightPos (pDC, m_Xlon+BCapsX, IDS_ALT);
m_Xvar = GetRightPos (pDC, m_Xalt+n*BCapsX, IDS_VAR);
m_Xfreq = GetRightPos (pDC, m_Xvar+(int)(1.5*BCapsX), IDS_FREQ);
m_Xrange = GetRightPos (pDC, m_Xfreq+1*BCapsX, IDS_RANGE);
m_Xrwylen  = GetRightPos (pDC, m_Xrange+1*BCapsX, IDS_RWY);
m_Xgras	= GetRightPos (pDC, m_Xrwylen+1*BCapsX, IDS_GRAS);
m_Xelevdiff = GetRightPos (pDC, m_Xgras+1*BCapsX, IDS_ELEVDIFF);
m_Xgel = GetRightPos (pDC, m_Xelevdiff+1*BCapsX, IDS_GEL);
m_Xcat = GetRightPos (pDC, m_Xgel+1*BCapsX, IDS_CATEGORY);

m_Xright = m_Xcat + CharX;
m_dX = m_Xright - m_Xleft;
}

/************************************************************************
 *  LocView.cpp   			  P r i n t P a g e							*
 ************************************************************************/
void CLocView::PrintPage (CDC* pDC, int nPageToPrint)
{
CLocDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);

int	Y;
int	nPage = 1;

DWORD dwIndex = 0;

if (pDoc != NULL)
	{
	BOOL bDraw;

	do	{
		Y = 3*m_LineY;

		bDraw = (nPage == nPageToPrint);
		this->DrawPageHeader (pDC, pDoc, m_LineY, &Y, m_dX, bDraw); 

		m_bMore = DrawKoord (pDC, pDoc, &dwIndex, &Y, bDraw);

		Y = (bMMText)? m_dY: -m_dY + m_LineY;
		this->DrawPageFooter (pDC, nPage, m_LineY, &Y, m_dX, bDraw); 
		nPage++;
		} while (!bDraw);
	}    
}                                                             

/************************************************************************
 *  LocView.cpp    	 			 O n D r a w							*
 ************************************************************************/
void CLocView::OnDraw(CDC* pDC)
{
	CLocDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here   
int	X_TAB = 3*m_CharX;
int	Y = m_LineY;

if (pDoc != NULL)
	{
	BOOL	bMore = FALSE;
	DWORD 	dwIndex = 0;

	bMore = DrawKoord (pDC, pDoc, &dwIndex, &Y, m_bDraw);
	}	
}
                              
/************************************************************************
 *  LocView.cpp				P r e p a r e X T a b s						* 
 ************************************************************************/
void CLocView::PrepareXTabs (CDC* pDC)
{
CLocDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	pDC->SetMapMode(MM_LOMETRIC);
	this->UpdateFonts (pDC);					// defines m_CharX
	CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);		
    this->SetXTabs (pDC, pDoc, m_CharX);
	pDC->SelectObject (ptOldFont);
	}
}
                              
/************************************************************************
 *  LocView.cpp					O n U p d a t e 						* 
 *  Called on FileNew, FileOpen, Doc.UpdateAllViews 					*
 ************************************************************************/
void CLocView::OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint)
{
CLocDoc* pDoc = GetDocument();

if (pDoc != NULL)
	{	        
	CDC* pDC = GetDC();    

	this->PrepareXTabs (pDC);
	m_bDraw = FALSE;
	this->OnDraw(pDC);						// sets m_sizeTotal
	m_bDraw = TRUE;
	this->SetScrollSize (m_sizeTotal);

	ReleaseDC(pDC);     
	
	CTextViewTool::OnUpdate (pSender, lHint, pHint);
	}	 
}

/************************************************************************
 *  LocView.cpp   			 O n P r e p a r e D C						*
 ************************************************************************/
void CLocView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class

CLocDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	m_bForPrinter = pDC->IsPrinting();	  // important to get correct update after 
	if (m_bForPrinter)					  // printing dlg disappears!!
		{
		int	Y;
		DWORD	dwIndex = 0; 
		BOOL bMore = TRUE;

		m_nPages = 0;
		this->PrepareXTabs (pDC);
   						
		m_dwLinesPerPage = this->GetMaxLines (pDC, m_LineY);   // used in DrawKoord	while m_bForPrinter
			
		m_bDraw = FALSE;
		do	{    
			Y = 3*m_LineY;
 			
			this->DrawPageHeader (pDC, pDoc, m_LineY, &Y, m_dX, FALSE); 
			bMore = DrawKoord (pDC, pDoc, &dwIndex, &Y, FALSE); // sets m_sizeTotal

 		//	this->DrawPageFooter (pDC, 0, m_LineY, &Y, m_dX, FALSE); 
		//  there is place for footer after last line !! see GetLogPixToUse
 			m_nPages++;
			} while (bMore);
		m_bDraw = TRUE;


		if (pInfo != NULL)
			{
			pInfo->SetMaxPage (m_nPages);
			pInfo->m_nNumPreviewPages = m_nPages;
			pInfo->m_bContinuePrinting = (m_bMore || pInfo->m_bPreview);
			}    
		}  // if m_bForPrinter
	else{
		this->PrepareXTabs (pDC);
		}
	}
		
if (!m_bForPrinter)
	CTextViewTool::OnPrepareDC(pDC, pInfo);	 // sets bContinuePrinting = TRUE if SetMaxPage is set
}

                
/************************************************************************
 *  LocView.cpp   		  O n P r e p a r e P r i n t i n g				*
 ************************************************************************/
BOOL CLocView::OnPreparePrinting(CPrintInfo* pInfo)
{			 // called before the display of the print dialog
	// default preparation
m_bMore = TRUE;	               

return DoPreparePrinting(pInfo);
}

/************************************************************************
 *  LocView.cpp   		 	O n B e g i n P r i n t i n g				*
 ************************************************************************/
void CLocView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{			   // called after the print dialog exists
	// TODO: add extra initialization before printing
CLocDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
//	pDC->SetMapMode(MM_LOMETRIC);

//	this->UpdateFonts (pDC);					// defines m_CharX

//    this->SetXTabs (pDC, pDoc, m_CharX);
	}
							// 2. possibility to set the document length 
}

/************************************************************************
 *  LocView.cpp   		 		 O n P r i n t							*
 ************************************************************************/
void CLocView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
this->PrintPage (pDC, pInfo->m_nCurPage);
}

/************************************************************************
 *  LocView.cpp   		 		 O n E n d P r i n t i n g				*
 ************************************************************************/
void CLocView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
}

/////////////////////////////////////////////////////////////////////////////
// CLocView diagnostics

#ifdef _DEBUG
void CLocView::AssertValid() const
{
	CTextViewTool::AssertValid();
}

void CLocView::Dump(CDumpContext& dc) const
{
	CTextViewTool::Dump(dc);
}
#endif //_DEBUG

CLocDoc* CLocView::GetDocument() // non-debug version is inline
{
//	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CLocDoc)));
//	return (CLocDoc*)m_pDocument;
return ptLocDoc;
}

/////////////////////////////////////////////////////////////////////////////
// CLocView message handlers


   

void CLocView::OnEditCopy() 
{
	// TODO: Add your command handler code here
this->CopyToClipboard();		
}
