// LocView.h : interface of the CLocView class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
#include "..\CPPTOOLS\TxVwTool.h"

class CLocView : public CTextViewTool
{                          
public:
	CFont	m_PlainFont; 
	CFont	m_BoldFont; 
	int		m_CharX, m_LineY;
	int		m_BCharX, m_BLineY;

	int m_Xloc, m_Xindic, m_Xlat, m_Xlon, m_Xalt, m_Xvar, m_Xfreq, m_Xrange;
	int	m_Xrwylen, m_Xgras, m_Xelevdiff, m_Xgel, m_Xcat;	
	                  
public: // create from serialization only
	CLocView();
	DECLARE_DYNCREATE(CLocView)

// Attributes
public:
	CLocDoc* GetDocument();

// Operations
public:

// Implementation
public:
	virtual ~CLocView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:                      
	void UpdateFonts (CDC* pDC);
	void SetXTabs (CDC* pDC, CLocDoc* ptLocDoc, int CharX);
	void PrepareXTabs (CDC* pDC);

	void DrawPageHeader (CDC* pDC, CLocDoc* ptLocDoc, int LineY, 
								int* ptY, int dX, BOOL bDraw = TRUE);
	void DrawPageFooter (CDC* pDC, int nPage, int LineY, 
								int* ptY, int dX, BOOL bDraw = TRUE); 
	void DrawAngle (CDC* pDC, int X, int Y, CLocation* ptLocation, BOOL bLat);
	void DrawVariation (CDC* pDC, int X, int Y, int CapsX, short nVar);
							
	BOOL DrawKoord (CDC* pDC, CLocDoc* ptLocDoc, DWORD* ptIndex,
					int* ptY, BOOL bDraw = TRUE);
 	void PrintPage (CDC* pDC, int nPageToPrint);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMusterView)
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
protected:
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo); 
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL



// Generated message map functions
protected:
	//{{AFX_MSG(CLocView)
	afx_msg void OnEditCopy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//#ifndef _DEBUG  // debug version in Koordvw.cpp
//inline CLocDoc* CLocView::GetDocument()
//   { return (CLocDoc*)m_pDocument; }
//#endif

/////////////////////////////////////////////////////////////////////////////
