#ifndef __LOCATION__      
#define __LOCATION__

// Location.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "LatLon.h" 

#define Country 	1
#define City		2
#define bigCity 	4
#define Gras		8
#define Relativ 	16 
#define NameIsIndic 32 	
#define UserCreated	64		

#define WP_AIRPORT			1
#define WP_REPORT			2
#define WP_INTERSECTION		3
#define WP_NDB				4
#define WP_VOR				5
#define WP_USER 			6
#define WP_SAIL				7
#define WP_HELI				8

#define SIZEOF_REGION	32		// see: region.h
#define SIZEOF_ORT	18
#define INDICATOR_SIZE	6                
 
#define ACT_KOORD_VERS	5   

#pragma pack(2)

typedef struct
	{
	char	Ort[SIZEOF_ORT];
	double	Lat;	
	double	Lon;
	long	MinAlt; 	/* minimale Flughhe, Elevation 	*/
	short	VAR;
	long	Frq;
	short	RwyLen; 	/* Lnge der Startbahn [m]		*/
	short	ElevDiff;	/* Hhendiff. durch Lngsneigung [ft]	*/
	BYTE	Range;	/* Reichweite des Senders [NM] (max:255)*/
	BYTE	Flag;	/* Country:1, City:2, bigCity:4, Gras:8 */
	} KOORDTYPE1;		/* Relativ:16				*/

typedef struct
	{
	char	Ort[SIZEOF_ORT];
	double	Lat;	
	double	Lon;
	long	MinAlt; 	/* minimale Flughhe, Elevation 	*/
	short	VAR;
	long	Frq;
	short	RwyLen; 	/* Lnge der Startbahn [m]		*/
	short	ElevDiff;	/* Hhendiff. durch Lngsneigung [ft]	*/
	BYTE	Range;	/* Reichweite des Senders [NM] (max:255)*/
	BYTE	Flag;	/* Country:1, City:2, bigCity:4, Gras:8 */
				/* Relativ:16				*/
	char	szIndicator[INDICATOR_SIZE];
	short	nAltDim;
	short	nRangeDim;
	short	nRwyDim;
	short	nDummy;
	} KOORDTYPE2;
 
typedef struct
	{
	char	szOrt[SIZEOF_ORT];
	double	dLat;	
	double	dLon;
 	long	lMinAlt; 		/* minimale Flughhe, Elevation 		*/
	short	nVAR;
 	long	lFrq;
 	short	nRwyLen; 		/* Lnge der Startbahn [m]				*/
	short	nElevDiff;	/* Hhendiff. durch Lngsneigung [ft]	*/
	BYTE	cRange;		/* Reichweite des Senders [NM] (max:255)*/
	BYTE	cFlag;		/* Country:1, City:2, bigCity:4, Gras:8 */
  							/* Relativ:16							*/
	char	szIndicator[INDICATOR_SIZE];
	short	nAltDim;
	short	nDistDim;
	short	nLenDim;   
	
 	short	nCountryCode;	/* String, containing 2 bytes: ED		*/
	BYTE	cType;		/* WP_AIRPORT, WP_INTERSECTION, WP_...	*/
	BYTE	cDummy;
	short	nDiffDim;                
	long	lDummy;
	} KOORDTYPE21;

typedef KOORDTYPE21 KOORDTYPE;

typedef KOORDTYPE FAR* LPKOORD;
#pragma pack() 
	
	
class CLocation : public CLatLon
{
	DECLARE_SERIAL(CLocation)

// Attributes
protected:    
	char	m_szOrt[SIZEOF_ORT];
 	long	m_lMinAlt; 		/* minimale Flughhe, Elevation 		*/
	short	m_nVAR;
 	long	m_lFrq;
 	short	m_nRwyLen; 		/* Lnge der Startbahn [m]				*/
	short	m_nElevDiff;	/* Hhendiff. durch Lngsneigung [ft]	*/
	BYTE	m_cRange;		/* Reichweite des Senders [NM] (max:255)*/
	BYTE	m_cFlag;		/* Country:1, City:2, bigCity:4, Gras:8 */
  							/* Relativ:16							*/
	char	m_szIndicator[INDICATOR_SIZE];
	short	m_nElevDim;
	short	m_nDistDim;
	short	m_nLenDim;   
	
 	short	m_nCountryCode;	/* String, containing 2 bytes: ED		*/
	BYTE	m_cType;		/* WP_AIRPORT, WP_INTERSECTION, WP_...	*/
	BYTE	m_cDummy;
	short	m_nDiffDim;                
	long	m_lDummy;

private:
	char	m_szRegionName[SIZEOF_REGION];

// Operations
protected:
	void ReadFromPtr(LPKOORD lpLoc);
	void WriteToPtr(LPKOORD lpLoc) const;

// Implementation
public:
	CLocation(LPKOORD lpLocation = NULL);		
	CLocation(CLocation& SourceLoc);
	~CLocation();    
	 
	void FirstInit();
	BOOL IsDefined();
	void Reset(CString szName="", short nVar=0, BYTE btFlag=0);
   
	const CLocation& operator=(const CLocation& Loc);   
	void GetPtr(LPKOORD lpLocation);
	void SetPtr(LPKOORD lpLocation);
                                     
	void CreateHomeBase();
	short NavFreqToCat (long lFreq);
	void SetTypeAndDummies (long lFreq);
	static void AddDigitToFreq(long* ptFreq);

 	void Serialize(CArchive& ar, short nVersion = ACT_KOORD_VERS, short nCC = 0);
	static double FlightAngle (double A, double B);

	LPKOORD CreatePtr ();
	BOOL IsRelativ();
	BOOL IsEqual(LPKOORD lpK1, LPKOORD lpK2);
	BOOL IsEqual(LPKOORD lpTestLocation);
	BOOL IsEqual(const CLocation& TestLocation);
	BOOL IsNear(CLocation& TestLocation);
	BOOL IsFacilityInRange (CLocation& ActLoc, double* ptDist);
	BOOL IsAirport ();
	BOOL IsFacility ();
	BOOL IsValid();

	void SetFlagBit (unsigned char FAR* lpFlag, short BitMask, BOOL bSet);
 	 
	static void SetName(LPSTR lpName, CString szName);
	static void SetIndicator(LPSTR lpIndicator, CString szIndicator);

	short GetTextWidth(CDC* pDC);
 	void SetName(CString szOrt);
 	CString GetName(); 
	BOOL GetName(LPSTR lpName);
   	void UseLatLonName();

	void SetUserCreated(BOOL bIndic);
	BOOL IsUserCreated(void);

	void UseIndicator(BOOL bIndic);
	BOOL IndicatorUsed(void) const;
	BOOL MarkNameForRte (CString szNameForRte);
	CString GetNameForRte ();

	void SetIndicator(CString szIndicator);
	void SetAltitude(long lAlt);
	void SetVariation(short nVar){m_nVAR = nVar;}
	void SetFrequency(float fFreq);
	void SetRange(long lRange);
	static BOOL StringToLatLon(LPCTSTR szText, double* ptAngle);
	static BOOL StringToCategory (CString szCategory, short* ptCat);
	static float StringToFreq (CString szFreq);
	void SetCategory(short nCat);
	void SetElevDiff(long lElevDiff);
 	void SetTopography(short nTopo);
	void SetCountryCode(CString szCC);
	void SetCC (short nCC) { m_nCountryCode = nCC; }
	void SetRwyLen(short nRwyLen);
	void SetRwyDir(short nDir);
	void SetGras (BOOL bGras);

 	CString GetIndicator();  
	BOOL GetIndicator(LPSTR lpIndicator);
 	long GetAltitude(){return m_lMinAlt;}
	BOOL GetAltitude(long* ptAlt);
	short GetVariation(){return m_nVAR;} 
	BOOL GetFrequency(float* ptFreq);
	BOOL GetRange(long* ptRange);
	long GetRange();
 	long GetSafeAlt_MSL(short nAltDim);
	short GetCategory(void);
	BOOL GetElevDiff(long* ptElevDiff);
	short GetElevDiff();
 	short GetTopography(void); 
  	CString GetCountryCode(void);
 	CString GetCountryName(void);
	short GetCC(void){ return m_nCountryCode; }        
	BOOL GetRwyLen(short* ptRwyLen);
 	short GetRwyDir(void);
 	BOOL IsGras(void);

	BOOL CheckLongLimits(long lValue, long lMin, long lMax);
	BOOL CheckDoubleLimits(double dValue, double dMin, double dMax);
	BOOL IsOK();		// shows message boxes for bad params

    void AngleToDMS (double angle, BOOL bLat,
	short* ptDegr, short* ptMin, short* ptSec, short* ptDir);
              
	short GetElevDim(){return m_nElevDim;}
	short GetDistDim(){return m_nDistDim;}
	short GetLenDim(){return m_nLenDim;}  
	short GetDiffDim(){return m_nDiffDim;}  
	CString GetRegionName(); 
	
	void SetElevDim(short nDim){m_nElevDim = nDim;}
	void SetDistDim(short nDim){m_nDistDim = nDim;}
	void SetLenDim(short nDim){m_nLenDim = nDim;}
	void SetDiffDim(short nDim){m_nDiffDim = nDim;}
	void SetRegionName(CString szName);

private:
	static void StringToCharArray(CString szText, char* ptText, short nArrayLen);

};
#endif 

