// LocDoc.cpp : implementation of the CLocDoc class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"

#include "LocDoc.h"  
#include "KoordDlg.h"				// dialog to set calculation pref parameters
#include "UpdatDlg.h"				// dialog to update databases
#include "GpsWptDlg.h"				// dialog to read/write waypoints
#include "Map.h"
#include "Import.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 	ptInit;              

/////////////////////////////////////////////////////////////////////////////
// CLocDoc

IMPLEMENT_DYNCREATE(CLocDoc, CDocument)

BEGIN_MESSAGE_MAP(CLocDoc, CDocument)
	//{{AFX_MSG_MAP(CLocDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLocDoc construction/destruction

CLocDoc::CLocDoc()
{
	// TODO: add one-time construction code here  
	m_bConverted	= FALSE;
	m_bAutoConvert	= FALSE;
	m_bSorted		= FALSE;
	m_bRename		= FALSE;		// to convert "danmark" into "denmark"
	m_szExt = ".krd";
	            
	m_nActCatIndex = CT_AIRPORT;
	m_ptQuickFind = ptInit->GetQuickFindPtr();
	m_nRegionIndex = -1;
}

CLocDoc::~CLocDoc()
{   
if (this->IsModified())  
	{
	CString szPath = this->GetPathName(); 
	this->OnSaveDocument (szPath);
	}
                        
short i;
for (i=0; i<CT_CNT; i++)
	this->DeleteArrayOf (&m_SubList[i]);     
}

/************************************************************************
 *  LocDoc.cpp			D e l e t e A r r a y O f 						*
 ************************************************************************/
void CLocDoc::DeleteArrayOf (CPtrArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	LPKOORD ptEntry;
	if ((ptEntry = (LPKOORD)ptArray->GetAt(i)) != NULL)
		{
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}                
 
/************************************************************************
 *  LocDoc.cpp			C o p y L o c a t i o n s						*
 ************************************************************************/
void CLocDoc::CopyLocations (CPtrArray* ptDest, CPtrArray* ptSource)
{
short i;
for (i=0; i<ptSource->GetSize(); i++) 
	{
	LPKOORD	lpDocKoord = NULL;         

	lpDocKoord = (LPKOORD)ptSource->GetAt (i);    
	if (lpDocKoord != NULL)
		{
		LPKOORD lpCpyKoord = new KOORDTYPE;	  	// need no class!!
		_fmemcpy (lpCpyKoord, lpDocKoord, sizeof(KOORDTYPE)); 
		ptDest->Add (lpCpyKoord);    
		}
	}
}        

/************************************************************************
 *  LocDoc.cpp			G e t P l a c e C n t							*
 ************************************************************************/
short CLocDoc::GetPlaceCnt (CATEGORYINDEX CatIndex)
{
	return m_SubList[CatIndex].GetSize(); 
}

/************************************************************************
 *  LocDoc.cpp			G e t P l a c e C n t							*
 ************************************************************************/
short CLocDoc::GetPlaceCnt (short nCategory)
{
	CATEGORYINDEX CatIndex = this->CategoryToIndex (nCategory);
	return m_SubList[CatIndex].GetSize(); 
}


/************************************************************************
 *  LocDoc.cpp			G e t L o c a t i o n P t r						*
 ************************************************************************/
LPKOORD CLocDoc::GetLocationPtr (short nCatIndex, short nIndex)
{
LPKOORD lpKoord = NULL;

if (nIndex>=0 && nIndex<m_SubList[nCatIndex].GetSize())
	{
	lpKoord = (LPKOORD)m_SubList[nCatIndex].GetAt (nIndex);  
	} 
return lpKoord;      
}



/************************************************************************
 *  LocDoc.cpp	  			G e t S u b L i s t P t r					*
 ************************************************************************/
CPtrArray* CLocDoc::GetSubListPtr (short nCategory)
{ 
CATEGORYINDEX CatIndex = this->CategoryToIndex (nCategory);
return &m_SubList[CatIndex];
}

/************************************************************************
 *  LocDoc.cpp	  		 G e t S o r t e d I n d e x 					*
 ************************************************************************/
short CLocDoc::GetSortedIndex (CPtrArray* ptSubList, CLocation& Location)
{
BOOL	bInsAfter;  
long	IndMin, IndMax, i, OldTestInd;

        								// get new name to insert 
CString	szNewName = Location.GetName();

IndMin  = 0;
IndMax  = ptSubList->GetSize();		/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;				/* i always < cnt !!	*/

if (ptSubList->GetSize() > 0)
   {
   do	{  
        LPKOORD lpTestKoord = (LPKOORD)ptSubList->GetAt((int)i);
        CLocation	TestKoord (lpTestKoord);
        CString szTestName = TestKoord.GetName();
        
        int iCmp = szNewName.CompareNoCase ((LPCTSTR)szTestName);

	    if (iCmp >=0)	bInsAfter = TRUE;
	    		else	bInsAfter = FALSE;

		if (bInsAfter)	IndMin = i;
				else	IndMax = i;
				
		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }                     
   
return (short)i;
}

/************************************************************************
 *  LocDoc.c			   N e x t D a t a I n d e x					*
 *  Output: last used index												*
 *  Return: TRUE, if szSearch found 									*
 ************************************************************************/
BOOL CLocDoc::NextDataIndex (CPtrArray* ptSubList, short* i, CString szSearch)
{
long	index;
short	nCmpResult;

if (szSearch.GetLength() == 0) return FALSE;

for	(index=*i; index < ptSubList->GetSize(); index++)
	{  
    LPKOORD lpTestKoord = (LPKOORD)ptSubList->GetAt((int)index);
    CLocation	TestKoord (lpTestKoord);
    CString szTestName = TestKoord.GetName();
    
    nCmpResult = szTestName.CompareNoCase ((LPCTSTR)szSearch);

	if (nCmpResult >= 0)
		{
		*i = (short)index;
		return (nCmpResult == 0);
		}
	}

*i = (short)index;
return FALSE;
}


/****************************************************************************
 *	LocDoc.cpp				C o p y W p t s O f C a t e g o r y 			*
 ****************************************************************************/
short CLocDoc::CopyWptsOfCategory(CLocDoc* ptSourceDoc, short nCategory)
{
	short	nCopied = 0;
	short 	i, nNewInd;

	CPtrArray* ptSourceList = ptSourceDoc->GetSubListPtr (nCategory);
	short nCnt = ptSourceList->GetSize();

	if (nCnt > 0)
	{
		nNewInd = 0;
		CPtrArray* ptDestList = this->GetSubListPtr (nCategory);
		for (i=0; i<nCnt; i++)
		{						// for all user waypoints in ptSourceDoc
			LPKOORD	lpSourceKoord = (LPKOORD)ptSourceList->GetAt(i);
			CLocation SourceLoc (lpSourceKoord);

			if (this->NextDataIndex (ptDestList, &nNewInd, SourceLoc.GetName()))
			{			// SourceLoc already member of ptDestList: change it
 				LPKOORD ptDestKoord = (LPKOORD)ptDestList->GetAt(nNewInd);
				_fmemcpy (ptDestKoord, lpSourceKoord, sizeof (KOORDTYPE));
				nCopied++;
			}
			else
			{					// SourceLoc is not member of this (dest) data base
				short nPos = this->GetSortedIndex (ptDestList, SourceLoc); 
				ptDestList->InsertAt (nPos, SourceLoc.CreatePtr());	// insert new
				nCopied++;
			}
		}
	}

	return nCopied;
}


/****************************************************************************
 *	LocDoc.cpp					C o p y U s e r W p t s 	 				*
 ****************************************************************************/
short CLocDoc::CopyUserWpts (CLocDoc* ptSourceDoc)
{
	short	nCopied = 0;

	nCopied = CopyWptsOfCategory(ptSourceDoc, WP_USER);

					// while waypoints of type intersection have no USER - flag, 
	nCopied += CopyWptsOfCategory(ptSourceDoc, WP_INTERSECTION);

					// while waypoints of type sail have no USER - flag, 
	nCopied += CopyWptsOfCategory(ptSourceDoc, WP_SAIL);

					// while waypoints of type heli have no USER - flag, 
	nCopied += CopyWptsOfCategory(ptSourceDoc, WP_HELI);

	return nCopied;
}

/************************************************************************
 *  LocDoc.cpp				G e t D a t a B a s e 						*
 ************************************************************************/
void CLocDoc::GetDataBase (CPtrArray* ptDlgSubList)
{                    
short i;

for (i=0; i<CT_CNT; i++)
	{                              	// copy database from Doc to Dlg
	this->DeleteArrayOf (ptDlgSubList + i);
	this->CopyLocations (ptDlgSubList + i, &m_SubList[i]);   
	}
}   

/************************************************************************
 *  LocDoc.cpp			S e t D a t a B a s e 						*
 ************************************************************************/
void CLocDoc::SetDataBase (CPtrArray* ptDlgSubList)
{     
short i;

for (i=0; i<CT_CNT; i++)
	{                          		 // copy database from Dlg to Doc
	this->DeleteArrayOf (&m_SubList[i]);
	this->CopyLocations (&m_SubList[i], (ptDlgSubList + i));   
	}
}


/************************************************************************
 *  LocDoc.cpp					G e t L o c a t i o n					*
 ************************************************************************/
CLocation CLocDoc::GetLocation (short nCategory, short nIndex)
{
CATEGORYINDEX CatIndex = this->CategoryToIndex (nCategory);
LPKOORD lpKoord = NULL;

if (nIndex>=0 && nIndex<m_SubList[CatIndex].GetSize())
	{
	lpKoord = (LPKOORD)m_SubList[CatIndex].GetAt (nIndex);  
	} 

CLocation Loc (lpKoord);
return Loc;
}


/************************************************************************
 *  LocDoc.cpp		 G e t M a x L o c N a m e L e n					*
 ************************************************************************/
short CLocDoc::GetMaxLocNameLen (short nCatIndex, CDC* pDC)
{
short	nThisTextLen;
short i, nMaxNameLen;

nMaxNameLen = 0;  
CSize	TextSize;
for (i=0; i<m_SubList[nCatIndex].GetSize(); i++)
    {
    LPKOORD lpKoord = (LPKOORD)m_SubList[nCatIndex].GetAt (i);  
    TextSize = pDC->GetTextExtent(lpKoord->szOrt, strlen(lpKoord->szOrt));
    nThisTextLen = (short)TextSize.cx;
    if (nThisTextLen > nMaxNameLen) nMaxNameLen = nThisTextLen;
    }
return nMaxNameLen;
}                                        

/************************************************************************
 *  LocDoc.cpp			G e t M a p B o r d e r		 					*
 ************************************************************************/
void CLocDoc::GetMapBorder (CBorder* ptBorder, BOOL bUseAPTs)
{
BOOL bUseREPs, bUseINTs, bUseNDBs, bUseVORs, bUseUSRs;
BOOL	bFirst = TRUE;
CATEGORYINDEX CatIndex;
double 		fLat, fLon;
short nCnt, i;		 

bUseREPs = bUseINTs = bUseNDBs = bUseVORs = bUseUSRs = FALSE;
								
if (bUseAPTs)						 
	{
	CatIndex = this->CategoryToIndex (WP_AIRPORT);
	nCnt = m_SubList[CatIndex].GetSize();

	for (i=0; i<nCnt; i++)
		{
		LPKOORD	lpKoord = (LPKOORD)m_SubList[CatIndex].GetAt(i);
		CLocation Loc (lpKoord);
		fLat = Loc.GetLat();
		fLon = Loc.GetLon();

		if (bFirst)	
			{
			ptBorder->Init (fLat, fLon);
			bFirst = FALSE;
			}
		else{
			ptBorder->Expand (fLat, fLon);
			}
		}
	}

if (bUseREPs)						 
	{
	CatIndex = this->CategoryToIndex (WP_REPORT);
	}

if (bUseINTs)
	{
	CatIndex = this->CategoryToIndex (WP_INTERSECTION);
	}
if (bUseNDBs)
	{
	CatIndex = this->CategoryToIndex (WP_NDB);
	}
if (bUseVORs)
	{
	CatIndex = this->CategoryToIndex (WP_VOR);
	}
if (bUseUSRs)
	{
	CatIndex = this->CategoryToIndex (WP_USER);
	}

ptBorder->Finish ();
}


/************************************************************************
 *  LocDoc.cpp			O n N e w D o c u m e n t						*
 ************************************************************************/
BOOL CLocDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)     
	
short i;
for (i=0; i<CT_CNT; i++)
	this->DeleteArrayOf (&m_SubList[i]);
    
return TRUE;
}   

/************************************************************************
 *  LocDoc.cpp				O n O p e n D o c u m e n t					*
 ************************************************************************/
BOOL CLocDoc::OnOpenDocument(LPCTSTR pszPathName)
{
BOOL bOpened = FALSE;
this->SetPathName(pszPathName);

bOpened = CDocument::OnOpenDocument(pszPathName); 

if (bOpened && m_bRename)
	{							// convert "danmark" to "denmark"
	CString szNameOld = this->GetPathName();
	CString szNameNew = szNameOld;

	short nSlash = szNameNew.ReverseFind ('\\');
	if (nSlash > 0)
		{
		int		err;
		BOOL bAddToMRU = FALSE;				// dont add to most recently used files
		szNameNew.SetAt (nSlash + 2, 'e'); 
		err = rename ((LPCTSTR)szNameOld, (LPCTSTR)szNameNew);
		if (err == 0)	this->SetPathName (szNameNew, bAddToMRU);
				else	MessageBeep (MB_OK);    
		}


	/*TRY{    
		CFile::Rename( pOldName, pNewName );
		}
	CATCH( CFileException, e )
		{
		#ifdef _DEBUG
		afxDump << "File " << pOldName << " not found, cause = " << e->m_cause << "\n";   
		#endif
		}
	END_CATCH
	*/ 
	m_bRename = FALSE;
	}	


return bOpened;
}

/************************************************************************
 *  LocDoc.cpp			O n S a v e D o c u m e n t						*
 ************************************************************************/
BOOL CLocDoc::OnSaveDocument(const char* pszPathName, BOOL bConfirm)
{
BOOL bSaved = FALSE;
BOOL bDoSave;

if (bConfirm)
	{
	CString szText;
	CString szFile = this->GetActRegionName();
	szText.Format(IDF_SAVE_FILE, (LPCTSTR)szFile);
	bDoSave = (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES);
	}
else{
	bDoSave = TRUE;
	}

if (bDoSave)
	{
	bSaved = CDocument::OnSaveDocument(pszPathName); 
	}        
else{   
    this->SetModifiedFlag (FALSE);
	}
return bSaved;
}

/************************************************************************
 *  KoordDlg.cpp	  		 E n u m L i s t P t r						*
 ************************************************************************/
CPtrArray* CLocDoc::EnumListPtr (CATEGORYINDEX nIndex)
{         
CPtrArray* ptList = NULL;
 
if (nIndex >= CT_AIRPORT && nIndex <= CT_HELI)
	ptList = &m_SubList[nIndex];	

return ptList;
}

/************************************************************************
 *  LocDoc.cpp  		 	G e t N e x t L o c a t i o n P t r			*
 ************************************************************************/
LPKOORD CLocDoc::GetNextLocFromCatList(int* ptMaxCnt, int* ptCnt, CATEGORYINDEX* ptCI)
{
CString	szMinStr; 
LPKOORD	lpMinKoord;
short	MinCategory; 
BOOL	bFirst = TRUE;
short i;

for (i=0; i<CT_CNT; i++)
	{               				// find "smallest" string of all lists
	CPtrArray* 	ptList = this->EnumListPtr ((CATEGORYINDEX)i);  
	if (*(ptCnt + i) < *(ptMaxCnt + i))
		{
		LPKOORD	lpKoord = (LPKOORD)ptList->GetAt (*(ptCnt + i));
		CLocation Location (lpKoord);
		CString szName = Location.GetName();  
		if (bFirst)
			{           
			bFirst 	= FALSE;
			szMinStr 	= szName; 
			lpMinKoord 	= lpKoord;
			MinCategory	= i;
			}                 
		else{
		    if (szMinStr.CompareNoCase (szName) > 0)
		    	{
		    	szMinStr 	= szName;     
		    	lpMinKoord 	= lpKoord;   
		    	MinCategory	= i;
		    	}
			}   
		}
	}

(*(ptCnt + MinCategory))++;    
*ptCI = (CATEGORYINDEX)MinCategory;
return lpMinKoord;
}

/************************************************************************
 *  LocDoc.cpp  		 		 C h a n g e 							*
 *	ptLoc != NULL and bShowLoc = TRUE => use ptLoc to initialize dlg	*
 *  ptLoc != NULL and bShowLoc = FALSE=> use ptLoc to return selection	*
 ************************************************************************/
BOOL CLocDoc::Change(CWnd* ptWnd, CLocation* ptLoc, BOOL bShowLoc)
{  
BOOL 	bChanged = FALSE;
CKoordDlg KoordDlg(ptWnd, this, ptLoc, bShowLoc);

int RetVal = KoordDlg.DoModal();
switch (RetVal)
	{
	case IDOK:
		{   
			CString szPath = this->GetPathName(); 
			if (KoordDlg.CopyDataBaseIntoDoc()) // get confirmation from user before copying data to doc
			{             
				BOOL bConfirm = FALSE;
			// this avoids updating background view. 
			// If view is DrawMap, this doc would be used to get airports of diffenent regions to be drawn.
				this->OnSaveDocument (szPath, bConfirm);

										// Updates CNameList and CLaLoList
				m_ptQuickFind->Update(this->GetRegionIndex());

				bChanged = TRUE;
			}

 			ptInit->SetLocDocPath(szPath);    

			if (ptLoc != NULL)
				KoordDlg.GetSelectedLocation(ptLoc);
		}
 		break;
	case IDCANCEL: 
        this->SetModifiedFlag(FALSE);
		break;
	}
return bChanged;	
} 


/************************************************************************
 *  LocDoc.cpp	  			 D o R e a l l y S a v e					*
 ************************************************************************/
BOOL CLocDoc::DoReallySave()
{
	CString szText;
	CString szFile = this->GetActRegionName();
	szText.Format(IDF_SAVE_FILE, (LPCTSTR)szFile);
	return (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES);
}


/************************************************************************
 *  LocDoc.cpp  		 		 D o I m p o r t 						*
 ************************************************************************/
BOOL CLocDoc::DoImport(CImport& LocImport, BOOL* ptAborted)
{  
	BOOL 	bChanged = FALSE;
	
	*ptAborted = FALSE;

	LocImport.AddColumnName("COUNTRY");
	LocImport.AddColumnName("NAME");
	LocImport.AddColumnName("IDENT");
	LocImport.AddColumnName("TYPE");				// "WP_AIRPORT", ...
	LocImport.AddColumnName("LAT");
	LocImport.AddColumnName("LON");
	LocImport.AddColumnName("ELEV");
	LocImport.AddColumnName("ELEV_IN");
	LocImport.AddColumnName("VAR");
	LocImport.AddColumnName("FREQ");
	LocImport.AddColumnName("RWYDIR");
	LocImport.AddColumnName("RWYLEN");
	LocImport.AddColumnName("RWYLEN_IN");
	LocImport.AddColumnName("RWYSLOPE");
	LocImport.AddColumnName("RWYSLOPE_IN");
	LocImport.AddColumnName("SURFACE");
	LocImport.AddColumnName("RANGE");
	LocImport.AddColumnName("RANGE_IN");

	if (LocImport.Open())
	{
		short nLine = 3;

		while (LocImport.ParseLine(ptAborted))
		{								// define new location here...
			CLocation Loc;

			CString szParam;
			if (LocImport.GetColumnParam(&szParam))		// COUNTRY
			    Loc.SetCountryCode(szParam);

			if (LocImport.GetColumnParam(&szParam))		// NAME
				Loc.SetName(szParam); 

			if (LocImport.GetColumnParam(&szParam))		// IDENT
			    Loc.SetIndicator (szParam);

			if (LocImport.GetColumnParam(&szParam))		// TYPE
			{
				short nCategory;
				if (Loc.StringToCategory(szParam, &nCategory))
					Loc.SetCategory(nCategory);
			}

			if (LocImport.GetColumnParam(&szParam))		// LAT
			{
				double dAngle;
				if (Loc.StringToLatLon((LPCTSTR)szParam, &dAngle))
					Loc.SetLat(dAngle);
			}
			
			if (LocImport.GetColumnParam(&szParam))		// LON
			{
				double dAngle;
				if (Loc.StringToLatLon((LPCTSTR)szParam, &dAngle))
					Loc.SetLon(dAngle);
			}

			if (LocImport.GetColumnParam(&szParam))		// ELEV
			{
				long lElev = atol((LPCTSTR)szParam);
				Loc.SetAltitude(lElev);
			}

			if (LocImport.GetColumnParam(&szParam))		// ELEV_IN
			{
				short nDim;
				if (CDimDoc::StringToDim(szParam, &nDim))
					Loc.SetElevDim(nDim);
			}

			if (LocImport.GetColumnParam(&szParam))		// VAR
			{
				double dAngle;
				if (Loc.StringToLatLon((LPCTSTR)szParam, &dAngle))
					Loc.SetVariation((short)dAngle);
			}

			if (LocImport.GetColumnParam(&szParam))		// FREQ
			{
				float fFreq = Loc.StringToFreq(szParam);
				Loc.SetFrequency(fFreq);
			}

			if (LocImport.GetColumnParam(&szParam))		// RWYDIR
			{
				short nDir = atoi((LPCTSTR)szParam);
				Loc.SetRwyDir (nDir);
			}

			if (LocImport.GetColumnParam(&szParam))		// RWYLEN
			{
				short nRwyLen = atoi ((LPCTSTR)szParam);
				Loc.SetRwyLen(nRwyLen);
			}

			if (LocImport.GetColumnParam(&szParam))		// RWYLEN_IN
			{
				short nDim;
				if (CDimDoc::StringToDim(szParam, &nDim))
					Loc.SetLenDim(nDim);
			}

			if (LocImport.GetColumnParam(&szParam))		// RWYSLOPE
			{
				long lElevDiff = atol ((LPCTSTR)szParam);
				Loc.SetElevDiff(lElevDiff);
			}

			if (LocImport.GetColumnParam(&szParam))		// RWYSLOPE_IN
			{
				short nDim;
				if (CDimDoc::StringToDim(szParam, &nDim))
					Loc.SetDiffDim(nDim);
			}


			if (LocImport.GetColumnParam(&szParam))		// SURFACE
			{
				short nHard = atoi ((LPCTSTR)szParam);
				Loc.SetGras(nHard == 0);
			}

			if (LocImport.GetColumnParam(&szParam))		// RANGE
			{
				if (!Loc.IsAirport ())
				{
					long lRange = atol((LPCTSTR)szParam);
					Loc.SetRange(lRange);
				}
			}

			if (LocImport.GetColumnParam(&szParam))		// RANGE_IN
			{
				short nDim;
				if (CDimDoc::StringToDim(szParam, &nDim))
					Loc.SetDistDim(nDim);
			}


		// Loc.SetTopography(Country);	    

			if (Loc.IsOK())		// reports errors via message boxes
			{	
				nLine++;
								// save new CLocation here
				short nCategory = Loc.GetCategory();
				CATEGORYINDEX CatIndex = this->CategoryToIndex (nCategory);

				CPtrArray* ptDestList = this->EnumListPtr (CatIndex);
				if (ptDestList != NULL)
				{
					BOOL bChangeMode = FALSE;

					short nNewIndex = this->GetSortedIndex (ptDestList, Loc); 

					if (nNewIndex > 0)
						{					// look for already existing name
 						CLocation PrevLoc((LPKOORD)ptDestList->GetAt(nNewIndex-1));
						CString szPrevName = PrevLoc.GetName();
						CString szNewName = Loc.GetName();

						if (szNewName.Compare (szPrevName) == 0)
							{
							bChangeMode = TRUE;
							}
						}

					if (bChangeMode)
					{			// change old data base entry
						short nOldInd = nNewIndex-1;
						LPKOORD ptOldKoord = (LPKOORD)ptDestList->GetAt(nOldInd);
						delete ptOldKoord;
						ptDestList->SetAt(nOldInd, Loc.CreatePtr());
					}
					else
					{			// insert new location
						ptDestList->InsertAt (nNewIndex, Loc.CreatePtr());	// insert new
					}
					bChanged = TRUE;
				}
			}
			else
			{
				*ptAborted = TRUE;
				
				CString szMsg;
				szMsg.Format (IDF_IMP_PARAMS, nLine);
				AfxMessageBox (szMsg);				
			}
		} // while (ParseLine)...
		
		AfxMessageBox ((*ptAborted)? IDS_IMP_CANCELED : IDS_IMP_OK);
	}
	else
	{
		AfxMessageBox (IDS_IMP_CANCELED);
	}

	return bChanged;
}


/************************************************************************
 *  LocDoc.cpp  		 		 I m p o r t							*
 ************************************************************************/
BOOL CLocDoc::Import(CWnd* ptWnd)
{  
	BOOL 	bChanged = FALSE;

	CString szText, szActRegion;

	szActRegion = this->GetActRegionName ();
	szText.Format(IDF_IMP_CONFIRM, (LPCTSTR)szActRegion);
	if (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES) 
	{ 
		CImport LocImport;

		if (LocImport.GetSourceFileName(ptWnd))
		{
			BOOL bAborted;
			CString szPath = this->GetPathName(); 
			if (this->DoImport(LocImport, &bAborted)) 
			{         
				if (bAborted)
				{						// restores old database
					m_ptQuickFind->Update(this->GetRegionIndex());
					bChanged = FALSE;
				}
				else
				{
					BOOL bConfirm = FALSE;
					this->OnSaveDocument (szPath, bConfirm);

											// Updates CNameList and CLaLoList
					m_ptQuickFind->Update(this->GetRegionIndex());
					bChanged = TRUE;
				}

 			}     
 			ptInit->SetLocDocPath(szPath);    
		}
	}

return bChanged;	
} 


/************************************************************************
 *  LocDoc.cpp  		 		 H e a d e r T o V e r s 				*
 ************************************************************************/
short CLocDoc::HeaderToVers (char* ptHeader)
{  
short nVersion = 0;
CString szTestVers; 

szTestVers.LoadString (IDS_KO_VERS1); 
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = 1;

szTestVers.LoadString (IDS_KO_VERS2);  
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = 2;

szTestVers.LoadString (IDS_KO_VERS21);  
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = 3;

szTestVers.LoadString (IDS_KO_VERS223);  
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = 4;

szTestVers.LoadString (IDS_KO_VERS);
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = ACT_KOORD_VERS;

return nVersion;
} 
     
/************************************************************************
 *  LocDoc.cpp  		 		V e r s T o H e a d e r 				*
 ************************************************************************/
void CLocDoc::VersToHeader (LPSTR lpHeader, short nVersion)
{      
CString szVers;
switch (nVersion)
	{
	case 1:	szVers.LoadString (IDS_KO_VERS1);	break; 
	case 2:	szVers.LoadString (IDS_KO_VERS2);	break; 
	case 3:	szVers.LoadString (IDS_KO_VERS21);	break; 
	case 4:	szVers.LoadString (IDS_KO_VERS223);	break; 
	case ACT_KOORD_VERS:	szVers.LoadString (IDS_KO_VERS);	break; 
	default: szVers.Empty();	break;
    }

_fstrcpy (lpHeader, (LPCTSTR)szVers);
}      


/************************************************************************
 *  LocDoc.cpp  		 	G e t E n t r y C n t						*
 ************************************************************************/
short CLocDoc::GetEntryCnt (CArchive& ar, short nVersion)
{ 
CFile* ptFile = ar.GetFile();
DWORD	dwLength = (DWORD)ptFile->GetLength();
  
DWORD dwBlockSize;  			// get number of entries:
switch (nVersion)
	{
	case 1:	dwBlockSize = sizeof (KOORDTYPE1);	break;
	case 2:	dwBlockSize = sizeof (KOORDTYPE2);	break;
	case 3:	dwBlockSize = sizeof (KOORDTYPE21);	break;
    case 4:  // no break!!
	case ACT_KOORD_VERS:	dwBlockSize = sizeof (KOORDTYPE);	break;
    }
return (short)((dwLength - MAX_HEADER_SIZE) / dwBlockSize);
}

/************************************************************************
 *  LocDoc.cpp  		 	N a m e T o C o u n t r y C o d e			*
 ************************************************************************/
short CLocDoc::NameToCountryCode (LPCTSTR szName)
{
short	nCC;
strncpy ((char*)&nCC, "  ", 2);

if ((szName[0] == 'G' || szName[0] == 'g') &&
    (szName[1] == 'E' || szName[1] == 'e')  )
	strncpy ((char*)&nCC, "ED", 2);
if ((szName[0] == 'A' || szName[0] == 'a') &&
    (szName[1] == 'U' || szName[1] == 'u')  )
	strncpy ((char*)&nCC, "LO", 2);
if ((szName[0] == 'S' || szName[0] == 's') &&
    (szName[2] == 'I' || szName[2] == 'i')  )
	strncpy ((char*)&nCC, "LS", 2);

return nCC;
}
 
/************************************************************************
 *  LocDoc.cpp  		 	C a t e g o r y T o I n d e x				*
 ************************************************************************/
CATEGORYINDEX CLocDoc::CategoryToIndex (short nCategory)
{   
CATEGORYINDEX Index;
         
switch (nCategory)
	{						  
	case WP_AIRPORT:		Index = CT_AIRPORT; break;
	case WP_VOR:			Index = CT_VOR; 	break;
	case WP_NDB:			Index = CT_NDB; 	break;
	case WP_REPORT:			Index = CT_REPORT; 	break;
	case WP_INTERSECTION:	Index = CT_INTERSECTION; break;
	case WP_USER:			Index = CT_USER; 	break;
	case WP_SAIL:			Index = CT_SAIL; 	break;
	case WP_HELI:			Index = CT_HELI; 	break;
	}     
return Index;
}                      

/************************************************************************
 *  LocDoc.cpp  		 	I n d e x T o C a t e g o r y				*
 ************************************************************************/
short CLocDoc::IndexToCategory (CATEGORYINDEX Index)
{ 
short	nCategory;  

switch (Index)
	{
	case CT_AIRPORT:		nCategory = WP_AIRPORT; break;
	case CT_VOR:			nCategory = WP_VOR; 	break;
	case CT_NDB:			nCategory = WP_NDB; 	break;
	case CT_REPORT:			nCategory = WP_REPORT; 	break;
	case CT_INTERSECTION:	nCategory = WP_INTERSECTION; break;
	case CT_USER:			nCategory = WP_USER; 	break;
	case CT_SAIL:			nCategory = WP_SAIL; 	break;
	case CT_HELI:			nCategory = WP_HELI; 	break;
	}     
return nCategory;
} 

/************************************************************************
 *  LocDoc.cpp  		 	S e t A c t C a t I n d e x					*
 ************************************************************************/
void CLocDoc::SetActCatIndex (CATEGORYINDEX CatIndex)
{
m_nActCatIndex = CatIndex;
}

/************************************************************************
 *  LocDoc.cpp  			 	G e t A c t C a t I n d e x				*
 ************************************************************************/
CATEGORYINDEX CLocDoc::GetActCatIndex ()
{
return m_nActCatIndex;
}       
 
/************************************************************************
 *  LocDoc.cpp  		 		S e r i a l i z e 						*
 ************************************************************************/
void CLocDoc::Serialize(CArchive& ar)
{    
	short i, nVersion, nCC;

	if (ar.IsStoring())
	{  
		// TODO: add storing code here     
		CATEGORYINDEX CatIndex;
		nVersion = ACT_KOORD_VERS;  
		VersToHeader ((LPSTR)&m_szHeader, nVersion);	
		ar.Write (&m_szHeader, MAX_HEADER_SIZE);    
		
		short	nTotalCnt 		= 0;
		int* 	ptCnt 		= new int[CT_CNT];		// Allocate new memory for act counter
		int* 	ptMaxCnt 	= new int[CT_CNT];		// Allocate new memory for max counter 
		for (i=0; i<CT_CNT; i++)   			   
		{										// define all counters 
			CPtrArray* 	ptList = this->EnumListPtr ((CATEGORYINDEX)i);    
			nTotalCnt		+= ptList->GetSize();	// total number of all entries
			*(ptMaxCnt + i) = ptList->GetSize();    // number of entries for each category
	 		*(ptCnt + i) 	= 0;                    // actual index for each category
	    }  
	
		for (i=0; i<nTotalCnt; i++)
		{
			LPKOORD lpKoord = this->GetNextLocFromCatList (ptMaxCnt, ptCnt, &CatIndex);
			CLocation Location(lpKoord);
			Location.Serialize (ar);  
		}      
	
		if (m_nRegionIndex >= 0)	// required for QF->Update and GetTotalEntryCnt
			m_ptQuickFind->RegionSetCnt (m_nRegionIndex, nTotalCnt);
		
		delete [] ptCnt;         
		delete [] ptMaxCnt;         

		m_bConverted = FALSE;		
	}
	else
	{
		// TODO: add loading code here   
		m_bConverted = FALSE;
		m_bSorted = FALSE;
		nCC = 0;

		ar.Read (&m_szHeader, MAX_HEADER_SIZE);
		nVersion = this->HeaderToVers (m_szHeader);  
		
		if (nVersion < ACT_KOORD_VERS)
		{	  
			if (m_bAutoConvert)
			{
				m_bConverted = TRUE;
				m_bAutoConvert = FALSE;
			}
			else
			{
				CString szText;
				szText.Format(IDS_CONVERT_KO, (LPCTSTR)this->GetActRegionName());
				m_bConverted = (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES);
			}

			if (m_bConverted) 
			{ 
				CString szName = this->GetActRegionName();		  // "danmark"
				nCC = this->NameToCountryCode ((LPCTSTR)szName);

				if (szName.CompareNoCase((LPCTSTR)"Danmark") == 0)
				{     						// convert Danmark to Denmark
					m_bRename = TRUE;
				}

			}
			else
			{ 
        		AfxMessageBox (IDS_BAD_KO_VERS);
        		return;
        	}
        }
	
		short nCnt = this->GetEntryCnt (ar, nVersion);
	
		for (i=0; i<nCnt; i++)
		{
			CLocation Location; 
			Location.Serialize (ar, nVersion, nCC);
			LPKOORD lpKoord = Location.CreatePtr();	   	
			if (lpKoord != NULL)
			{  
				CATEGORYINDEX CatIndex = this->CategoryToIndex (Location.GetCategory());
				m_SubList[CatIndex].Add (lpKoord);       	// add new Element
			        
						// Store nSubListIndex for each Location if
						//	 CNameList::m_nAddRegionIndex != -1	and
						//	 CLaLoList::m_nAddRegionIndex != -1
				short nSubListIndex = m_SubList[CatIndex].GetSize() - 1;
				m_ptQuickFind->AddEntry (&Location, nSubListIndex);
			}  
		} 
 	}  
}



/************************************************************************
 *  LocDoc.cpp  		 S o r t L o c a t i o n N a m e				*
 ************************************************************************/
BOOL CLocDoc::SortLocationName (CPtrArray* ptKoords)
{
LPKOORD	ptNewKoord, ptOldKoord;
BOOL		bSort, bRepeat, bIndicateSort;
register short	i;
bIndicateSort = FALSE;

do	{
	bSort = bRepeat = FALSE;
	for (i=0; i<ptKoords->GetSize(); i++)
		{      
		if ((ptNewKoord = (LPKOORD)ptKoords->GetAt(i)) != NULL)
			{                 
			if (i>0)		/* new name < old name	*/
			    bSort = (_fstricmp ((LPSTR)ptNewKoord->szOrt,
					       (LPSTR)ptOldKoord->szOrt) < 0 )? TRUE : FALSE;
			if (bSort)
				{    
				ptKoords->SetAt (i-1, ptNewKoord);
				ptKoords->SetAt (i, ptOldKoord);
				bRepeat = TRUE;
				bIndicateSort = TRUE;
				}
			else{
				ptOldKoord = ptNewKoord;
				}
			}      
		}	
	} while (bRepeat);

return bIndicateSort;
}

/************************************************************************
 *  LocDoc.cpp  		 	S o r t A l l C a t e g o r i e s			*
 ************************************************************************/
BOOL CLocDoc::SortAllCategories()
{
BOOL	bSorted = FALSE;
short i;

for (i=0; i<CT_CNT; i++)
	{               				
	CPtrArray* 	ptList = this->EnumListPtr ((CATEGORYINDEX)i);
	if (this->SortLocationName (ptList))
		bSorted = TRUE;
    }
    
if(bSorted)
    {
	m_bSorted = TRUE;
    }
return bSorted;
}


/************************************************************************
 *  LocDoc.cpp  		 		 U p d a t e 							*
 ************************************************************************/
BOOL CLocDoc::Update(CWnd* ptWnd)
{  
BOOL 	bChanged = FALSE;
CLocUpdateDlg UpdateDlg(ptWnd, ptInit, this);

int RetVal = UpdateDlg.DoModal();
switch (RetVal)
	{
	case IDOK:
		{   
		CString szPath = this->GetPathName(); 
									// Updates CNameList and CLaLoList
		m_ptQuickFind->Update(this->GetRegionIndex());
 		bChanged = TRUE;
 		ptInit->SetLocDocPath(szPath);    
		}
 		break;
	case IDCANCEL: 
		break;
	}
return bChanged;	
} 

/************************************************************************
 *  LocDoc.cpp  		 	S h o w C h a n g e M s g					*
 ************************************************************************/
void ShowChangeMsg (LPKOORD ptKoord)
{
	char szMsg[256];
	char szType[32];

	switch (ptKoord->cType)
	{
	case WP_AIRPORT:
		sprintf (szType, "Flugplatz");
		break;
	case WP_REPORT:
		sprintf (szType, "Meldepunkt");
		break;
	case WP_INTERSECTION:
		sprintf (szType, "Kreuzung");
		break;
	case WP_NDB:
		sprintf (szType, "NDB");
		break;
	case WP_VOR:
		sprintf (szType, "VOR");
		break;
	case WP_USER:
		sprintf (szType, "Benutzerwegpunkt");
		break;
	}

sprintf (szMsg, "%s %s wird berschrieben!", szType, ptKoord->szOrt);
AfxMessageBox (szMsg);
}

/************************************************************************
 *  LocDoc.cpp  		 		 D o M e r g e 							*
 ************************************************************************/
BOOL CLocDoc::DoMerge(CLocDoc* ptSourceDoc)
{  
BOOL	bMerged = FALSE;
LPKOORD   ptNewKoord, ptOldKoord;
short	  nIndex, NewInd, OldInd;
BOOL	  bFound, bDelete;

for (nIndex=0; nIndex<CT_CNT; nIndex++)
	{							// for every new category     				
	CPtrArray* 	ptDestList = this->EnumListPtr ((CATEGORYINDEX)nIndex);
	CPtrArray* 	ptSourceList = ptSourceDoc->EnumListPtr ((CATEGORYINDEX)nIndex);

	OldInd = 0;
	for (NewInd=0; NewInd<ptSourceList->GetSize(); NewInd++)
		{						// for every new location  
		if ((ptNewKoord = (LPKOORD)ptSourceList->GetAt(NewInd)) != NULL)
			{					// try to find appr. old entry
			bFound = this->NextDataIndex (ptDestList, &OldInd, (CString)ptNewKoord->szOrt);

			bDelete = ( ptNewKoord->dLat == 0 &&
						ptNewKoord->dLon == 0 &&
						ptNewKoord->lMinAlt == 0);
			if (bFound)
				{				// old data base contains new location
				if (bDelete)
					{
				 //     sprintf (szBuffer, "Del OldOrt[%d]=%s\n", OldInd, NewBlock.Ort);
				 //     WarningBox (MainWindow, (LPSTR)szBuffer);

					ptOldKoord = (LPKOORD)ptDestList->GetAt(OldInd);
					delete ptOldKoord;
					ptDestList->RemoveAt(OldInd);
					bMerged = TRUE;
			//		DeleteBlock (oldData, OldInd);
					}
				else{
					ShowChangeMsg (ptNewKoord);
				 //     sprintf (szBuffer, "Change OldOrt[%d]=%s\n", OldInd, NewBlock.Ort);
				 //     WarningBox (MainWindow, (LPSTR)szBuffer);

					ptOldKoord = (LPKOORD)ptDestList->GetAt(OldInd);
					_fmemcpy (ptOldKoord, ptNewKoord, sizeof (KOORDTYPE));
				//	ptDestList->SetAt(OldInd, ptOldKoord);
					bMerged = TRUE;
				//	ChangeBlock (oldData, OldInd, (LPSTR)&NewBlock);
					}
				}
			else{
				if (!bDelete)
					{
				 //     sprintf (szBuffer, "Add OldOrt[%d]=%s\n", OldInd, NewBlock.Ort);
				 //     WarningBox (MainWindow, (LPSTR)szBuffer);

					ptOldKoord = new KOORDTYPE;
					if (ptOldKoord != NULL)
						{
						_fmemcpy (ptOldKoord, ptNewKoord, sizeof(KOORDTYPE)); 
						ptDestList->InsertAt(OldInd, ptOldKoord);  
						bMerged = TRUE;
						}

				//	if (!AddBlock (oldData, OldInd, (LPSTR)&NewBlock))
				//		return;
					}
				}
			}
		}
    }

return bMerged;
}

/************************************************************************
 *  LocDoc.cpp  		 	G e t A c t R e g i o n N a m e 			*
 ************************************************************************/
CString CLocDoc::GetActRegionName ()
{
CString szRegion;
short nDot;
CString szNameExt = this->GetTitle();

nDot = szNameExt.Find ('.');
if (nDot >= 0)
	 szRegion = szNameExt.Left(nDot);			// for Windows NT only!!!
else szRegion = szNameExt;

return szRegion;
}

/************************************************************************
 *  LocDoc.cpp  		 	G e t A c t P a t h N a m e 				*
 ************************************************************************/
CString CLocDoc::GetActPathName ()
{
CString szPath;
short nSlash;
CString szFullPath = this->GetPathName();

nSlash = szFullPath.ReverseFind ('\\');
if (nSlash >= 0)
	{
	szPath = szFullPath.Left(nSlash + 1);
	}
else{
	szPath = szFullPath + "\\";
	}

return szPath;
}

/************************************************************************
 *  LocDoc.cpp  		 		R e a d F r o m G P S 					*
 ************************************************************************/
BOOL CLocDoc::ReadFromGPS(CWnd* ptWnd)
{  
	BOOL 	bOK = FALSE;
	CString szText, szActRegion;
	szActRegion = this->GetActRegionName ();
	szText.Format(IDF_CONFREADFROMGPS, (LPCTSTR)szActRegion);
	if (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES) 
	{ 
		BOOL	bWrite = FALSE;

		CGpsDoc* ptGpsDoc = ptInit->GetGpsPtr();
		CGpsWptDlg ReadWptDlg(ptWnd, this, ptGpsDoc, bWrite);

		int RetVal = ReadWptDlg.DoModal();
		switch (RetVal)
		{
			case IDOK:
				m_ptQuickFind->Update(this->GetRegionIndex());
				bOK = TRUE;
 				break;
			case IDCANCEL: 
				break;
		}
	}
	return bOK;	
}

/************************************************************************
 *  LocDoc.cpp  		 		 W r i t e T o G P S  					*
 ************************************************************************/
BOOL CLocDoc::WriteToGPS(CWnd* ptWnd)
{  
	BOOL 	bOK = FALSE;
	CString szText, szActRegion;
	szActRegion = this->GetActRegionName ();
	szText.Format(IDF_CONFWRITETOGPS, (LPCTSTR)szActRegion);
	if (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES) 
	{ 
		BOOL	bWrite = TRUE;

		CGpsDoc* ptGpsDoc = ptInit->GetGpsPtr();
		CGpsWptDlg WriteWptDlg(ptWnd, this, ptGpsDoc, bWrite);

		int RetVal = WriteWptDlg.DoModal();
		switch (RetVal)
		{
			case IDOK:
				bOK = TRUE;
 				break;
			case IDCANCEL: 
				break;
		}
	}
	return bOK;	
}

/************************************************************************
 *  LocDoc.cpp  		 		 M e r g e 								*
 ************************************************************************/
BOOL CLocDoc::Merge(CWnd* ptWnd)
{  
BOOL 	bChanged = FALSE;
CString szText, szActRegion;

szActRegion = this->GetActRegionName ();
szText.Format(IDF_CONFMERGE, (LPCTSTR)szActRegion);
if (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES) 
	{ 
							// ask for new file name
	//static char szFilter[] = "DeltaDoc (*.ddc) | *.ddc | Text Files (*.txt) | *.txt | All Files (*.*) | *.* ||"; 
	static char szFilter[] = "Region (*.krd)|*.krd||"; 

	CFileDialog dlg(TRUE, 	  					// File Open dialog
					NULL,						// no default extension
					"*.krd",					// initial filename
					OFN_HIDEREADONLY |	  		// dwFlags
					OFN_OVERWRITEPROMPT,
					szFilter,
					ptWnd);						// parent window

	CString szPath = this->GetActPathName();	// without NameExt
	dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;

	int ret = dlg.DoModal();
	if (ret == IDOK)
		{
		CLocDoc* ptSourceDoc = new CLocDoc;	
		if (ptSourceDoc != NULL)
			{
			CString szNameNew = dlg.GetPathName();  
			if (ptSourceDoc->OnOpenDocument (szNameNew))
				{
				// WaitCursor
				if (this->DoMerge (ptSourceDoc))
					{				 // force saving new data on hard disk
					this->SetModifiedFlag(TRUE);			
					CString szPath = this->GetPathName(); 
					BOOL bConfirm = FALSE;
					if (this->OnSaveDocument (szPath, bConfirm))
						{		// Updates CNameList and CLaLoList
						m_ptQuickFind->Update(this->GetRegionIndex());
						bChanged = TRUE;
						}
					}
				// Normal Cursor
				}
			delete ptSourceDoc;  
			}
		}
    }

return bChanged;	
} 

/************************************************************************
 *  LocDoc.cpp  		 			A d d  								*
 ************************************************************************/
BOOL CLocDoc::Add(CLocation& Loc)
{  
	BOOL bAdded = FALSE;

	short nCategory = Loc.GetCategory();
	CPtrArray* ptDestList = GetSubListPtr (nCategory);
	if (ptDestList != NULL)
	{					// test: is Loc already in ptDestList?
		short OldInd=0;
		BOOL bFound = this->NextDataIndex (ptDestList, &OldInd, Loc.GetName());
		if (!bFound)
		{
			short nNewIndex = this->GetSortedIndex (ptDestList, Loc); 
			ptDestList->InsertAt (nNewIndex, Loc.CreatePtr());	// insert new
			bAdded = TRUE;
		}
	}
	return bAdded;
}

/************************************************************************
 *  LocDoc.cpp  		 			G e t C n t							*
 ************************************************************************/
short CLocDoc::GetCnt()
{
	short nCnt = 0;
	short	  nIndex;

	for (nIndex=0; nIndex<CT_CNT; nIndex++)
	{							// add counters of every category     				
		CPtrArray* 	ptDestList = this->EnumListPtr ((CATEGORYINDEX)nIndex);
		nCnt += (short)ptDestList->GetSize();
	}
	return nCnt;
}

/////////////////////////////////////////////////////////////////////////////
// CLocDoc diagnostics

#ifdef _DEBUG
void CLocDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CLocDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLocDoc commands
