// LocDoc.h : interface of the CLocDoc class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

#include "Location.h"

enum CATEGORYINDEX { CT_AIRPORT,
				CT_VOR,
				CT_NDB,
				CT_REPORT,
				CT_INTERSECTION,
				CT_USER,
				CT_SAIL,
				CT_HELI
				};
#define CT_CNT (CT_HELI - CT_AIRPORT + 1)

class CBorder;
class CImport;
class CLocDoc : public CDocument
{         
private:
	#define MAX_HEADER_SIZE 20
    
    char m_szHeader[MAX_HEADER_SIZE];  
    CPtrArray	m_SubList[CT_CNT];
    
    BOOL			m_bConverted;
	BOOL			m_bAutoConvert;
	BOOL			m_bSorted;  
	BOOL			m_bRename;			// convert "danmark" to "denmark"
 	CString			m_szExt;

    CQuickFind*		m_ptQuickFind;
    CATEGORYINDEX	m_nActCatIndex;
    short			m_nRegionIndex;	// used for CNameList

protected: // create from serialization only
	DECLARE_DYNCREATE(CLocDoc)

// Attributes
public:
// Operations
public:           
	CString GetExt() { return m_szExt; }
	static CATEGORYINDEX CategoryToIndex (short nCategory);
	static short IndexToCategory (CATEGORYINDEX Index);           
	void SetActCatIndex (CATEGORYINDEX CatIndex);
	CATEGORYINDEX GetActCatIndex ();        
	
 	void DeleteArrayOf (CPtrArray* ptArray);
	void CopyLocations (CPtrArray* ptDest, CPtrArray* ptSource);

	short GetPlaceCnt (CATEGORYINDEX CatIndex);
	short GetPlaceCnt (short nCategory);
	LPKOORD GetLocationPtr (short nCatIndex, short nIndex);

	CPtrArray* GetSubListPtr (short nCategory);
	short GetSortedIndex (CPtrArray* ptSubList, CLocation& Location);
	BOOL NextDataIndex (CPtrArray* ptUserList, short* i, CString szSearch);
	short CopyWptsOfCategory(CLocDoc* ptSourceDoc, short nCategory);
	short CopyUserWpts (CLocDoc* lpOldKo);



	void GetDataBase (CPtrArray* ptDlgSubList);
	void SetDataBase (CPtrArray* ptDlgSubList);
	CLocation GetLocation (short nCategory, short nIndex);
    short GetMaxLocNameLen (short nCatIndex, CDC* pDC);
	void GetMapBorder (CBorder* ptBorder, BOOL bUseAPTs);

	BOOL SortAllCategories();
    BOOL WasConverted(){return m_bConverted;}     
    BOOL WasSorted(){return m_bSorted;}     
    void SetAutoConvert(BOOL bSet) { m_bAutoConvert = bSet; }

  	void SetRegionIndex (short nIndex) { m_nRegionIndex = nIndex; } 
 	short GetRegionIndex () { return m_nRegionIndex; }
	
	CString GetActRegionName ();
	CString GetActPathName ();
					  
// Implementation
public:
	CLocDoc();
	virtual ~CLocDoc();  
	virtual BOOL OnNewDocument();  
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName, BOOL bConfirm = TRUE);

	BOOL DoReallySave();

	BOOL DoImport(CImport& LocImport, BOOL* ptAborted);

	BOOL Change(CWnd* ptWnd, CLocation* ptLoc=NULL, BOOL bShowLoc = FALSE);
	BOOL Import(CWnd* ptWnd);
	BOOL Update(CWnd* ptWnd);

	BOOL ReadFromGPS(CWnd* ptWnd);
	BOOL WriteToGPS(CWnd* ptWnd);
	BOOL Merge(CWnd* ptWnd);
	BOOL Add(CLocation& Loc);
	short GetCnt();


	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:    
	BOOL SortLocationName (CPtrArray* ptLocations);   
	BOOL DoMerge(CLocDoc* ptNewKoords);

	short HeaderToVers (char* ptHeader);
	void VersToHeader (LPSTR lpHeader, short nVersion);
	short GetEntryCnt (CArchive& ar, short nVersion);
   	short NameToCountryCode (LPCTSTR szName);

 	CPtrArray* EnumListPtr (CATEGORYINDEX nIndex);
	LPKOORD GetNextLocFromCatList(int* ptMaxCnt, int* ptCnt, CATEGORYINDEX* ptCI);
	
// Generated message map functions
protected:
	//{{AFX_MSG(CLocDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
