// MaKoDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"    

#include "LocDoc.h"
#include "WayPoint.h"
#include "MaKoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;  

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CManuKoordDlg 


CManuKoordDlg::CManuKoordDlg(CWnd* pParent, CWayPoint* ptWpt)
	: CDlgTool(CManuKoordDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CManuKoordDlg)
	m_nCatIndex = -1;
	m_szCountryCode = "";
	m_szName = "";
	m_szIndicator = "";
	m_dLat = 0.;
	m_dLon = 0.;
	m_lElevation = 0;
	m_dVAR = 0;
	m_fFreq = (float)0.;
	m_bGras = FALSE;
	m_lRange = 0;
	m_nRwyLen = 0;
	m_nTopography = -1;
	m_lElevDiff = 0;
	m_nDiffDim = -1;
	m_nElevDim = -1;
	m_nLenDim = -1;
	m_nRangeDim = -1;
	m_nRwyDir = -1;
	//}}AFX_DATA_INIT

m_ptWpt = ptWpt;
}

/************************************************************************
 *  MaKoDlg.cpp	  		 	F i l l C a t P U 							*
 ************************************************************************/
void CManuKoordDlg::FillCatPU ()
{      
CComboBox* ptCategory = (CComboBox*)GetDlgItem (IDC_MKCATEGORY);

CString szText;
short i;
for (i=0; i<CT_CNT; i++)
	{
	szText.LoadString (ID_CA_AIRPORT + i);  
	ptCategory->AddString((LPCTSTR)szText);  
	}
} 

/************************************************************************
 *  MaKoDlg.cpp	  		 	F i l l M i n A l t P U 					*
 ************************************************************************/
void CManuKoordDlg::FillMinAltPU ()
{
CComboBox* ptTopography = (CComboBox*)GetDlgItem (IDC_MKTOPO);
CString szText;
short i;
for (i=0; i<3; i++)
	{
	szText.LoadString (ID_TO_COUNTRY + i);  
	ptTopography->AddString((LPCTSTR)szText);  
	}
}

/************************************************************************
 *  MaKoDlg.cpp	  			 	F i l l R w y D i r P U					*
 ************************************************************************/
void CManuKoordDlg::FillRwyDirPU ()
{      
CComboBox* ptRwyDir = (CComboBox*)GetDlgItem (IDC_MKRWYDIR);

CString szText;
short i;
for (i=0; i<19; i++)
	{
	szText.LoadString (ID_RD_01 + i);  
	ptRwyDir->AddString((LPCTSTR)szText);  
	}
}                                                                           

/************************************************************************
 *  MaKoDlg.cpp	  		 D o D a t a E x c h a n g e 				*
 ************************************************************************/
void CManuKoordDlg::DoDataExchange(CDataExchange* pDX)
{
this->ActivateDimGroups();

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CManuKoordDlg)
	DDX_CBIndex(pDX, IDC_MKCATEGORY, m_nCatIndex);
	DDX_Text(pDX, IDC_MKCC, m_szCountryCode);
	DDV_MaxChars(pDX, m_szCountryCode, 2);
	DDX_Text(pDX, IDC_MKNAME, m_szName);
	DDV_MaxChars(pDX, m_szName, 17);
	DDX_Text(pDX, IDC_MKINDICATOR, m_szIndicator);
	DDV_MaxChars(pDX, m_szIndicator, 5);
	DDX_Latitude(pDX, IDC_MKLAT, m_dLat);
	DDV_Angle(pDX, m_dLat, -90., 90.);
	DDX_Longitude(pDX, IDC_MKLON, m_dLon);
	DDV_Angle(pDX, m_dLon, -180., 180.);
	DDX_Alt(pDX, IDC_MKELEV, m_lElevation);
	DDV_AltOptional(pDX, m_lElevation, -5000, 15000);
	DDX_Variation(pDX, IDC_MKVAR, m_dVAR);
	DDV_Angle(pDX, m_dVAR, -180., 180.);
	DDX_Freq(pDX, IDC_MKFRQ, m_fFreq);
	DDV_FreqOptional(pDX, m_fFreq, 108.f, 1750.f);
	DDX_Check(pDX, IDC_MKGRAS, m_bGras);
	DDX_Dist(pDX, IDC_MKRANGE, m_lRange);
	DDV_DistOptional(pDX, m_lRange, 0, 255);
	DDX_RwyOpt(pDX, IDC_MKRWYLEN, m_nRwyLen);
	DDV_RwyOpt(pDX, m_nRwyLen, 100, 5000);
	DDX_CBIndex(pDX, IDC_MKTOPO, m_nTopography);
	DDX_Alt(pDX, IDC_MKELEVDIFF, m_lElevDiff);
	DDV_AltOptional(pDX, m_lElevDiff, -250, 250);
	DDX_CBIndex(pDX, IDC_MKDIFFDIM, m_nDiffDim);
	DDX_CBIndex(pDX, IDC_MKELEVDIM, m_nElevDim);
	DDX_CBIndex(pDX, IDC_MKLENDIM, m_nLenDim);
	DDX_CBIndex(pDX, IDC_MKRANGEDIM, m_nRangeDim);
	DDX_CBIndex(pDX, IDC_MKRWYDIR, m_nRwyDir);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CManuKoordDlg, CDlgTool)
	//{{AFX_MSG_MAP(CManuKoordDlg)
	ON_CBN_SELCHANGE(IDC_MKCATEGORY, OnSelchangeCategory)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CManuKoordDlg 


/************************************************************************
 *  MaKoDlg.cpp	  		 		S e t D a t a  							*
 ************************************************************************/
void CManuKoordDlg::SetData (CWayPoint* ptWpt)
{  
m_nElevDim = ptDim->GetPUIndex (ALTITUDE, ((CLocation*)ptWpt)->GetElevDim());
m_nRangeDim = ptDim->GetPUIndex (DISTANCE, ptWpt->GetDistDim());
m_nLenDim = ptDim->GetPUIndex (RWYLENGTH, ptWpt->GetLenDim());
m_nDiffDim = ptDim->GetPUIndex (ALTITUDE, ptWpt->GetDiffDim());    

m_nCatIndex = CLocDoc::CategoryToIndex(ptWpt->GetCategory());	        

m_szName 		= ptWpt->GetName();
m_szIndicator	= ptWpt->GetIndicator(); 
m_szCountryCode = ptWpt->GetCountryCode();

m_dLat			= ptWpt->GetLat();
m_dLon			= ptWpt->GetLon();

m_dVAR			= (double)ptWpt->GetVariation();   
m_bGras 		= ptWpt->IsGras();

if (ptWpt->IsAirport ())
	{
	switch (ptWpt->GetRwyDir())
		{
		case  1:	m_nRwyDir = 0;	break;	 //Rwy 01/19 => 1. PU entry: Index=0
		case  2:	m_nRwyDir = 1;	break;
		case  3:	m_nRwyDir = 2;	break;
		case  4:	m_nRwyDir = 3;	break;
		case  5:	m_nRwyDir = 4;	break;
		case  6:	m_nRwyDir = 5;	break;
		case  7:	m_nRwyDir = 6;	break;
		case  8:	m_nRwyDir = 7;	break;
		case  9:	m_nRwyDir = 8;	break;
		case 10:	m_nRwyDir = 9;	break;
		case 11:	m_nRwyDir =10;	break;
		case 12:	m_nRwyDir =11;	break;
		case 13:	m_nRwyDir =12;	break;
		case 14:	m_nRwyDir =13;	break;
		case 15:	m_nRwyDir =14;	break;
		case 16:	m_nRwyDir =15;	break;
		case 17:	m_nRwyDir =16;	break;
		case  0:	m_nRwyDir =17;	break;
		default:	m_nRwyDir = NO_RWYDIR; break;
		}

  	m_lRange = NO_LONG;					// reset range
	HideControl (IDC_MKRANGE_TXT, TRUE);
	HideControl (IDC_MKRANGE, TRUE);
	HideControl (IDC_MKRANGEDIM, TRUE);

	HideControl (IDC_MKRWYDIR_TXT, FALSE);
	HideControl (IDC_MKRWYDIR, FALSE);
	}
else{
	ptWpt->GetRange(&m_lRange);
 
 	m_nRwyDir = NO_RWYDIR;		// reset runway direction
	HideControl (IDC_MKRWYDIR_TXT, TRUE);
	HideControl (IDC_MKRWYDIR, TRUE);

	HideControl (IDC_MKRANGE_TXT, FALSE);
	HideControl (IDC_MKRANGE, FALSE);
	HideControl (IDC_MKRANGEDIM, FALSE);
	}

switch (ptWpt->GetTopography())
	{
	case Country:	m_nTopography = 0;	break;
	case City:		m_nTopography = 1;	break;
	case bigCity:	m_nTopography = 2;	break;
	}
	
ptWpt->GetAltitude(&m_lElevation); 
ptWpt->GetFrequency(&m_fFreq); 
ptWpt->GetRwyLen(&m_nRwyLen); 
ptWpt->GetElevDiff(&m_lElevDiff);   
}	

/************************************************************************
 *  MaKoDlg.cpp	  		 		G e t D a t a  							*
 ************************************************************************/
void CManuKoordDlg::GetData (CWayPoint* ptWpt)
{                                         
((CLocation*)ptWpt)->SetElevDim(ptDim->GetPUDim (ALTITUDE, m_nElevDim));
ptWpt->SetDistDim(ptDim->GetPUDim (DISTANCE, m_nRangeDim));
ptWpt->SetLenDim(ptDim->GetPUDim (RWYLENGTH, m_nLenDim));
ptWpt->SetDiffDim(ptDim->GetPUDim (ALTITUDE, m_nDiffDim));    
	                  
ptWpt->SetCategory(CLocDoc::IndexToCategory((CATEGORYINDEX)m_nCatIndex));		
	
ptWpt->SetName(m_szName);
ptWpt->SetIndicator(m_szIndicator); 
ptWpt->SetCountryCode(m_szCountryCode); 
	
ptWpt->SetLat(m_dLat);
ptWpt->SetLon(m_dLon);  
ptWpt->SetVariation((short)m_dVAR);   
ptWpt->SetGras(m_bGras);

short nTopo;
switch (m_nTopography)
	{
	case 0: nTopo = Country;	break;
	case 1: nTopo = City;		break;
	case 2: nTopo = bigCity;	break;
	}
ptWpt->SetTopography(nTopo);

ptWpt->SetAltitude(m_lElevation); 
ptWpt->SetFrequency(m_fFreq); 
ptWpt->SetRwyLen(m_nRwyLen); 
ptWpt->SetElevDiff(m_lElevDiff); 


if (ptWpt->IsAirport ())
	{
	short nRwyDir;				// 10*degrees
	switch (m_nRwyDir)
		{	 
		case  0:	nRwyDir = 1;	break;		// 1. PU entry: Index=1 => Rwy 01/19 
		case  1:	nRwyDir = 2;	break;	 
		case  2:	nRwyDir = 3;	break;
		case  3:	nRwyDir = 4;	break;
		case  4:	nRwyDir = 5;	break;
		case  5:	nRwyDir = 6;	break;
		case  6:	nRwyDir = 7;	break;
		case  7:	nRwyDir = 8;	break;
		case  8:	nRwyDir = 9;	break;
		case  9:	nRwyDir =10;	break;
		case 10:	nRwyDir =11;	break;
		case 11:	nRwyDir =12;	break;
		case 12:	nRwyDir =13;	break;
		case 13:	nRwyDir =14;	break;
		case 14:	nRwyDir =15;	break;
		case 15:	nRwyDir =16;	break;
		case 16:	nRwyDir =17;	break;
		case 17:	nRwyDir = 0;	break;
		case NO_RWYDIR:
		default:	nRwyDir = NO_RWYDIR; break;
		}
	ptWpt->SetRwyDir(nRwyDir);
	}
else{
	ptWpt->SetRange(m_lRange);
	}
}	

/************************************************************************
 *  MaKoDlg.cpp	  			 O n I n i t D i a l o g	 				*
 ************************************************************************/
BOOL CManuKoordDlg::OnInitDialog()
{             
this->FillCatPU ();
this->FillMinAltPU ();
this->FillRwyDirPU ();

this->AddDimGroup (IDC_MKELEV, IDC_MKELEVDIM);
this->AddDimGroup (IDC_MKRANGE, IDC_MKRANGEDIM);
this->AddDimGroup (IDC_MKRWYLEN, IDC_MKLENDIM);
this->AddDimGroup (IDC_MKELEVDIFF, IDC_MKDIFFDIM);
      
this->FillDimPU (IDC_MKELEVDIM, ALTITUDE);
this->FillDimPU (IDC_MKRANGEDIM, DISTANCE);
this->FillDimPU (IDC_MKLENDIM, RWYLENGTH);
this->FillDimPU (IDC_MKDIFFDIM, ALTITUDE);    

this->SetData (m_ptWpt);
// TODO: Add extra initialization here   
	CDlgTool::OnInitDialog();
	
return TRUE;  // return TRUE  unless you set the focus to a control
}


void CManuKoordDlg::OnOK() 
{
	// TODO: Zustzliche Prfung hier einfgen
if (this->UpdateData(TRUE))
	{
	this->GetData(m_ptWpt);
	CDlgTool::OnOK();
	}
}

void CManuKoordDlg::OnSelchangeCategory() 
{
	// TODO: Add your control notification handler code here
CWayPoint TempWpt;

if (this->UpdateData(TRUE))
	{
	this->GetData(&TempWpt);
	if (TempWpt.IsAirport ())
		{
		HideControl (IDC_MKRANGE_TXT, TRUE);
		HideControl (IDC_MKRANGE, TRUE);
		HideControl (IDC_MKRANGEDIM, TRUE);

		HideControl (IDC_MKRWYDIR_TXT, FALSE);
		HideControl (IDC_MKRWYDIR, FALSE);
		}
	else{
		HideControl (IDC_MKRWYDIR_TXT, TRUE);
		HideControl (IDC_MKRWYDIR, TRUE);

		HideControl (IDC_MKRANGE_TXT, FALSE);
		HideControl (IDC_MKRANGE, FALSE);
		HideControl (IDC_MKRANGEDIM, FALSE);
		}
	this->UpdateData(FALSE);
	}
}


/************************************************************************
 *  MaKoDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CManuKoordDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
