// MainFrm.cpp : implementation of the CMainFrame class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "Pf.h"
#include "InitDoc.h"    

#include "TrackDoc.h"
#include "MetDoc.h"
#include "WayDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"
#include "ElevDoc.h"
#include "ElevArrayDoc.h"
#include "Calc.h"			// this statement must be after PlaneDoc.h

#include "CourseVw.h"
#include "RteView.h"
#include "ElevView.h"
#include "FuelView.h"
#include "FlPlView.h"
#include "WayView.h"
#include "PlaneVw.h"
#include "TrackVw.h"
#include "AltVw.h"
#include "SpeedVw.h"
#include "ScMpView.h"
#include "AuKoDlg.h"    
#include "DCalcDlg.h"
#include "MovingMp.h"

#include "AirspaceDoc.h"
#include "AirspaceDlg.h"
#include "..\CppTools\DirBrDlg.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;
extern CFontDoc* 		ptFontTool;
extern CDimDoc* 		ptDim;
extern CLoadDoc*		ptLoad; 
extern CCalcDoc*		ptCalc;
extern CAppendixDoc*	ptAppend;  

extern CMetDoc*			ptMet;
extern CLocDoc*			ptLocDoc;
extern CElevDoc*		ptElevDoc;
extern CPlaneDoc*		ptPlaneDoc;
extern CTrackDoc*		ptTrackDoc;
extern CFlightPlanDoc*	ptFlPlDoc;
extern CScanMapDoc*		ptScMpDoc;

extern BOOL bDemo;

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

#define PLANE_MENU	4
#define MOVE_TIMER 4

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_MISC_CALC, OnMiscCalculator)
	ON_COMMAND(ID_PLANE_LOAD, OnInpLoad)
	ON_COMMAND(ID_CALC_PREF, OnCalcPref)
	ON_COMMAND(ID_MISC_APPENDIX, OnInpAppendix)
	ON_COMMAND(ID_MISC_FLPL, OnMiscFlpl)
	ON_COMMAND(ID_MISC_MAPS, OnMiscMaps)
	ON_COMMAND(ID_MISC_GPS, OnMiscGps)
	ON_COMMAND(ID_LOC_EDIT, OnLocEdit)	
	ON_COMMAND(ID_LOC_REGIONS, OnLocRegions)
	ON_COMMAND(ID_LOC_UPDATE, OnLocUpdate)	
	ON_COMMAND(ID_LOC_READFROMGPS, OnLocReadFromGPS)	
	ON_COMMAND(ID_LOC_WRITETOGPS, OnLocWriteToGPS)	
	ON_COMMAND(ID_LOC_MERGE, OnLocMerge)	
	ON_COMMAND(ID_LOC_ELEV, OnLocElev)	
	ON_COMMAND(ID_LOC_ELEVARRAY, OnLocElevArray)	
	ON_COMMAND(ID_LOC_AIRSPACE, OnLocAirspace)	
	ON_COMMAND(ID_MISC_MET, OnInpMet)
	ON_COMMAND(ID_PLANE_EDIT, OnInpPlane)
	ON_COMMAND(ID_RTE_EDIT, OnInpRoute)
	ON_COMMAND(ID_RTE_TOGPS, OnRteToGPS)
	ON_COMMAND(ID_RTE_FROMGPS, OnRteFromGPS)

	ON_COMMAND(ID_TRK_NEW, OnRteTrackNew)
	ON_COMMAND(ID_TRK_OPEN, OnRteTrackOpen)
	ON_COMMAND(ID_TRK_SAVE_AS, OnRteTrackSaveAs)
	ON_COMMAND(ID_TRK_SAVE_AS_KML, OnRteTrackSaveAsKML)
	ON_COMMAND(ID_TRK_MOVINGMAP, OnRteTrackMovingMap)
	ON_COMMAND(ID_TRK_DLG, OnRteTrackRoute)
	ON_COMMAND(ID_TRK_MMPREF, OnRteTrackMvMapPref)

	ON_UPDATE_COMMAND_UI(ID_TRK_NEW, OnUpdateRteTrackNew)
	ON_UPDATE_COMMAND_UI(ID_TRK_OPEN, OnUpdateRteTrackOpen)
	ON_UPDATE_COMMAND_UI(ID_TRK_SAVE_AS, OnUpdateRteTrackSaveAs)
	ON_UPDATE_COMMAND_UI(ID_TRK_SAVE_AS_KML, OnUpdateRteTrackSaveAsKML)
	ON_UPDATE_COMMAND_UI(ID_TRK_MOVINGMAP, OnUpdateRteTrackMovingMap)
	ON_UPDATE_COMMAND_UI(ID_TRK_DLG, OnUpdateRteTrackRoute)
	ON_UPDATE_COMMAND_UI(ID_TRK_MMPREF, OnUpdateRteTrackMvMapPref)

	ON_COMMAND(ID_RTE_GPSTRACK, OnTrackFromGPS)
	ON_COMMAND(ID_RTE_GCAS, OnRteToGCAS)	
	ON_COMMAND(ID_RTE_KML, OnRteToKML)	
	ON_COMMAND(ID_VIEW_COURSE, OnViewCourse)
	ON_COMMAND(ID_VIEW_LAST, OnViewLast)
	ON_COMMAND(ID_VIEW_MAP, OnViewMap)
	ON_COMMAND(ID_VIEW_MAPSCAN, OnViewMapScan)
	ON_COMMAND(ID_VIEW_ELEV, OnViewElev)
	ON_COMMAND(ID_VIEW_FUEL, OnViewFuel)
	ON_COMMAND(ID_VIEW_FLIGHTPLAN, OnViewFlightPlan)
	ON_COMMAND(ID_VIEW_WAY, OnViewWay)
	ON_COMMAND(ID_VIEW_PLANE, OnViewPlane)
	ON_COMMAND(ID_VIEW_LOCLIST, OnViewLocList)
	ON_COMMAND(ID_VIEW_TRACK, OnViewTrack)
	ON_COMMAND(ID_VIEW_TRACKSCAN, OnViewTrackScan)
	ON_COMMAND(ID_VIEW_TRACKALT, OnViewTrackAlt)
	ON_COMMAND(ID_VIEW_TRACKSPD, OnViewTrackSpd)
	ON_COMMAND(ID_VIEW_FONTS, OnMiscFonts)
	ON_COMMAND(ID_VIEW_DIM, OnMiscDim)
	ON_COMMAND(ID_VIEW_COLORS, OnViewColors)
	ON_COMMAND(ID_VIEW_TB_VIEW, OnViewSelViewToolBar)
	ON_COMMAND(ID_VIEW_TB_GPS, OnViewGpsTransToolBar)
	ON_COMMAND(ID_VIEW_TB_MAP, OnViewMapSymbolToolBar)
	ON_COMMAND(ID_VIEW_TB_WAYPT, OnViewWayptToolBar)
	ON_COMMAND(ID_VIEW_TB_DRAWMAP, OnViewDrawMapToolBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_COURSE, OnUpdateViewCourse)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ELEV, OnUpdateViewElev)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FUEL, OnUpdateViewFuel)
	ON_UPDATE_COMMAND_UI(ID_VIEW_MAP, OnUpdateViewMap)
	ON_UPDATE_COMMAND_UI(ID_VIEW_MAPSCAN, OnUpdateViewMapScan)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FLIGHTPLAN, OnUpdateViewFlightPlan)
	ON_UPDATE_COMMAND_UI(ID_VIEW_WAY, OnUpdateViewWay)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PLANE, OnUpdateViewPlane)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TRACK, OnUpdateViewTrack)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TRACKSCAN, OnUpdateViewTrackScan)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TRACKALT, OnUpdateViewTrackAlt)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TRACKSPD, OnUpdateViewTrackSpd)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TB_VIEW, OnUpdateViewSelViewToolBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TB_GPS, OnUpdateViewGpsTransToolBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TB_MAP, OnUpdateViewMapSymbolToolBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TB_WAYPT, OnUpdateViewWayptToolBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TB_DRAWMAP, OnUpdateViewDrawMapToolBar)
	ON_COMMAND(ID_CALC_WAY, OnCalcWay)
	ON_UPDATE_COMMAND_UI(ID_CALC_WAY, OnUpdateCalcWay)
	ON_COMMAND(ID_CALC_ORTHO, OnCalcOrtho)
	ON_UPDATE_COMMAND_UI(ID_CALC_ORTHO, OnUpdateCalcOrtho)
	ON_COMMAND(ID_CALC_SEMI, OnCalcSemi)
	ON_UPDATE_COMMAND_UI(ID_CALC_SEMI, OnUpdateCalcSemi)
	ON_COMMAND(ID_CALC_ELEV, OnCalcElev)
	ON_UPDATE_COMMAND_UI(ID_CALC_ELEV, OnUpdateCalcElev)
	ON_COMMAND(ID_CALC_UPDOWN, OnCalcUpdown)
	ON_UPDATE_COMMAND_UI(ID_CALC_UPDOWN, OnUpdateCalcUpdown)
	ON_COMMAND(ID_CALC_REVERSE, OnCalcReverse)
	ON_UPDATE_COMMAND_UI(ID_CALC_REVERSE, OnUpdateCalcReverse)
	ON_COMMAND(ID_LOC_HOME, OnLocHome)
	ON_UPDATE_COMMAND_UI(ID_RTE_FROMGPS, OnUpdateRteFromGps)
	ON_UPDATE_COMMAND_UI(ID_RTE_TOGPS, OnUpdateRteToGps)
	ON_UPDATE_COMMAND_UI(ID_RTE_GPSTRACK, OnUpdateTrackFromGPS)
	ON_UPDATE_COMMAND_UI(ID_RTE_GCAS, OnUpdateRteToGCAS)
	ON_UPDATE_COMMAND_UI(ID_RTE_KML, OnUpdateRteToKML)
	ON_WM_CLOSE()
	ON_COMMAND(ID_TB_DRAWMAP, OnToolbarDrawMap)
	ON_UPDATE_COMMAND_UI(ID_TB_DRAWMAP, OnUpdateTbDrawMap)
	ON_COMMAND(ID_TB_SCANMAP, OnToolbarScanMap)
	ON_UPDATE_COMMAND_UI(ID_TB_SCANMAP, OnUpdateTbScanMap)
	ON_COMMAND(ID_TB_WPT_PREV, OnToolbarSelectPrev)
	ON_UPDATE_COMMAND_UI(ID_TB_WPT_PREV, OnUpdateTbSelectPrev)
	ON_COMMAND(ID_TB_WPT_NEXT, OnToolbarSelectNext)
	ON_UPDATE_COMMAND_UI(ID_TB_WPT_NEXT, OnUpdateTbSelectNext)
	ON_COMMAND(ID_TB_BEEP, OnBeep)
	ON_UPDATE_COMMAND_UI(ID_TB_BEEP, OnUpdateBeep)
	ON_WM_TIMER()
	ON_COMMAND(ID_LOC_IMPORT, OnLocImport)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_UPDATE_COMMAND_UI(ID_STATUS_LATLON, OnUpdateStatusLatLon)
	ON_UPDATE_COMMAND_UI(ID_STATUS_ELEV, OnUpdateStatusElev)
	ON_UPDATE_COMMAND_UI(ID_STATUS_SPEED, OnUpdateStatusSpeed)
	ON_COMMAND_RANGE(ID_PLANE_FIRST, ID_PLANE_LAST, OnSelectPlane)

	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
//	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_STATUS_LATLON,
	ID_STATUS_ELEV,
	ID_STATUS_SPEED,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};


/////////////////////////////////////////////////////////////////////////////
// Helpers for saving/restoring window state

static TCHAR BASED_CODE szSection[] = _T("Settings");
static TCHAR BASED_CODE szWindowPos[] = _T("WindowPos");
static TCHAR szFormat[] = _T("%u,%u,%d,%d,%d,%d,%d,%d,%d,%d");

static BOOL PASCAL NEAR ReadWindowPlacement(LPWINDOWPLACEMENT pwp)
{
	CString strBuffer = AfxGetApp()->GetProfileString(szSection, szWindowPos);
	if (strBuffer.IsEmpty())
		return FALSE;

	WINDOWPLACEMENT wp;
	int nRead = _stscanf(strBuffer, szFormat,
		&wp.flags, &wp.showCmd,
		&wp.ptMinPosition.x, &wp.ptMinPosition.y,
		&wp.ptMaxPosition.x, &wp.ptMaxPosition.y,
		&wp.rcNormalPosition.left, &wp.rcNormalPosition.top,
		&wp.rcNormalPosition.right, &wp.rcNormalPosition.bottom);

	if (nRead != 10)
		return FALSE;

	wp.length = sizeof wp;
	*pwp = wp;
	return TRUE;
}

static void PASCAL NEAR WriteWindowPlacement(LPWINDOWPLACEMENT pwp)
	// write a window placement to settings section of app's ini file
{
	TCHAR szBuffer[sizeof("-32767")*8 + sizeof("65535")*2];

	wsprintf(szBuffer, szFormat,
		pwp->flags, pwp->showCmd,
		pwp->ptMinPosition.x, pwp->ptMinPosition.y,
		pwp->ptMaxPosition.x, pwp->ptMaxPosition.y,
		pwp->rcNormalPosition.left, pwp->rcNormalPosition.top,
		pwp->rcNormalPosition.right, pwp->rcNormalPosition.bottom);
	AfxGetApp()->WriteProfileString(szSection, szWindowPos, szBuffer);
}



/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	m_nView = D_COURSE;	
	m_ptMapDoc = ptInit->GetMapDocPtr();
	m_bEnableNextCmd = FALSE;
}

CMainFrame::~CMainFrame()
{
}


/************************************************************************
 *  MainFrm.cpp			D o c k C o n t r o l B a r R i g h t O f		*
 ************************************************************************/
void CMainFrame::DockControlBarRightOf(CToolBar* RightOf, CToolBar* Bar)
{
	CRect rect;
	DWORD dw;
	UINT n;

	// get MFC to adjust the dimensions of all docked ToolBars
	// so that GetWindowRect will be accurate
	RecalcLayout();
	RightOf->GetWindowRect(&rect);
	rect.OffsetRect(rect.Width(),0);
	dw=RightOf->GetBarStyle();
	n = 0;
	n = (dw&CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n = (dw&CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dw&CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n = (dw&CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;

	// When we take the default parameters on rect, DockControlBar will dock
	// each Toolbar on a seperate line.  By calculating a rectangle, we in effect
	// are simulating a Toolbar being dragged to that location and docked.
	DockControlBar(Bar,n,&rect);
}


/************************************************************************
 *  MainFrm.cpp				A d d T o o l b a r	 						*
 ************************************************************************/
BOOL CMainFrame::AddToolbar(CToolBar* ptBar, UINT uRsrcID, UINT uStrID, UINT uWndID)
{
	if (!ptBar->Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP, uWndID) ||
		!ptBar->LoadToolBar(uRsrcID))
	{
		TRACE0("Failed to create toolbar\n");
		return FALSE;      // fail to create
	}

	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
	ptBar->SetBarStyle(ptBar->GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	CString szText;
	szText.LoadString (uStrID);
 	ptBar->SetWindowText((LPCTSTR)szText);   // title of undocked toolbar
	ptBar->EnableDocking(CBRS_ALIGN_ANY);

return TRUE;
}
							

/************************************************************************
 *  MainFrm.cpp				O n C r e a t e		 						*
 ************************************************************************/
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
	return -1;

WINDOWPLACEMENT wp;
if (ReadWindowPlacement(&wp))
	SetWindowPlacement(&wp);



if (!m_wndStatusBar.Create(this) ||
	!m_wndStatusBar.SetIndicators(indicators,
	  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}
else{					
	UINT nID, nStyle;	// change width of ID_STATUS_LATLON status bar field
	int cxWidth;		// nIndex = 1
	m_wndStatusBar.GetPaneInfo(1, nID, nStyle, cxWidth);
	int nLatLonWidth = (int)(2.5*cxWidth);

	m_wndStatusBar.SetPaneInfo(1, ID_STATUS_LATLON, nStyle, nLatLonWidth);
	m_wndStatusBar.SetPaneInfo(2, ID_STATUS_ELEV, nStyle, nLatLonWidth);
	m_wndStatusBar.SetPaneInfo(3, ID_STATUS_SPEED, nStyle, nLatLonWidth/2);
	}

		
	if (!AddToolbar(&m_wndTBFile, IDR_WAYFRAME, IDS_TB_FILE, AFX_IDW_TOOLBAR))
		return -1;
  
	if (!AddToolbar(&m_wndTBSelView, IDR_SELVIEW, IDS_TB_SELVIEW, IDW_SELVIEW))
		return -1;
	if (!AddToolbar(&m_wndTBGpsTrans, IDR_GPSTRANS, IDS_TB_GPSTRANS, IDW_GPSTRANS))
		return -1;
	if (!AddToolbar(&m_wndTBMapSymbol, IDR_MAPSYMBOL, IDS_TB_MAPSYMBOL, IDW_MAPSYMBOL))
		return -1;
	if (!AddToolbar(&m_wndTBWaypt, IDR_WAYPOINT, IDS_TB_WAYPOINT, IDW_WAYPOINT))
		return -1;
	if (!AddToolbar(&m_wndTBDrawMap, IDR_DRAWMAP, IDS_TB_DRAWMAP, IDW_DRAWMAP))
		return -1;

 	EnableDocking(CBRS_ALIGN_ANY);		// prepare mainframe for docking

	DockControlBar(&m_wndTBFile, AFX_IDW_DOCKBAR_TOP);
	
	DockControlBarRightOf(&m_wndTBFile, &m_wndTBSelView);
	DockControlBarRightOf(&m_wndTBSelView, &m_wndTBGpsTrans);
//	DockControlBarRightOf(&m_wndTBGpsTrans, &m_wndTBMapSymbol);
			// begin new toolbar row with MapSymbols
	DockControlBar(&m_wndTBMapSymbol, AFX_IDW_DOCKBAR_TOP);
	DockControlBarRightOf(&m_wndTBMapSymbol, &m_wndTBWaypt);
	DockControlBarRightOf(&m_wndTBWaypt, &m_wndTBDrawMap);

	this->LoadBarState(_T("PFWnd"));

    ptPlaneDoc->NewPlaneMenu (this, PLANE_MENU);
return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG


/************************************************************************
 *  MainFrm.cpp			S w i t c h T o V i e w 						*
 ************************************************************************/
void CMainFrame::SwitchToView(eView nView)
{
							// otherwise we have a new frame !
CView* ptNewView = NULL;
CPfApp* ptApp = (CPfApp*)AfxGetApp();

m_nOldView = m_nView;

				  // to remove lat lon values from status bar
m_ptMapDoc->SetLatLon (NO_KOORD, NO_KOORD);

if ((m_nOldView == D_SCANTRACK || m_nOldView == D_TRACK) && 
	(nView != D_SCANTRACK && nView != D_TRACK))
{
	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
		ptMovingMap->SetSymbolsOnView(FALSE);
}

if (nView == D_MAP || nView == D_TRACK)
{				// if show elevations is activated:
	((CScanMapView*)(ptApp->m_pScanMapView))->FreeMemory();	// delete memory occupied from D_SCANMAP 
											// or D_SCANTRACK (uses same view)
}

m_ptMapDoc->SetRouteInScanMap (TRUE);
switch(nView)
	{
	case D_COURSE:
		ptNewView = ptApp->m_pCourseView;
		break;    
	case D_MAP:
		ptNewView = ptApp->m_pMapView;
		break;    
	case D_SCANMAP:
		ptNewView = ptApp->m_pScanMapView;
		break;    
	case D_ELEV:
		ptNewView = ptApp->m_pElevView;
		break;    
	case D_FUEL:
		ptNewView = ptApp->m_pFuelView;
		break;    
	case D_FLIGHTPLAN:
		ptNewView = ptApp->m_pFlPlView;
		break;    
	case D_WAY:
		ptNewView = ptApp->m_pWayView;
		break;    
	case D_PLANE:
		ptNewView = ptApp->m_pPlaneView;
		break;    
 	case D_LOCLIST:
		ptNewView = ptApp->m_pLocView;
		break;    
		
	case D_TRACK:
		ptNewView = ptApp->m_pTrackView; 
		break;    
	case D_SCANTRACK:
        ptNewView = ptApp->m_pScanMapView;
		m_ptMapDoc->SetRouteInScanMap (FALSE);
        break;    
	case D_TRACKALT:
		ptNewView = ptApp->m_pAltView;   
		break;    
	case D_TRACKSPD:
		ptNewView = ptApp->m_pSpeedView; 
		break;   
		
	}

if (m_nOldView < D_TRACK && nView >= D_TRACK)
	{			// switching from route to track
	CString szTitle;
	szTitle = CTextViewTool::Format (IDF_MAINFRM_TITLE, (LPCTSTR)ptTrackDoc->GetTitle());
	this->SetWindowText(szTitle);
	}

if (m_nOldView >= D_TRACK && nView < D_TRACK)
	{			// switching from track to route
	CString szTitle;
	CWayDoc* ptWayDoc = (CWayDoc*)ptNewView->GetDocument();
	szTitle = CTextViewTool::Format (IDF_MAINFRM_TITLE, (LPCTSTR)ptWayDoc->GetTitle());
	this->SetWindowText(szTitle);


	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
		ptMovingMap->SetJustFinished(FALSE);
	}

if (bDemo && (nView < D_TRACK))
	{					// switch to route view, check for legal area
	CWayDoc* ptWayDoc = (CWayDoc*)ptNewView->GetDocument();
	if (ptWayDoc!=NULL)
		ptWayDoc->InLegalArea();
	}



m_nView = nView;

			// sets WM_COMMAND id used in CMapView::OnShowScannedMap
			// to show correct data on scanned map
m_ptMapDoc->SetCmdID ((m_nView == D_TRACK)? ID_VIEW_TRACKSCAN : ID_VIEW_MAPSCAN);			
ptScMpDoc->SetCmdID((m_nView == D_TRACK)? ID_VIEW_TRACKSCAN : ID_VIEW_MAPSCAN);	

if ((m_nView != D_SCANMAP) && (m_nView != D_SCANTRACK) && (m_nView != D_MAP) && (m_nView != D_TRACK))
{				// no map in view: reset elevation string
	CElevArrayDoc* ptElevArrayDoc = ptInit->GetElevArrayDocPtr();
	if (ptElevArrayDoc != NULL)
	{				
		ptElevArrayDoc->ResetStatusElev();
	}
}

CView* ptOldView = ptApp->SwitchView(ptNewView);
/*
  Note: This function returns a pointer to the old view so that the old
   view can be destroyed if desired. Before destroying the view though,
   CDocument::RemoveView() should be called so the association between the
   view and the document is removed.
*/


if ((m_nView == D_SCANMAP) || (m_nView == D_SCANTRACK))
{
	((CScanMapView*)ptNewView)->SetImagePtr(ptScMpDoc->GetDibPtr());
	((CScanMapView*)ptNewView)->CheckLoaded();		// switched back to scanned map view
}

CDocument* ptDoc = ptNewView->GetDocument();
ASSERT_VALID(ptDoc);
if (ptDoc != NULL)
	ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
									// each view sets scrollbar size in OnUpdate!
}



/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


/************************************************************************
 *  MainFrm.cpp	  				O n M i s c F o n t s					*
 ************************************************************************/
void CMainFrame::OnMiscFonts()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
if (ptFontTool->ChooseFont(ptActView))
	{      
	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
	ASSERT_VALID(ptWayDoc);
    if (ptWayDoc != NULL)
		ptWayDoc->UpdateAllViews(NULL);
	}	
}

/************************************************************************
 *  MainFrm.cpp	  				O n M i s c D i m						*
 ************************************************************************/
void CMainFrame::OnMiscDim()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
ptDim->Change(ptActView);	
}

/************************************************************************
 *  MainFrm.cpp	  				O n V i e w C o l o r s					*
 ************************************************************************/
void CMainFrame::OnViewColors()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
CColorDoc* ptColorDoc = ptInit->GetColorPtr();
if (ptColorDoc != NULL)
	{									// get selected scanned map
	CScannedMap* ptScannedMap = ptScMpDoc->GetMapPtr(ptScMpDoc->GetActMapIndex());

	BOOL bMapSelected = (ptScannedMap != NULL);
	if (bMapSelected)			// put data of act map into color doc
		ptColorDoc->SetColScMapText (ptScannedMap->GetTextColor());

	if (ptColorDoc->Change(ptActView, bMapSelected))
		{					
		if (bMapSelected)		// put data from color doc into act map
			ptScannedMap->SetTextColor (ptColorDoc->GetColScMapText());
		}
	}
}


/************************************************************************
 *  MainFrm.cpp	  		O n V i e w S e l V i e w T o o l B a r			*
 ************************************************************************/
void CMainFrame::OnViewSelViewToolBar ()
{
BOOL bVisible = ((m_wndTBSelView.GetStyle() & WS_VISIBLE) != 0);
this->ShowControlBar(&m_wndTBSelView, !bVisible, FALSE);
m_wndTBSelView.Invalidate();
}

/************************************************************************
 *  MainFrm.cpp	  		O n V i e w G p s T r a n s T o o l B a r		*
 ************************************************************************/
void CMainFrame::OnViewGpsTransToolBar ()
{
BOOL bVisible = ((m_wndTBGpsTrans.GetStyle() & WS_VISIBLE) != 0);
this->ShowControlBar(&m_wndTBGpsTrans, !bVisible, FALSE);
m_wndTBGpsTrans.Invalidate();
}

/************************************************************************
 *  MainFrm.cpp	  		O n V i e w M a p S y m b o l T o o l B a r		*
 ************************************************************************/
void CMainFrame::OnViewMapSymbolToolBar	()
{
BOOL bVisible = ((m_wndTBMapSymbol.GetStyle() & WS_VISIBLE) != 0);
this->ShowControlBar(&m_wndTBMapSymbol, !bVisible, FALSE);
m_wndTBMapSymbol.Invalidate();
}

/************************************************************************
 *  MainFrm.cpp			O n V i e w W a y p t T o o l B a r				*
 ************************************************************************/
void CMainFrame::OnViewWayptToolBar	()
{
BOOL bVisible = ((m_wndTBWaypt.GetStyle() & WS_VISIBLE) != 0);
this->ShowControlBar(&m_wndTBWaypt, !bVisible, FALSE);
m_wndTBWaypt.Invalidate();
}


/************************************************************************
 *  MainFrm.cpp	  		O n V i e w D r a w M a p T o o l B a r			*
 ************************************************************************/
void CMainFrame::OnViewDrawMapToolBar	()
{
BOOL bVisible = ((m_wndTBDrawMap.GetStyle() & WS_VISIBLE) != 0);
this->ShowControlBar(&m_wndTBDrawMap, !bVisible, FALSE);
m_wndTBDrawMap.Invalidate();
}

/************************************************************************
 *  MainFrm.cpp	  			O n M i s c C a l c u l a t o r				*
 ************************************************************************/
void CMainFrame::OnMiscCalculator()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();

CDimCalcDlg CalculatorDlg(ptActView);

int RetVal = CalculatorDlg.DoModal();
switch (RetVal)
	{
	case IDOK:   
		break;
	case IDCANCEL:
		break;
	}
}

   
/************************************************************************
 *  MainFrm.cpp	  			 	O n I n p L o a d						*
 ************************************************************************/
void CMainFrame::OnInpLoad()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();

CDocument* ptDoc;
switch (ptLoad->Change(ptActView))
	{
	case IDOK:   
		ptDoc = ptActView->GetDocument();
		ASSERT_VALID(ptDoc);
		if (ptDoc != NULL)
			{
			ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
			this->ShowStartLandErr ();	// Error message boxes
			}
		break;
	case IDCANCEL:
		break;
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n C a l c P r e f							*
 ************************************************************************/
void CMainFrame::OnCalcPref()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
ptCalc->Change(ptActView);	
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n I n p A p p e n d i x 					*
 ************************************************************************/
void CMainFrame::OnInpAppendix()
{
	// TODO: Add your command handler code here
	CView* ptActView = GetActiveView();

	CDocument* ptDoc;
	if (ptAppend->Change(ptActView))
	{
		ptDoc = ptActView->GetDocument();
		ASSERT_VALID(ptDoc);
		if (ptDoc != NULL)
			ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n M i s c	F l p l							*
 ************************************************************************/
void CMainFrame::OnMiscFlpl()
{
	// TODO: Add your command handler code here
	CView* ptActView = GetActiveView();
	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
	ASSERT_VALID(ptWayDoc);

	if (ptFlPlDoc->GetDataMode () == DATA_AUTOMATIC)
	{					// get actual data for flight plan...
		ptFlPlDoc->Update (ptWayDoc);	// calls SetRouteParams
	}		 

	if (ptFlPlDoc->Change(ptActView, ptWayDoc))
	{
		BOOL bManual = (ptFlPlDoc->GetDataMode() == DATA_MANUAL);

		ptWayDoc->SetFlightPlanParams(bManual,
						   ptFlPlDoc->GetLevel(),
						   ptFlPlDoc->GetRoute(),
						   ptFlPlDoc->GetAlternate1(),  
						   ptFlPlDoc->GetAlternate2(),  
						   ptFlPlDoc->GetOtherInfo());
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n M i s c	M a p s							*
 ************************************************************************/
void CMainFrame::OnMiscMaps()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();

if (ptScMpDoc->Change(ptActView))		// show Dialog with list of scanned maps
	{									// get selected scanned map
	CScannedMap* ptScannedMap = ptScMpDoc->GetMapPtr(ptScMpDoc->GetActMapIndex());
	if (ptScannedMap != NULL)
		{
	    ptActView->Invalidate (FALSE); // don't erase background

		CDocument* ptDoc = ptActView->GetDocument();
		ASSERT_VALID(ptDoc);
		if (ptDoc != NULL)
			ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate


		CPfApp* ptApp = (CPfApp*)AfxGetApp();
		BOOL bTrack = (m_nView >= D_TRACK);	// switch to scanned map view
		int nMenuID;
		if(bTrack)
		{
			((CTrackView*)(ptApp->m_pTrackView))->ShowFullRoute();
			nMenuID = ID_VIEW_TRACKSCAN;
		}
		else
		{
			((CRouteView*)(ptApp->m_pMapView))->ShowFullRoute(); 
			nMenuID = ID_VIEW_MAPSCAN;
		}
		WPARAM wParam = MAKELONG (nMenuID, 0);
		this->PostMessage(WM_COMMAND, wParam, 0);

											// allow system to update view
		m_uTimer = this->SetTimer (CALIB_TIMER, 1000, NULL);
											// then show calib dlg, if necdessary
		}
	else{	 // ptScannedMap == NULL (ActMapIndex == -1)
 		WPARAM wParam = MAKELONG (ID_VIEW_MAP, 0);
		this->PostMessage(WM_COMMAND, wParam, 0);
		}
	}
}

/************************************************************************
 *  MainFrm.cpp					O n T i m e r							*
 ************************************************************************/
void CMainFrame::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

if (nIDEvent == CALIB_TIMER)
	{
	this->KillTimer (m_uTimer);


	CView* ptActView = GetActiveView();

	CScannedMap* ptScannedMap = ptScMpDoc->GetMapPtr(ptScMpDoc->GetActMapIndex());
	if (ptScannedMap != NULL)
		{
		if (ptScMpDoc->IsActivatedCalibDlg())
			{			
		//	ptScMpDoc->SetActivateCalibDlg(FALSE);		// ans blockende verschoben!!
			
			ptActView = GetActiveView();
			if (ptActView->IsKindOf(RUNTIME_CLASS(CScanMapView)))
				{					// show calibration dlg
				ptScannedMap->SetActCalIndex(-1);
				if (ptScMpDoc->ChangeCalibration((CScanMapView*)ptActView)) 
					{							// first step of calibration
					}
				else{
					ptScannedMap->SetActCalIndex(-1);
					if (!((CScanMapView*)ptActView)->IsDrawn())
						OnViewLast();
					}
				}
			ptScMpDoc->SetActivateCalibDlg(FALSE);
			}
		}
	}

	if (nIDEvent == GPS_TIMER)
	{
		CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
		if (ptMovingMap != NULL)
		{
			if (ptMovingMap->NextStep())		// KillTimer, DoRecord NMEA, StartTimer
			{
				CColorDoc* ptColor = ptInit->GetColorPtr();

				BOOL bScMapMoved = FALSE;
				if (m_nView == D_SCANTRACK)
				{
					if (ptColor != NULL)
						ptMovingMap->SetActPosColor(ptColor->GetColScMapPos());
					bScMapMoved = MoveScMap(ptMovingMap);
					if (!bScMapMoved)
					{
						ptMovingMap->TimerStop();
						AfxMessageBox (IDS_NO_MOVING_MAP);		
						ptMovingMap->TimerStart();
					}
				}

				if ((m_nView == D_TRACK) || !bScMapMoved)
				{
					if (ptColor != NULL)
						ptMovingMap->SetActPosColor(ptColor->GetColMapPos());
					MoveMap();		// use vektor graphic
				}

								// used in CMovingMapDoc::PointOnLegAtDist
				ptMovingMap->SetScMapMoved (bScMapMoved);

				if (ptMovingMap->IsJustStarted())
				{

				}
			}
		}
	}

	if (nIDEvent == MOVE_TIMER)
	{
		this->KillTimer(nIDEvent);
		CLatLon ActPos = m_ptMapDoc->GetLatLon();
		CElevArrayDoc* ptElevArrayDoc = ptInit->GetElevArrayDocPtr();
		if (ptElevArrayDoc != NULL)
		{
			ptElevArrayDoc->ActualizeStatusElev(ActPos);
		}
	}
		
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n M i s c G p s							*
 ************************************************************************/
void CMainFrame::OnMiscGps()
{
	// TODO: Add your command handler code here
CGpsDoc* ptGps = ptInit->GetGpsPtr();
CView* ptActView = GetActiveView();
ptGps->Change(ptActView);
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n L o c R e g i o n s						*
 ************************************************************************/
void CMainFrame::OnLocRegions()
{
	// TODO: Add your command handler code here
CQuickFind* ptQuickFind = ptInit->GetQuickFindPtr();
CView* ptActView = GetActiveView();
if (ptQuickFind->Change(ptActView))
	{
	ptActView->Invalidate(FALSE);  // bErase = FALSE;   
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n L o c I m p o r t						*
 ************************************************************************/
void CMainFrame::OnLocImport() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
CView* ptActView = GetActiveView();
if (ptLocDoc->Import(ptActView))
	{
	CDocument* ptDoc = ptActView->GetDocument();
	ASSERT_VALID(ptDoc);
	if (ptDoc != NULL)
		ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
	}
}



/************************************************************************
 *  MainFrm.cpp	  				O n L o c H o m e						*
 ************************************************************************/
void CMainFrame::OnLocHome() 
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
CQuickFind* ptQuickFind = ptInit->GetQuickFindPtr();
CNameList* ptNameList = ptQuickFind->GetNameListPtr();
CLocation HomeLoc = ptInit->GetHomeBase ();

CAutoKoordDlg HomeBaseDlg(ptActView, 
						&HomeLoc, 
						ptQuickFind,
						ptNameList);

short	nRegIndex;
int RetVal = HomeBaseDlg.DoModal();
switch (RetVal)
	{
	case IDOK:   
		if (HomeBaseDlg.GetLoc(&HomeLoc, &nRegIndex))
			{
			ptInit->SetHomeBase (HomeLoc); 
			ptActView->InvalidateRect(NULL);   
			}
		break;
	case IDCANCEL:
		break;
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n L o c E d i t							*
 ************************************************************************/
void CMainFrame::OnLocEdit()
{
	// TODO: Add your command handler code here
	CView* ptActView = GetActiveView();

	CLocation Loc;
	if (ptLocDoc->Change(ptActView, &Loc))
	{
		CDocument* ptDoc = ptActView->GetDocument();
		ASSERT_VALID(ptDoc);
		if (ptDoc != NULL)
			ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
	}

		// to select a location, CHANGE must not return TRUE,
		// but Location must be defined
		// after leaving dlg via Abort, Loc is NOT defined!!
		
	

	if (ptScMpDoc != NULL && Loc.IsDefined())
	{
		ptInit->SetLatLonToCenter(Loc.GetLat(), Loc.GetLon());		// neu

		if (m_nView != D_SCANMAP && m_nView != D_SCANTRACK &&
			m_nView != D_MAP && m_nView != D_TRACK)
		{		// no map or track view activated:
			SwitchToView (D_SCANMAP);	// first: search map to show ptLoc
		}

		if (m_nView == D_SCANMAP || m_nView == D_SCANTRACK)
		{						// search map to show ptLoc
			if (ptScMpDoc->ActivateScMapForLatLon((CLatLon)Loc))
			{
				if (ptActView->IsKindOf(RUNTIME_CLASS(CScanMapView)))
				{					// check calibration
					((CScanMapView*)ptActView)->CheckCalibration();
				}

				this->CenterLatLonOnScMp ((CLatLon)Loc);
			}
			else		
			{					// no map found: switch to vector graphic
				eView NewView = (m_nView == D_SCANMAP)? D_MAP : D_TRACK;
				SwitchToView (NewView);
			}
		}

		if (m_nView == D_MAP || m_nView == D_TRACK)
		{				
			CenterLatLonOnMp((CLatLon)Loc);
		}
	}
} 



/************************************************************************
 *  MainFrm.cpp	  		 	O n L o c U p d a t e						*
 ************************************************************************/
void CMainFrame::OnLocUpdate()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();

CQuickFind* ptQuickFind = ptInit->GetQuickFindPtr();
short nRgnCnt = ptQuickFind->GetRegionCnt();	// Region Cnt may be 0
if (ptLocDoc->Update(ptActView))				// update location data dlg
	{
	BOOL bUpdateViews=TRUE;

	if (nRgnCnt == 0)	// there was no region => no region activated !!
		{									// show region select dialog now
		if (ptQuickFind->Change(ptActView)) 
			{								
			CLocation HomeBase;
			if (ptInit->IsJustInstalled())
				{							// try to set home base now
				if (ptQuickFind->GetHomeBase(&HomeBase))
					ptInit->SetHomeBase (HomeBase);
				}
			}
		else{
			bUpdateViews = FALSE;
			}
		}

	if (bUpdateViews)
		{
		CDocument* ptDoc = ptActView->GetDocument();
		ASSERT_VALID(ptDoc);
		if (ptDoc != NULL)
			ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
		}
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n L o c R e a d F r o m G P S				*
 ************************************************************************/
void CMainFrame::OnLocReadFromGPS()
{
	CView* ptActView = GetActiveView();
	if (ptLocDoc->ReadFromGPS(ptActView))
	{
		CDocument* ptDoc = ptActView->GetDocument();
		ASSERT_VALID(ptDoc);
		if (ptDoc != NULL)
			ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n L o c W r i t e T o G P S				*
 ************************************************************************/
void CMainFrame::OnLocWriteToGPS()
{
	CView* ptActView = GetActiveView();
	if (ptLocDoc->WriteToGPS(ptActView))
	{
		CDocument* ptDoc = ptActView->GetDocument();
		ASSERT_VALID(ptDoc);
		if (ptDoc != NULL)
			ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n L o c M e r g e							*
 ************************************************************************/
void CMainFrame::OnLocMerge()
{
	// TODO: Add your command handler code here
//CQuickFind* ptQuickFind = ptInit->GetQuickFindPtr();
CView* ptActView = GetActiveView();
if (ptLocDoc->Merge(ptActView))
	{
	CDocument* ptDoc = ptActView->GetDocument();
	ASSERT_VALID(ptDoc);
	if (ptDoc != NULL)
		ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n L o c E l e v							*
 ************************************************************************/
void CMainFrame::OnLocElev()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
if (ptElevDoc->Change(ptActView))
	{
	CDocument* ptDoc = ptActView->GetDocument();
	ASSERT_VALID(ptDoc);
	if (ptDoc != NULL)
		ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n L o c E l e v A r r a y					*
 ************************************************************************/
void CMainFrame::OnLocElevArray()
{
	// TODO: Add your command handler code here
	CView* ptActView = GetActiveView();
	CElevArrayDoc* ptElevArrayDoc = ptInit->GetElevArrayDocPtr();
	if (ptElevArrayDoc != NULL)
	{
		if (ptElevArrayDoc->Change(ptActView))
		{
			CDocument* ptDoc = ptActView->GetDocument();
			ASSERT_VALID(ptDoc);
			if (ptDoc != NULL)
				ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
		}
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n L o c A i r s p a c e					*
 ************************************************************************/
void CMainFrame::OnLocAirspace()
{
	BOOL 	bChanged = FALSE;

								// ptWayDoc may be used to import airspace
	CView* ptActView = GetActiveView();		
	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
	ASSERT_VALID(ptWayDoc);

	CAirspaceDlg AirspaceDlg(this);

	AirspaceDlg.SetWayDocPtr(ptWayDoc);	// for importing airspace from route

	int RetVal = AirspaceDlg.DoModal();
	switch (RetVal)
	{
	case IDOK:
		bChanged = TRUE;
 		break;
	case IDCANCEL: 
    //    this->SetModifiedFlag(FALSE);
		break;
	}

	ptActView->InvalidateRect(NULL);   
}


/************************************************************************
 *  MainFrm.cpp	  				O n I n p M e t							*
 ************************************************************************/
void CMainFrame::OnInpMet()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
ptMet->Change(ptActView);	
}


/************************************************************************
 *  MainFrm.cpp	  	G e t S t a t u s S p e e d S t r i n g				*
 *  Purpose: to show actual speed in status bar							*
 ************************************************************************/
CString CMainFrame::GetStatusSpeedString()
{
	CString szSpeed ("---");

	short nSpeedDim = ptDim->DistDimToSpeedDim (ptDim->Distance());
	float fSpeed = 0;
	

	BOOL bShowMovingMapSpeed = FALSE;
	short nLastTrkIndex;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		if (ptMovingMap->IsRecording())
		{	
			if (ptTrackDoc != NULL)
			{
				nLastTrkIndex = ptTrackDoc->GetCnt()-1;
				if (nLastTrkIndex > 0)
					bShowMovingMapSpeed = TRUE;	
			}
		}
	}
	
	if (bShowMovingMapSpeed)
	{
		szSpeed = ptTrackDoc->GetSpeedString(nLastTrkIndex, nSpeedDim);
	}
	else
	{	
		if (m_nView < D_TRACK)				// route view active
		{					
			if (ptPlaneDoc != NULL)
			{						
				short nActIndex = ptPlaneDoc->GetActIndex();
				szSpeed = ptPlaneDoc->GetSpeedString(nActIndex, nSpeedDim);
			}
		}
		else
		{		// track view active
			if (m_nView == D_TRACK && m_nView == D_SCANTRACK)
			{		// show stored speed near mouse pos

			}

			if (m_nView == D_TRACKALT)
			{

			}

			if (m_nView == D_TRACKSPD)
			{

			}

		}
	}

	return szSpeed;
}

/************************************************************************
 *  MainFrm.cpp	  	G e t S t a t u s A l t S t r i n g					*
 *  Purpose: to show actual altitude in status bar						*
 ************************************************************************/
CString CMainFrame::GetStatusAltString ()
{
	CString szAltitude ("---");

	short nAltDim = ptDim->Altitude();
	float fAlt = 0;
	

	BOOL bShowMovingMapAlt = FALSE;
	short nLastTrkIndex;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		if (ptMovingMap->IsRecording())
		{	
			if (ptTrackDoc != NULL)
			{
				nLastTrkIndex = ptTrackDoc->GetCnt()-1;
				if (nLastTrkIndex > 0)
					bShowMovingMapAlt = TRUE;	
			}
		}
	}

	
	if (bShowMovingMapAlt)
	{
		szAltitude = ptTrackDoc->GetAltitudeString(nLastTrkIndex, nAltDim);
	}

	return szAltitude;
}

/************************************************************************
 *  MainFrm.cpp	  	G e t S t a t u s A l t _ E l e v S t r i n g		*
 *  Purpose: to show actual altitude AND elevatio in status bar			*
 ************************************************************************/
CString CMainFrame::GetStatusAlt_ElevString ()
{
	CString szAlt_Elev ("---");

	BOOL bShowMovingMapAlt = FALSE;
	long lAlt;

	BOOL bShowElev = FALSE;
	short nElev;

	short nAltDim = ptDim->Altitude();	

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		if (ptMovingMap->IsRecording())
		{	
			if (ptTrackDoc != NULL)
			{
				short nLastTrkIndex = ptTrackDoc->GetCnt()-1;
				if (nLastTrkIndex > 0)
				{
					if (ptTrackDoc->GetAltitude(nLastTrkIndex, nAltDim, &lAlt))
					{
						bShowMovingMapAlt = TRUE;	
					}
				}
			}
		}
	}

	
	CElevArrayDoc* ptElevArrayDoc = ptInit->GetElevArrayDocPtr();
	if (ptElevArrayDoc != NULL)
	{
		if (ptElevArrayDoc->GetStatusElev (&nElev))
		{
			bShowElev = TRUE;
		}
	}

	CString szDim;
	ptDim->GetDimCstring(&szDim, nAltDim);

	if (bShowMovingMapAlt && bShowElev)
	{
		szAlt_Elev.Format ("%ld / %d %s", lAlt, nElev, (LPCTSTR)szDim);
	}
	else
	{
		if (bShowMovingMapAlt)
		{
			szAlt_Elev.Format ("%ld %s", lAlt, (LPCTSTR)szDim);
		}

		if (bShowElev)
		{
			szAlt_Elev.Format ("%d %s", nElev, (LPCTSTR)szDim);
		}
	}


	return szAlt_Elev;
}

/************************************************************************
 *  MainFrm.cpp	  	O n U p d a t e S t a t u s L a t L o n				*
 *  Purpose: shows actual Lat Lon in status bar							*
 ************************************************************************/
void CMainFrame::OnUpdateStatusLatLon(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
								  // S t a t u s b a r
CString szLatLon = m_ptMapDoc->GetLatLonString();

pCmdUI->SetText (szLatLon);
pCmdUI->Enable (szLatLon.GetLength() > 0);
}

/************************************************************************
 *  MainFrm.cpp	  	O n U p d a t e S t a t u s E l e v					*
 *  Purpose: shows actual elevation of 1km-grid in status bar			*
 ************************************************************************/
void CMainFrame::OnUpdateStatusElev(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
								  // S t a t u s b a r
//	BOOL bGroundElev = TRUE;
	CString szElev;

//	if (bGroundElev)
//	{						// show ground elevation
//		CElevArrayDoc* ptElevArrayDoc = ptInit->GetElevArrayDocPtr();
//		if (ptElevArrayDoc != NULL)
//		{
//			short nElev;
//			if (ptElevArrayDoc->GetStatusElev (&nElev))
//			{
//				CString szDim;
//				short nElevDim = ptDim->Altitude();
//				ptDim->GetDimCstring(&szDim, nElevDim);
//				szElev.Format ("%d %s", nElev, (LPCTSTR)szDim);
//			}
//		}
//	}
//	else
//	{						// show flight altitude
//		szElev = this->GetStatusAltString();
//	}

	szElev = this->GetStatusAlt_ElevString();
	pCmdUI->SetText (szElev);
	pCmdUI->Enable (szElev.GetLength() > 0);
}

	

/************************************************************************
 *  MainFrm.cpp	  	O n U p d a t e S t a t u s S p e e d				*
 *  Purpose: shows actual speed in status bar							*
 ************************************************************************/
void CMainFrame::OnUpdateStatusSpeed(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
								  // S t a t u s b a r

	CString szSpeed = GetStatusSpeedString();

	pCmdUI->SetText (szSpeed);
	pCmdUI->Enable (szSpeed.GetLength() > 0);
}


/************************************************************************
 *  MainFrm.cpp	  		 	O n S e l e c t P l a n e					*
 ************************************************************************/
void CMainFrame::OnSelectPlane(UINT nID) 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
short	nIndex = nID - ID_PLANE_FIRST;
CView* ptActView = GetActiveView();
ptPlaneDoc->ActivatePlane (ptActView, nIndex);

							//  update updown
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);
if (ptWayDoc != NULL)
	{
	ptWayDoc->UpdateUpDown();
	ptWayDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n I n p P l a n e							*
 ************************************************************************/
void CMainFrame::OnInpPlane()
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
if (ptPlaneDoc->Change(ptActView))
	{
    ptPlaneDoc->DelPlaneMenu (this, PLANE_MENU);
    ptPlaneDoc->NewPlaneMenu (this, PLANE_MENU);

	CDocument* ptDoc = ptActView->GetDocument();
	ASSERT_VALID(ptDoc);
	if (ptDoc != NULL)
		ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
	}	
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n I n p R o u t e							*
 ************************************************************************/
void CMainFrame::OnInpRoute() 
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

if (ptWayDoc->Change(ptActView))
	{
	if ((m_nView == D_FLIGHTPLAN) && 
		(ptFlPlDoc->GetDataMode () == DATA_MANUAL) )
		{
		AfxMessageBox (IDS_FLIGHTPLAN_AUTO);
		ptFlPlDoc->SetUpdateRequired (FALSE);
		}

	CPfApp* ptApp = (CPfApp*)AfxGetApp();
	((CRouteView*)(ptApp->m_pMapView))->ShowFullRoute(); 

	if (m_nView == D_SCANMAP)
		this->OnViewMapScan();
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n R t e T o G C A S						*
 ************************************************************************/
void CMainFrame::OnRteToGCAS()
{
CView* ptActView = GetActiveView();

CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

if (ptWayDoc->WriteToGCAS(ptActView))
	{
	CPfApp* ptApp = (CPfApp*)AfxGetApp();
	((CRouteView*)(ptApp->m_pMapView))->ShowFullRoute(); 
	}

}

/************************************************************************
 *  MainFrm.cpp	  		 	O n R t e T o K M L							*
 ************************************************************************/
void CMainFrame::OnRteToKML()
{
CView* ptActView = GetActiveView();

CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

if (ptWayDoc->WriteToKML(ptActView))
	{
	CPfApp* ptApp = (CPfApp*)AfxGetApp();
	((CRouteView*)(ptApp->m_pMapView))->ShowFullRoute(); 
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n R t e T o G P S							*
 ************************************************************************/
void CMainFrame::OnRteToGPS() 
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();

CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

if (ptWayDoc->WriteToGPS(ptActView))
	{
	CPfApp* ptApp = (CPfApp*)AfxGetApp();
	((CRouteView*)(ptApp->m_pMapView))->ShowFullRoute(); 
	}
}

void CMainFrame::OnUpdateRteToGps(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();

CGpsDoc* ptGpsDoc = ptInit->GetGpsPtr();
short nGpsListIndex = ptGpsDoc->GetGpsListIndex();

BOOL bDisabled = ((nGpsListIndex == GPS_LIST_NONE) || 
			 (nGpsListIndex == GPS_LIST_OTHER)|| (ptWayDoc->GetWayPointCnt()<2));
pCmdUI->Enable(!bDisabled);	
}

void CMainFrame::OnUpdateRteToGCAS(CCmdUI* pCmdUI) 
{
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();

BOOL bDisabled = (ptWayDoc->GetWayPointCnt()<2);
pCmdUI->Enable(!bDisabled);	
}

void CMainFrame::OnUpdateRteToKML(CCmdUI* pCmdUI) 
{
	// Allow exporting a route to KML if there are at least two way points
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();

BOOL bDisabled = (ptWayDoc->GetWayPointCnt()<2);
pCmdUI->Enable(!bDisabled);	
}


/************************************************************************
 *  MainFrm.cpp	  		 	O n R t e F r o m G P S						*
 ************************************************************************/
void CMainFrame::OnRteFromGPS() 
{
	// TODO: Add your command handler code here
	CView* ptActView = GetActiveView();

	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
	ASSERT_VALID(ptWayDoc);

	if (ptWayDoc->ReadFromGPS(ptActView))
	{
		ptWayDoc->InLegalArea();
		ptWayDoc->SetActInd(ptWayDoc->GetWayPointCnt()-1);
		this->SwitchToRte();
	}									
}

void CMainFrame::OnUpdateRteFromGps(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
CGpsDoc* ptGpsDoc = ptInit->GetGpsPtr();
short nGpsListIndex = ptGpsDoc->GetGpsListIndex();

BOOL bDisabled = ((nGpsListIndex == GPS_LIST_NONE) || 
			 (nGpsListIndex == GPS_LIST_OTHER));
pCmdUI->Enable(!bDisabled);
}

/************************************************************************
 *  MainFrm.cpp	  		 	S w i t c h T o T r a c k					*
 ************************************************************************/
void CMainFrame::SwitchToTrack()
{
	CString szTitle;
	szTitle = CTextViewTool::Format (IDF_MAINFRM_TITLE, (LPCTSTR)ptTrackDoc->GetTitle());
	this->SetWindowText(szTitle);			// Update Window Title

	
	BOOL bUseDefault = TRUE;
	switch(m_nView)
	{
	case D_MAP:
		bUseDefault = TRUE;
		break;

	case D_SCANMAP:
		if (ptScMpDoc->GetMapCnt() > 0)
		{
			if (ptScMpDoc->ActivateNearestMap(ptTrackDoc))
			{
				SwitchToView(D_SCANTRACK);
				this->CenterLastTrackPtOnScMp(ptTrackDoc);
				bUseDefault = FALSE;
			}
		}
		break;

	case D_TRACK:
		bUseDefault = TRUE;
		break;

	case D_SCANTRACK:
		if (ptScMpDoc->GetMapCnt() > 0)
		{
			if (ptScMpDoc->ActivateNearestMap(ptTrackDoc))
			{
		//		SwitchToView(D_SCANTRACK);
				this->CenterLastTrackPtOnScMp(ptTrackDoc);
				bUseDefault = FALSE;
			}
		}
		break;

	default:
		break;
	}

	if (bUseDefault)
	{
		CPfApp* ptApp = (CPfApp*)AfxGetApp();
		((CTrackView*)(ptApp->m_pTrackView))->ShowFullRoute();
		this->SwitchToView (D_TRACK);	// switch to mercator map for track
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	S w i t c h T o R t e						*
 ************************************************************************/
void CMainFrame::SwitchToRte()
{
	CView* ptActView = GetActiveView();
	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
	ASSERT_VALID(ptWayDoc);
	
	CString szTitle;
	szTitle = CTextViewTool::Format (IDF_MAINFRM_TITLE, (LPCTSTR)ptWayDoc->GetTitle());
	this->SetWindowText(szTitle);			// Update Window Title


	BOOL bUseDefault = TRUE;
	switch(m_nView)
	{
	case D_MAP:
		bUseDefault = TRUE;
		break;

	case D_SCANMAP:
		if (ptScMpDoc->GetMapCnt() > 0)
		{
			CLocation llActWpt;
			if (ptWayDoc->GetActLocationPtr(&llActWpt))
			{
				ptInit->SetLatLonToCenter(llActWpt.GetLat(), llActWpt.GetLon());
				this->OnViewMapScan();
				bUseDefault = FALSE;
			}
		}
		break;

	case D_TRACK:
		bUseDefault = TRUE;
		break;

	case D_SCANTRACK:
		if (ptScMpDoc->GetMapCnt() > 0)
		{
			CLocation llActWpt;
			if (ptWayDoc->GetActLocationPtr(&llActWpt))
			{
				ptInit->SetLatLonToCenter(llActWpt.GetLat(), llActWpt.GetLon());
				this->OnViewMapScan();
				bUseDefault = FALSE;
			}
		}
		break;

	default:
		break;
	}

	if (bUseDefault)
	{
		CPfApp* ptApp = (CPfApp*)AfxGetApp();
		((CRouteView*)(ptApp->m_pMapView))->ShowFullRoute(); 
		this->SwitchToView (D_MAP);		// switch to mercator map for route
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n R t e T r a c k N e w					*
 ************************************************************************/
void CMainFrame::OnRteTrackNew()
{									// use CTrackDoc here !!!!!!!!!!!!!!
	if (ptTrackDoc != NULL)
	{
		ptTrackDoc->OnNewDocument();
		this->SwitchToRte();
	}
}

void CMainFrame::OnUpdateRteTrackNew(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bEnabled = FALSE;
	
	if (ptTrackDoc != NULL)
		bEnabled = (ptTrackDoc->GetCnt() > 0);

	pCmdUI->Enable(bEnabled);	
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n R t e T r a c k O p e n					*
 ************************************************************************/
void CMainFrame::OnRteTrackOpen()
{									// use CTrackDoc here !!!!!!!!!!!!!!
	if (ptTrackDoc != NULL)
	{
		if (ptTrackDoc->Open(this))	// also selects nearest map
		{
			CView* ptActView = GetActiveView();
			CDocument* ptDoc = ptActView->GetDocument();
			ASSERT_VALID(ptDoc);
			if (ptDoc != NULL)
				ptDoc->UpdateAllViews(NULL);	// force a call to OnUpdate

			this->SwitchToTrack();
			this->Invalidate(FALSE);
		}
	}
}

void CMainFrame::OnUpdateRteTrackOpen(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bEnabled = FALSE;
	
	bEnabled = (ptTrackDoc != NULL);

	pCmdUI->Enable(bEnabled);	// always allowed
}


/************************************************************************
 *  MainFrm.cpp	  		 	O n R t e T r a c k S a v e A s				*
 ************************************************************************/
void CMainFrame::OnRteTrackSaveAs()
{									// use CTrackDoc here !!!!!!!!!!!!!!
	if (bDemo)
	{
		AfxMessageBox (IDS_SAVE_DISABLED);
	}
	else
	{
		if (ptTrackDoc != NULL)
			ptTrackDoc->SaveAs(this);
	}

	CString szTitle;
	szTitle = CTextViewTool::Format (IDF_MAINFRM_TITLE, (LPCTSTR)ptTrackDoc->GetTitle());
	this->SetWindowText(szTitle);			// Update Window Title
}


void CMainFrame::OnUpdateRteTrackSaveAs(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bEnabled = FALSE;
	BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}

	if (ptTrackDoc != NULL)
		bEnabled = (ptTrackDoc->IsModified() && !bRecording);

	pCmdUI->Enable(bEnabled);
}


/************************************************************************
 *  MainFrm.cpp	  		O n R t e T r a c k S a v e A s K M L			*
 ************************************************************************/
void CMainFrame::OnRteTrackSaveAsKML()
{									// use CTrackDoc here !!!!!!!!!!!!!!
	if (bDemo)
	{
		AfxMessageBox (IDS_SAVE_DISABLED);
	}
	else
	{
		if (ptTrackDoc != NULL)
			ptTrackDoc->WriteToKML(this);
	}

	CString szTitle;
	szTitle = CTextViewTool::Format (IDF_MAINFRM_TITLE, (LPCTSTR)ptTrackDoc->GetTitle());
	this->SetWindowText(szTitle);			// Update Window Title
}


void CMainFrame::OnUpdateRteTrackSaveAsKML(CCmdUI* pCmdUI) 
{
	// Allow exporting a track to KML if there is at least one track point
	BOOL bEnabled = FALSE;
	
	if (ptTrackDoc != NULL)
		bEnabled = (ptTrackDoc->GetCnt() > 0);

	pCmdUI->Enable(bEnabled);	
}


/************************************************************************
 *  MainFrm.cpp	  		 O n R t e T r a c k M o v i n g M a p	 		*
 ************************************************************************/
void CMainFrame::OnRteTrackMovingMap()
{									// use CTrackDoc here !!!!!!!!!!!!!!
	// TODO: Add your command handler code here
	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		if (ptMovingMap->IsRecording())
		{						// stop moving map
			ptMovingMap->Stop();
		}
		else
		{						// start moving map
			CGpsDoc* ptGpsDoc = ptInit->GetGpsPtr();		// get GpsDoc

			CView* ptActView = GetActiveView();				// get WayDoc
			CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
			if (ptMovingMap->Start(this, ptGpsDoc, ptTrackDoc, ptWayDoc))
			{			
				CString szTitle;
				szTitle = CTextViewTool::Format (IDF_MAINFRM_TITLE, (LPCTSTR)ptTrackDoc->GetTitle());
				this->SetWindowText(szTitle);			// Update Window Title
			}
		}
	}
}


void CMainFrame::OnUpdateRteTrackMovingMap(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bDisabled = FALSE;
	BOOL bRecording = FALSE;
	BOOL bWay = FALSE;
	short nGpsListIndex = GPS_LIST_NONE;

	CView* ptActView = GetActiveView();
	CDocument* ptActDoc = ptActView->GetDocument();
	if (ptActDoc->IsKindOf(RUNTIME_CLASS(CWayDoc)))
		bWay = (((CWayDoc*)ptActDoc)->GetWayPointCnt() > 1);


	CGpsDoc* ptGpsDoc = ptInit->GetGpsPtr();
	if (ptGpsDoc != NULL)
		nGpsListIndex = ptGpsDoc->GetGpsListIndex();


	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		MMSource mmSource = ptMovingMap->GetSource();
		switch (mmSource)
		{
		case 	SOURCE_GPS: bDisabled = (nGpsListIndex == GPS_LIST_NONE); break;
		case 	SOURCE_TRK: bDisabled = (ptTrackDoc->GetCnt() == 0); break;
		case 	SOURCE_RTE: bDisabled = !bWay; break;
		}

		if (!bDisabled)
		{
			bRecording = ptMovingMap->IsRecording();
		}
	}

	pCmdUI->Enable(!bDisabled);
	pCmdUI->SetCheck(bRecording);	
}


/************************************************************************
 *  MainFrm.cpp	  		 	O n R t e T r a c k R o u t e 				*
 ************************************************************************/
void CMainFrame::OnRteTrackRoute()
{												// use CTrackDoc here !!!!!!!!!!!!!!
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
//CTrackDoc* ptTrackDoc = (CTrackDoc*)ptActView->GetDocument();
//ASSERT_VALID(ptTrackDoc);

if (ptTrackDoc->Change(ptActView))
	{
	if (ptTrackDoc->GetCnt() > 1)
		{									// track available
		this->SwitchToTrack();
		}
	else{									// no track available
		this->SwitchToRte();
		}
	}
}


void CMainFrame::OnUpdateRteTrackRoute(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bDisabled = TRUE;
	BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}

	CGpsDoc* ptGpsDoc = ptInit->GetGpsPtr();
	if (ptGpsDoc != NULL)
	{
		short nGpsListIndex = ptGpsDoc->GetGpsListIndex();
		bDisabled = (nGpsListIndex == GPS_LIST_NONE) || bRecording;
	}

	pCmdUI->Enable(!bDisabled);
}

/************************************************************************
 *  MainFrm.cpp	  		 O n R t e T r a c k M v M a p P r e f 			*
 ************************************************************************/
void CMainFrame::OnRteTrackMvMapPref() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		ptMovingMap->Change(this);
	}
}

void CMainFrame::OnUpdateRteTrackMvMapPref(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen
	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();	
	pCmdUI->Enable(ptMovingMap != NULL);
}


/****************************************************************************
 *	MainFrm.cpp					M o v e M a p								*
 ****************************************************************************/
BOOL CMainFrame::MoveMap()
{
BOOL bOK = TRUE;

if (ptScMpDoc != NULL)
	{
	short nTrackCnt = ptTrackDoc->GetCnt();

	if (nTrackCnt == 0)
		{					// no track points recorded
		if (m_nView != D_TRACK)		
			{
			this->SwitchToView (D_TRACK);	// switch to ICAO map for track		
			}
		}
	else{
		double dLat, dLon;
		BOOL bShow = FALSE;
		CTrackPoint TrackPt;
		
		if (ptTrackDoc->GetTrackPointPtr (nTrackCnt-1, &TrackPt))
			{						
			if (TrackPt.GetLatLon (&dLat, &dLon))
				{
				bShow = TRUE;
				}
			else{
				bOK = FALSE;
				}
			}

		if (bShow)
			{
			if (m_nView != D_TRACK)		
				{
				this->SwitchToView (D_TRACK);	// switch to ICAO map for track		
				}

			CPfApp* ptApp = (CPfApp*)AfxGetApp();
			((CTrackView*)(ptApp->m_pTrackView))->DoCenter (dLat, dLon);
			}
		}
	}

	return bOK;
}

/****************************************************************************
 *	MainFrm.cpp				M o v e S c M a p								*
 ****************************************************************************/
BOOL CMainFrame::MoveScMap(CMovingMapDoc* ptMovingMap)
{
	BOOL bOK = TRUE;

	int nChangeMapLimit_mm = ptMovingMap->GetChangeMapLimit_mm();

	if (ptScMpDoc != NULL)
	{
		BOOL bRedraw = TRUE;
		short nTrackCnt = ptTrackDoc->GetCnt();

		if (nTrackCnt == 0)
		{					// no track points recorded
			if (ptScMpDoc->GetActMapIndex() >= 0)
			{				// show activated map
				if (m_nView != D_SCANTRACK)			// route view active
				{
				this->SwitchToView (D_SCANTRACK);		// switch to ICAO map for track		
				bRedraw = FALSE;
				}
			}
			else
			{				// no map selected, no track available
							// do nothing				
			bOK = FALSE;
			}
		}
		else
		{					// at least 1 track point available
			double dLat, dLon;
			BOOL bNeedNewMap=FALSE;
			BOOL bShow = FALSE;
			CTrackPoint TrackPt;

			if (ptTrackDoc->GetTrackPointPtr (nTrackCnt-1, &TrackPt))
			{						
				if (TrackPt.GetLatLon (&dLat, &dLon))
				{
					short nOldIndex = ptScMpDoc->GetActMapIndex();
					short nNewIndex=-1;

					if (ptMovingMap->KnowsStartLand())
					{				// try to get index of Visual Approach Chart to show
						short nIndexStartVAC = -1;
						if (ptScMpDoc->IsOnVAC (dLat, dLon, ptMovingMap->GetStartPos(), &nIndexStartVAC))
						{			// track point is near aerodrome of departure
							nNewIndex = nIndexStartVAC;
						}

						short nIndexLandVAC = -1;
						if (ptScMpDoc->IsOnVAC (dLat, dLon, ptMovingMap->GetLandPos(), &nIndexLandVAC))
						{			// track point is near aerodrome of destination
							nNewIndex = nIndexLandVAC;
						}

						if (nIndexStartVAC >= 0 && nIndexLandVAC >= 0 && nIndexStartVAC != nIndexLandVAC)
						{	// trackpoint is near both aerodromes
							double dDist1 = ptMovingMap->GetStartPos().LoxoDist(dLat, dLon);
							double dDist2 = ptMovingMap->GetLandPos().LoxoDist(dLat, dLon);
							nNewIndex = (dDist1 < dDist2)? nIndexStartVAC : nIndexLandVAC;
						}


						if (nNewIndex >= 0)
						{
							if (nNewIndex != nOldIndex)
							{						// activate visual approach chart
								ptScMpDoc->ActivateMap (nNewIndex);
								nOldIndex = nNewIndex;
							}
						}
					} // ptMovingMap->KnowsStartLand

			
					if (nOldIndex >= 0)
					{			// one map activated
						CScannedMap* ptMap = ptScMpDoc->GetMapPtr(nOldIndex);
						if (ptMap != NULL)
						{		// try to use activated map
							if (ptMap->IsNearBorder(dLat, dLon, nChangeMapLimit_mm)) 
										bNeedNewMap = TRUE;
								else 	bShow = TRUE;
						}
					}
					else
					{			// no map selected
						bNeedNewMap = TRUE;
					}				
				}
			}
		
			if (bNeedNewMap)
			{					// try to find best map
				CSize sizeTotal;
				if (ptScMpDoc->SearchNextMovingMap(ptTrackDoc, &sizeTotal))	// no parameter for track!!
					bShow = TRUE;
			}
		
			
			if (bShow)
			{
				if (m_nView != D_SCANTRACK)	
				{
					this->SwitchToView (D_SCANTRACK);	// switch to ICAO map for track		
					bRedraw = FALSE;
				}
				

				CView* ptActView = GetActiveView();
				if (ptActView->IsKindOf(RUNTIME_CLASS(CScanMapView)))
				{
					if (!((CScanMapView*)ptActView)->DoCenter (dLat, dLon, bRedraw))
					{
						bOK = FALSE;
					}
				}
			}
			else
			{					// no map to show
			bOK = FALSE;
			}
		}
	}

return bOK;
}



/************************************************************************
 *  MainFrm.cpp	  		 	O n T r a c k F r o m G P S					*
 ************************************************************************/
void CMainFrame::OnTrackFromGPS() 
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();

if (ptTrackDoc->ReadFromGPS(ptActView))
	{
	if (ptTrackDoc->GetCnt() > 1)
		{									// track available
		CPfApp* ptApp = (CPfApp*)AfxGetApp();
		((CTrackView*)(ptApp->m_pTrackView))->ShowFullRoute();
		
		if (m_nView < D_TRACK)				// route view active
			this->SwitchToView (D_TRACK);	// switch to mercator map for track
		}
	else{									// no track available
		if (m_nView >= D_TRACK)				// track view active
			this->SwitchToView (D_MAP);		// switch to mercator map for route
		}
	}
	else
	{
		CString szTitle;
		szTitle = CTextViewTool::Format (IDF_MAINFRM_TITLE, (LPCTSTR)ptTrackDoc->GetTitle());
		this->SetWindowText(szTitle);
		this->Invalidate(FALSE);
	}
}

void CMainFrame::OnUpdateTrackFromGPS(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL	bStoreTrack = FALSE;
	BOOL	bEnabled = FALSE;

	BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}

	CGpsDoc* ptGpsDoc = ptInit->GetGpsPtr();
	if (ptGpsDoc != NULL)
	{
		bStoreTrack = ptGpsDoc->ActGpsCanStoreTrack();

		short nGpsListIndex = ptGpsDoc->GetGpsListIndex();
		bEnabled =	(nGpsListIndex != GPS_LIST_NONE) &&
					(nGpsListIndex != GPS_LIST_OTHER) && 
					bStoreTrack;
	}

	pCmdUI->Enable(bEnabled && !bRecording);
}


/************************************************************************
 *  MainFrame.cpp	     S h o w S t a r t L a n d E r r				*
 ************************************************************************/
void CMainFrame::ShowStartLandErr ()
{
if (ptPlaneDoc != NULL)
	{						  // show warnings...
	CPlane	ActPlane;
	short nIndex = ptPlaneDoc->GetActIndex();

	if (ptPlaneDoc->GetPlanePtr(nIndex, &ActPlane))
		{
		CView* ptActView = GetActiveView();
		CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
		ASSERT_VALID(ptWayDoc);
		if (ptWayDoc != NULL)
			{				/* do prepare calculations		*/
			CCalculate* ptLegs = ptWayDoc->GetCalculationPtr();
			ptLegs->Activate(&ActPlane);
			if (ptLegs->DoConsumCalc (&ActPlane, ptMet, ptLoad))
				{
				CONSUMTYPE* ptC = ptLegs->GetConsPtr();
				if (ptC->bBadFuel1)		AfxMessageBox (IDS_BAD_FUEL1);
				if (ptC->bBadFuel2)		AfxMessageBox (IDS_BAD_FUEL2);
				if (ptC->bBadBalance)	AfxMessageBox (IDS_BAD_BALANCE);
				if (ptC->bBadElev1)		AfxMessageBox (IDS_NO_START_ELEV);
				if (ptC->bBadStart && !ptC->bBadElev1)	
										AfxMessageBox (IDS_BAD_START);
				if (ptC->bBadElev2)		AfxMessageBox (IDS_NO_LAND_ELEV);
				if (ptC->bBadLand && !ptC->bBadElev2)	
										AfxMessageBox (IDS_BAD_LAND);
				}
			else{	
				CString szMsg;
				CONSUMTYPE* ptC = ptLegs->GetConsPtr();
				if (ptC->nBadRowLoad > 0)	
					{
					szMsg.Format (IDF_BAD_ROW_LOAD, ptC->nBadRowLoad);
					AfxMessageBox (szMsg);
					}
				if (ptC->nBadLugLoad > 0)	
					{
					szMsg.Format (IDF_BAD_LUG_LOAD, ptC->nBadLugLoad);
					AfxMessageBox (szMsg);
					}
				if (ptC->nBadFuelLoad > 0)	
					{
					szMsg.Format (IDF_BAD_FUEL_LOAD, ptC->nBadFuelLoad);
					AfxMessageBox (szMsg);
					}
				}

			ptLegs->DeActivate();
			}
		}
	}
}



/************************************************************************
 *  MainFrm.cpp			O n V i e w X X X								*
 ************************************************************************/
void CMainFrame::OnViewCourse() 
{
	// TODO: Add your command handler code here
SwitchToView(D_COURSE);
}

void CMainFrame::OnViewLast() 
{
	// TODO: Add your command handler code here
SwitchToView (m_nOldView);

if (m_ptMapDoc->IsAborted())
	{							   // used if map aborted
	AfxMessageBox (NO_MERCATOR);
	}
}


void CMainFrame::OnViewMap() 
{
	// TODO: Add your command handler code here
	CView* ptActView = GetActiveView();
	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
	ASSERT_VALID(ptWayDoc);
	
	SwitchToView(D_MAP);	
}

/****************************************************************************
 *	MainFrm.cpp				C e n t e r L a t L o n O n M p					*
 *  Purpose: generates Map to view specified location						*
 *				must be called after SwitchToView (D_MAP)					*
 ****************************************************************************/
void CMainFrame::CenterLatLonOnMp(CLatLon LatLon)
{
	if (LatLon.IsValid())
	{
		ptInit->SetLatLonToCenter(LatLon.GetLat(), LatLon.GetLon());
		CView* ptActView = GetActiveView();
		if (ptActView->IsKindOf(RUNTIME_CLASS(CMapView)))
		{
			((CMapView*)ptActView)->ActivateCenterView();
			((CMapView*)ptActView)->Invalidate(FALSE);
		}
	}
}


/****************************************************************************
 *	MainFrm.cpp				O n V i e w M a p S c a n						*
 *  Purpose: called in OnToolBarScanMap and									*
 *					in OnToolBarSelectPrev, OnToolBarSelectNext				*
 ****************************************************************************/
void CMainFrame::OnViewMapScan() 
{
	// TODO: Add your command handler code here
	CView* ptActView = GetActiveView();
	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
	ASSERT_VALID(ptWayDoc);

	if (ptScMpDoc->GetMapCnt() > 0)
	{
		CLatLon LLtoCenter = ptInit->GetLatLonToCenter();

		if (LLtoCenter.IsValid())
		{
		//	CString szMsg;
		//	szMsg.Format ("Use stored pos to center = %f, %f", LLtoCenter.GetLat(), LLtoCenter.GetLon());
		//	AfxMessageBox (szMsg);
		}
		else
		{
			if (ptWayDoc->GetActLatLonPtr(&LLtoCenter))
			{
			//	CString szMsg;
			//	szMsg.Format ("Use ActWpt= %f, %f", LLtoCenter.GetLat(), LLtoCenter.GetLon());
			//	AfxMessageBox (szMsg);

				ptInit->SetLatLonToCenter(LLtoCenter.GetLat(), LLtoCenter.GetLon());
			}
		}


		if (ptScMpDoc->IsAutoSelectAllowed() &&
			!ptScMpDoc->IsActivatedCalibDlg()) 		// don`t deactivate new inserted map
		{
			if (LLtoCenter.IsValid())
				ptScMpDoc->ActivateScMapForLatLon(LLtoCenter);
		}

		SwitchToView(D_SCANMAP);

		if(LLtoCenter.IsValid())
			this->CenterLatLonOnScMp (LLtoCenter);

		ptScMpDoc->SetAutoSelect(TRUE);
		}
	else{
		AfxMessageBox (IDS_NOSCANMAP);
		}
}

/****************************************************************************
 *	MainFrm.cpp				C e n t e r L a t L o n O n S c M p	 			*
 *  Purpose: scrolls ScMap to view specified location						*
 *				must be called after SwitchToView (D_SCANMAP)				*
 ****************************************************************************/
BOOL CMainFrame::CenterLatLonOnScMp(CLatLon LatLon)
{
	BOOL bCentered = FALSE;

	if (LatLon.IsValid())
	{
		BOOL bRedraw = FALSE;		// if called after SwitchToView
		double dLat, dLon;			// get Lat Lon of activated WayPt
		
		dLat = LatLon.GetLat();
		dLon = LatLon.GetLon();

		CView* ptActView = GetActiveView();
		if (ptActView->IsKindOf(RUNTIME_CLASS(CScanMapView)))
		{
			if (((CScanMapView*)ptActView)->DoCenter (dLat, dLon, bRedraw))
			{
				bCentered = TRUE;
			}
		}
	}

	return bCentered;
}

/****************************************************************************
 *	MainFrm.cpp		C e n t e r L a s t T r a c k P t O n S c M p	 		*
 *  Purpose: scrolls ScMap to view last point of actual track.				*
 *				must be called after SwitchToView (D_SCANTRACK)				*
 ****************************************************************************/
BOOL CMainFrame::CenterLastTrackPtOnScMp(CTrackDoc* ptTrackDoc)
{
	BOOL bCentered = FALSE;

	if (ptTrackDoc != NULL)
	{
		
		if (ptTrackDoc->GetCnt() > 0)
		{
			BOOL bRedraw = FALSE;		// if called after SwitchToView
			double dLat, dLon;			// get Lat Lon of activated WayPt
			
			CTrackPoint TrackPt;
			if (ptTrackDoc->GetTrackPointPtr (ptTrackDoc->GetCnt()-1, &TrackPt))
			{						
				if (TrackPt.GetLatLon (&dLat, &dLon))
				{
					CView* ptActView = GetActiveView();
					if (ptActView->IsKindOf(RUNTIME_CLASS(CScanMapView)))
					{
						if (((CScanMapView*)ptActView)->DoCenter (dLat, dLon, bRedraw))
						{
							CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
							if (ptMovingMap != NULL)
							{
								if (!ptMovingMap->IsRecording())
									ptMovingMap->SetSymbolsOnView(FALSE);
							}

							bCentered = TRUE;
						}
					}
				}
			}
		}
	}

return bCentered;
}


void CMainFrame::OnViewElev() 
{
	// TODO: Add your command handler code here
SwitchToView(D_ELEV);
}


void CMainFrame::OnViewFuel() 
{
	// TODO: Add your command handler code here
SwitchToView(D_FUEL);

this->ShowStartLandErr ();	// Error message boxes
}

void CMainFrame::OnViewFlightPlan() 
{
	// TODO: Add your command handler code here
SwitchToView(D_FLIGHTPLAN);

if (ptFlPlDoc->GetDataMode () == DATA_MANUAL)
	{
	if (ptFlPlDoc->IsUpdateRequired	())
		{
		ptFlPlDoc->SetUpdateRequired (FALSE);
		AfxMessageBox (IDS_FLIGHTPLAN_AUTO);
		}
	}
}

void CMainFrame::OnViewWay() 
{
	// TODO: Add your command handler code here
SwitchToView(D_WAY);
}

void CMainFrame::OnViewPlane() 
{
	// TODO: Add your command handler code here
SwitchToView(D_PLANE);
}

void CMainFrame::OnViewLocList() 
{
	// TODO: Add your command handler code here
SwitchToView(D_LOCLIST);
}


void CMainFrame::OnViewTrack() 
{
	// TODO: Add your command handler code here
SwitchToView(D_TRACK);
}

void CMainFrame::OnViewTrackScan() 
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
//CTrackDoc* ptTrackDoc = (CTrackDoc*)ptActView->GetDocument();
//ASSERT_VALID(ptTrackDoc);

//if (ptScMpDoc->GetActMapIndex() >= 0)
if (ptScMpDoc->GetMapCnt() > 0)
	{
	ptScMpDoc->ActivateNearestMap(ptTrackDoc);
	SwitchToView(D_SCANTRACK);
	this->CenterLastTrackPtOnScMp(ptTrackDoc);
	}
else{
	AfxMessageBox (IDS_NOSCANMAP);
	}
}

   
void CMainFrame::OnViewTrackAlt() 
{
	// TODO: Add your command handler code here
SwitchToView(D_TRACKALT);
}

void CMainFrame::OnViewTrackSpd() 
{
	// TODO: Add your command handler code here
SwitchToView(D_TRACKSPD);
}



/************************************************************************
 *  MainFrm.cpp			O n U p d a t e V i e w X X X					*
 ************************************************************************/
void CMainFrame::OnUpdateViewCourse(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}


	pCmdUI->Enable(!bRecording &&
		!GetActiveView()->IsKindOf(RUNTIME_CLASS(CCourseView)));
}

void CMainFrame::OnUpdateViewMap(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}

    pCmdUI->Enable(!bRecording && (m_nView != D_MAP));
}

void CMainFrame::OnUpdateViewMapScan(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

		BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}

   
    if (m_bEnableNextCmd)
	{				// e.g.: case clicked into a map frame within the ScMpView!!
		pCmdUI->Enable(TRUE);	
		m_bEnableNextCmd = FALSE;		// reset flag now
	}
	else
	{				// standard update handling
		pCmdUI->Enable(!bRecording && (m_nView != D_SCANMAP) && ptScMpDoc->GetMapCnt() > 0);
	}
}


void CMainFrame::OnUpdateViewElev(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}


	pCmdUI->Enable(!bRecording &&
		!GetActiveView()->IsKindOf(RUNTIME_CLASS(CElevView)));
}

void CMainFrame::OnUpdateViewFuel(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}

	pCmdUI->Enable(!bRecording &&
		!GetActiveView()->IsKindOf(RUNTIME_CLASS(CFuelView)));
}

void CMainFrame::OnUpdateViewFlightPlan(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}

	pCmdUI->Enable(!bRecording &&
		!GetActiveView()->IsKindOf(RUNTIME_CLASS(CFlPlView)));
}

void CMainFrame::OnUpdateViewWay(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}

	pCmdUI->Enable(!bRecording &&
			!GetActiveView()->IsKindOf(RUNTIME_CLASS(CWayView)));
}

void CMainFrame::OnUpdateViewPlane(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	BOOL bRecording = FALSE;

	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
	{
		bRecording = ptMovingMap->IsRecording();
	}

	pCmdUI->Enable(!bRecording &&
		!GetActiveView()->IsKindOf(RUNTIME_CLASS(CPlaneView)));
}

void CMainFrame::OnUpdateViewTrack(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
pCmdUI->Enable((m_nView != D_TRACK) &&
	ptTrackDoc->GetCnt() > 1);
}

void CMainFrame::OnUpdateViewTrackScan(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

pCmdUI->Enable((m_nView != D_SCANTRACK) &&
	ptScMpDoc->GetMapCnt() > 0 &&
	ptTrackDoc->GetCnt() > 1);
}

void CMainFrame::OnUpdateViewTrackAlt(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
pCmdUI->Enable(
    !GetActiveView()->IsKindOf(RUNTIME_CLASS(CAltView)) &&
	ptTrackDoc->GetCnt() > 1);
}

void CMainFrame::OnUpdateViewTrackSpd(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
pCmdUI->Enable(
    !GetActiveView()->IsKindOf(RUNTIME_CLASS(CSpeedView)) &&
	ptTrackDoc->GetCnt() > 1);
}


void CMainFrame::OnUpdateViewSelViewToolBar(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
BOOL bVisible = ((m_wndTBSelView.GetStyle() & WS_VISIBLE) != 0);
pCmdUI->SetCheck(bVisible? 1 : 0);	
}

void CMainFrame::OnUpdateViewGpsTransToolBar(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
BOOL bVisible = ((m_wndTBGpsTrans.GetStyle() & WS_VISIBLE) != 0);
pCmdUI->SetCheck(bVisible? 1 : 0);	
}


void CMainFrame::OnUpdateViewMapSymbolToolBar(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
BOOL bVisible = ((m_wndTBMapSymbol.GetStyle() & WS_VISIBLE) != 0);
pCmdUI->SetCheck(bVisible? 1 : 0);	
}

void CMainFrame::OnUpdateViewWayptToolBar(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
BOOL bVisible = ((m_wndTBWaypt.GetStyle() & WS_VISIBLE) != 0);
pCmdUI->SetCheck(bVisible? 1 : 0);	
}


void CMainFrame::OnUpdateViewDrawMapToolBar(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
BOOL bVisible = ((m_wndTBDrawMap.GetStyle() & WS_VISIBLE) != 0);
pCmdUI->SetCheck(bVisible? 1 : 0);	
}


/************************************************************************
 *  MainFrm.cpp					O n C a l c R e v e r s e				*
 ************************************************************************/
void CMainFrame::OnCalcReverse() 
{
	// TODO: Add your command handler code here

CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

if (!bDemo)
	{
	BOOL bConfirm=ptWayDoc->IsModified();
	ptWayDoc->OnSaveDocument (ptWayDoc->GetPathName(), bConfirm);       
	}

BOOL bReverse = !ptWayDoc->IsReverse();
ptWayDoc->SetReverse (bReverse);	
if (bDemo) ptWayDoc->SetModifiedFlag (FALSE);




BOOL bUpDown = ptWayDoc->IsUpDown();
if (bUpDown)
	ptWayDoc->SetUpDown (FALSE);		// temporarily switch off upDown

ptWayDoc->InvertRoute ();


if (bUpDown)
	ptWayDoc->SetUpDown (TRUE);			// switch on upDown



//		    if (Display >= D_TRACK) break;
   // m_nView == D_TRACK...

ptWayDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
}

void CMainFrame::OnUpdateCalcReverse(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

if (ptWayDoc != NULL)
	{
	pCmdUI->Enable(ptWayDoc->GetWayPointCnt()>1);
	pCmdUI->SetCheck(ptWayDoc->IsReverse()? 1 : 0);	
	}
}



/************************************************************************
 *  MainFrm.cpp					O n C a l c S e m i	 					*
 ************************************************************************/
void CMainFrame::OnCalcSemi() 
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

BOOL bSemi = !ptWayDoc->IsSemi();
ptWayDoc->SetSemi (bSemi);	
ptWayDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
}

void CMainFrame::OnUpdateCalcSemi(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

if (ptWayDoc != NULL)
	{
	pCmdUI->Enable(ptWayDoc->GetWayPointCnt()>1);
	pCmdUI->SetCheck(ptWayDoc->IsSemi()? 1 : 0);
	}	
}

/************************************************************************
 *  MainFrm.cpp					O n C a l c E l e v 					*
 ************************************************************************/
void CMainFrame::OnCalcElev() 
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

BOOL bElev = !ptWayDoc->IsElev();
ptWayDoc->SetElev (bElev);	
ptWayDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
}

void CMainFrame::OnUpdateCalcElev(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

if (ptWayDoc != NULL)
	{
	BOOL bElevAvail = FALSE;
	if (ptElevDoc != NULL)
		bElevAvail = (ptElevDoc->GetElevCnt() > 0);
	pCmdUI->Enable(ptWayDoc->GetWayPointCnt()>1 && bElevAvail);
	pCmdUI->SetCheck(ptWayDoc->IsElev()? 1 : 0);
	}	
}


/************************************************************************
 *  MainFrm.cpp					O n C a l c U p D o w n					*
 ************************************************************************/
void CMainFrame::OnCalcUpdown() 
{
	// TODO: Add your command handler code here
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);


BOOL bUpDown = !ptWayDoc->IsUpDown();
ptWayDoc->SetUpDown (bUpDown);
ptWayDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
}

void CMainFrame::OnUpdateCalcUpdown(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

if (ptWayDoc != NULL)
	{
	pCmdUI->Enable(ptWayDoc->GetWayPointCnt()>1);
	pCmdUI->SetCheck(ptWayDoc->IsUpDown()? 1 : 0);
	}	
}

/************************************************************************
 *  MainFrm.cpp					O n C a l c O r t h o 					*
 ************************************************************************/
void CMainFrame::OnCalcOrtho() 
{
	// TODO: Add your command handler code here

CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

BOOL bOrtho = !ptWayDoc->IsOrtho();
ptWayDoc->SetOrtho (bOrtho);	

ptWayDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
}

void CMainFrame::OnUpdateCalcOrtho(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);

if (ptWayDoc != NULL)
	{
	pCmdUI->Enable(ptWayDoc->GetWayPointCnt()>1);
	pCmdUI->SetCheck(ptWayDoc->IsOrtho()? 1 : 0);	
	}
}

/************************************************************************
 *  MainFrm.cpp	  		 	O n C a l c W a y							*
 ************************************************************************/
void CMainFrame::OnCalcWay() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
ASSERT_VALID(ptWayDoc);
/* neu */
BOOL bAuto = !ptWayDoc->IsAutoRoute();
BOOL bChanged = ptWayDoc->SetAutoRoute (bAuto);	

if (bAuto && !bChanged)
	AfxMessageBox (IDS_BADAUTOROUTE);

if (bChanged)
	{
	CPfApp* ptApp = (CPfApp*)AfxGetApp();
	((CRouteView*)(ptApp->m_pMapView))->ShowFullRoute(); 

	ptWayDoc->UpdateAllViews(NULL);	// force a call to OnUpdate
	}
}

void CMainFrame::OnUpdateCalcWay(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen
//	if (Display >= D_TRACK) break;
CView* ptActView = GetActiveView();
CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
if (ptWayDoc != NULL)
	{
	pCmdUI->Enable(ptWayDoc->GetWayPointCnt()>1);
	pCmdUI->SetCheck(ptWayDoc->IsAutoRoute()? 1 : 0);	
	}
}

/************************************************************************
 *  MainFrm.cpp					O n C l o s e		 					*
 ************************************************************************/
void CMainFrame::OnClose() 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen

if (bDemo)
	{	// Note: only queries the active document
	CDocument* pDocument = GetActiveDocument();
	if (pDocument != NULL)		// dont save modified file in demo-mode
		pDocument->SetModifiedFlag(FALSE);
	}


this->SaveBarState(_T("PFWnd"));

/*	AfxGetApp()->WriteProfileInt(
		_T("PFWnd"),_T("Columns"),m_wndPaletteBar.GetColumns());
	AfxGetApp()->WriteProfileInt(
		_T("PFWnd"),_T("Color"),(m_bColor!=0));
	AfxGetApp()->WriteProfileInt(
		_T("PFWnd"),_T("ToolTips"),(m_bToolTips!=0));
*/

WINDOWPLACEMENT wp;
wp.length = sizeof wp;
if (GetWindowPlacement(&wp))
	{
	wp.flags = 0;
	if (this->IsZoomed())
		wp.flags |= WPF_RESTORETOMAXIMIZED;
		// and write it to the .INI file
	WriteWindowPlacement(&wp);
	}
	
CFrameWnd::OnClose();
}

void CMainFrame::OnToolbarDrawMap() 
{
	// TODO: Add your command handler code here
BOOL bTrack = (m_nView >= D_TRACK);
//this->SwitchToView (bTrack? D_TRACK : D_MAP );
if (bTrack)	this->OnViewTrack();
	else	this->OnViewMap();

}

void CMainFrame::OnUpdateTbDrawMap(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
BOOL bTrack = (m_nView >= D_TRACK);
pCmdUI->SetCheck (m_nView == (bTrack? D_TRACK : D_MAP));
}

void CMainFrame::OnToolbarScanMap() 
{
	// TODO: Add your command handler code here
BOOL bTrack = (m_nView >= D_TRACK);
//this->SwitchToView (bTrack? D_SCANTRACK : D_SCANMAP );
if (bTrack)	this->OnViewTrackScan();
	else	this->OnViewMapScan();
}

void CMainFrame::OnUpdateTbScanMap(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
BOOL bTrack = (m_nView >= D_TRACK);
pCmdUI->SetCheck (m_nView == (bTrack? D_SCANTRACK : D_SCANMAP));

if (ptScMpDoc != NULL)
	pCmdUI->Enable(ptScMpDoc->GetMapCnt() > 0);
}

void CMainFrame::OnToolbarSelectPrev() 
{
	// TODO: Add your command handler code here
	CView* ptActView = GetActiveView();
	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
	CLatLon LLtoCenter;

	if (ptWayDoc != NULL)
		{
		short nNextInd = ptWayDoc->GetActInd() - 1;
		ptWayDoc->SetActInd(nNextInd);
		}

	if (m_nView == D_MAP)		
	{
		ptWayDoc->GetActLatLonPtr(&LLtoCenter);
		this->CenterLatLonOnMp(LLtoCenter);
	}

	if (m_nView == D_SCANMAP)	this->OnViewMapScan();
}

void CMainFrame::OnUpdateTbSelectPrev(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	CView* ptActView = GetActiveView();
	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
	if (ptWayDoc != NULL)
	{
		pCmdUI->Enable(ptWayDoc->GetActInd() > 0);
	}	
}

void CMainFrame::OnToolbarSelectNext() 
{
	// TODO: Add your command handler code here
	CView* ptActView = GetActiveView();
	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();

	CLatLon LLtoCenter;
	if (ptWayDoc != NULL)
	{
		short nNextInd = ptWayDoc->GetActInd() + 1;
		ptWayDoc->SetActInd(nNextInd);
	}

	ShowActWaypoint(ptWayDoc);
}

void CMainFrame::ShowActWaypoint(CWayDoc* ptWayDoc)
{
	CLatLon LLtoCenter;
	if (ptWayDoc != NULL)
		ptWayDoc->GetActLatLonPtr(&LLtoCenter);

	if (m_nView == D_MAP)		this->CenterLatLonOnMp(LLtoCenter);
	if (m_nView == D_SCANMAP)	this->OnViewMapScan();
}

void CMainFrame::OnUpdateTbSelectNext(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	CView* ptActView = GetActiveView();
	CWayDoc* ptWayDoc = (CWayDoc*)ptActView->GetDocument();
	if (ptWayDoc != NULL)
	{
		pCmdUI->Enable(ptWayDoc->GetActInd() < ptWayDoc->GetWayPointCnt()-1);
	}	
}




void CMainFrame::OnBeep() 
{
	// TODO: Add your command handler code here
ptInit->SetSaveSignal (!ptInit->IsSaveSignal());
if (ptInit->IsSaveSignal())
	MessageBeep (MB_OK);
}

void CMainFrame::OnUpdateBeep(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
pCmdUI->SetCheck (ptInit->IsSaveSignal());	
}

