// MainFrm.h : interface of the CMainFrame class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__587F6A0B_F1A8_11D1_BFB4_AFAC529C17B9__INCLUDED_)
#define AFX_MAINFRM_H__587F6A0B_F1A8_11D1_BFB4_AFAC529C17B9__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


    enum eView {D_COURSE = 1, 
				D_MAP, 
				D_SCANMAP,
				D_ELEV,
				D_FUEL, 
				D_FLIGHTPLAN,
				D_WAY,
				D_PLANE,
				D_LOCLIST,
				D_TRACK,
				D_SCANTRACK,
				D_TRACKALT,
				D_TRACKSPD
				};						


class CLatLon;
class CLocation;
class CWayDoc;
class CTrackDoc;
class CMapDoc;
class CMovingMapDoc;
class CMainFrame : public CFrameWnd
{

private:
    void SwitchToView(eView nView);
	
protected: // create from serialization only
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

// Attributes
private:
	eView			m_nView;
	eView			m_nOldView;		// case bad map view: switch back
	CMapDoc*		m_ptMapDoc;
	UINT			m_uTimer;
	BOOL			m_bEnableNextCmd;

#define CALIB_TIMER 3

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
	eView GetTypeOfView () { return m_nView; }	// see: WayDoc
	void EnableNextCmd() { m_bEnableNextCmd = TRUE; }
	void CenterLatLonOnMp(CLatLon LatLon);
	BOOL CenterLatLonOnScMp(CLatLon LatLon);
	BOOL CenterLastTrackPtOnScMp(CTrackDoc* ptTrackDoc);
	void ShowActWaypoint(CWayDoc* ptWayDoc);

private:
	CString GetStatusSpeedString();
	CString GetStatusAltString ();
	CString GetStatusAlt_ElevString();
	void DockControlBarRightOf(CToolBar* RightOf, CToolBar* ptBar);
	BOOL AddToolbar(CToolBar* ptBar, UINT uRsrcID, UINT uStrID, UINT uWndID);
	void ShowStartLandErr ();
	BOOL MoveMap();
	BOOL MoveScMap(CMovingMapDoc* ptMovingMap);
	void SwitchToTrack();
	void SwitchToRte();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CStatusBar  m_wndStatusBar;
	CToolBar    m_wndTBFile;
	CToolBar    m_wndTBSelView;
	CToolBar    m_wndTBGpsTrans;
	CToolBar    m_wndTBMapSymbol;
	CToolBar	m_wndTBWaypt;
	CToolBar	m_wndTBDrawMap;

// Generated message map functions

protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnMiscCalculator();
	afx_msg void OnInpLoad();
	afx_msg void OnCalcPref();
	afx_msg void OnInpAppendix();
	afx_msg void OnMiscFlpl();
	afx_msg void OnMiscMaps();
	afx_msg void OnMiscGps();
	afx_msg void OnLocEdit();
	afx_msg void OnLocRegions();
	afx_msg void OnLocUpdate();
	afx_msg void OnLocReadFromGPS();
	afx_msg void OnLocWriteToGPS();
	afx_msg void OnLocMerge();
	afx_msg void OnLocElev();
	afx_msg void OnLocElevArray();
	afx_msg void OnLocAirspace();
	afx_msg void OnInpMet();
	afx_msg void OnInpPlane();
	afx_msg void OnInpRoute();
	afx_msg void OnRteToGPS();
	afx_msg void OnRteToGCAS();
	afx_msg void OnRteToKML();
	afx_msg void OnRteFromGPS();

	afx_msg void OnRteTrackNew();
	afx_msg void OnRteTrackOpen();
	afx_msg void OnRteTrackSaveAs();
	afx_msg void OnRteTrackSaveAsKML();
	afx_msg void OnRteTrackMovingMap();
	afx_msg void OnRteTrackRoute();
	afx_msg void OnRteTrackMvMapPref();

	afx_msg void OnUpdateRteTrackNew(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRteTrackOpen(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRteTrackSaveAs(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRteTrackSaveAsKML(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRteTrackMovingMap(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRteTrackRoute(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRteTrackMvMapPref(CCmdUI* pCmdUI);

	afx_msg void OnTrackFromGPS();
	afx_msg void OnViewCourse();
	afx_msg void OnViewLast();
	afx_msg void OnViewMap();
	afx_msg void OnViewMapScan();
	afx_msg void OnViewElev();
	afx_msg void OnViewFuel();
	afx_msg void OnViewFlightPlan();
	afx_msg void OnViewWay();
	afx_msg void OnViewPlane();
	afx_msg void OnViewLocList();
	afx_msg void OnViewTrack();
	afx_msg void OnViewTrackScan();
	afx_msg void OnViewTrackAlt();
	afx_msg void OnViewTrackSpd();
	afx_msg void OnMiscFonts();
	afx_msg void OnMiscDim();
	afx_msg void OnViewColors();
	afx_msg void OnViewSelViewToolBar();
	afx_msg void OnViewGpsTransToolBar();
	afx_msg void OnViewMapSymbolToolBar();
	afx_msg void OnViewWayptToolBar();
	afx_msg void OnViewDrawMapToolBar();
	afx_msg void OnUpdateViewCourse(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewElev(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewFuel(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewMap(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewMapScan(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewFlightPlan(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewWay(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewPlane(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewTrack(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewTrackScan(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewTrackAlt(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewTrackSpd(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewSelViewToolBar(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewGpsTransToolBar(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewMapSymbolToolBar(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewWayptToolBar(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewDrawMapToolBar(CCmdUI* pCmdUI);
	afx_msg void OnCalcWay();
	afx_msg void OnUpdateCalcWay(CCmdUI* pCmdUI);
	afx_msg void OnCalcOrtho();
	afx_msg void OnUpdateCalcOrtho(CCmdUI* pCmdUI);
	afx_msg void OnCalcSemi();
	afx_msg void OnUpdateCalcSemi(CCmdUI* pCmdUI);
	afx_msg void OnCalcElev();
	afx_msg void OnUpdateCalcElev(CCmdUI* pCmdUI);
	afx_msg void OnCalcUpdown();
	afx_msg void OnUpdateCalcUpdown(CCmdUI* pCmdUI);
	afx_msg void OnCalcReverse();
	afx_msg void OnUpdateCalcReverse(CCmdUI* pCmdUI);
	afx_msg void OnLocHome();
	afx_msg void OnUpdateRteFromGps(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRteToGps(CCmdUI* pCmdUI);
	afx_msg void OnUpdateTrackFromGPS(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRteToGCAS(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRteToKML(CCmdUI* pCmdUI);
	afx_msg void OnClose();
	afx_msg void OnToolbarDrawMap();
	afx_msg void OnUpdateTbDrawMap(CCmdUI* pCmdUI);
	afx_msg void OnToolbarScanMap();
	afx_msg void OnUpdateTbScanMap(CCmdUI* pCmdUI);
	afx_msg void OnToolbarSelectPrev();
	afx_msg void OnUpdateTbSelectPrev(CCmdUI* pCmdUI);
	afx_msg void OnToolbarSelectNext();
	afx_msg void OnUpdateTbSelectNext(CCmdUI* pCmdUI);
	afx_msg void OnBeep();
	afx_msg void OnUpdateBeep(CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnLocImport();
	//}}AFX_MSG
	afx_msg void OnUpdateStatusLatLon (CCmdUI* pCmdUI);
	afx_msg void OnUpdateStatusElev (CCmdUI* pCmdUI);
	afx_msg void OnUpdateStatusSpeed (CCmdUI* pCmdUI);
	afx_msg void OnSelectPlane (UINT nID);
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__587F6A0B_F1A8_11D1_BFB4_AFAC529C17B9__INCLUDED_)
