#ifndef __MAP__
#define __MAP__

#include "..\Cpptools\Image.h"

// Map.h : interface of the CMap class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
		   
typedef short (*ScaleProcPtr)(double dVal, double dGrid, CString* ptScale);
typedef double (*MapProcPtr)(double dVal);

#define ANISOTROPIC 0
#define ISOTROPIC 1


class CBorder : public CObject
{         
private:
		BOOL	m_bBorder;
		BOOL	m_bAroundWorld;
		double	m_oldLon, m_LeftAngle, m_RightAngle, m_AngleFromStart;
		double	m_LonFirst;

		DRECT	m_rBaseLatLon;		// minimal area for route,
		double	m_dCenterLat;
		double	m_dCenterLon;

public:
	void Init (double fLat, double fLon);										 
	void Expand (double fLat, double fLon);
	void Finish ();
	BOOL IsValid() { return m_bBorder; }
	DRECT CenterBorderFor (double dLat, double dLon);
	void SetBorderFor (double dLat, double dLon);
	DRECT GetLatLonRect () { return m_rBaseLatLon; }
	static double FlightAngle (double A, double B);

public:
	CBorder();
	virtual ~CBorder();  
};


// DRECT is defined in PF.h
class CSymbols;		
class CLocation;	 
class CMap : public CObject
{         
DECLARE_SERIAL(CMap)

private:
		CDC*	m_pDC;
		int		m_LineY;
		int		m_CharX;
		BOOL	m_bPrinter;
		BOOL	m_bDraw;
		BOOL	m_bValid;

		double	m_dGridX;
		double	m_dGridY;
		short	m_nLPSKx;		  	// Breite der Y- und Hhe der X-Skala
		short	m_nLPSKy;

 		DRECT	m_rLatLon;			// visible lat lon area, changes with scaling factor
		RECT	m_rMaxLP;			// log. area of window to draw
		RECT	m_rGridLP;			// area of grid 

		short	m_nXLabelLP;
		short	m_nYLabelLP;				// size of text on Y-Axis
		ScaleProcPtr m_ScaleTextX;
		ScaleProcPtr m_ScaleTextY;
		CString	m_szTitle;
        
		double	m_LPx0;
		double  m_LPy0;
		double	m_dFaktX;
		double	m_dFaktY;

		MapProcPtr	m_MapXtoLP;
		MapProcPtr	m_MapYtoLP;
		MapProcPtr	m_MapLPtoX;
		MapProcPtr	m_MapLPtoY;
		short	m_nMode;
			

		BOOL	m_bAntipod;			// 170E ... 180 ... 170W
		BOOL	m_bXfits;

		CColorDoc* 	m_ptColor;
		CMapDoc*	m_ptMapDoc;

protected: // create from serialization only

// Attributes
public:
	BOOL IsValid () { return m_bValid; }

	BOOL IsAntipod () { return m_bAntipod; }
	void SetTitle (CString szTitle);	// for printing only

	void GetLabelSize (double dGridX, double dGridY,
						short* ptLabelLP_X, short* ptLabelLP_Y);
	double GetGridX (DRECT& rLatLon);
	DRECT GetBorder () { return m_rLatLon; }
	BOOL Expand (DRECT rMapMin, CRect& rMaxLP, BOOL bPrinter, DRECT* ptVirtMap);

	void Calculate (DRECT rMinLatLon, CRect& rMaxLP, BOOL bPrinter);
	void CalculateGraph (CDC* pDC, DRECT rMap, CRect& rMaxLP, BOOL bPrinter, short nGridX, short nGridY);
	DRECT UseFullView (BOOL bXfits, DRECT rMapMin, CRect rView);
	void ScrollBorder (CPoint pActScroll, CPoint pInitScroll);

	void DrawLocation (CLocation& Loc, CSymbols& Symbols);
	void GetLabelStartLP(long LPx1, long LPy1, double dAngle, long LineY,
								   long* ptLPx, long* ptLPy);
	void DrawLabel (long LPx1, long LPy1, double TextAngle, long LineY, 
				BOOL bRightAlign, CString szLoc, short nSizeLP, BOOL bActWpt=FALSE);


	long GetScale (long lHorzResDPI);	
	void GetLatLonBorder (DRECT* ptLatLon);


	double RoundUpY (double dMinLat, double dGridY);								
	double RoundDownX (double dMaxLon, double dGridX);								
	void DrawGrid (CDC* pDC, int CharX, int LineY, int* ptX, int* ptY);

	void XYtoLP (double dXval, double dYval, long* LPx, long* LPy);
	void LPtoXY (long LPx, long LPy, double* ptXval, double* ptYval);

	void XYtoLP (double dXval, double dYval, double* LPx, double* LPy);
	void LPtoXY (double LPx, double LPy, double* ptXval, double* ptYval);

	CRect GetGridRect() { return (CRect)m_rGridLP; }
	void SetGridRect (CRect rRect) { m_rGridLP = rRect; }
	CDC* GetDCPtr() { return m_pDC; }

	void Clip(BOOL bOn);

	static void RectAlignLeft (CDC* pDC, int Xleft, int Ybot, int LineY,
				short nSizeLP, BOOL bFrame);
	static void RectAlignRight (CDC* pDC, int Xright, int Ybot, int LineY,
				short nSizeLP, BOOL bFrame);

// Operations
private:     

	void TextAlignLeft (CDC* pDC, long X, long Y, CString szText);
	void TextAlignCenter (CDC* pDC, long X, long Y, CString szText);
	void TextAlignRight (CDC* pDC, long X, long Y, CString szText);

	void GetRequiredSizeLP (DRECT& rLatLon, double* ptReqWidthLP, double* ptReqHeightLP);
	void Transform (DRECT rMap, CRect& rView, BOOL bPrinter, short LPSKx=0, short LPSKy=0);

    						  
// Implementation
public:
	CMap();
	CMap(	MapProcPtr MapXtoLP, MapProcPtr MapYtoLP, 
			MapProcPtr MapLPtoX, MapProcPtr MapLPtoY,
			ScaleProcPtr TextX, ScaleProcPtr TextY, short nMode);
	virtual ~CMap();  
	
};

/////////////////////////////////////////////////////////////////////////////
#endif
