/************************************************************************
 *  							M a p D o c . c p p  					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "LatLon.h"
#include "MapDoc.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL bDemo;

/////////////////////////////////////////////////////////////////////////////
// CMapDoc
IMPLEMENT_DYNCREATE(CMapDoc, CDocument)

BEGIN_MESSAGE_MAP(CMapDoc, CDocument)
	//{{AFX_MSG_MAP(CMapDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/****************************************************************************
 *  MapDoc.cpp	  		 	 C M a p D o c 						Constructor	*
 ****************************************************************************/
CMapDoc::CMapDoc()
{                                      
memset (m_ptShowFlags, 0, FLAG_CNT*sizeof (BOOL));

m_dLat = NO_KOORD;
m_dLon = NO_KOORD;
m_bRouteInScanMap = TRUE;
m_bAborted = FALSE;

this->Activate (SHOW_APT, TRUE);
this->Activate (SHOW_REP, TRUE);
this->Activate (SHOW_VOR, TRUE);

if (bDemo)
	this->Activate (SHOW_AIRSPACE, TRUE);
}

/****************************************************************************
 *  MapDoc.cpp	  					~ C M a p D o c							*
 ****************************************************************************/
CMapDoc::~CMapDoc()
{
}

/****************************************************************************
 *	MapDoc.cpp					A c t i v a t e 							*
 ****************************************************************************/										 
void CMapDoc::Activate (short nTypeID, BOOL bActivate)
{
*(m_ptShowFlags + nTypeID) = bActivate;
}

/****************************************************************************
 *	MapDoc.cpp					I s A c t i v a t e d						*
 ****************************************************************************/										 
BOOL CMapDoc::IsActivated (short nTypeID)
{
return *(m_ptShowFlags + nTypeID);
}

/****************************************************************************
 *	MapDoc.cpp			I n v e r t A c t i v a t e S t a t e				*
 ****************************************************************************/										 
void CMapDoc::InvertActivateState (short nTypeID)
{
*(m_ptShowFlags + nTypeID) = !(*(m_ptShowFlags + nTypeID));
}

/****************************************************************************
 *  MapDoc.cpp	  				S e t L a t L o n	 						*
 ****************************************************************************/
void CMapDoc::SetLatLon (double dLat, double dLon)
{
m_dLat = dLat;
m_dLon = dLon;
}

/****************************************************************************
 *  MapDoc.cpp	  				G e t L a t L o n	 						*
 ****************************************************************************/
CLatLon CMapDoc::GetLatLon ()
{
	CLatLon ActPos (m_dLat, m_dLon);
	return ActPos;
}

/****************************************************************************
 *  MapDoc.cpp	  			G e t L a t L o n S t r i n g					*
 *  Purpose: prepares Lat-Lon-String to show in stauts bar					*
 ****************************************************************************/
CString CMapDoc::GetLatLonString ()
{
CString szLatLon;
if (m_dLat != NO_KOORD && m_dLon != NO_KOORD)
	{
	CLatLon llMouse(m_dLat, m_dLon);
	llMouse.CreateLatLonStr (&szLatLon, LATLON_STAT);
	}
else{
	
	}
return szLatLon;
}

/****************************************************************************
 *  MapDoc.cpp	  					S e r i a l i z e 						*
 ****************************************************************************/
void CMapDoc::Serialize(CArchive& ar)
{    
int nCnt, i;

if (ar.IsStoring())
	{
		// TODO: add storing code here  
	ar << (int)FLAG_CNT; 
	for (i=0; i<(WORD)FLAG_CNT; i++)
		ar << m_ptShowFlags[i];	// show APT, REP, INT, NDB, VOR, USR, SAIL, HELI, LABEL, MAPS, ELEV
	}
else{
		// TODO: add loading code here  
	ar >> nCnt;
	for (i=0; i<nCnt; i++)
		ar >> m_ptShowFlags[i];	// show APT, REP, INT, NDB, VOR, USR, SAIL, HELI, LABEL, MAPS, ELEV

	for (i=nCnt; i<(int)FLAG_CNT; i++)	// if nCnt < FLAG_CNT:
		m_ptShowFlags[i] = FALSE;	// set rest = FALSE 

	if (bDemo)
		this->Activate (SHOW_AIRSPACE, true);
	}
}
