#ifndef __MAP_DOC__
#define __MAP_DOC__

/************************************************************************
 *  							M a p D o c . h 	 					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#define SHOW_APT		0
#define SHOW_REP		1
#define SHOW_INT		2
#define SHOW_NDB		3
#define SHOW_VOR		4
#define SHOW_USR		5
#define SHOW_SAIL		6
#define SHOW_HELI		7
#define SHOW_LABEL		8
#define SHOW_MAP		9
#define SHOW_ELEV		10
#define SHOW_AIRSPACE	11

#define FLAG_CNT	12	// for: APT, REP, INT, NDB, VOR, USR, SAIL, HELI, LABEL, MAPS, ELEV, AIRSPACE

class CLatLon;
class CMapDoc : public CDocument
{ 
protected: // create from serialization only
	DECLARE_DYNCREATE(CMapDoc)

protected:   

// Attributes
private:				
	BOOL	m_ptShowFlags[FLAG_CNT];	// show APT, REP, INT, NDB, VOR, USR, HELI, LABEL, MAPS, ELEV
	double	m_dLat;
	double	m_dLon;
	BOOL	m_bRouteInScanMap;
	WORD	m_wCmdID;
	BOOL	m_bAborted;
// Operations
public:
	CMapDoc();	
	~CMapDoc();  
	
	void SetLatLon (double dLat, double dLon);
	CLatLon GetLatLon ();

	void SetRouteInScanMap	(BOOL bSet){m_bRouteInScanMap = bSet;}
	void SetAborted (BOOL bSet) { m_bAborted = bSet; }
	void SetCmdID (WORD wCmd) {	m_wCmdID=wCmd; }
	WORD GetCmdID () { return m_wCmdID;	}

	BOOL IsRouteInScanMap () { return m_bRouteInScanMap; } 
	BOOL IsAborted() { return m_bAborted; }

	CString GetLatLonString ();

	void Activate (short nTypeID, BOOL bActivate);
	BOOL IsActivated (short nTypeID);
	void InvertActivateState (short nTypeID);
	 
	void Serialize(CArchive& ar);
   
// Implementation
protected:          

	// Generated message map functions
protected:
	//{{AFX_MSG(CMapDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 
