#ifndef __MAPVIEW__
#define __MAPVIEW__

// MapView.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "BmpView.h"
#include "Map.h"				// includes CBorder class

/////////////////////////////////////////////////////////////////////////////
// Ansicht CMapView 
#define L0_LAT		-90.			/* Breitengrad		*/
#define L1_LAT		90.	
#define L0_LON		-180.			/* Laengengrad		*/
#define L1_LON		180.	

class CWayPoint;
class CWayDoc;
class CLaLoList;
class CInteractiveMap;
class CAirspace;
class CAirspaceSegmentDoc;
class CMapView : public CBitmapView
{
private:
	typedef enum
	{
		FOR_SCREEN,
		FOR_PRINTER,
		FOR_FILE
	} IMAGETARGET;

	IMAGETARGET m_Target;

public:
	CMapView();           // Dynamische Erstellung verwendet geschtzten Konstruktor
	DECLARE_DYNAMIC(CMapView)

// Attribute
public:
	CBorder m_Border;
	BOOL	m_bMore;
	BOOL	m_bForPrinter;
	BOOL	m_bDraw;
	DWORD 	m_dwLinesPerPage;
                             	                 
    int		m_dX, m_dY;
	int		m_Xleft, m_Xright; 
	int		m_Ybottom;
                          				// font handling
    WORD	m_wPointSize; 
	TCHAR	m_FontName[LF_FACESIZE]; 
	int		m_lfHeight;

protected:
	CMap*	m_ptMercator;

//  (frher: m_rMapBorder)
	DRECT	m_rVirtualLatLon;	// lat lon on rVirtLP, unchanged while scaling
							// but changed for new center position
	//(frher: m_rMap)
	DRECT	m_rVisibleLatLon;			// lat lon on visible map area, changes with scaling factor
							// for scaling factor = 1, m_rVisibleLatLon = m_rVirtualLatLon


	BOOL	m_bInitialView;
	BOOL	m_bCenterView;

	CPoint  m_pScrollBarSizeLP;
	CPoint	m_pMouseLP;

	CPoint		m_pInitScroll;
	CLaLoList*	m_ptLaLoList;	// list of possible map entries
	CMapDoc*	m_ptMapDoc;
	CString		m_szMapTitle;

private:
	CInteractiveMap*	m_ptInterMap;
	CImage*				m_ptImage;		// background image to show elevation in colors
	BOOL				m_bTBMapCenter;

	double	m_dActFakt;
	short	m_nIncreaseCnt;
	CSize	m_sVirt;
	BOOL	m_bScrollBarsOn;
	double  m_dSFx, m_dSFy;
	CDC*	m_ptDC;			// pointer stored for RteCriticalLeg

							// last used parameters to draw backgound image
	BOOL m_bSeaCT;			// used to create new image for storing into file
	BOOL m_bFlightCT;
	long m_lElev_m;
	CRect m_rClientLP;


// Operationen
protected:
	BOOL LegIsAntipod (double dLon0, double dFlightAngle);
	void ChangeMapSide (CDC* pDC, long LPx0, long LPy0, 
						double dWptLat, double dWptLon, 
						CPoint* ptLeaveSideLP, CPoint* ptEnterSideLP);
	virtual void DrawOnMap (CDC* pDC, BOOL bAntipod) = 0;

	CFont* ChangeFont (CDC* pDC, CFont* ptNewFont, int* ptCapsX, int* ptLineY);
	BOOL CreateNewFont (CFont* ptFont);

public:
	void ActivateInitialView();
	void ActivateCenterView();
	void SetMapTitle (CString szTitle) { m_szMapTitle = szTitle; }
//	CString GetMapTitle() { return m_szMapTitle; }
	CImage*	GetImagePtr() { return m_ptImage; }

public:
	void ChooseFont();      
	void ActivateDrawing (BOOL bDraw) { m_bDraw = bDraw; }
	void TextRotate (CDC* pDC, long lX, long lY, double dAngle, CString szText);
	void TextAlignLeft (CDC* pDC, short nX, short nY, CString szText);
	void TextAlignCenter (CDC* pDC, short nX, short nY, CString szText);
	void RsrcAlignCenterEx (CDC* pDC, short nX, short nY, short nID, ...);


	void GetMaxRectLP (CDC* pDC, CWnd* ptWnd, LPRECT lpRectMax, BOOL bPrinter);
	CRect GetUseableRectLP (CDC* pDC = NULL);
	CSize GetVirtSize (short nIncreaseCnt, CRect rView);

	CRect RectAround (CPoint pFix, CSize sVirtLP, double dFakt);
	DRECT GetVisibleMapRect (DRECT rVirtMap, CSize sVirtLP,
				double dSFx, double dSFy);

	void DrawScannedMaps (CDC* pDC, DRECT rLatLon);
	void DrawElevAreas (CDC* pDC, DRECT rLatLon);
	long DistanceToLP(double dLat, double dLon, double* LPx, double* LPy,
							double dDist, short nDistDim);
	long DistanceToLP(double dLat, double dLon, long* LPx, long* LPy,
							double dDist, short nDistDim);
	BOOL DrawSegments (CDC* pDC, DRECT rLatLon, CAirspace* ptAirspace,
								CAirspaceSegmentDoc* ptSegDoc, long lStartIndex, double dLonOffset);
	void DrawAirspaces (CDC* pDC, DRECT rLatLon, long lMapScale, long LineY);

	BOOL GetMovingMapAlt_m(long* ptAlt_m);
	BOOL SaveImage();
	BOOL DrawElevImage(CDC* pDC, CRect rView, DRECT rMap, long lElev_m, BOOL bSeaCT);
	BOOL DrawMap (CDC* pDC, DWORD* ptIndex);

	double GetLonForAntipodMap (double dLon);
	void DoCenterLatLon(double dLat, double dLon);
	void DoCenter(double dLat, double dLon);
	void SetBorderFor (double dLat, double dLon);

	CWayDoc* GetDocument();
	BOOL SearchDataBase (float fLat, float fLon, CWayPoint* ptWayPt);
	void ResetScroll ();
	void HideScrollBars();

	CMap*	GetMapPtr () { return m_ptMercator; }		// for RteCriticalLeg
	void	SetDCPtr (CDC* ptDC) { m_ptDC = ptDC; }		
	CDC*	GetDCPtr () { return m_ptDC; }


private:
	short Y_PointToLP (CDC* pDC, WORD wPointSize);
	void YtoLat (double* ptLat);
	void XtoLon (double* ptLon);

	void LPtoLatLon (long lLPx, long lLPy, double* ptLat, double* ptLon);
	void DPtoLatLon (CDC* pDC, long lDPx, long lDPy, double* ptLat, double* ptLon);

	void LPtoLatLon (double lLPx, double lLPy, double* ptLat, double* ptLon);

	void ScrollToScaledPos (CRect rView);
	void GetScrollFaktors (double* ptSFx, double* ptSFy,
							CSize sVirt, CRect rView);

	void CenterLP(CPoint PosLP);

	void GenerateWhiteImage(LPSTR lpData, long lHeight, long lFileRowBytes);

	void GenerateElevImage(LPSTR	lpData, CElevArray* ptElevArray, 
							 DRECT rMap, DRECT rElevArray, CRect rClientLP,
							 double dXImageResPerClientRes, double dYImageResPerClientRes,
							 long lFileRowBytes, long lPixHeight);

	BOOL GetRectForAntipodMap (DRECT* ptElevArray, DRECT rMap);
	LPSTR Create256ImageLP(	CRect rClientLP, DRECT rMap, 
							long lPixWidth, long lPixHeight,
							double dXImageResPerClientRes, double dYImageResPerClientRes,
							WORD* ptBitCount, LONG* ptFileRowBytes);


// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CMapView)
	public:
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
	virtual void OnInitialUpdate();
	virtual BOOL OnScroll(UINT nScrollCode, UINT nPos, BOOL bDoScroll = TRUE);
	protected:
	virtual void OnDraw(CDC* pDC);      // berschrieben zum Zeichnen dieser Ansicht
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementierung
protected:
	virtual ~CMapView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generierte Nachrichtenzuordnungsfunktionen
protected:
	//{{AFX_MSG(CMapView)
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnMenuRegion();
	afx_msg void OnMenuCenter();
	afx_msg void OnMenuLarger();
	afx_msg void OnMenuSmaller();
	afx_msg void OnMenuAPT();
	afx_msg void OnMenuREP();
	afx_msg void OnMenuINT();
	afx_msg void OnMenuNDB();
	afx_msg void OnMenuVOR();
	afx_msg void OnMenuUSR();
	afx_msg void OnMenuSAIL();
	afx_msg void OnMenuHELI();
	afx_msg void OnMenuMAP();
	afx_msg void OnMenuELEV();
	afx_msg void OnMenuAirspace();
	afx_msg void OnMenuInsert  ();
	afx_msg void OnMenuAppend  ();
	afx_msg void OnMenuBear    ();
	afx_msg void OnMenuDelete  ();
	afx_msg void OnMenuActivate();
	afx_msg void OnMenuPlAlt();
	afx_msg void OnMenuMeEditMapLoc (UINT nID);
	afx_msg void OnMenuMeEditAirspace (UINT nID);
	afx_msg void OnMenuInsMapLoc (UINT nID);
	afx_msg void OnMenuAppMapLoc (UINT nID);
	afx_msg void OnMenuBearMapNav (UINT nID);
	afx_msg void OnMenuDelRteWpt (UINT nID);
	afx_msg void OnMenuActRteWpt (UINT nID);
	afx_msg void OnMenuPlAltRteWpt (UINT nID);
	afx_msg void OnUpdateWyIns(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWyApp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWyBear(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWyDel(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWyAct(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWyPlAlt(CCmdUI* pCmdUI);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnEditCopy();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnTBMapCenter();
	afx_msg void OnUpdateAirport(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNdb(CCmdUI* pCmdUI);
	afx_msg void OnUpdateIntersect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateReport(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVor(CCmdUI* pCmdUI);
	afx_msg void OnUpdateUsr(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSail(CCmdUI* pCmdUI);
	afx_msg void OnUpdateHeli(CCmdUI* pCmdUI);
	afx_msg void OnUpdateMapFrames(CCmdUI* pCmdUI);
	afx_msg void OnUpdateElev(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAirspace(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

							 // gets m_pDocument from base class
#ifndef _DEBUG  // debug version in mapview.cpp
inline CWayDoc* CMapView::GetDocument()
   { return (CWayDoc*)m_pDocument; }
#endif


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio fgt zustzliche Deklarationen unmittelbar vor der vorhergehenden Zeile ein.

#endif // __MAPVIEW__
