// metdlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h" 

#include "DimDoc.h"         
#include "MetDoc.h"
#include "metdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc* ptDim;

/////////////////////////////////////////////////////////////////////////////
// CMetDlg dialog


CMetDlg::CMetDlg(CWnd* pParent, CMetDoc* ptDoc)
	: CDlgTool(CMetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMetDlg)
	m_nTemp1 = 0;
	m_fQNH1 = 0;
	m_bWet1 = FALSE;
	m_nWindDir01 = 0;
	m_nWindSpd01 = 0;
	m_nWindDir03 = 0;
	m_nWindSpd03 = 0;
	m_nWindDir05 = 0;
	m_nWindSpd05 = 0;
	m_nWindDir10 = 0;
	m_nWindSpd10 = 0;
	m_nTemp2 = 0;
	m_fQNH2 = 0;
	m_bWet2 = FALSE;
	m_nPressDim1 = -1;
	m_nPressDim2 = -1;
	m_nTempDim1 = -1;
	m_nTempDim2 = -1;
	m_nWindDim = -1;
	//}}AFX_DATA_INIT

m_ptDoc = ptDoc;
	                     
	m_nTempDim1 = ptDim->GetPUIndex (TEMP, ptDoc->GetTempDim1());  
	m_nPressDim1 = ptDim->GetPUIndex (PRESS, ptDoc->GetPressDim1());  
	m_nWindDim = ptDim->GetPUIndex (WIND, ptDoc->GetWindDim());  
	m_nTempDim2 = ptDim->GetPUIndex (TEMP, ptDoc->GetTempDim2());  
	m_nPressDim2 = ptDim->GetPUIndex (PRESS, ptDoc->GetPressDim2());  
	    
	ptDoc->GetStartMet (&m_nTemp1, &m_fQNH1, &m_bWet1);  	 
	
	short nWindDir;
	ptDoc->GetWind (ptDoc->ALT01, &nWindDir, &m_nWindSpd01);     
	m_nWindDir01 = (int)nWindDir;
	ptDoc->GetWind (ptDoc->ALT03, &nWindDir, &m_nWindSpd03); 
	m_nWindDir03 = (int)nWindDir;
	ptDoc->GetWind (ptDoc->ALT05, &nWindDir, &m_nWindSpd05); 
	m_nWindDir05 = (int)nWindDir;
	ptDoc->GetWind (ptDoc->ALT10, &nWindDir, &m_nWindSpd10); 
	m_nWindDir10 = (int)nWindDir;

	ptDoc->GetLandMet (&m_nTemp2, &m_fQNH2, &m_bWet2);
}

/************************************************************************
 *  MetDlg.cpp	  			 D o D a t a E x c h a n g e 				*
 ************************************************************************/
void CMetDlg::DoDataExchange(CDataExchange* pDX)
{
this->ActivateDimGroups(); 

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMetDlg)
	DDX_CBIndex(pDX, ID_MTQNH1DIM, m_nPressDim1);
	DDX_CBIndex(pDX, ID_MTQNH2DIM, m_nPressDim2);
	DDX_CBIndex(pDX, ID_MTTMP1DIM, m_nTempDim1);
	DDX_CBIndex(pDX, ID_MTTMP2DIM, m_nTempDim2);
	DDX_CBIndex(pDX, ID_MTWINDDIM, m_nWindDim);
	DDX_Temp(pDX, ID_MTTMP1, m_nTemp1);
	DDV_Temp(pDX, m_nTemp1, -70, 70);
	DDX_Press(pDX, ID_MTQNH1, m_fQNH1);
	DDV_Press(pDX, m_fQNH1, 920, 1060);    
	DDX_Check(pDX, ID_MTWET1, m_bWet1);
	DDX_Text(pDX, ID_MTDIR01, m_nWindDir01);
	DDV_MinMaxInt(pDX, m_nWindDir01, 0, 360);
	DDX_WindSpeed(pDX, ID_MTSPD01, m_nWindSpd01);
	DDV_WindSpeed(pDX, m_nWindSpd01, 0, 99);   
	DDX_Text(pDX, ID_MTDIR03, m_nWindDir03);
	DDV_MinMaxInt(pDX, m_nWindDir03, 0, 360);
	DDX_WindSpeed(pDX, ID_MTSPD03, m_nWindSpd03);
	DDV_WindSpeed(pDX, m_nWindSpd03, 0, 99);  
	DDX_Text(pDX, ID_MTDIR05, m_nWindDir05);
	DDV_MinMaxInt(pDX, m_nWindDir05, 0, 360);
 	DDX_WindSpeed(pDX, ID_MTSPD05, m_nWindSpd05);
	DDV_WindSpeed(pDX, m_nWindSpd05, 0, 99);  
	DDX_Text(pDX, ID_MTDIR10, m_nWindDir10);
	DDV_MinMaxInt(pDX, m_nWindDir10, 0, 360);
	DDX_WindSpeed(pDX, ID_MTSPD10, m_nWindSpd10);
	DDV_WindSpeed(pDX, m_nWindSpd10, 0, 99); 
	DDX_Temp(pDX, ID_MTTMP2, m_nTemp2);
	DDV_Temp(pDX, m_nTemp2, -70, 70);
	DDX_Press(pDX, ID_MTQNH2, m_fQNH2);
	DDV_Press(pDX, m_fQNH2, 920, 1060);
	DDX_Check(pDX, ID_MTWET2, m_bWet2);     
	//}}AFX_DATA_MAP  
	
if (pDX->m_bSaveAndValidate)
	{        
	this->GetMet (m_ptDoc);     
    }
}


/************************************************************************
 *  MetDlg.cpp   					G e t M e t 						*
 ************************************************************************/
void CMetDlg::GetMet (CMetDoc* ptDoc)     
{             
ptDoc->SetTempDim1(ptDim->GetPUDim (TEMP, m_nTempDim1));
ptDoc->SetPressDim1(ptDim->GetPUDim (PRESS, m_nPressDim1));  
ptDoc->SetWindDim(ptDim->GetPUDim (WIND, m_nWindDim));
ptDoc->SetTempDim2(ptDim->GetPUDim (TEMP, m_nTempDim2));
ptDoc->SetPressDim2(ptDim->GetPUDim (PRESS, m_nPressDim2));

ptDoc->SetStartMet (m_nTemp1, m_fQNH1, m_bWet1);

ptDoc->SetWind (ptDoc->ALT01, m_nWindDir01, m_nWindSpd01); 
ptDoc->SetWind (ptDoc->ALT03, m_nWindDir03, m_nWindSpd03); 
ptDoc->SetWind (ptDoc->ALT05, m_nWindDir05, m_nWindSpd05); 
ptDoc->SetWind (ptDoc->ALT10, m_nWindDir10, m_nWindSpd10); 

ptDoc->SetLandMet (m_nTemp2, m_fQNH2, m_bWet2);
}

BEGIN_MESSAGE_MAP(CMetDlg, CDlgTool)
	//{{AFX_MSG_MAP(CMetDlg)
	ON_BN_CLICKED(ID_MTCOPY, OnCopy)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMetDlg message handlers

void CMetDlg::OnCopy()
{
	// TODO: Add your control notification handler code here
CString szText;
this->GetText (ID_MTTMP1, szText);
this->SetText (ID_MTTMP2, szText);
                          
this->GetText (ID_MTQNH1, szText);
this->SetText (ID_MTQNH2, szText);   

this->SetControl (ID_MTWET2, this->GetControl (ID_MTWET1)); 
this->SetPUIndex (ID_MTTMP2DIM, this->GetPUIndex (ID_MTTMP1DIM));
this->SetPUIndex (ID_MTQNH2DIM, this->GetPUIndex (ID_MTQNH1DIM));
}

/************************************************************************
 *  MetDlg.cpp   			O n I n i t D i a l o g						*
 ************************************************************************/
BOOL CMetDlg::OnInitDialog()
{
	// TODO: Add extra initialization here
this->AddDimGroup (ID_MTQNH1, ID_MTQNH1DIM);
this->AddDimGroup (ID_MTTMP1, ID_MTTMP1DIM);   
this->AddDimGroup (ID_MTSPD01, ID_MTWINDDIM);
this->AddDimGroup (ID_MTSPD03, ID_MTWINDDIM);
this->AddDimGroup (ID_MTSPD05, ID_MTWINDDIM);
this->AddDimGroup (ID_MTSPD10, ID_MTWINDDIM);
this->AddDimGroup (ID_MTQNH2, ID_MTQNH2DIM);
this->AddDimGroup (ID_MTTMP2, ID_MTTMP2DIM); 

this->FillDimPU (ID_MTQNH1DIM, PRESS);
this->FillDimPU (ID_MTTMP1DIM, TEMP);
this->FillDimPU (ID_MTWINDDIM, WIND);
this->FillDimPU (ID_MTQNH2DIM, PRESS);
this->FillDimPU (ID_MTTMP2DIM, TEMP);
	
	CDlgTool::OnInitDialog();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/************************************************************************
 *  MetDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CMetDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}

