/************************************************************************
 *  						M e t D o c . c p p  						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include <math.h>		/* sin, cos				*/

#include "pf.h"

#include "WayPoint.h"
#include "DimDoc.h"

#include "MetDlg.h"				// dialog to set meteorological parameters
#include "MetDoc.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc* 		ptDim;      

/////////////////////////////////////////////////////////////////////////////
// CMetDoc
IMPLEMENT_DYNCREATE(CMetDoc, CDocument)

BEGIN_MESSAGE_MAP(CMetDoc, CDocument)
	//{{AFX_MSG_MAP(CMetDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMetDoc construction/destruction


CMetDoc::CMetDoc()
{ 
m_nTempDim1		= DIM_C;
m_nPressDim1	= DIM_HPA;
m_nWindDim		= DIM_KT;   
m_nTempDim2		= DIM_C;
m_nPressDim2	= DIM_HPA;

m_nTmp1		= 15;			/* Tempreratur beim Start [C]	*/
m_wQNH1		= 1013;			/* QNH-Wert am Ausgangsort	*/
m_bWet1		= FALSE;		/* Bahn ist trocken		*/
m_wDir01 = 0;				/* wind direction at 1500 ft	*/
m_wSpd01 = 0;				/* wind speed at 1500 ft	*/
m_wDir03 = 0;				/* wind direction at 3000 ft	*/
m_wSpd03 = 0;				/* wind speed at 3000 ft	*/
m_wDir05 = 0;				/* wind direction at 5000 ft	*/
m_wSpd05 = 0;				/* wind speed at 5000 ft	*/
m_wDir10 = 0;				/* wind direction at 10000 ft	*/
m_wSpd10 = 0;				/* wind speed at 10000 ft	*/
m_nTmp2		= 15;			/* Tempreratur beim Landen [C]	*/
m_wQNH2		= 1013;			/* QNH-Wert am Zielort		*/
m_bWet2		= FALSE;		/* Bahn ist trocken		*/
}

CMetDoc::~CMetDoc()
{
}
    
/************************************************************************
 *  MetDoc.cpp	  		 		 S e t S t a r t M e t					*
 ************************************************************************/
void CMetDoc::SetStartMet (short nTemp, float fQNH, BOOL bWet)
{
m_nTmp1		= nTemp;

if (m_nPressDim1 == DIM_INCHHG)
		m_wQNH1 = (WORD)(fQNH * 100 +.5);
else	m_wQNH1	= (WORD)fQNH;

m_bWet1		= bWet;
}

/************************************************************************
 *  MetDoc.cpp	  		 		 S e t W i n d							*
 ************************************************************************/
void CMetDoc::SetWind (GARFORALT nAlt, short nDir, short nSpd) 
{  
switch (nAlt)
	{
	case	ALT01:
		m_wDir01	= (WORD)nDir;
		m_wSpd01	= (WORD)nSpd;
		break;
	case	ALT03:
		m_wDir03	= (WORD)nDir;
		m_wSpd03	= (WORD)nSpd;
		break;
	case	ALT05:
		m_wDir05	= (WORD)nDir;
		m_wSpd05	= (WORD)nSpd;
		break;
	case	ALT10:
		m_wDir10	= (WORD)nDir;
		m_wSpd10	= (WORD)nSpd;
		break;
	default:
		break;
	}
}

/************************************************************************
 *  MetDoc.cpp				    Wind Anteil								*
 ************************************************************************/
float WindAnteil (long H0, long H1, long Min, long Max, long* Altitude)
{
long help, Int0, Int1;
float fakt;
						/* make H0 <= H1	*/
if (H1 < H0) { help=H1; H1=H0; H0=help; } 
					
Int0 = (Min > H0  &&  Min < H1)? Min : H0;	/* check if H0 <Min <H1	*/
Int1 = (Max > H0  &&  Max < H1)? Max : H1;	/* check if H0 <Max <H1	*/
*Altitude = (Int0 + Int1)/2;

fakt = (float)0;				/* reset fakt		*/
if (*Altitude>Min && *Altitude<=Max)	/* check if Min < Altitude <=Max*/
	{				/* if so, calculate fakt	*/
	if (H1-H0 < 1L)	fakt = (float)1;	/* no big height diff.	*/
		else	fakt = (float)(Int1-Int0)/(H1-H0);
	}

return fakt;
}

/****************************************************************************
 *  MetDoc.cpp				    Set Wind									*
 * Bestimmt die Anteile der Flugstrecke in den Hoehenbaendern				*
 * 1500 - 3000 - 5000 - 10000 Fuss, ermittelt fuer jedes durchflogene		*
 * Band die mittleren Winddaten und nutzt sie im Verhaeltnis der oben		*
 * bestimmten Anteile zur Berechnung der mittelen Winddaten bezueglich		*
 * der  g e s a m t e n  Steigflugstrecke von H0 auf ptWpt->GetActAlt_ft().	*
 ****************************************************************************/
void CMetDoc::SetWind (CWayPoint* ptWpt, long H0)
										/* H0: alte Flughoehe [ft]	*/
{
CVektor vN, vR;			/* Vektor: Norden, Winde	*/
CVektor vR01, vR03, vR05, vR10, vR11;	/* 2-dimensionale Windvektoren	*/
double	V0h, V1h;			/* Wind speeds in height Hm	*/
double	fWSpd1, fWSpd3, fWSpd5, fWSpd10;/* Wind speeds in knots		*/
long	Hm;				/* mittlere Flughoehen [ft]	*/
long	H_00, H_01, H_03, H_05, H_10;	/* limits			*/
float	fakt, SumFakt;			/* Anteile der Winddaten [0...1]*/
					/* beim Steigflug von H0 nach H1*/

SumFakt = (float)0;
H_00 = 0L;  H_01 = 1500L;  H_03 = 3000L;  H_05 = 5000L;  H_10 = 10000L;
vN.Set (0, 1, 0);			/* 2 dimensional: nach Norden	*/

fWSpd1	= ptDim->ConvertSpeed (m_wSpd01, m_nWindDim, DIM_KT);
fWSpd3	= ptDim->ConvertSpeed (m_wSpd03, m_nWindDim, DIM_KT);
fWSpd5	= ptDim->ConvertSpeed (m_wSpd05, m_nWindDim, DIM_KT);
fWSpd10	= ptDim->ConvertSpeed (m_wSpd10, m_nWindDim, DIM_KT);
						
fakt	= WindAnteil (H0, ptWpt->GetActAlt_ft(), H_00, H_01, &Hm);
vR01.Set (	sin(m_wDir01 * pi/DB180) * fWSpd1 * fakt,
			cos(m_wDir01 * pi/DB180) * fWSpd1 * fakt);
SumFakt += fakt;

fakt	= WindAnteil (H0, ptWpt->GetActAlt_ft(), H_01, H_03, &Hm);
V0h	= fWSpd1 * (double)(Hm-H_03) / (H_01-H_03);
V1h	= fWSpd3 * (double)(Hm-H_01) / (H_03-H_01);


vR03.Set (( V0h * sin(m_wDir01*pi/DB180)  
		 +  V1h * sin(m_wDir03*pi/DB180) ) * fakt,
		  ( V0h * cos(m_wDir01*pi/DB180)  
	     +  V1h * cos(m_wDir03*pi/DB180) ) * fakt);
SumFakt += fakt;

fakt	= WindAnteil (H0, ptWpt->GetActAlt_ft(), H_03, H_05, &Hm);
V0h	= fWSpd3 * (double)(Hm-H_05) / (H_03-H_05);
V1h	= fWSpd5 * (double)(Hm-H_03) / (H_05-H_03);
vR05.Set (( V0h * sin(m_wDir03*pi/DB180)  
	     +  V1h * sin(m_wDir05*pi/DB180) ) * fakt,
		  ( V0h * cos(m_wDir03*pi/DB180)  
	     +  V1h * cos(m_wDir05*pi/DB180) ) * fakt);
SumFakt += fakt;

fakt	= WindAnteil (H0, ptWpt->GetActAlt_ft(), H_05, H_10, &Hm);
V0h	= fWSpd5 * (double)(Hm-H_10) / (H_05-H_10);
V1h	= fWSpd10 * (double)(Hm-H_05) / (H_10-H_05);
vR10.Set (( V0h * sin(m_wDir05*pi/DB180)  
	     +  V1h * sin(m_wDir10*pi/DB180) ) * fakt,
		  ( V0h * cos(m_wDir05*pi/DB180)  
	     +  V1h * cos(m_wDir10*pi/DB180) ) * fakt);
SumFakt += fakt;

fakt	= 1 - SumFakt;
vR11.Set (sin(m_wDir10 * pi/DB180) * fWSpd10 * fakt,
		  cos(m_wDir10 * pi/DB180) * fWSpd10 * fakt);

vR = vR01 + vR03 + vR05 + vR10 + vR11;

ptWpt->SetWindSpeed_kt ((short)(vR.Abs() + 0.5));

ptWpt->SetWindDir(0);
if (ptWpt->GetWindSpeed_kt() > 0)
  {								/* 0 <= W_Dir <= 180	*/
  ptWpt->SetWindDir ( (short) (vN.VektorAngle (vR) * DB180/pi + 0.5));
  if (vR.x < 0.) 				 /* 0 <= W_Dir <= 360	*/
	ptWpt->SetWindDir (360 - ptWpt->GetWindDir());	
  }
}

/************************************************************************
 *  MetDoc.cpp	  		 		 S e t L a n d M e t 					*
 ************************************************************************/
void CMetDoc::SetLandMet ( short nTemp, float fQNH, BOOL bWet)
{
m_nTmp2		= nTemp;

if (m_nPressDim2 == DIM_INCHHG)
		m_wQNH2 = (WORD)(fQNH * 100 +.5);
else	m_wQNH2	= (WORD)fQNH;

m_bWet2		= bWet;
}
    
/************************************************************************
 *  MetDoc.cpp	  		 		 G e t S t a r t M e t					*
 ************************************************************************/
void CMetDoc::GetStartMet (short* ptTemp, float* ptQNH, BOOL* ptWet)
{
*ptTemp		= m_nTmp1;

if (m_nPressDim1 == DIM_INCHHG)
	 *ptQNH = (float)m_wQNH1 / 100;
else *ptQNH = (float)m_wQNH1;		

*ptWet		= m_bWet1;
}

/************************************************************************
 *  MetDoc.cpp	  		 		 G e t W i n d							*
 ************************************************************************/
void CMetDoc::GetWind (GARFORALT nAlt, short* ptDir, short* ptSpd) 
{  
switch (nAlt)
	{
	case	ALT01:
		*ptDir	= (short)m_wDir01;
		*ptSpd	= (short)m_wSpd01;
		break;
	case	ALT03:
		*ptDir	= (short)m_wDir03;
		*ptSpd	= (short)m_wSpd03;
		break;
	case	ALT05:
		*ptDir	= (short)m_wDir05;
		*ptSpd	= (short)m_wSpd05;
		break;
	case	ALT10:
		*ptDir	= (short)m_wDir10;
		*ptSpd	= (short)m_wSpd10;
		break;
	default:
		*ptDir	= (short)0;
		*ptSpd	= (short)0;
		break;
	}
}

/************************************************************************
 *  MetDoc.cpp	  		 		 G e t L a n d M e t 					*
 ************************************************************************/
void CMetDoc::GetLandMet ( short* ptTemp, float* ptQNH, BOOL* ptWet)
{
*ptTemp		= m_nTmp2;

if (m_nPressDim2 == DIM_INCHHG)
	 *ptQNH = (float)m_wQNH2 / 100;
else *ptQNH = (float)m_wQNH2;		

*ptWet		= m_bWet2;
}                               

/************************************************************************
 *  MetDoc.cpp	  		 		 C h a n g e 							*
 ************************************************************************/
void CMetDoc::Change(CWnd* ptWnd)
{
CMetDlg MetDlg(ptWnd, this);

int RetVal = MetDlg.DoModal();
switch (RetVal)
	{
	case IDOK:   
 		ptWnd->InvalidateRect(NULL);
		break;
	case IDCANCEL:
		break;
	}	
} 


/************************************************************************
 *  MetDoc.cpp	  		 		 S e r i a l i z e 						*
 ************************************************************************/
void CMetDoc::Serialize(CArchive& ar)
{    
WORD	Word;

if (ar.IsStoring())
	{
		// TODO: add storing code here         
 	ar << (WORD)m_nTempDim1;
	ar << (WORD)m_nPressDim1;
	ar << (WORD)m_nWindDim;
 	ar << (WORD)m_nTempDim2;
	ar << (WORD)m_nPressDim2;
	ar << (WORD)m_nTmp1;
	ar << m_wQNH1;
	ar << (WORD)m_bWet1;
	ar << m_wDir01;
	ar << m_wSpd01;
	ar << m_wDir03;
	ar << m_wSpd03;
	ar << m_wDir05;
	ar << m_wSpd05;
	ar << m_wDir10;
	ar << m_wSpd10;
	ar << (WORD)m_nTmp2;
	ar << m_wQNH2;
	ar << (WORD)m_bWet2;        
	}
else{
		// TODO: add meteorological data here    
 	ar.Read (&m_nTempDim1, sizeof(short));	
	ar.Read (&m_nPressDim1, sizeof(short));	
	ar.Read (&m_nWindDim, sizeof(short));	
	ar.Read (&m_nTempDim2, sizeof(short));	
	ar.Read (&m_nPressDim2, sizeof(short));	
	ar.Read (&m_nTmp1, sizeof(short));	
	ar >> m_wQNH1;	
	ar >> Word;		m_bWet1=(BOOL)Word;
	ar >> m_wDir01;
	ar >> m_wSpd01;
	ar >> m_wDir03;
	ar >> m_wSpd03;	
	ar >> m_wDir05;
	ar >> m_wSpd05;
	ar >> m_wDir10;
	ar >> m_wSpd10;
	ar.Read (&m_nTmp2, sizeof(short));
	ar >> m_wQNH2;	
	ar >> Word;		m_bWet2=(BOOL)Word;
	}
}

/************************************************************************
 *  MetDoc.cpp				S e t Q n h T e x t							*
 ************************************************************************/
CString CMetDoc::SetQnhText (short nQNH, short nOldDim, short nNewDim)
{
CString szQnh;
double	fConvert;
char	szText[32];

if (nOldDim==DIM_INCHHG) fConvert = (double)nQNH/100.0;
				else	 fConvert = (double)nQNH;
fConvert = ptDim->ConvertPress (fConvert, nOldDim, nNewDim);

if (nNewDim == DIM_INCHHG)
    {
    sprintf (szText, "%.2f",fConvert);
    }
else{
    sprintf (szText, "%ld", (long)(fConvert + 0.5));
    }
szQnh = (CString)szText;

return szQnh;
}

