#ifndef __METDOC__
#define __METDOC__

/************************************************************************
 *  						M e t D o c . h 	 						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

class CWayPoint;
class CMetDoc : public CDocument
{ 
protected: // create from serialization only
	DECLARE_DYNCREATE(CMetDoc)

protected:
// Attributes
public:   
	enum GARFORALT {ALT01, ALT03, ALT05, ALT10};			

	short	m_nTempDim1;
	short	m_nPressDim1;
	short	m_nWindDim;
	short	m_nTempDim2;
	short	m_nPressDim2;
	short	m_nTmp1;		/* Temperatur beim Start [Grad C]	*/
	WORD	m_wQNH1;		/* QNH-Wert am Ausgangsort [hPa]	*/
	BOOL	m_bWet1;		/* TRUE, wenn feuchte Startbahn		*/
	WORD	m_wDir01;		/* Windrichtung in 1500 ft Hoehe [Grad]	*/
	WORD	m_wSpd01;		/* Windgeschwindigkeit in 1500 ft [kt]	*/
	WORD	m_wDir03;		/* Windrichtung in 3000 ft Hoehe [Grad]	*/
	WORD	m_wSpd03;		/* Windgeschwindigkeit in 3000 ft [kt]	*/
	WORD	m_wDir05;		/* Windrichtung in 5000 ft Hoehe [Grad]	*/
	WORD	m_wSpd05;		/* Windgeschwindigkeit in 5000 ft [kt]	*/
	WORD	m_wDir10;		/* Windrichtung in 10000 ft Hoehe [Grad]*/
	WORD	m_wSpd10;		/* Windgeschwindigkeit in 10000 ft [kt]	*/
	short	m_nTmp2;		/* Temperatur bei der Landung [Grad C]	*/
	WORD	m_wQNH2;		/* QNH-Wert am Zielort [hPa]		*/
	BOOL	m_bWet2;		/* TRUE, wenn feuchte Landebahn		*/
public:
	CMetDoc();	
	~CMetDoc();      

  	short GetTemp1(){return m_nTmp1;}
  	short GetTemp2(){return m_nTmp2;}
  	BOOL IsWet1(){return m_bWet1;}
  	BOOL IsWet2(){return m_bWet2;}

	short GetQNH1(){return (short)m_wQNH1;}
	short GetQNH2(){return (short)m_wQNH2;}
  	short GetTempDim1(){return m_nTempDim1;}
 	short GetPressDim1(){return m_nPressDim1;}
 	short GetWindDim(){return m_nWindDim;}
 	short GetTempDim2(){return m_nTempDim2;}
 	short GetPressDim2(){return m_nPressDim2;}

	void SetTempDim1 (short nDim){m_nTempDim1 = nDim;}
	void SetPressDim1 (short nDim){m_nPressDim1 = nDim;}
	void SetWindDim (short nDim){m_nWindDim = nDim;}
	void SetTempDim2 (short nDim){m_nTempDim2 = nDim;}
	void SetPressDim2 (short nDim){m_nPressDim2 = nDim;}
	
	void SetStartMet (short nTemp, float fQNH, BOOL bWet);
	void SetWind (GARFORALT nAlt, short nDir, short nSpd); 
	void SetLandMet ( short nTemp, float fQNH, BOOL bWet);
	void GetStartMet (short* ptTemp, float* ptQNH, BOOL* ptWet);
	void GetWind (GARFORALT nAlt, short* ptDir, short* ptSpd); 
	void GetLandMet ( short* ptTemp, float* ptQNH, BOOL* ptWet);
	
	void SetWind (CWayPoint* ptWpt, long H0);
	CString SetQnhText (short nQNH, short nOldDim, short nNewDim);


	void Change (CWnd* ptWnd);
	void Serialize(CArchive& ar);
    
// Implementation
protected:

	// Generated message map functions
protected:
	//{{AFX_MSG(CMetDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 
