/*********************************************************************
 *							M o v i n g M a p . c p p			     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"    

#include "TrackDoc.h" 


#include "MetDoc.h"			// neue
#include "PlaneDoc.h"
#include "Calc.h"			// this statement must be after PlaneDoc.h
#include "WayDoc.h"

#include "Symbols.h"


#include "MvMapDlg.h"
#include "MovingMp.h"

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;

extern CPlaneDoc*		ptPlaneDoc;	// neue
extern CLoadDoc*		ptLoad; 
extern CMetDoc*			ptMet;
extern BOOL	bDemo;

/////////////////////////////////////////////////////////////////////////////
// CMovingMapDoc
IMPLEMENT_DYNCREATE(CMovingMapDoc, CDocument)

BEGIN_MESSAGE_MAP(CMovingMapDoc, CDocument)
	//{{AFX_MSG_MAP(CMovingMapDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/************************************************************************
 *  MovingMp.cpp				C M o v i n g M a p	D o c				*
 ************************************************************************/
CMovingMapDoc::CMovingMapDoc()
{ 
m_ptWnd		= NULL;		// for timer
m_ptDoc		= NULL;   
m_ptGpsDoc	= NULL;	

m_bRteLoaded = FALSE;	// to start selection of Visual Approach Chart

m_bTimeOut	= FALSE;

m_ptNmea	= NULL;
m_uTimer	= 0;

m_bJustStarted		= FALSE;
m_bJustFinished		= FALSE;

m_bRecording		= FALSE;
m_bScMapMoving		= FALSE;
m_bShowSymbols		= FALSE;		// TRUE while showing moving map symbols on map

m_nActPosSymbol		= (int)ACTPOS_PLANE;
m_nTrackSymbol		= (int)TRACK_LINE;
m_nChgMapLimit_mm	= 5;
m_nSource			= SOURCE_GPS;
m_nSpeedFakt		= FAKT_10;
m_ActPosColor		= RGB(0,0,0);

m_ptLegs = NULL;			// used to move map for rte
m_ulTimeSimulate_sec	= 0;
m_nTrackSimIndex		= 0; // used to move map for trk
}


/************************************************************************
 *  MovingMp.cpp				~ C M o v i n g M a p					*
 ************************************************************************/
CMovingMapDoc::~CMovingMapDoc()
{
if (m_ptNmea != NULL)
	{
	m_ptNmea->Close();
	delete m_ptNmea;
	m_ptNmea = NULL;
	}
} 

/************************************************************************
 *  MovingMp.cpp			I n i t R e a d N M E A 					*
 ************************************************************************/
BOOL CMovingMapDoc::InitReadNMEA (short nInpLen, short nOutLen)
{
BOOL	bInit = FALSE;

if (m_ptNmea != NULL)
	{
	m_ptNmea->BinMode();
	bInit = m_ptNmea->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

return bInit;
}

/****************************************************************************
 *	MovingMp.cp				G e t S i m S t e p _ s e c						*
 *  Purpose: Calculates time diff for next simulation step					*
 ****************************************************************************/
unsigned long CMovingMapDoc::GetSimStep_sec ()
{
unsigned long uStep_sec = 1;

switch (m_nSpeedFakt)
	{
	case FAKT_01: uStep_sec = 1;	break;
	case FAKT_02: uStep_sec = 2;	break;
	case FAKT_04: uStep_sec = 4;	break;
	case FAKT_10: uStep_sec = 10;	break;
	case FAKT_20: uStep_sec = 20;	break;
	case FAKT_40: uStep_sec = 40;	break;
	}
	
return uStep_sec;
}

/****************************************************************************
 *	MovingMp.cpp			P o i n t O n L e g A t D i s t					*
 *  Purpose: Calculates LatLon for point on leg, dDist NM after LL1			*
 ****************************************************************************/
CLatLon CMovingMapDoc::PointOnLegAtDist (double dDist, CLatLon& LL1, CLatLon& LL2)
{
	CLatLon LL;
	
	if (m_bScMapMoving)
		 LL = CLatLon::PointOnOrthoLegAtDist(dDist, LL1, LL2);
	else LL = CLatLon::PointOnLoxoLegAtDist(dDist, LL1, LL2);

	return LL;
}

/****************************************************************************
 *	MovingMp.cpp			A l t O n L e g A t D i s t 					*
 *  Purpose: Calculates altitude for point on leg, dDist NM after lAltWpt0	*
 ****************************************************************************/
long CMovingMapDoc::AltOnLegAtDist (double dDist, double dDistLeg, long lAltWpt0, long lAltWpt1)
{
	long lAltTrk=0;

	if (dDistLeg > 0)
			lAltTrk = (long)(dDist * (lAltWpt1 - lAltWpt0) / dDistLeg + lAltWpt0 + 0.5);
	else	lAltTrk = lAltWpt1;

	return lAltTrk;
}



/************************************************************************
 *  MovingMp.cpp				P r e p a r e F o r G p s				*
 ************************************************************************/
BOOL CMovingMapDoc::PrepareForGps()
{
	BOOL	bPrepared = FALSE;

	m_ptNmea = (CNmea*)new CNmea (4800, 8, (float)1, NO);

		    // nInputLen = 2560
	if (this->InitReadNMEA (2560, 256))
	{	
		bPrepared = TRUE;
	}	
return bPrepared;
}

/************************************************************************
 *  MovingMp.cpp				R e c o r d	F o r G P S					*
 ************************************************************************/
BOOL CMovingMapDoc::RecordForGps()
{
	BOOL bValid = FALSE;
	BOOL bDemoLimitReached = FALSE;
							// loops while (!bStop && !bStored)
	m_bTimeOut = m_ptDoc->ReceiveNMEA (m_ptNmea, &m_ActTrackPt, &bValid, NULL);  // m_ptLogFile=NULL					
	
	if (bDemo)		// to abort demo after 50 steps
		bDemoLimitReached = (m_ptDoc->GetCnt() > MAX_DEMO_TRK_CNT);	

	if (m_bTimeOut || bDemoLimitReached)
	{
		if (m_ptNmea->Close())
		{ 
			CString szBuffer;
			short nStrID;

			if (bDemoLimitReached)	nStrID = IDS_DEMO_MOVING_MAP;
				else	nStrID = (m_bTimeOut)? IDS_GPSTIMEOUT : IDS_GPSOK;

			szBuffer.LoadString (nStrID);
			AfxMessageBox (szBuffer);
			m_bRecording = FALSE;
			bValid = (m_ptDoc->GetCnt() > 2);
		}   
		
		if (m_ptNmea->GetError() == SER_BADCLOSE)
			AfxMessageBox("bad Close Comm");
	}
	else
	{  				// no time out
		bValid = TRUE;
	//	m_ptDoc->SetModifiedFlag (TRUE);	// see: EndForGps
	}				
		
	return bValid;
}

/************************************************************************
 *  MovingMp.cpp				E n d F o r G p s						*
 ************************************************************************/
BOOL CMovingMapDoc::EndForGps()
{
	BOOL bEnd = FALSE;

	if (m_ptNmea->Close())
	{
		if ((m_ptDoc->GetCnt() > 1) && !bDemo)
		{
			m_ptDoc->SetModifiedFlag (TRUE);	// to enable save as in TrackDlg
		}

		m_ptDoc->Filter();
		bEnd = TRUE;
	}

	return bEnd;
}

/************************************************************************
 *  MovingMp.cpp				P r e p a r e F o r T r k				*
 ************************************************************************/
BOOL CMovingMapDoc::PrepareForTrk()
{
	BOOL	bPrepared = FALSE;

	if (m_ptDoc != NULL)
	{
		if (m_ptDoc->GetCnt() > 1)
		{
			CString szMsg;
			szMsg.Format (IDF_SIM_MM_TRK, (LPCTSTR)m_ptDoc->GetTitle());
 			int iRet = AfxMessageBox (szMsg, MB_YESNO);
			if (iRet == IDYES)
			{
				m_nTrackPtCnt = m_ptDoc->GetCnt();
				if (m_nTrackPtCnt > 0)
				{
					m_nTrackSimIndex = 0;
					bPrepared = TRUE;
				}
			}
		}	
		else
		{
			AfxMessageBox (IDS_BAD_SIM_MM_TRK);
		}
	}
	else
	{
		AfxMessageBox (IDS_BAD_SIM_MM_TRK);
	}

	return bPrepared;
}


/************************************************************************
 *  MovingMp.cpp	  		G e t T r k S i m T i m e 					*
 ************************************************************************/
unsigned long CMovingMapDoc::GetTrkSimTime (short nHour, short nMin, short nSec)
{
	unsigned long ulTime;
	time_t	ltime;
	struct	tm LogTime, *ptLogTime;

	time (&ltime);
	ptLogTime = &LogTime;
	ptLogTime = localtime (&ltime);		/* get actual date		*/

	long lActDaysSec = (long)ptLogTime->tm_sec + (long)60*ptLogTime->tm_min + (long)60*60*ptLogTime->tm_hour;
	ulTime = (unsigned long)ltime - lActDaysSec + nSec + (long)60*nMin + (long)3600*nHour;

	return ulTime;
}



/************************************************************************
 *  MovingMp.cpp				R e c o r d	F o r T r k					*
 ************************************************************************/
BOOL CMovingMapDoc::RecordForTrk()
{
	BOOL bValid = FALSE;

	for (int i=m_nTrackSimIndex; i<m_nTrackPtCnt && !bValid; i++)
	{						// for all track points
		if (m_ptDoc->GetTrackPointPtr (i, &m_ActTrackPt))
		{					// get point with time >= m_ulTimeSimulate_sec
			short nHour, nMin, nSec;
			m_ActTrackPt.GetTime (&nHour, &nMin, &nSec);

			unsigned long ulTime = this->GetTrkSimTime(nHour, nMin, nSec);

			if (i==0)
			{
				m_ulTimeSimulate_sec = ulTime;
			}
			else
			{
				bValid = (ulTime >= m_ulTimeSimulate_sec); 
				if (bValid)
				{
					m_nTrackSimIndex = i;
					m_ulTimeSimulate_sec = ulTime + this->GetSimStep_sec();	
				}
			}
		}
	}

	if (bValid)		// temporarily change counter to draw only part of track
		m_ptDoc->SetSimulateCnt(m_nTrackSimIndex);

	return bValid;
}


/************************************************************************
 *  MovingMp.cpp				E n d F o r T r k						*
 ************************************************************************/
BOOL CMovingMapDoc::EndForTrk()
{
	BOOL bEnd = TRUE;

	m_ptDoc->SetSimulateCnt(-1);	// reset simulation counter to draw whole track
	AfxMessageBox (IDS_SIM_MM_FINISHED);

	return bEnd;
}


/************************************************************************
 *  MovingMp.cpp				P r e p a r e F o r R t e				*
 ************************************************************************/
BOOL CMovingMapDoc::PrepareForRte()
{
	BOOL	bPrepared = FALSE;

	if (m_ptWayDoc != NULL)
	{
		if (m_ptWayDoc->GetWayPointCnt() > 1)
		{
			CString szMsg;
			szMsg.Format (IDF_SIM_MM_RTE, (LPCTSTR)m_ptWayDoc->GetTitle());
 			int iRet = AfxMessageBox (szMsg, MB_YESNO);
			if (iRet == IDYES)
			{
				CPlane	ActPlane;
				if (ptPlaneDoc != NULL)
				{
					short nIndex = ptPlaneDoc->GetActIndex();
					if (!ptPlaneDoc->GetPlanePtr(nIndex, &ActPlane))
						return FALSE;	
				}

									/* do prepare calculations		*/
				m_ptLegs = m_ptWayDoc->GetCalculationPtr();
				m_ptLegs->Activate(&ActPlane);

				if (m_ptLegs->DoConsumCalc (&ActPlane, ptMet, ptLoad))
				{
					m_ptDoc->SetDimensions (DIM_FEET, DIM_KT);
					m_ulTimeSimulate_sec = 0;

					time_t	ActualTime;				// get actual time
					time (&ActualTime);
					m_ulStartTime	= (unsigned long)ActualTime;

					bPrepared = TRUE;
				}
			}
		}
		else
		{
			AfxMessageBox (IDS_BAD_SIM_MM_RTE);
		}
	}
	else
	{
		AfxMessageBox (IDS_BAD_SIM_MM_RTE);
	}
	
	return bPrepared;
}


/************************************************************************
 *  MovingMp.cpp				A p p e n d T r a c k P t				*
 *  for dimensions see: CMovingMapDoc::PrepareForRte					*
 *						m_ptDoc->SetDimensions (DIM_FEET, DIM_KT);		*
 ************************************************************************/
void CMovingMapDoc::AppendTrackPt (CLatLon& LL, long lAlt_ft, short nIAS_kt,
								   unsigned long ulTimeSimulate_sec)
{
	m_ActTrackPt.SetLatLon (LL.GetLat(), LL.GetLon(), TRUE);
	m_ActTrackPt.SetSpeed (nIAS_kt, TRUE);
	m_ActTrackPt.SetAlt (lAlt_ft, TRUE);
	
	m_ActTrackPt.SetTime (m_ulStartTime + ulTimeSimulate_sec);	
	m_ptDoc->AppendWpt (m_ActTrackPt);
}
	

/************************************************************************
 *  MovingMp.cpp				R e c o r d	F o r R t e					*
 ************************************************************************/
BOOL CMovingMapDoc::RecordForRte()
{
	BOOL bValid = FALSE;
	short		nAltDim;
	CLatLon		LLwpt0;
	long		lAltWpt0;
	CWayPoint	WayPt;

	short nCnt = m_ptWayDoc->GetWayPointCnt();
	nAltDim = DIM_FEET;

	unsigned long ulTotalTime_sec = 0;

					// get Lat, Lon, Alt and Speed for time = m_ulTimeSimulate_sec
	for (int i=0; i<nCnt && !bValid; i++)
	{
		LEGTYPE Leg = m_ptLegs->GetAt (i);	// get calculated leg

		long lAltWpt1;
		unsigned long ulStartOfLegTime_sec;
		if (m_ptWayDoc->GetWayPointPtr (i, &WayPt))
		{
			CLatLon LLwpt1(WayPt.GetLat(), WayPt.GetLon());

			lAltWpt1 = WayPt.GetActAlt_ft();
			ulStartOfLegTime_sec = ulTotalTime_sec;

			ulTotalTime_sec += (unsigned long)(60*Leg.dTimeLeg);

			if (i>0)	
			{
				if (ulStartOfLegTime_sec <= m_ulTimeSimulate_sec &&
					m_ulTimeSimulate_sec < ulTotalTime_sec)
				{					// append Lat Lon to actual track
					unsigned long ulTimeOnLeg_sec = m_ulTimeSimulate_sec - ulStartOfLegTime_sec;

					double dDistLeg = LLwpt0.LoxoDist(LLwpt1);
					double dDist = dDistLeg * ulTimeOnLeg_sec / 
									(ulTotalTime_sec-ulStartOfLegTime_sec);
					CLatLon LLtrk;
					LLtrk = this->PointOnLegAtDist (dDist, LLwpt0, LLwpt1);
					
					long lAltTrk_ft;
					lAltTrk_ft = this->AltOnLegAtDist (dDist, dDistLeg, lAltWpt0, lAltWpt1);

					short nIAS_kt = WayPt.GetActIAS_kt();
					this->AppendTrackPt (LLtrk, lAltTrk_ft, nIAS_kt, m_ulTimeSimulate_sec);

					m_ulTimeSimulate_sec += this->GetSimStep_sec();
					bValid = TRUE;
				}
			}
			LLwpt0 = LLwpt1;
			lAltWpt0 = lAltWpt1;
		}	// if (GetWayPointPtr...
	} // for all waypoints


	return bValid;
}


/************************************************************************
 *  MovingMp.cpp				E n d F o r R t e						*
 ************************************************************************/
BOOL CMovingMapDoc::EndForRte()
{
	BOOL bEnd = TRUE;

	m_ptLegs->DeActivate();
	AfxMessageBox (IDS_SIM_MM_FINISHED);

	return bEnd;
}


/************************************************************************
 *  MovingMp.cpp				T i m e r S t a r t 					*
 ************************************************************************/
BOOL CMovingMapDoc::TimerStart()
{
	BOOL bOK = TRUE;

	m_uTimer = m_ptWnd->SetTimer (GPS_TIMER, 1000, NULL);
	if (m_uTimer == 0)
	{   // 1 sec Timer  
		AfxMessageBox ("Bad Timer");
		bOK = FALSE;
	}
	return bOK;
}

/************************************************************************
 *  MovingMp.cpp				T i m e r S t o p	 					*
 ************************************************************************/
void CMovingMapDoc::TimerStop()
{
	m_ptWnd->KillTimer (m_uTimer);
	m_uTimer = 0;
}


/************************************************************************
 *  MovingMp.cpp					S t a r t 							*
 ************************************************************************/
BOOL CMovingMapDoc::Start(CWnd* ptWnd, CGpsDoc* ptGpsDoc, CTrackDoc* ptDoc, CWayDoc* ptWayDoc)
{
	m_ptWnd		= ptWnd;		// for timer
	m_ptDoc		= ptDoc;   
	m_ptGpsDoc	= ptGpsDoc;	
	m_ptWayDoc	= ptWayDoc;

										// prepare CLatLon of Start/Land positions
	m_bRteLoaded = FALSE;

	if (m_ptWayDoc != NULL)
	{				// get Start/Land position
		short nWptCnt = m_ptWayDoc->GetWayPointCnt();
		if (nWptCnt > 1)
		{
			CWayPoint Wpt;
			if (m_ptWayDoc->GetWayPointPtr(0, &Wpt))
			{
				m_llStart = (CLatLon)Wpt;
				if (m_ptWayDoc->GetWayPointPtr(nWptCnt-1, &Wpt))
				{
					m_llLand = (CLatLon)Wpt;	
					m_bRteLoaded = TRUE;
				}
			}
		}
	}



	if (m_ptDoc == NULL)
	{
		return FALSE;
	}

	switch ((MMSource)m_nSource)
	{
	case SOURCE_GPS:
		m_bRecording = this->PrepareForGps();
		break;
	case SOURCE_TRK:
		m_bRecording = this->PrepareForTrk();
		break;
	case SOURCE_RTE:
		m_bRecording = this->PrepareForRte();
		break;
	}

	if (m_bRecording)
	{
		if ((MMSource)m_nSource != SOURCE_TRK)
		{
			BOOL bAppend = FALSE;

			if (m_ptDoc->GetCnt() > 0)
			{								// old track in memory
				if ((MMSource)m_nSource == SOURCE_GPS)
				{							// ask user to append or not
					CString szText;	
					szText.Format(IDF_APPEND_TRACK, (LPCTSTR)m_ptDoc->GetTitle());
					if (AfxMessageBox (szText, MB_YESNO) == IDYES)
					{
						bAppend = TRUE;
					}
				}

				if (!bAppend)
				{								// don`t append 
					BOOL bNewDoc = TRUE;

					if (m_ptDoc->IsModified())
					{
						bNewDoc = m_ptDoc->SaveAs(m_ptWnd, TRUE); // bConfirm = TRUE
					}
					if (bNewDoc || bDemo)
					{							// old track is saved
						m_ptDoc->OnNewDocument();			// delete actual track
					}
					else
					{
						this->Stop();
						return m_bRecording;
					}
				}
			}

			if (!bAppend)
			{
				BOOL bAddToMRU = FALSE;			
				m_ptDoc->SetPathName("MoveMap.trk", bAddToMRU);	// rename actual track
			}
		}

		this->SetSymbolsOnView(TRUE);
		m_bJustStarted = TRUE;

		m_uTimer = m_ptWnd->SetTimer (GPS_TIMER, 1000, NULL);
		if (m_uTimer == 0)
		{									/* 1 sec Timer	*/
			AfxMessageBox ("Bad Timer in CMovingMapDoc::Start");
			m_bRecording = FALSE;
		}
	}
	
return m_bRecording;
}


/************************************************************************
 *  MovingMp.cpp				I s J u s t S t a r t e d				*
 ************************************************************************/
BOOL CMovingMapDoc::IsJustStarted()
{
	BOOL bJustStarted = m_bJustStarted;
	m_bJustStarted = FALSE;
	return bJustStarted;
}


/************************************************************************
 *  MovingMp.cpp					N e x t S t e p						*
 ************************************************************************/
BOOL CMovingMapDoc::NextStep()
{
	BOOL bValid = FALSE;


	if (m_bRecording)
	{
		this->TimerStop();

		switch ((MMSource)m_nSource)
		{
		case SOURCE_GPS:
			bValid = this->RecordForGps();
			break;
		case SOURCE_TRK:
			bValid = this->RecordForTrk();
			break;
		case SOURCE_RTE:
			bValid = this->RecordForRte();
			break;
		}
	}

	if (bValid)
	{   
		bValid = this->TimerStart();
	}
	else
	{
		this->Stop();
	}


return bValid;
}

/************************************************************************
 *  MovingMp.cpp					S t o p								*
 ************************************************************************/
void CMovingMapDoc::Stop()
{
	BOOL bEnd = FALSE;
	
	if (m_bRecording)
	{
		if (m_uTimer != 0)
		{
			m_ptWnd->KillTimer (m_uTimer);
			m_uTimer = 0;
		}

		m_bRecording = FALSE;
		m_bJustFinished	= TRUE;

		switch ((MMSource)m_nSource)
		{
		case SOURCE_GPS:
			bEnd = this->EndForGps();
			break;
		case SOURCE_TRK:
			bEnd = this->EndForTrk();
			break;
		case SOURCE_RTE:
			bEnd = this->EndForRte();
			break;
		}
	}
}


/****************************************************************************
 *  MovingMp.cpp	  		 	 C h a n g e 								*
 ****************************************************************************/
BOOL CMovingMapDoc::Change(CWnd* ptWnd)
{
BOOL bChanged=FALSE;
CMMPrevDlg MovingMapPrefDlg(ptWnd, this);

int RetVal = MovingMapPrefDlg.DoModal();
switch (RetVal)
	{
	case IDOK:   
 		ptWnd->InvalidateRect(NULL);
		bChanged = TRUE;
		break;
	case IDCANCEL:
		break;
	}	

return bChanged;
} 

/****************************************************************************
 *  MovingMp.cpp	  				S e r i a l i z e 						*
 ****************************************************************************/
void CMovingMapDoc::Serialize(CArchive& ar)
{    
//WORD	Word;

if (ar.IsStoring())
	{
		// TODO: add storing code here   
	ar << m_nActPosSymbol;
	ar << m_nTrackSymbol;
	ar << m_nChgMapLimit_mm;
	ar << m_nSource;
	ar << m_nSpeedFakt;
	}
else{
		// TODO: add loading code here  
	ar >> m_nActPosSymbol;
	ar >> m_nTrackSymbol;
	ar >> m_nChgMapLimit_mm;
	ar >> m_nSource;
	ar >> m_nSpeedFakt;
	}
}


/****************************************************************************
 *	ScMpView.c				D r a w P l a n e S y m b o l 					*
 ****************************************************************************/
void CMovingMapDoc::DrawPlaneSymbol(CDC* pDC, long lActLPx, long lActLPy)
{
double dCourse;

if (m_ptDoc->GetCourse (&dCourse))
	{
	dCourse = 360 - dCourse;				// rotate in other direction
	double dRad = pi * dCourse / 180;
	
	
	long	dUnit = 10;
	CVektor ActPos(lActLPx, lActLPy);
	
	CVektor vOffset(0, -10*dUnit);					// plane, direction north 5 mm
	CVektor EndOfPlane = ActPos + vOffset;
	
	vOffset.Set (-6*dUnit, -3*dUnit);
	CVektor Wing1Left = 	ActPos + vOffset;
	
	vOffset.Set (6*dUnit, -3*dUnit);
	CVektor Wing1Right = ActPos + vOffset;
	
	vOffset.Set (-2*dUnit, -8*dUnit);
	CVektor Wing2Left = ActPos + vOffset;

	vOffset.Set (2*dUnit, -8*dUnit);
	CVektor Wing2Right = ActPos + vOffset;
	
	EndOfPlane.Rotate (ActPos, dRad);
	Wing1Left.Rotate (ActPos, dRad);
	Wing1Right.Rotate (ActPos, dRad);
	Wing2Left.Rotate (ActPos, dRad);
	Wing2Right.Rotate (ActPos, dRad);
	
	

//	CPen PlanePen (PS_SOLID, dUnit, RGB(255,255,0));		// originally: PS_DASH, PS_LTGRAY
	CPen PlanePen (PS_SOLID, dUnit, m_ActPosColor);		// originally: PS_DASH, PS_LTGRAY
	CPen* ptOldPen = (CPen*)pDC->SelectObject (&PlanePen);

	long LPx = (long)EndOfPlane.X();
	long LPy = (long)EndOfPlane.Y();
	pDC->MoveTo (lActLPx, lActLPy);
	pDC->LineTo (LPx, LPy);						// plane body
	
	LPx = (long)Wing1Left.X();
	LPy = (long)Wing1Left.Y();
	pDC->MoveTo (LPx, LPy);
	LPx = (long)Wing1Right.X();
	LPy = (long)Wing1Right.Y();
	pDC->LineTo (LPx, LPy);						// wing 1
	
	
	LPx = (long)Wing2Left.X();
	LPy = (long)Wing2Left.Y();
	pDC->MoveTo (LPx, LPy);
	LPx = (long)Wing2Right.X();
	LPy = (long)Wing2Right.Y();
	pDC->LineTo (LPx, LPy);						// wing 2
	
	pDC->SelectObject (ptOldPen);
	}
}

/****************************************************************************
 *	ScMpView.c					D r a w J e t S y m b o l 					*
 ****************************************************************************/
void CMovingMapDoc::DrawJetSymbol(CDC* pDC, long lActLPx, long lActLPy)
{
double dCourse;

if (m_ptDoc->GetCourse (&dCourse))
	{
	dCourse = 360 - dCourse;				// rotate in other direction
	double dRad = pi * dCourse / 180;
	
	
	long	dUnit = 10;
	CVektor ActPos(lActLPx, lActLPy);
	
	CVektor vOffset(0, -3*dUnit);					
	CVektor Cockpit = ActPos + vOffset;

	vOffset.Set (0, -10*dUnit);				
	CVektor EndOfPlane = ActPos + vOffset;	
	
	vOffset.Set (-6*dUnit, -5*dUnit);
	CVektor Wing1Left = 	ActPos + vOffset;
	
	vOffset.Set (6*dUnit, -5*dUnit);
	CVektor Wing1Right = ActPos + vOffset;
	
	vOffset.Set (-2*dUnit, -8*dUnit);
	CVektor Wing2Left = ActPos + vOffset;

	vOffset.Set (2*dUnit, -8*dUnit);
	CVektor Wing2Right = ActPos + vOffset;
	
	Cockpit.Rotate (ActPos, dRad);
	EndOfPlane.Rotate (ActPos, dRad);
	Wing1Left.Rotate (ActPos, dRad);
	Wing1Right.Rotate (ActPos, dRad);
	Wing2Left.Rotate (ActPos, dRad);
	Wing2Right.Rotate (ActPos, dRad);
	
	

 	CPen PlanePen (PS_SOLID, dUnit, m_ActPosColor);		// originally: PS_DASH, PS_LTGRAY
	CPen* ptOldPen = (CPen*)pDC->SelectObject (&PlanePen);

	long LPx = (long)EndOfPlane.X();
	long LPy = (long)EndOfPlane.Y();
	pDC->MoveTo (lActLPx, lActLPy);
	pDC->LineTo (LPx, LPy);						// plane body
	
	LPx = (long)Wing1Left.X();
	LPy = (long)Wing1Left.Y();
	pDC->MoveTo (LPx, LPy);	
	LPx = (long)Cockpit.X();
	LPy = (long)Cockpit.Y();
	pDC->LineTo (LPx, LPy);	
	LPx = (long)Wing1Right.X();
	LPy = (long)Wing1Right.Y();
	pDC->LineTo (LPx, LPy);						// wing 1
	
	
	LPx = (long)Wing2Left.X();
	LPy = (long)Wing2Left.Y();
	pDC->MoveTo (LPx, LPy);
	LPx = (long)Wing2Right.X();
	LPy = (long)Wing2Right.Y();
	pDC->LineTo (LPx, LPy);						// wing 2
	
	pDC->SelectObject (ptOldPen);
	}
}

/****************************************************************************
 *	ScMpView.c				D r a w C r o s s S y m b o l 					*
 ****************************************************************************/
void CMovingMapDoc::DrawCrossSymbol(CDC* pDC, long lActLPx, long lActLPy)
{
	long	dUnit = 10;

 	CPen PlanePen (PS_SOLID, dUnit, m_ActPosColor);		// originally: PS_DASH, PS_LTGRAY
	CPen* ptOldPen = (CPen*)pDC->SelectObject (&PlanePen);

	pDC->MoveTo (lActLPx, lActLPy +  3*dUnit);
	pDC->LineTo (lActLPx, lActLPy + 6*dUnit);		// north line
	
	pDC->MoveTo (lActLPx +  3*dUnit, lActLPy);
	pDC->LineTo (lActLPx + 6*dUnit, lActLPy);		// east line
	
	pDC->MoveTo (lActLPx, lActLPy -  3*dUnit);
	pDC->LineTo (lActLPx, lActLPy - 6*dUnit);		// south line

	pDC->MoveTo (lActLPx -  3*dUnit, lActLPy);
	pDC->LineTo (lActLPx - 6*dUnit, lActLPy);		// west line
	
	pDC->SelectObject (ptOldPen);
}

/****************************************************************************
 *	ScMpView.cpp					C i r c l e								*
 ****************************************************************************/
void CMovingMapDoc::Circle (CDC* pDC, long nX0, long nY0, short nRadius, BOOL bFilled)
{
CSymbols::Ellipse (pDC, nX0-nRadius, nY0-nRadius, nX0+nRadius, nY0+nRadius, bFilled);
}


/****************************************************************************
 *	ScMpView.c				D r a w C i r c l e S y m b o l 				*
 ****************************************************************************/
void CMovingMapDoc::DrawCircleSymbol(CDC* pDC, long lActLPx, long lActLPy)
{
	long	dUnit = 10;

 	CPen PlanePen (PS_SOLID, dUnit, m_ActPosColor);		// originally: PS_DASH, PS_LTGRAY
	CPen* ptOldPen = (CPen*)pDC->SelectObject (&PlanePen);

	short nRadius = 5*(short)dUnit;
	BOOL	bFilled = FALSE;

	this->Circle (pDC, lActLPx, lActLPy, nRadius, bFilled);

	pDC->SelectObject (ptOldPen);
}

/****************************************************************************
 *	ScMpView.c				D r a w D e l t a S y m b o l 					*
 ****************************************************************************/
void CMovingMapDoc::DrawDeltaSymbol(CDC* pDC, long lActLPx, long lActLPy)
{
double dCourse;

if (m_ptDoc->GetCourse (&dCourse))
	{
	dCourse = 360 - dCourse;				// rotate in other direction
	double dRad = pi * dCourse / 180;
	
	
	long	dUnit = 10;
	CVektor ActPos(lActLPx, lActLPy);
	
	CVektor vOffset(-3*dUnit, -10*dUnit);
	CVektor BaseLeft = 	ActPos + vOffset;
	
	vOffset.Set (3*dUnit, -10*dUnit);
	CVektor BaseRight = ActPos + vOffset;
	
	BaseLeft.Rotate (ActPos, dRad);
	BaseRight.Rotate (ActPos, dRad);
	
	
 	CPen PlanePen (PS_SOLID, dUnit, m_ActPosColor);		// originally: PS_DASH, PS_LTGRAY
	CPen* ptOldPen = (CPen*)pDC->SelectObject (&PlanePen);

	pDC->MoveTo (lActLPx, lActLPy);
	
	long LPx = (long)BaseLeft.X();
	long LPy = (long)BaseLeft.Y();
	pDC->LineTo (LPx, LPy);
	LPx = (long)BaseRight.X();
	LPy = (long)BaseRight.Y();
	pDC->LineTo (LPx, LPy);		
		
	pDC->LineTo (lActLPx, lActLPy);
	
	pDC->SelectObject (ptOldPen);
	}
}


/****************************************************************************
 *	ScMpView.c				D r a w A c t P o s S y m b o l 				*
 ****************************************************************************/
void CMovingMapDoc::DrawActPosSymbol(CDC* pDC, long lActLPx, long lActLPy)
{
	ActPosSymbol Symbol = ACTPOS_OFF;
	
	if (this->IsOnView())
		Symbol = this->GetActPosSymbol();

	switch (Symbol)
		{
		case ACTPOS_OFF:
			break;
		case ACTPOS_PLANE:
			this->DrawPlaneSymbol(pDC, lActLPx, lActLPy);
			break;
		case ACTPOS_JET:
			this->DrawJetSymbol(pDC, lActLPx, lActLPy);
			break;
		case ACTPOS_CIRCLE:
			this->DrawCircleSymbol(pDC, lActLPx, lActLPy);
			break;
		case ACTPOS_CROSS:
			this->DrawCrossSymbol(pDC, lActLPx, lActLPy);
			break;
		case ACTPOS_DELTA:
			this->DrawDeltaSymbol(pDC, lActLPx, lActLPy);
			break;
		}
}
