#ifndef __MOVINGMAPDOC__      
#define __MOVINGMAPDOC__

// MovingMap.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "TrackPt.h"
#include "Nmea.h"

typedef enum
{
	ACTPOS_OFF,
	ACTPOS_PLANE,
	ACTPOS_JET,
	ACTPOS_CIRCLE,
	ACTPOS_CROSS,
	ACTPOS_DELTA
} ActPosSymbol;

typedef enum
{
	TRACK_OFF,
	TRACK_LINE,
	TRACK_TAIL
} TrackSymbol;

typedef enum
{
	SOURCE_GPS,
	SOURCE_TRK,
	SOURCE_RTE
} MMSource;

typedef enum
{
	FAKT_01,
	FAKT_02,
	FAKT_04,
	FAKT_10,
	FAKT_20,
	FAKT_40
} SIMSPEEDFAKT;

class CLatLon;
class CCalculate;
class CMovingMapDoc : public CDocument
{
protected: // create from serialization only
	DECLARE_DYNCREATE(CMovingMapDoc)

// Attributes
private:  
	CWnd*		m_ptWnd;		// for timer
	CTrackDoc*	m_ptDoc;
	CGpsDoc*	m_ptGpsDoc; 
	CWayDoc*	m_ptWayDoc;

	BOOL		m_bRteLoaded;	// to start selection of Visual Approach Chart
	CLatLon		m_llStart;
	CLatLon		m_llLand;



	CNmea*		m_ptNmea;
	CTrackPoint	m_ActTrackPt;
 	BOOL		m_bTimeOut;
 
 	UINT		m_uTimer;
	BOOL		m_bJustStarted;
	BOOL		m_bJustFinished;
	BOOL		m_bRecording;
	BOOL		m_bShowSymbols;	// TRUE while showing moving map symbols on map
	BOOL		m_bScMapMoving;		// used in CMainFrame::MoveScMap and:
									// TRUE: use PointOnOrthoLegAtDist,
									// FALSE: use PointOnLoxoLegAtDist
								
								// preferences
	int	m_nActPosSymbol;
	int m_nTrackSymbol;
	int m_nChgMapLimit_mm;
	int m_nSource;
	int m_nSpeedFakt;
	COLORREF m_ActPosColor;


// Implementation
public:
	#define GPS_TIMER	2

	CMovingMapDoc();		
	~CMovingMapDoc();        

	BOOL Change (CWnd* ptWnd);
	void Serialize(CArchive& ar);

	BOOL InitReadNMEA (short nInpLen, short nOutLen);

	BOOL TimerStart();
	void TimerStop();

	BOOL Start(CWnd* ptWnd, CGpsDoc* ptGpsDoc, CTrackDoc* ptDoc, CWayDoc* ptWayDoc);
	BOOL IsJustStarted();
	BOOL IsJustFinished() { return m_bJustFinished; }
	void SetJustFinished (BOOL bSet) { m_bJustFinished = bSet; }
	BOOL NextStep();
	void Stop();
	
	BOOL KnowsStartLand () { return m_bRteLoaded; }
	CLatLon GetStartPos () { return m_llStart; }
	CLatLon GetLandPos() { return m_llLand; }

	BOOL IsScMapMoving() { return m_bScMapMoving; }
	void SetScMapMoved(BOOL bMoved) { m_bScMapMoving = bMoved; }
	BOOL IsRecording() { return m_bRecording; }
	
	void SetSymbolsOnView(BOOL bSet) { m_bShowSymbols = bSet; }
	BOOL IsOnView() { return m_bShowSymbols; }

	void SetActPosSymbol (ActPosSymbol Symbol) { m_nActPosSymbol = (int)Symbol; }
	void SetTrackSymbol (TrackSymbol Symbol) { m_nTrackSymbol = (int)Symbol; }
	void SetChangeMapLimit_mm (int nLimit) { m_nChgMapLimit_mm = nLimit; }
	void SetSource (MMSource Source) { m_nSource = (int)Source; }
	void SetSpeedFakt (SIMSPEEDFAKT Fakt) { m_nSpeedFakt = (int)Fakt; }
	void SetActPosColor(COLORREF Col) { m_ActPosColor = Col; };

	ActPosSymbol GetActPosSymbol () { return (ActPosSymbol)m_nActPosSymbol; }
	TrackSymbol GetTrackSymbol () { return (TrackSymbol)m_nTrackSymbol; }
	int GetChangeMapLimit_mm () { return m_nChgMapLimit_mm; }
	MMSource GetSource () { return (MMSource)m_nSource; }
	SIMSPEEDFAKT GetSpeedFakt () { return (SIMSPEEDFAKT)m_nSpeedFakt; }

	void Circle (CDC* pDC, long nX0, long nY0, short nRadius, BOOL bFilled);
	void DrawPlaneSymbol(CDC* pDC, long lActLPx, long lActLPy);
	void DrawJetSymbol(CDC* pDC, long lActLPx, long lActLPy);
	void DrawCrossSymbol(CDC* pDC, long lActLPx, long lActLPy);
	void DrawCircleSymbol(CDC* pDC, long lActLPx, long lActLPy);
	void DrawDeltaSymbol(CDC* pDC, long lActLPx, long lActLPy);
	void DrawActPosSymbol(CDC* pDC, long lActLPx, long lActLPy);


private:
	BOOL PrepareForGps();
	BOOL PrepareForTrk();
	BOOL PrepareForRte();

	BOOL RecordForGps();
	BOOL RecordForTrk();
	BOOL RecordForRte();

	BOOL EndForGps();
	BOOL EndForTrk();
	BOOL EndForRte();

	unsigned long GetSimStep_sec ();
	CLatLon PointOnLegAtDist (double dDist, CLatLon& LL1, CLatLon& LL2);
	long AltOnLegAtDist (double dDist, double dDistLeg, long lAltWpt0, long lAltWpt1);
	void AppendTrackPt (CLatLon& LL, long lAlt_ft, short nIAS_kt,
								   unsigned long ulTimeSimulate_sec);
	unsigned long GetTrkSimTime (short nHour, short nMin, short nSec);

private:
	CCalculate* m_ptLegs;
	unsigned long m_ulTimeSimulate_sec;
	unsigned long m_ulStartTime;

	short	m_nTrackSimIndex;
	short	m_nTrackPtCnt;
	// Generated message map functions
protected:
	//{{AFX_MSG(CMovingMapDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

	
#endif 

