// MMPrevDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "PF.h"

#include "InitDoc.h"
#include "MvMapDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CMMPrevDlg 


CMMPrevDlg::CMMPrevDlg(CWnd* pParent, CMovingMapDoc* ptDoc)
	: CDlgTool(CMMPrevDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMMPrevDlg)
	m_nChgMapLimit_mm = 5;
	m_nActPosSymbol = 1;
	m_nTrackSymbol = 0;
	m_nSource = -1;
	m_nSpeedFakt = -1;
	//}}AFX_DATA_INIT

	m_ptDoc = ptDoc;
	if (m_ptDoc != NULL)
	{
		m_nActPosSymbol = (int)m_ptDoc->GetActPosSymbol ();
		m_nTrackSymbol = (int)m_ptDoc->GetTrackSymbol ();
		m_nChgMapLimit_mm = m_ptDoc->GetChangeMapLimit_mm ();
		m_nSource = (int)m_ptDoc->GetSource();
		m_nSpeedFakt = (int)m_ptDoc->GetSpeedFakt();
	}
	else
	{
		this->Init();
	}
}


void CMMPrevDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMMPrevDlg)
	DDX_Text(pDX, IDC_MMLIMIT, m_nChgMapLimit_mm);
	DDV_MinMaxInt(pDX, m_nChgMapLimit_mm, 1, 20);
	DDX_CBIndex(pDX, IDC_MMACTPOS, m_nActPosSymbol);
	DDX_CBIndex(pDX, IDC_MMTRACK, m_nTrackSymbol);
	DDX_CBIndex(pDX, IDC_MMSOURCE, m_nSource);
	DDX_CBIndex(pDX, IDC_MMSPEEDFAKT, m_nSpeedFakt);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMMPrevDlg, CDlgTool)
	//{{AFX_MSG_MAP(CMMPrevDlg)
	ON_BN_CLICKED(IDC_MMRESET, OnReset)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/****************************************************************************
 *	MvMapDlg.cpp					I n i t									*
 ****************************************************************************/
void CMMPrevDlg::Init()
{
	m_nChgMapLimit_mm	= 5;
	m_nActPosSymbol		= ACTPOS_PLANE;
	m_nTrackSymbol		= TRACK_LINE;
	m_nSource			= SOURCE_GPS;
	m_nSpeedFakt		= FAKT_10;
}

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CMMPrevDlg 

/****************************************************************************
 *	MvMapDlg.cpp					O n O K									*
 ****************************************************************************/
void CMMPrevDlg::OnOK() 
{
	// TODO: Zustzliche Prfung hier einfgen
	
	CDlgTool::OnOK();

	m_ptDoc->SetActPosSymbol ((ActPosSymbol)m_nActPosSymbol); 
	m_ptDoc->SetTrackSymbol ((TrackSymbol)m_nTrackSymbol);
	m_ptDoc->SetChangeMapLimit_mm (m_nChgMapLimit_mm);
	m_ptDoc->SetSource ((MMSource)m_nSource);
	m_ptDoc->SetSpeedFakt ((SIMSPEEDFAKT)m_nSpeedFakt);

}

/****************************************************************************
 *	MvMapDlg.cpp					O n R e s e t							*
 ****************************************************************************/
void CMMPrevDlg::OnReset() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->Init();
	this->UpdateData(FALSE);
}

/************************************************************************
 *  MvMapDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CMMPrevDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}


BOOL CMMPrevDlg::OnInitDialog() 
{
	CDlgTool::OnInitDialog();
	
	// TODO: Zustzliche Initialisierung hier einfgen
	if (m_ptDoc->IsRecording())
	{
		this->DisableControl (IDC_MMSOURCE, TRUE);	// dimm source selection Popup
		this->DisableControl (IDC_MMRESET, TRUE);	// dimm data reset button
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}
