/*********************************************************************
 *							N m e a . c	p p						     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "resource.h"					// IDS_NO_NMEA0183
#include "Nmea.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/************************************************************************
 *  Nmea.cpp					C N m e a 					CONSTRUCTOR	*
 ************************************************************************/
CNmea::CNmea(long lBaud, short nData, float fStop, short nParity, BOOL bBinary)	:
	CSerCom (lBaud, nData, fStop, nParity, bBinary)
{


}


/************************************************************************
 *  Nmea.cpp				~ C N m e a						DESTRUCTOR	*
 ************************************************************************/
CNmea::~CNmea()
{
}

/****************************************************************************
 *	Nmea.cpp					E n d O f N M E A							*
 ****************************************************************************/
BOOL CNmea::EndOfNMEA (unsigned char* szBinBuff, short* ptRest)
{
BOOL bEnd = FALSE;
short	i;

*ptRest = 0;
									// last bytes: *, 0xHH, 0xLL, 0x0D, 0x0A
for (i=0; i<5 && !bEnd; i++)
	{
	bEnd = (*(szBinBuff + i) == '*');
	*ptRest = i;
	}

return bEnd;
}

/****************************************************************************
 *	wNMEA.c				G e t N e x t N M E A E v e n t						*
 ****************************************************************************/
BOOL CNmea::GetNextNMEAEvent (CNmeaEvent* ptNMEA, CFile* ptFile)
{
BOOL	bStop = FALSE;
long	lLen;
long	lRead = 0;
short	nOffs;
short	nStartCnt=0;
unsigned char	szBinBuff[256];		
BOOL 		bOK = FALSE;
BOOL		bStartNMEA = FALSE;
BOOL		bEndNMEA = FALSE;
char		szBuffer[256];

//ptNMEA = (CNmeaEvent*)new CNmeaEvent ();

do	{								// search start of NMEA sentence
	lRead = 1;	
	bStop = this->ReadBytes (&lRead, szBinBuff, ptFile) && ((nStartCnt++ > 5)); 
	if (bStop) 
		{
		AfxMessageBox (IDS_NO_NMEA0183);
		return bStop;
		}

	if (szBinBuff[0] == 0x24)
		bStartNMEA = TRUE;
	} while (!bStartNMEA && !bStop);

lRead = 1;							// read byte after "$"
bStop = this->ReadBytes (&lRead, szBinBuff+1, ptFile);
if (bStop) return bStop;

if (szBinBuff[1] == 0x50)			// $P...
	{								// Proprietary sentence
	ptNMEA->SetType(SN_PROP);		// SN_APPR, SN_QUERY, SN_PROP
									// $P...
	szBinBuff[2] = 0;				// 012
	ptNMEA->SetTalker(*((unsigned short*)(szBinBuff+1)));
	
	lRead = 3;						// Manufacturer's Code
	bStop = this->ReadBytes (&lRead, szBinBuff+2, ptFile);
	if (bStop) return bStop;
	
									// $Paaa
	szBinBuff[5] = 0;				// 012345
	ptNMEA->SetFunction(*((unsigned long*)(szBinBuff+2)));
	ptNMEA->SetCheckSum (ptNMEA->CalcCheckSum (0, szBinBuff+1, 4));
	}
else{								// Approved OR Query sentence:
	lRead = 4;	
	bStop = this->ReadBytes (&lRead, szBinBuff+2, ptFile);
	if (bStop) return bStop;
									// $aaccc	OR  $aaaaQ
									// 012345		012345
	ptNMEA->SetTalker( *((unsigned short*)(szBinBuff+1)));

	if (szBinBuff[5] == 0x51)
		{								// Query sentence
		ptNMEA->SetType (SN_QUERY);		// SN_APPR, SN_QUERY, SN_PROP
										// $aaaaQ
		szBinBuff[6] = 0;				// 0123456
		ptNMEA->SetFunction (*((unsigned long*)(szBinBuff+3)));	// requested talker ID + "Q"
		}
	else{								// Approved sentence
		ptNMEA->SetType(SN_APPR);		
										// $aaccc
		szBinBuff[6] = 0;				// 0123456
		ptNMEA->SetFunction(*((unsigned long*)(szBinBuff+3)));	// sentence formatter
		}
	ptNMEA->SetCheckSum (ptNMEA->CalcCheckSum (0, szBinBuff+1, 5));
	}

szBinBuff[lRead + 2] = 0;
lLen = sprintf (szBuffer, "\nNMEA: %s\tData: ", szBinBuff);
if (ptFile != NULL)
	ptFile->Write ((const void*)szBuffer, (UINT)lLen);

nOffs = 0;	
do	{										// read data...
	short nRest;

	lRead = 5;
	bStop = this->ReadBytes (&lRead, (szBinBuff+nOffs), ptFile);
	if (bStop) return bStop;
	
							// last bytes: *, 0xHH, 0xLL, 0x0D, 0x0A

	bEndNMEA = this->EndOfNMEA (szBinBuff+nOffs, &nRest);
	nOffs += (short)lRead;
	
	if (bEndNMEA)
		{             
		unsigned char uSentCheckSum;
		
		lRead = (long)nRest;
		bStop = this->ReadBytes (&lRead, (szBinBuff+nOffs), ptFile);
		if (bStop) return bStop;

		nOffs += nRest;
		
		ptNMEA->SetData (szBinBuff, nOffs-5);
		
		uSentCheckSum = (unsigned char)ptNMEA->SplitCheckSum (szBinBuff + nOffs - 4);
	
		ptNMEA->SetCheckSum (ptNMEA->CalcCheckSum (ptNMEA->GetCheckSum(), szBinBuff, nOffs-5));

		if (ptNMEA->GetCheckSum() == uSentCheckSum)
			{
			ptNMEA->WriteToFile (ptFile);
			bOK = TRUE;
			}
		}
	} while (!bEndNMEA);

//if (!bOK) MessageBox (NULL, (LPCSTR)"!bOK", (LPCSTR)"Stop", MB_OK);
	
return (!bOK);
}

/****************************************************************************
 *	wNMEA.c					S e n d N M E A E v e n t						*
 ****************************************************************************/
BOOL CNmea::SendNMEAEvent (CNmeaEvent* ptNMEA, CFile* ptFile)
{
	BOOL bSent = FALSE;
	unsigned char	szBinBuff[128];	
	long	lFunc;
	short	nOffs=0;
	unsigned char uChkSum;

	szBinBuff[nOffs++]= '$';

	switch (ptNMEA->GetType())
	{
		case SN_PROP:
			szBinBuff[nOffs++]= 'P';
			lFunc = ptNMEA->GetFunction();
			memcpy ((long*)(szBinBuff+nOffs), (long*)&lFunc, sizeof(long));
			nOffs+=3;
			nOffs += ptNMEA->GetData(szBinBuff+nOffs);
			break;
		case SN_QUERY:
			szBinBuff[nOffs++]= 'Q';		// not ready!!!
			break;
		case SN_APPR:
			szBinBuff[nOffs++]= 'x';		// not ready!!!
			break;
	}


	szBinBuff[nOffs++]= '*';
	uChkSum = ptNMEA->CalcCheckSum(0, szBinBuff+1, nOffs-2);
//	nOffs += sprintf ((char*)(szBinBuff+nOffs), "%02X\r\n", uChkSum);
	nOffs += sprintf ((char*)(szBinBuff+nOffs), "%02X%c%c", uChkSum, 0x0D, 0x0A);

	ptNMEA->WriteToFile (ptFile);

	bSent = this->Write (szBinBuff, nOffs);
	return bSent;
}

/****************************************************************************
 *	wNMEA.c					S e n d M G N C S M								*
 ****************************************************************************/
void CNmea::SendMGNCSM (CNmeaEvent* ptNMEA)
{
												// send received check sum
	char szSum[16];
	sprintf (szSum, "%02X", ptNMEA->GetCheckSum());
	CNmeaEvent CheckSum(SN_PROP, FM_MGN, MGN_CSM, szSum);
	this->SendNMEAEvent (&CheckSum, NULL);
}


/////////////////////////////////////////////////////////////////////////////
// CNmea diagnostics

#ifdef _DEBUG
void CNmea::AssertValid() const
{
	CSerCom::AssertValid();
}

void CNmea::Dump(CDumpContext& dc) const
{
	CSerCom::Dump(dc);
}

#endif //_DEBUG

IMPLEMENT_DYNAMIC(CNmea, CSerCom)
