/*********************************************************************
 *							N m e a E v . c	p p					     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "Location.h"			// defines INDICATOR_SIZE
#include "NmeaEv.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/****************************************************************************
 *	NmeaEv.cpp				S p l i t L a t i t u d e						*
 ****************************************************************************/
double SplitLatitude (char* szLat)
{
char szLatDegr[3];
double	fLat, fMinutes;

*(szLatDegr + 0) = *(szLat + 0);
*(szLatDegr + 1) = *(szLat + 1);
*(szLatDegr + 2) = 0;

fLat = atoi (szLatDegr);				// 2 fixed digits of degrees
fMinutes = atof (szLat + 2);			// minutes with decimal fraction
fLat += fMinutes / 60;

return fLat;
}

/****************************************************************************
 *	NmeaEv.cpp				S p l i t L o n g i t u d e						*
 ****************************************************************************/
double SplitLongitude (char* szLon)
{
char szLonDegr[4];
double	fLon, fMinutes;

*(szLonDegr + 0) = *(szLon + 0);
*(szLonDegr + 1) = *(szLon + 1);
*(szLonDegr + 2) = *(szLon + 2);
*(szLonDegr + 3) = 0;

fLon = atoi (szLonDegr);				// 3 fixed digits of degrees
fMinutes = atof (szLon + 3);			// minutes with decimal fraction
fLon += fMinutes / 60;

return fLon;
}

/****************************************************************************
 *	NmeaEv.cpp					S p l i t D a t e							*
 ****************************************************************************/
void SplitDate (char* szDate, short* ptDay, short* ptMonth, short* ptYear)
{
char szDateDay[3];
char szDateMonth[3];

*(szDateDay + 0) = *(szDate + 0);
*(szDateDay + 1) = *(szDate + 1);
*(szDateDay + 2) = 0;

*(szDateMonth + 0) = *(szDate + 2);
*(szDateMonth + 1) = *(szDate + 3);
*(szDateMonth + 2) = 0;

*ptDay 	= atoi (szDateDay);			// 2 fixed digits for day
*ptMonth= atoi (szDateMonth);		// 2 fixed digits for month
*ptYear	= atoi (szDate + 4);		// 2 fixed digits for year
}


/****************************************************************************
 *	NmeaEv.cpp					S p l i t T i m e							*
 ****************************************************************************/
void SplitTime (char* szTime, short* ptHour, short* ptMin, double* ptSec)
{
char szTimeHour[3];
char szTimeMin[3];

*(szTimeHour + 0) = *(szTime + 0);
*(szTimeHour + 1) = *(szTime + 1);
*(szTimeHour + 2) = 0;

*(szTimeMin + 0) = *(szTime + 2);
*(szTimeMin + 1) = *(szTime + 3);
*(szTimeMin + 2) = 0;

*ptHour = atoi (szTimeHour);			// 2 fixed digits of hours
*ptMin  = atoi (szTimeMin);				// 2 fixed digits of minutes
*ptSec	= atof (szTime + 4);			// minutes with decimal fraction
}


/************************************************************************
 *  NmeaEv.cpp				C N m e a E v e n t				CONSTRUCTOR	*
 ************************************************************************/
CNmeaEvent::CNmeaEvent()
{
m_uType=0;		
m_nTalker=0;	
m_lFunc=0;		
memset (m_szData, 0, 80);
m_uCheckSum=0;
}

/************************************************************************
 *  NmeaEv.cpp				C N m e a E v e n t				CONSTRUCTOR	*
 ************************************************************************/
CNmeaEvent::CNmeaEvent(unsigned char uType, long lManufacturer, long lCmd)
{
m_uType=uType;		
m_nTalker=0;	
m_lFunc=lManufacturer;		
memset (m_szData, 0, 80);
sprintf (m_szData, "%s", (char*)((long*)&lCmd));
m_uCheckSum=0;
}

/************************************************************************
 *  NmeaEv.cpp				C N m e a E v e n t				CONSTRUCTOR	*
 ************************************************************************/
CNmeaEvent::CNmeaEvent(unsigned char uType, long lManufacturer, long lCmd, char* szData)
{
m_uType=uType;		
m_nTalker=0;	
m_lFunc=lManufacturer;		
memset (m_szData, 0, 80);
sprintf (m_szData, "%s,%s", (char*)((long*)&lCmd), szData);
m_uCheckSum=0;
}



/************************************************************************
 *  NmeaEv.cpp			~ C N m e a	E v e n t			DESTRUCTOR	*
 ************************************************************************/
CNmeaEvent::~CNmeaEvent()
{
}

/****************************************************************************
 *	NmeaEv.cpp					C a l c C h e c k S u m						*
 ****************************************************************************/
unsigned char CNmeaEvent::CalcCheckSum (unsigned char uOld, unsigned char* szBinBuff, short nLen)
{
short i;

for (i=0; i<nLen; i++)
	{
	uOld = uOld ^ *(szBinBuff + i);
	}
return uOld;
}

/************************************************************************
 *  NmeaEv.cpp					S e t D a t a							*
 ************************************************************************/
void CNmeaEvent::SetData (unsigned char* ptData, short nLen)
{
_fmemcpy (m_szData, ptData, nLen);
*(m_szData + nLen) = 0;					  	// make C-String
}

/************************************************************************
 *  NmeaEv.cpp					G e t D a t a							*
 ************************************************************************/
short CNmeaEvent::GetData (unsigned char* ptData)
{
strcpy ((char*)ptData, m_szData);
return strlen (m_szData);
}

/************************************************************************
 *  NmeaEv.cpp			G e t F i r s t D a t a C h a r					*
 ************************************************************************/
char CNmeaEvent::GetFirstDataChar ()
{
return *m_szData;
}

/************************************************************************
 *  NmeaEv.cpp					G e t M G N F u n c						*
 ************************************************************************/
long CNmeaEvent::GetMGNFunc ()
{
long lFunc=0;
char szFunc[4];

strncpy (szFunc, m_szData, 3);	// extract first 3 chars of data
szFunc[3]=0;

memcpy (&lFunc, (long*)szFunc, sizeof(long));	// get func ID
return lFunc;
}

/************************************************************************
 *  NmeaEv.cpp					A p p e n d	L a t						*
 ************************************************************************/
void CNmeaEvent::AppendLat(double dLat)
{
	BOOL bLat = TRUE;
	short	nOffs, nDegr, nMin, nSec, nDir;
	float fSec;

	CLatLon::AngleToDMS (dLat, bLat, &nDegr, &nMin, &nSec, &nDir);

	fSec = (float)nSec/60 * 1000;
	nOffs = strlen (m_szData);
	sprintf (m_szData+nOffs, ",%02d%02d.%03d,%c", nDegr, nMin, (short)fSec, (char)nDir);
}

/************************************************************************
 *  NmeaEv.cpp					A p p e n d	L o n						*
 ************************************************************************/
void CNmeaEvent::AppendLon(double dLon)
{
	BOOL bLat = FALSE;
	short	nOffs, nDegr, nMin, nSec, nDir;
	float fSec;

	CLatLon::AngleToDMS (dLon, bLat, &nDegr, &nMin, &nSec, &nDir);

	fSec = (float)nSec/60 * 1000;
	nOffs = strlen (m_szData);
	sprintf (m_szData+nOffs, ",%03d%02d.%03d,%c", nDegr, nMin, (short)fSec, (char)nDir);

}

/************************************************************************
 *  NmeaEv.cpp					A p p e n d	A l t						*
 ************************************************************************/
void CNmeaEvent::AppendAlt(long lAlt, char cDim)
{
	short nOffs = strlen (m_szData);
	sprintf (m_szData+nOffs, ",%04d,%c", lAlt, cDim);
}

/************************************************************************
 *  NmeaEv.cpp					A p p e n d	T e x t						*
 ************************************************************************/
void CNmeaEvent::AppendText (char* szText)
{
	short nOffs = strlen (m_szData);
	sprintf (m_szData+nOffs, ",%s", szText);
}

/************************************************************************
 *  NmeaEv.cpp					A p p e n d	S h o r t					*
 ************************************************************************/
void CNmeaEvent::AppendShort (short nVal)
{
	short nOffs = strlen (m_szData);
	sprintf (m_szData+nOffs, ",%d", nVal);
}

/************************************************************************
 *  NmeaEv.cpp					A p p e n d	C h a r						*
 ************************************************************************/
void CNmeaEvent::AppendChar (char cVal)
{
	short nOffs = strlen (m_szData);
	sprintf (m_szData+nOffs, ",%c", cVal);
}

/************************************************************************
 *  Garmin.cpp				C o p y W p t N a m e						*
 *  copies nBytes bytes into lpOut, starting at nOffs.					*
 *  source is szName with nMaxWptChars chars.							*
 *  if nLen < nBytes, lpOut will get space chars						*
 ************************************************************************/
void CNmeaEvent::CopyWptName (unsigned char* lpOut, short nOffs, short nBytes,
				char* szName, short nLen)
{
short i;
BOOL	bEnd = FALSE;
int	ch = 0;
				    // use upper case letters only
for (i=0; i<nBytes; i++)	    // fill "nBytes" bytes of lpOut
    {
    if (!bEnd)
		{
		ch = *(szName+i);
		if (ch == '') ch = 'S';    // check: 
		if (ch == '+') ch = 0x20;   // convert "+" to space char
					    // stop copy on first space char
		bEnd = (ch == 0) || (ch == 0x20) || (i>=nLen);
		}

    if (bEnd)
		{
		//ch = 0x20;			// fill with spaces until nBytes is reached
		ch = 0;					// end of string
		}
    else{
	//	if (!isupper (ch))
	//	    ch = toupper (ch);

		if (ch == '') ch = 'A';      // 
		if (ch == '') ch = 'O';      // 
		if (ch == '') ch = 'U';      // 

		if (ch == '') ch = 'a';      // 
		if (ch == '') ch = 'o';      // 
		if (ch == '') ch = 'u';      // 	
		}
    *(lpOut + nOffs + i) = ch;
    }
}

/************************************************************************
 *  NmeaEv.cpp					A p p e n d	N a m e						*
 ************************************************************************/
void CNmeaEvent::AppendName (char* szName)
{
	char szText[32];
	short nMaxLen = strlen(szName);
	this->CopyWptName ((unsigned char*)szText, 0, nMaxLen, szName, nMaxLen);
	szText[nMaxLen]=0;
	this->AppendText(szText);
}

/************************************************************************
 *  NmeaEv.cpp				W r i t e T o F i l e						*
 ************************************************************************/
void CNmeaEvent::WriteToFile (CFile* ptFile)
{
long	lLen;

if (ptFile != NULL)
	{
	lLen = strlen (m_szData);
	if (ptFile != NULL)
		{
		ptFile->Write ((const void*)m_szData, (UINT)lLen);

		char szCRLF[16];
		lLen = sprintf (szCRLF, "\r\n");
		ptFile->Write ((const void*)szCRLF, (UINT)lLen);
		}
	}
}

/****************************************************************************
 *	NmeaEv.cpp					H e x T o D e z								*
 ****************************************************************************/
short CNmeaEvent::HexToDez (unsigned char cHex)
{
short	nDez=0;

if (cHex >= 48 && cHex <= 57)
	nDez = (short)cHex - 48;

if (cHex >= 65 && cHex <= 70)
	nDez = (short)cHex - 55;
	
return nDez;
}

/****************************************************************************
 *	NmeaEv.cpp				S p l i t C h e c k S u m						*
 ****************************************************************************/
unsigned short CNmeaEvent::SplitCheckSum (unsigned char* szBinBuff)
{
unsigned short uSum;

uSum = 16 * this->HexToDez(*(szBinBuff + 0)) + 
			this->HexToDez(*(szBinBuff + 1));

return uSum;
}

/****************************************************************************
 *	NmeaEv.cpp				G e t N e x t N M E A p a r a m					*
 ****************************************************************************/
BOOL CNmeaEvent::GetNextNMEAparam (char* ptData, short* ptOffs, char* szParam, short* ptParamID)
{
BOOL bNextParam = (*(ptData + *ptOffs) == 0x2C);
(*ptOffs)++;
(*ptParamID)++;

if (bNextParam)
	{
	char ch;
	short i=0;
	BOOL bEnd;
	
	do	{
		ch = (*(ptData + *ptOffs));
		bEnd = ((ch == 0x2C) || (ch == 0));
		
		if (!bEnd)
			{							// no field delimiter, no end of param:
			*(szParam + i++) = ch;
			(*ptOffs)++;
			}
		else{
			*(szParam + i++) = 0;
			}
		} while (!bEnd);
	}
	
return bNextParam;
}

/****************************************************************************
 *	NmeaEv.cpp				G e t N e x t V a l i d P a r a m				*
 *  Purpose: Returns TRUE, for valid paramas only							*
 *			 Returns FALSE, after last param
 ****************************************************************************/
BOOL CNmeaEvent::GetNextValidParam (short* ptOffs, char* szParam, short* ptParamID)
{
BOOL	bParam;
BOOL	bValid;

do	{
	bParam = this->GetNextNMEAparam (m_szData, ptOffs, szParam, ptParamID);
	if (bParam)
		bValid = (*szParam != 0);
	} while (bParam && !bValid);

return bParam;	
}



/****************************************************************************
 *	NmeaEv.cpp					S p l i t G L L 							*
 ****************************************************************************/
void CNmeaEvent::SplitGLL (NMEA_GLL* ptGLL)
{
char	szParam[80];
short	nOffs = 0;
short	nParamID = 0;

BOOL	bLat = FALSE;
BOOL	bLon = FALSE;
char	cDir;

memset (ptGLL, 0, sizeof (NMEA_GLL));

while (GetNextValidParam (&nOffs, szParam, &nParamID))
	{
	switch (nParamID)
		{
		case 1:								
			ptGLL->fLat = SplitLatitude (szParam);
			bLat = TRUE;
			break;
		case 2:	
			cDir = *szParam;
			if (cDir == 'S')
				ptGLL->fLat *= -1;
			break;
		
		case 3:									
			ptGLL->fLon = SplitLongitude (szParam);
			bLon = TRUE;
			break;
		case 4:
			cDir = *szParam;
			if (cDir == 'W')
				ptGLL->fLon *= -1;
			break;
			
		case 5:									
			SplitTime (szParam, &ptGLL->nHour, &ptGLL->nMin, &ptGLL->fSec);
			ptGLL->bTime = TRUE;
			break;
			
		case 6:
			ptGLL->cDataState = *szParam;
			break;
			
		default:
			break;
		}
	}

ptGLL->bLatLon = (bLat && bLon);
}

/****************************************************************************
 *	NmeaEv.cpp					S p l i t R M B								*
 ****************************************************************************/
void CNmeaEvent::SplitRMB (NMEA_RMB* ptRMB)
{
char	szParam[80];
short	nOffs = 0;
short	nParamID = 0;

BOOL	bLat	= FALSE;
BOOL	bLon	= FALSE;
BOOL	bRange	= FALSE;
BOOL	bBrng	= FALSE;
BOOL	bVelocity = FALSE;
char	cDir;

memset (ptRMB, 0, sizeof (NMEA_RMB));

while (GetNextValidParam (&nOffs, szParam, &nParamID))
	{
	switch (nParamID)
		{
		case 1:
			ptRMB->cDataState = *szParam;
			break;					
		case 2:								
			ptRMB->fCrossTrackErr_NM = atof (szParam);
			ptRMB->bCrossTrackErr = TRUE;
			break;
		case 3:
			ptRMB->cDirToSteer = *szParam;
			break;
		case 4:
			strcpy (ptRMB->szOrigWpt, szParam);
			break;
		case 5:
			strcpy (ptRMB->szDestWpt, szParam);
			break;

		case 6:								
			ptRMB->fDestLat = SplitLatitude (szParam);
			bLat = TRUE;
			break;
		case 7:	
			cDir = *szParam;
			if (cDir == 'S')
				ptRMB->fDestLat *= -1;
			break;
		
		case 8:									
			ptRMB->fDestLon = SplitLongitude (szParam);
			bLon = TRUE;
			break;
		case 9:
			cDir = *szParam;
			if (cDir == 'W')
				ptRMB->fDestLon *= -1;
			break;
		
		case 10:
			ptRMB->fRangeToDest_NM = atof (szParam);
			bRange = TRUE;
			break;
			
		case 11:									
			ptRMB->fBrngToDest_Dgr_T = atof (szParam);
			bBrng = TRUE;
			break;
		
		case 12:
			ptRMB->fVelClDest_kt = atof (szParam);
			bVelocity = TRUE;
			break;
		
		case 13:
			ptRMB->cArrivalState = *szParam;
			break;
			
		default:
			break;
		}
	}

ptRMB->bDestLatLon = (bLat && bLon);
ptRMB->bDestParams = (bRange && bBrng && bVelocity);
}

/****************************************************************************
 *	NmeaEv.cpp					S p l i t R M C								*
 ****************************************************************************/
void CNmeaEvent::SplitRMC (NMEA_RMC* ptRMC)
{
char	szParam[80];
short	nOffs = 0;
short	nParamID = 0;

BOOL	bLat = FALSE;
BOOL	bLon = FALSE;;
char	cDir;
BOOL	bSpeed = FALSE;
BOOL	bCourse = FALSE;

memset (ptRMC, 0, sizeof (NMEA_RMC));

while (GetNextValidParam (&nOffs, szParam, &nParamID))
	{
	switch (nParamID)
		{
		case 1:									
			SplitTime (szParam, &ptRMC->nHour, &ptRMC->nMin, &ptRMC->fSec);
			ptRMC->bTime = TRUE;
			break;
			
		case 2:
			ptRMC->cDataState = *szParam;
			break;
			
		case 3:								
			ptRMC->fLat = SplitLatitude (szParam);
			bLat = TRUE;
			break;
		case 4:	
			cDir = *szParam;
			if (cDir == 'S')
				ptRMC->fLat *= -1;
			break;
		
		case 5:									
			ptRMC->fLon = SplitLongitude (szParam);
			bLon = TRUE;
			break;
		case 6:
			cDir = *szParam;
			if (cDir == 'W')
				ptRMC->fLon *= -1;
			break;
		
		case 7:
			ptRMC->fSpeedGnd_kt = atof (szParam);
			bSpeed = TRUE;
			break;
		case 8:
			ptRMC->fCourseGnd_Dgr_T = atof (szParam);
			bCourse = TRUE;
			break;

		case 9:									
			SplitDate (szParam, &ptRMC->nDay, &ptRMC->nMonth, &ptRMC->nYear);
			ptRMC->bDate = TRUE;
			break;
		
		case 10:
			ptRMC->fVar = atof (szParam);
			ptRMC->bVar = TRUE;
			break;
		case 11:
			cDir = *szParam;
			if (cDir == 'W')
				ptRMC->fVar *= -1;
			break;
	
		default:
			break;
		}
	}

ptRMC->bLatLon = (bLat && bLon);
ptRMC->bGndParams = (bSpeed && bCourse);
}

/****************************************************************************
 *	NmeaEv.cpp					S p l i t G R M Z							*
 ****************************************************************************/
void CNmeaEvent::SplitGRMZ (NMEA_GRMZ* ptGRMZ)
{
char	szParam[80];
short	nOffs = 1;			// nOffs = 1: jump over first char, start with ","
short	nParamID = 0;

memset (ptGRMZ, 0, sizeof (NMEA_GRMZ));
						
while (GetNextValidParam (&nOffs, szParam, &nParamID))
	{
	switch (nParamID)
		{
		case 1:									
			ptGRMZ->nAlt = atoi (szParam);
			ptGRMZ->bAlt = TRUE;
			break;
			
		case 2:
			ptGRMZ->cDim = *szParam;
			break;
			
		case 3:								
			ptGRMZ->nVal = atoi (szParam);
			ptGRMZ->bVal = TRUE;
			break;
	
		default:
			break;
		}
	}
}

/****************************************************************************
 *	NmeaEv.cpp					S p l i t M G N C M D						*
 ****************************************************************************/
void CNmeaEvent::SplitMGNCMD(CString* ptCmd)
{
char	szParam[80];
short	nOffs = 3;			// nOffs = 3: jump over CMD chars, start with ","
short	nParamID = 0;

	ptCmd->Empty();
						
	if (GetNextValidParam (&nOffs, szParam, &nParamID))
	{
		*ptCmd = (CString)szParam;
	}
}

/****************************************************************************
 *	NmeaEv.cpp					S p l i t M G N C S M						*
 ****************************************************************************/
void CNmeaEvent::SplitMGNCSM (short* ptChkSum)
{
char	szParam[80];
short	nOffs = 3;			// nOffs = 3: jump over CSM chars, start with ","
short	nParamID = 0;

	*ptChkSum = 0;
						
	while (GetNextValidParam (&nOffs, szParam, &nParamID))
	{
		switch (nParamID)
		{
			case 1:									
				*ptChkSum = atoi (szParam);
				break;
		}
	}
}

/****************************************************************************
 *	NmeaEv.cpp					S p l i t M G N V E R						*
 ****************************************************************************/
void CNmeaEvent::SplitMGNVER (NMEA_MGNVER* ptVers)
{
char	szParam[80];
short	nOffs = 3;			// nOffs = 3: jump over VER chars, start with ","
short	nParamID = 0;

memset (ptVers, 0, sizeof (NMEA_MGNVER));

while (GetNextValidParam (&nOffs, szParam, &nParamID))
	{
	switch (nParamID)
		{
		case 1:									
			ptVers->nProdID = atoi (szParam);
			break;
			
		case 2:
			strcpy (ptVers->szRev, szParam);
			break;
			
		case 3:								
			strcpy (ptVers->szModel, szParam);
			break;

		case 4:								
			strcpy (ptVers->szDataBase, szParam);
			break;
	
		default:
			break;
		}
	}
}

/****************************************************************************
 *	NmeaEv.cpp					S p l i t M G N T R K						*
 ****************************************************************************/
void CNmeaEvent::SplitMGNTRK (NMEA_MGNTRK* ptTrack)
{
char	szParam[80];
short	nOffs = 3;			// nOffs = 3: jump over TRK chars, start with ","
short	nParamID = 0;

BOOL	bLat = FALSE;
BOOL	bLon = FALSE;
char	cDir;

memset (ptTrack, 0, sizeof (NMEA_MGNTRK));

while (GetNextValidParam (&nOffs, szParam, &nParamID))
	{
	switch (nParamID)
		{
		case 1:								
			ptTrack->fLat = SplitLatitude (szParam);
			bLat = TRUE;
			break;
		case 2:	
			cDir = *szParam;
			if (cDir == 'S')
				ptTrack->fLat *= -1;
			break;
		
		case 3:									
			ptTrack->fLon = SplitLongitude (szParam);
			bLon = TRUE;
			break;
		case 4:
			cDir = *szParam;
			if (cDir == 'W')
				ptTrack->fLon *= -1;
			break;
			
		case 5:
			ptTrack->nAlt = atoi (szParam);
			ptTrack->bAlt = TRUE;
			break;
		case 6:
			ptTrack->cDim = *szParam;
			break;

		case 7:									
			SplitTime (szParam, &ptTrack->nHour, &ptTrack->nMin, &ptTrack->fSec);
			ptTrack->bTime = TRUE;
			break;
			
		case 8:
			ptTrack->cDataState = *szParam;
			break;

		case 9:
			strcpy (ptTrack->szName, szParam);
			ptTrack->bName = (strlen(ptTrack->szName) > 0);
			break;

		default:
			break;
		}
	}

ptTrack->bLatLon = (bLat && bLon);
}

/****************************************************************************
 *	NmeaEv.cpp					S p l i t M G N W P L						*
 ****************************************************************************/
void CNmeaEvent::SplitMGNWPL (NMEA_MGNWPL* ptWpt)
{
char	szParam[80];
short	nOffs = 3;			// nOffs = 3: jump over WPL chars, start with ","
short	nParamID = 0;

BOOL	bLat = FALSE;
BOOL	bLon = FALSE;
char	cDir;

memset (ptWpt, 0, sizeof (NMEA_MGNWPL));

while (GetNextValidParam (&nOffs, szParam, &nParamID))
	{
	switch (nParamID)
		{
		case 1:								
			ptWpt->fLat = SplitLatitude (szParam);
			bLat = TRUE;
			break;
		case 2:	
			cDir = *szParam;
			if (cDir == 'S')
				ptWpt->fLat *= -1;
			break;
		
		case 3:									
			ptWpt->fLon = SplitLongitude (szParam);
			bLon = TRUE;
			break;
		case 4:
			cDir = *szParam;
			if (cDir == 'W')
				ptWpt->fLon *= -1;
			break;
			
		case 5:
			ptWpt->nAlt = atoi (szParam);
			ptWpt->bAlt = TRUE;
			break;
		case 6:
			ptWpt->cDim = *szParam;
			break;

		case 7:									
			strcpy (ptWpt->szName, szParam);
			ptWpt->bName = (strlen(ptWpt->szName) > 0);
			break;
			
		case 8:
			strcpy (ptWpt->szMessage, szParam);
			break;

		case 9:
			ptWpt->cIcon = *szParam;
			break;

		default:
			break;
		}
	}

ptWpt->bLatLon = (bLat && bLon);
}

/****************************************************************************
 *	NmeaEv.cpp					I s I c o n I n f o 						*
 ****************************************************************************/
BOOL CNmeaEvent::IsIconInfo (char* szParam)
{
	BOOL bIconInfo = FALSE;

	if (strlen(szParam) == 1)
	{
		char ch = *szParam;

		if (ch >= 'a' && ch <= 'z')		// a=97, z=122
			bIconInfo=TRUE;
	}
	return bIconInfo;
}

/************************************************************************
 *  NmeaEv.cpp				D e l e t e A r r a y O f 					*
 ************************************************************************/
void CNmeaEvent::DeleteArrayOf (CPtrArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	MGN_WPT_INFO* ptEntry;
	if ((ptEntry = (MGN_WPT_INFO*)ptArray->GetAt(i)) != NULL)
		{
		TRACE ("Deleting NmewEv MGN_WPT_INFO %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}          

/****************************************************************************
 *	NmeaEv.cpp					S p l i t M G N R T E						*
 ****************************************************************************/
void CNmeaEvent::SplitMGNRTE (NMEA_MGNRTE* ptRte)
{
char	szParam[80];
short	nOffs = 3;			// nOffs = 3: jump over WPL chars, start with ","
short	nParamID = 0;

BOOL	bRteDescription = FALSE;
BOOL	bRteMessage = FALSE;

memset (ptRte, 0, sizeof (NMEA_MGNRTE));
ptRte->ptWptNames = new CPtrArray;

while (GetNextValidParam (&nOffs, szParam, &nParamID))
	{
	switch (nParamID)
		{
		case 1:								
			ptRte->nNumbOfMsgs = atoi(szParam);
			break;
		case 2:	
			ptRte->nID = atoi(szParam);
			break;
		
		case 3:									
			ptRte->cIndic = *szParam;
			bRteDescription = (ptRte->cIndic == 'c');
			bRteMessage = (ptRte->cIndic == 'm');
			break;

		case 4:
			strcpy (ptRte->szName, szParam);
			ptRte->bName = (strlen(ptRte->szName) > 0);
			break;
			
		default:				// read array of wpt names
			if (ptRte->bName)
			{			// name received, get route description or message now:
				if (bRteDescription)
				{
					if (IsIconInfo(szParam))
					{			// put icon info to last waypoint name
						short nCnt = ptRte->ptWptNames->GetSize();
						MGN_WPT_INFO* ptInfo = (MGN_WPT_INFO*)ptRte->ptWptNames->GetAt(nCnt-1);
						ptInfo->cIcon = *szParam;
					}
					else
					{			// new way point name received
						MGN_WPT_INFO* ptInfo = new MGN_WPT_INFO;
						memset (ptInfo, 0, sizeof (MGN_WPT_INFO));
						strcpy (ptInfo->szName, szParam);
						ptRte->ptWptNames->Add(ptInfo);
					}
				}

				if (bRteMessage)
				{
					strcpy (ptRte->szMessage, szParam);
				}
			}
			break;
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CNmeaEvent diagnostics

#ifdef _DEBUG
void CNmeaEvent::AssertValid() const
{
	CObject::AssertValid();
}

void CNmeaEvent::Dump(CDumpContext& dc) const
{
	CObject::Dump(dc);
}

#endif //_DEBUG

IMPLEMENT_DYNAMIC(CNmeaEvent, CObject)
