#ifndef __NMEA_EVENT__
#define __NMEA_EVENT__
/*********************************************************************
 *							N m e a E v . h						     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "..\Cpptools\SerCom.h"

									// type of sentence
#define SN_APPR		0				// Approved Sentence Structure	
#define SN_QUERY	1				// Query Sentence
#define SN_PROP		2				// Proprietary Sentence

#define DS_VALID	('A')			// Data state DS_xxx
#define DS_INVALID	('V')

#define AS_TRUE		('A')			// Arrival state AS_xxx
#define AS_FALSE	('V')

#ifdef __MAC__             		// defines for MAC
#define FN_AAM	1094798592
#define FN_ALM	1095519488
#define FN_APB	1095778816
#define FN_ASD	1095975936
#define FN_BEC	1111835392
#define FN_BOD	1112491008
#define FN_BWC	1113015040
#define FN_BWR	1113018880
#define FN_BWW	1113020160
#define FN_DBT	1145197568
#define FN_DCN	1145261568
#define FN_DPT	1146115072
#define FN_DSC	1146307328
#define FN_DSE	1146307840
#define FN_DSI	1146308864
#define FN_DSR	1146311168
#define FN_DTM	1146375424
#define FN_FSI	1179863296
#define FN_GBS	1195528960
#define FN_GGA	1195852032
#define FN_GLC	1196180224
#define FN_GLL	1196182528
#define FN_GRS	1196577536
#define FN_GSA	1196638464
#define FN_GST	1196643328
#define FN_GSV	1196643840
#define FN_GXA	1196966144
#define FN_HDG	1212434176
#define FN_HDT	1212437504
#define FN_HSC	1213416192
#define FN_LCD	1279476736
#define FN_MSK	1297304320
#define FN_MSS	1297306368
#define FN_MTW	1297372928
#define FN_MWD	1297564672
#define FN_MWV	1297569280
#define FN_OLN	1330400768
#define FN_OSD	1330856960
#define FN_RMA	1380794624
#define FN_RMB	1380794880
#define FN_RMC	1380795136
#define FN_ROT	1380930560
#define FN_RPM	1380994304
#define FN_RSA	1381187840
#define FN_RSD	1381188608
#define FN_RTE	1381254400
#define FN_SFI	1397115136
#define FN_STN	1398033920
#define FN_TLL	1414286336
#define FN_TRF	1414678016
#define FN_TTM	1414810880
#define FN_VBW	1447188224
#define FN_VDR	1447318016
#define FN_VHW	1447581440
#define FN_VLW	1447843584
#define FN_VPW	1448105728
#define FN_VTG	1448363776
#define FN_WCV	1464030720
#define FN_WNC	1464746752
#define FN_WPL	1464880128
#define FN_XDR	1480872448
#define FN_XTE	1481917696
#define FN_XTR	1481921024
#define FN_ZDA	1514422528
#define FN_ZDL	1514425344
#define FN_ZFO	1514557184
#define FN_ZTG	1515472640
#define FN_APA	1095778560
#define FN_BER	1111839232
#define FN_BPI	1112557824
#define FN_DBK	1145195264
#define FN_DBS	1145197312
#define FN_DRU	1146246400
#define FN_GTD	1196704768
#define FN_HCC	1212367616
#define FN_HCD	1212367872
#define FN_HDM	1212435712
#define FN_HVD	1213613056
#define FN_HVM	1213615360
#define FN_IMA	1229799680
#define FN_MDA	1296318720
#define FN_MHU	1296585984
#define FN_MMB	1296908800
#define FN_MTA	1297367296
#define FN_MWH	1297565696
#define FN_MWS	1297568512
#define FN_OLW	1330403072
#define FN_OMP	1330466816
#define FN_ONZ	1330534912
#define FN_SBK	1396853504
#define FN_SCY	1396922624
#define FN_SCD	1396917248
#define FN_SDB	1396982272
#define FN_SGD	1397179392
#define FN_SGR	1397182976
#define FN_SIU	1397314816
#define FN_SLC	1397506816
#define FN_SNC	1397637888
#define FN_SNU	1397642496
#define FN_SPS	1397773056
#define FN_SSF	1397966336
#define FN_STC	1398031104
#define FN_STR	1398034944
#define FN_SYS	1398362880
#define FN_TEC	1413825280
#define FN_TEP	1413828608
#define FN_TGA	1413955840
#define FN_TIF	1414088192
#define FN_TRP	1414680576
#define FN_TRS	1414681344
#define FN_VCD	1447248896
#define FN_VPE	1448101120
#define FN_VTA	1448362240
#define FN_VTI	1448364288
#define FN_VWE	1448559872
#define FN_VWR	1448563200
#define FN_VWT	1448563712
#define FN_WDC	1464091392
#define FN_WDR	1464095232
#define FN_WFM	1464225024
#define FN_WNR	1464750592
#define FN_YWP	1498894336
#define FN_YWS	1498895104
#define FN_ZCD	1514357760
#define FN_ZEV	1514493440
#define FN_ZLZ	1514953216
#define FN_ZZU	1515869440

#define FN_GRM	1196576000
#endif
                            	// defines for PC
#define FN_AAM	5062977
#define FN_ALM	5065793
#define FN_APB	4345921
#define FN_ASD	4477761
#define FN_BEC	4408642
#define FN_BOD	4476738
#define FN_BWC	4413250
#define FN_BWR	5396290
#define FN_BWW	5723970
#define FN_DBT	5521988
#define FN_DCN	5129028
#define FN_DPT	5525572
#define FN_DSC	4412228
#define FN_DSE	4543300
#define FN_DSI	4805444
#define FN_DSR	5395268
#define FN_DTM	5067844
#define FN_FSI	4805446
#define FN_GBS	5456455
#define FN_GGA	4278087
#define FN_GLC	4410439
#define FN_GLL	5000263
#define FN_GRS	5460551
#define FN_GSA	4281159
#define FN_GST	5526343
#define FN_GSV	5657415
#define FN_GXA	4282439
#define FN_HDG	4670536
#define FN_HDT	5522504
#define FN_HSC	4412232
#define FN_LCD	4473676
#define FN_MSK	4936525
#define FN_MSS	5460813
#define FN_MTW	5723213
#define FN_MWD	4478797
#define FN_MWV	5658445
#define FN_OLN	5131343
#define FN_OSD	4477775
#define FN_RMA	4279634
#define FN_RMB	4345170
#define FN_RMC	4410706
#define FN_ROT	5525330
#define FN_RPM	5066834
#define FN_RSA	4281170
#define FN_RSD	4477778
#define FN_RTE	4543570
#define FN_SFI	4802131
#define FN_STN	5133395
#define FN_TLL	5000276
#define FN_TRF	4608596
#define FN_TTM	5067860
#define FN_VBW	5718614
#define FN_VDR	5391446
#define FN_VHW	5720150
#define FN_VLW	5721174
#define FN_VPW	5722198
#define FN_VTG	4674646
#define FN_WCV	5653335
#define FN_WNC	4410967
#define FN_WPL	5001303
#define FN_XDR	5391448
#define FN_XTE	4543576
#define FN_XTR	5395544
#define FN_ZDA	4277338
#define FN_ZDL	4998234
#define FN_ZFO	5195354
#define FN_ZTG	4674650
#define FN_APA	4280385
#define FN_BER	5391682
#define FN_BPI	4804674
#define FN_DBK	4932164
#define FN_DBS	5456452
#define FN_DRU	5591620
#define FN_GTD	4478023
#define FN_HCC	4408136
#define FN_HCD	4473672
#define FN_HDM	5063752
#define FN_HVD	4478536
#define FN_HVM	5068360
#define FN_IMA	4279625
#define FN_MDA	4277325
#define FN_MHU	5589069
#define FN_MMB	4345165
#define FN_MTA	4281421
#define FN_MWH	4740941
#define FN_MWS	5461837
#define FN_OLW	5721167
#define FN_OMP	5262671
#define FN_ONZ	5918287
#define FN_SBK	4932179
#define FN_SCY	5849939
#define FN_SCD	4473683
#define FN_SDB	4342867
#define FN_SGD	4474707
#define FN_SGR	5392211
#define FN_SIU	5589331
#define FN_SLC	4410451
#define FN_SNC	4410963
#define FN_SNU	5590611
#define FN_SPS	5460051
#define FN_SSF	4608851
#define FN_STC	4412499
#define FN_STR	5395539
#define FN_SYS	5462355
#define FN_TEC	4408660
#define FN_TEP	5260628
#define FN_TGA	4278100
#define FN_TIF	4606292
#define FN_TRP	5263956
#define FN_TRS	5460564
#define FN_VCD	4473686
#define FN_VPE	4542550
#define FN_VTA	4281430
#define FN_VTI	4805718
#define FN_VWE	4544342
#define FN_VWR	5396310
#define FN_VWT	5527382
#define FN_WDC	4408407
#define FN_WDR	5391447
#define FN_WFM	5064279
#define FN_WNR	5394007
#define FN_YWP	5265241
#define FN_YWS	5461849
#define FN_ZCD	4473690
#define FN_ZEV	5653850
#define FN_ZLZ	5917786
#define FN_ZZU	5593690    

#define FN_GRM	5067335
#define FM_MGN	5130061

#define MGN_CMD 4476227
#define MGN_CSM	5067587
#define MGN_END 4476485
#define MGN_RTE 4543570
#define MGN_TRK 4936276
#define MGN_VER 5391702
#define MGN_WPL 5001303


typedef struct 
		{
		BOOL	bLatLon;
		BOOL	bTime;
		
		double	fLat;
		double	fLon;
		short	nHour;
		short	nMin;
		double	fSec;
		char 	cDataState;				// DS_VALID, DS_INVALID, undefined: 0
		char	cDummy;
		} NMEA_GLL;

typedef struct 
		{
		BOOL	bCrossTrackErr;
		BOOL	bDestLatLon;
		BOOL	bDestParams;				// Range, Brng, Velocity
		
		char	cDataState;					// DS_VALID, DS_INVALID, undefined: 0
		char	cDirToSteer;				// L, R, undefined: 0
		char	szOrigWpt[6];
		char	szDestWpt[6];
		double	fCrossTrackErr_NM;			
		double	fDestLat;
		double	fDestLon;
		double	fRangeToDest_NM;
		double 	fBrngToDest_Dgr_T;			// Bearing to dest, degrees True
		double	fVelClDest_kt;				// Destination closing velocity, knots
		char    cArrivalState;				// AS_TRUE, AS_FALSE, undefined: 0
		} NMEA_RMB;
		
typedef struct 
		{
		BOOL	bTime;
		BOOL	bLatLon;
		BOOL	bGndParams;					// speed, course
		BOOL	bDate;
		BOOL	bVar;
		
		short	nHour;
		short	nMin;
		double	fSec;
		char	cDataState;				// DS_VALID, DS_INVALID, undefined: 0
		char	cDummy;
		double	fLat;
		double	fLon;
		double	fSpeedGnd_kt;
		double 	fCourseGnd_Dgr_T;		// Course over ground, degrees True
		short	nDay;
		short	nMonth;
		short	nYear;
		double	fVar;
		} NMEA_RMC;
		
typedef struct 
		{
		BOOL	bAlt;
		BOOL	bVal;
		
		short	nAlt;			
		char	cDim;			
		short	nVal;
		} NMEA_GRMZ;

typedef struct
		{
		short	nProdID;
		char	szRev[24];
		char	szModel[24];
		char	szDataBase[24];
		} NMEA_MGNVER;

typedef struct
		{
		BOOL	bLatLon;
		BOOL	bAlt;
		BOOL	bTime;
		BOOL	bName;

		double	fLat;
		double	fLon;

		short	nAlt;			
		char	cDim;			

		short	nHour;
		short	nMin;
		double	fSec;
		char 	cDataState;				// DS_VALID, DS_INVALID, undefined: 0
		char	szName[32];
		} NMEA_MGNTRK;

typedef struct
{
		char szName[32];		// waypoint name, "<<>>" should be ignored
		char cIcon;				// icon attached to waypoint
} MGN_WPT_INFO;

typedef struct
{
		BOOL	bName;

		short	nNumbOfMsgs;	// number of messages making up this route
		short	nID;			// number for this message
		char	cIndic;			// c: complete route description after name
								// m: route message after name
		char	szName[32];
		CPtrArray* ptWptNames;	// route description (array of MGN_WPT_INFO)
		char	szMessage[128];	// OR message (see: cIndic)
} NMEA_MGNRTE;

typedef struct
{
		BOOL	bLatLon;
		BOOL	bAlt;
		BOOL	bName;

		double	fLat;
		double	fLon;

		short	nAlt;			
		char	cDim;			

		char	szName[32];		// name of wpt
		char	szMessage[128];
		char	cIcon;
} NMEA_MGNWPL;



class CNmeaEvent : public CObject
{    
DECLARE_DYNAMIC(CNmeaEvent)
     
private:
	unsigned char	m_uType;			// SN_APPR, SN_QUERY, SN_PROP
	unsigned short	m_nTalker;			
	unsigned long	m_lFunc;			// Sentence Formatter, 
										//	Talker ID for Query,
										//	Manufacturer's Code
	char			m_szData[256];
	unsigned char	m_uCheckSum;



protected: // create from serialization only

// Attributes
// Operations
public:


// Implementation
private:

public:
	CNmeaEvent();
	CNmeaEvent(unsigned char uType, long lManufacturer, long lCmd);
	CNmeaEvent(unsigned char uType, long lManufacturer, long lCmd, char* szData);
	virtual ~CNmeaEvent();

	unsigned char CalcCheckSum (unsigned char uOld, unsigned char* szBinBuff, short nLen);
	void SetData (unsigned char* ptData, short nLen);
	short GetData (unsigned char* ptData);
	char GetFirstDataChar ();
	long GetMGNFunc ();

	void AppendLat(double dLat);
	void AppendLon(double dLon);
	void AppendAlt(long lAlt, char cDim);
	void AppendText (char* szText);
	void AppendShort (short nVal);
	void AppendChar (char cVal);
	void CopyWptName (unsigned char* lpOut, short nOffs, short nBytes,
				char* szName, short nLen);
	void AppendName (char* szName);

	void WriteToFile (CFile* ptFile);
	short HexToDez (unsigned char cHex);
	unsigned short SplitCheckSum (unsigned char* szBinBuff);
	BOOL GetNextNMEAparam (char* ptData, short* ptOffs, char* szParam, short* ptParamID);
	BOOL GetNextValidParam (short* ptOffs, char* szParam, short* ptParamID);
	void SplitGLL (NMEA_GLL* ptGLL);
	void SplitRMB (NMEA_RMB* ptRMB);
	void SplitRMC (NMEA_RMC* ptRMC);
	void SplitGRMZ (NMEA_GRMZ* ptGRMZ);

	BOOL IsIconInfo (char* szParam);
	static void DeleteArrayOf (CPtrArray* ptArray);
	void SplitMGNCMD (CString* ptCmd);
	void SplitMGNCSM (short* ptChkSum);
	void SplitMGNVER (NMEA_MGNVER* ptVers);
	void SplitMGNTRK (NMEA_MGNTRK* ptTrack);
	void SplitMGNWPL (NMEA_MGNWPL* ptWpt);
	void SplitMGNRTE (NMEA_MGNRTE* ptRte);


	void SetType (unsigned char uType) { m_uType = uType; }
	void SetTalker (unsigned short uTalker) { m_nTalker = uTalker; }
	void SetFunction (unsigned long lFunc) { m_lFunc = lFunc; }
	void SetCheckSum (unsigned char uSum) { m_uCheckSum = uSum; }

	unsigned char GetType () { return m_uType; }
	unsigned long GetFunction () { return m_lFunc; }
	unsigned char GetCheckSum () { return m_uCheckSum; }

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};




#endif
