// Pf.cpp : Defines the class behaviors for the application.
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

// to detect memory leaks, remove comments of next 3 lines:
//#define _CRTDBG_MAP_ALLOC
//#include <stdlib.h>
//#include <crtdbg.h>


/*
To detect memory leaks:
Set a break point at the beginning of the programm,
open QuickWatch window,
type _crtBreakAlloc
press RETURN. The name "_crtBreakAlloc" appears below the name column, -1 below the value column.
Now replace -1 with the number of the memory allocation, seen at the memory leak.
As soon as the bad memory is allocated, the debugger stopps
and the the Call Stack window shows, where the allocation occured!!
*/


/* Modifications
4.0.0.1:
after changing to negative increase cnt, changing the map via arrow keys will reset incrCnt to 0

*/

#include "stdafx.h"

#include <AFXPRIV.H>			// for WM_INITIALUPDATE

#include "Pf.h"

#include "InitDoc.h"
#include "InitDlg.h"
#include "PersDlg.h"
#include "MetDoc.h"
#include "TrackDoc.h"

#include "MainFrm.h"
#include "LocDoc.h"
#include "PlaneDoc.h"			// defines PL_MAX_TANK
#include "WayDoc.h"
#include "ElevDoc.h"
#include "ElevArrayDoc.h"
#include "Calc.h"				// this statement must be after PlaneDoc.h	(PL_MAX_TANK)
								// in Calc.h defines arrays[PL_MAX_TANK];
#include "CourseVw.h"
#include "RteView.h"			// to show route on map
#include "ElevView.h"
#include "FuelView.h"
#include "FlPlView.h"
#include "WayView.h"
#include "PlaneVw.h"
#include "LocView.h"
#include "ScMpView.h"
#include "MovingMp.h"

#include "TrackVw.h"
#include "AltVw.h"
#include "SpeedVw.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


CInitDoc* 		ptInit;  
CFontDoc* 		ptFontTool;
CDimDoc* 		ptDim;
CLoadDoc*		ptLoad;
CCalcDoc*		ptCalc;               
CAppendixDoc*	ptAppend;

CMetDoc*		ptMet;
CLocDoc*		ptLocDoc;
CPlaneDoc*		ptPlaneDoc;
CElevDoc*		ptElevDoc;
CElevArrayDoc*	ptElevArrayDoc;

CElevColorDoc*	ptSeaElevColorDoc;
CElevColorDoc*	ptFlightElevColorDoc;
CTrackDoc*		ptTrackDoc;
CFlightPlanDoc*	ptFlPlDoc;
CScanMapDoc*	ptScMpDoc;



BOOL	bMMText;
BOOL	bDemo;

/////////////////////////////////////////////////////////////////////////////
// CPfApp

BEGIN_MESSAGE_MAP(CPfApp, CWinApp)
	//{{AFX_MSG_MAP(CPfApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPfApp construction

CPfApp::CPfApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CPfApp object

CPfApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CPfApp initialization

/************************************************************************
 *  PF.cpp    		 A d d T o R e c e n t F i l e L i s t				*
 ************************************************************************/
void CPfApp::AddToRecentFileList( LPCTSTR lpszPathName )
{
short nDot;
CString szActExt, szExt;
CString szFullPath(lpszPathName);

nDot = szFullPath.Find ('.');
if (nDot >= 0)
	{			// do only append *.way files to Most Recent File List
	short nLen = szFullPath.GetLength() - nDot - 1;
	szActExt = szFullPath.Right(nLen);
	szExt.LoadString (IDS_WAYEXT);
	if (szExt.CompareNoCase (szActExt)==0)
		CWinApp::AddToRecentFileList (lpszPathName);
	}
}




/********************************************************************************
 *  PF.cpp				C o n v e r t E l e v A r r a y P a t h					*
 *  if binary data file is no longer stored at the old path,					*
 *  adjust path entry of all elev array descriptions to new installation path	*
 ********************************************************************************/
void CPfApp::ConvertElevArrayPath(CString szNewDescrPath, CString szNewDataPath)
{
	BOOL bChanged = FALSE;
    CElevArrayDoc*	ptElevArrayDoc;
    ptElevArrayDoc	= new CElevArrayDoc;  

    if (ptElevArrayDoc != NULL)
    {
        ptElevArrayDoc->SetPathName ((LPCTSTR)szNewDescrPath);
        ptElevArrayDoc->OnOpenDocument (ptElevArrayDoc->GetPathName());       

        for (int i=0; i<ptElevArrayDoc->GetElevCnt(); i++)
        {
            CElevArray* ptElevArray;
            if (ptElevArrayDoc->GetElevArrayPtr (i, &ptElevArray))
            {			// test if *.bin files are stored outside of preflight dir
                CString szOldPath = ptElevArray->GetPath();	// #include "D:\Orte\Elev\SOUTHAFRICA.BIN"
				if (!CInitDoc::FileExists(szOldPath))
				{								// if file doesn't exist, expect in in current elev-dir
					CString szFileExt = CInitDoc::GetFileFromPath(szOldPath);
					CString szNewPath = szNewDataPath + szFileExt;

					ptElevArray->SetPath(szNewPath);
					bChanged = TRUE;
				}
            }
        }

		if (bChanged)
		{			// if at least one elev file got a new path, save PFElev.ela
			BOOL bTempDemo = bDemo;
			bDemo = FALSE;		// temporarily allow save, even if demo-version
		    BOOL bConfirmSave = FALSE;
			ptElevArrayDoc->OnSaveDocument(ptElevArrayDoc->GetPathName(), bConfirmSave);
			bDemo = bTempDemo;
		}
        delete ptElevArrayDoc;
    }
}




/********************************************************************************
 *  PF.cpp				I m p o r t E l e v A r r a y							*
 *  Purpose: compare old elev array doc with new elev array doc and				*
 *	copy user added elevation array descriptions from old into new doc.			*
 *	while adding new entries, file path will be converted						*
 ********************************************************************************/
void CPfApp::ImportElevArray(CString szOldDescrPath, CString szNewDescrPath, 
                    CString szNewDataPath)
{
    BOOL bImported = FALSE;
    BOOL bFirstImport = TRUE;
    BOOL bCopyDataFiles = FALSE;
    BOOL bConfirmSave = FALSE;
    
    CElevArrayDoc*	ptOldElevArrayDoc;
    CElevArrayDoc*	ptNewElevArrayDoc;
    
    ptOldElevArrayDoc	= new CElevArrayDoc;  
    ptNewElevArrayDoc	= new CElevArrayDoc;  
    
    if (ptOldElevArrayDoc != NULL && ptNewElevArrayDoc != NULL)
    {

                                    // open old existing configuration file to import
        ptOldElevArrayDoc->SetReadOnly(TRUE);
        ptOldElevArrayDoc->SetPathName ((LPCTSTR)szOldDescrPath);
        ptOldElevArrayDoc->OnOpenDocument (ptOldElevArrayDoc->GetPathName());       

                                    // open new configuration file
        ptNewElevArrayDoc->SetPathName ((LPCTSTR)szNewDescrPath);
        ptNewElevArrayDoc->OnOpenDocument (ptNewElevArrayDoc->GetPathName());       


        for (int i=0; i<ptOldElevArrayDoc->GetElevCnt(); i++)
        {
            CElevArray* ptOldElevArray;
            if (ptOldElevArrayDoc->GetElevArrayPtr (i, &ptOldElevArray))
            {			// "Macintosh HD/Orte/Elev/afgh.bin"
                CString szOldPath = ptOldElevArray->GetPath();	
                                // name of elevarray to import, i.e. "afgh.bin"
                CString szOldFileExt = CInitDoc::GetFileFromPath(szOldPath);

                                // check if this elevation array is already present
                BOOL bPresent = FALSE;
                for (int j=0; j<ptNewElevArrayDoc->GetElevCnt() && !bPresent; j++)
                {
                    CElevArray* ptNewElevArray;
                    if (ptNewElevArrayDoc->GetElevArrayPtr (j, &ptNewElevArray))
                    {
                        CString szNewPath = ptNewElevArray->GetPath();
                        CString szNewFileExt = CInitDoc::GetFileFromPath(szNewPath);	// i.e.: "Faroe.bin"
                        bPresent = (szNewFileExt.CompareNoCase(szOldFileExt) == 0);
                    }
                }

                if (!bPresent)
                {     		// entry of old description file not member of new one 
                    if (bFirstImport)
                    {		// ask user, to copy the old *.bin files to new installation folder
                        if (AfxMessageBox(IDS_COPYELEVARRAY, MB_YESNO) == IDYES)
                        {	// IDS_COPYELEVARRAY "Mchten Sie Ihre Hhenprofile (*.bin) 
                                // in den ""elev""-Ordner der neuen PreFlight-Version kopieren?"
                            bCopyDataFiles = TRUE;
						}
                    
                        bFirstImport = FALSE;
                    }
                    
                    if (bCopyDataFiles)
                    {		
                        CString szNewPath = szNewDataPath + szOldFileExt;
                                 // copy BIN-file from old path into new elev path
						if (CopyFile ((LPCTSTR)szOldPath,// pointer to name of an existing file 
							(LPCTSTR)szNewPath,			// pointer to filename to copy to 
								FALSE))					//   BOOL bFailIfExists = FALSE
                        {	// add old elevation array description into new description file
                            CElevArray* ptElevArray = new CElevArray(*ptOldElevArray);
                            ptElevArray->SetPath(szNewPath);	// and change path to *.bin file
                            if (ptNewElevArrayDoc->AddSortedElevArrayPtr(ptElevArray))
                                bImported = TRUE;                                
                        }
                    }
                    else
                    {		// add old elevation array description into new description file
                        CElevArray* ptElevArray = new CElevArray(*ptOldElevArray);
                        if (ptNewElevArrayDoc->AddSortedElevArrayPtr(ptElevArray))
                            bImported = TRUE;
                    }
                }
            }
        }  // for all elev arrays in old configuration file

        if (bImported)		// new configuration file extended
            ptNewElevArrayDoc->OnSaveDocument(ptNewElevArrayDoc->GetPathName(), bConfirmSave);

        delete ptNewElevArrayDoc;
        delete ptOldElevArrayDoc;
    }	// pointers != NULL
}

/************************************************************************
 *  PF.cpp			C h e c k E l e v A r r a y P a t h		 			*
 *  Purpose: Adjust path of elev array to actual path of application 	*
 ************************************************************************/
void CPfApp::CheckElevArrayPath()
{
		                    // adjust path entries of elev array descriptions here...
    CString szElaFile;
    szElaFile.LoadString(IDS_ELEV_ARRAY_FILE);	// "PFelev.ela"

    CString szNewDescrPath(ptInit->GetActualPath());	// mac: GetApplicationPath
    szNewDescrPath += szElaFile;       
    CString szNewDataPath(ptInit->GetActualPath());
    szNewDataPath += "elev\\";
    this->ConvertElevArrayPath(szNewDescrPath, szNewDataPath);       
}

/************************************************************************
 *  PF.cpp			D o C h e c k I n i F i l e 			 			*
 ************************************************************************/
BOOL CPfApp::DoCheckIniFile(CInitDoc* ptInit, CString szIniFile)
{
    BOOL bInitAvailable = ptInit->OnOpenDocument(szIniFile);
 
    if (bInitAvailable)
    {
                    // regular full version has PF.ini with undefined serial number
        CString szSerNum (ptInit->GetSerNum());
        if (szSerNum.Compare("******") == 0)	// if serial number = "******"
        {			
            if (!bDemo)		// installing full version
            {               // => ask for name, loc and serial number only
				CPersonalDlg GetNamesDlg(NULL, ptInit);
				if(GetNamesDlg.DoModal() == IDOK)	// stores result in ptInit
				{			// use entered names and ser num to store in PF.ini
					bInitAvailable = ptInit->OnSaveDocument (szIniFile);                
				}
				else		// user has aborted installation dlg
				{			// bad ser num
					bInitAvailable = false;
				}
			}
		}
    }
    else	// for update <--------------------------
    {		// update version has no PF.ini file
        BOOL bUseOldData = FALSE;	
        BOOL bUpdateWithoutOldData = FALSE;
        BOOL bNewLocDataReceived = FALSE;
        
        // now ask user, whether he likes to use old data
        if (AfxMessageBox(IDS_COPYOLDDATA, MB_YESNO) == IDYES)
        {	// IDS_COPYOLDDATA "Mchten Sie Daten von Ihrer letzten PreFlight-Version bernehmen?"
				// ask user for old preflight-path
            CString szOldIniPath;
            bUseOldData = ptInit->SelectOldPath(NULL, &szOldIniPath);

            if (bUseOldData)
            {
                CInitDoc OldIni;
                OldIni.SetPathName (szOldIniPath);	// ini file of latest pf.exe version
                if (OldIni.OnOpenDocument(szOldIniPath))
                {                                        // put old name and loc into actual doc
                    ptInit->SetCustName (OldIni.GetCustName());
                    ptInit->SetCustLoc (OldIni.GetCustLoc());
                    
                                                    // copy plane data here...
                    CString szPlaneFileName;
                    szPlaneFileName.LoadString (IDS_PLANE_FILE);
                    CString szPlaneSrc(ptInit->GetOldActualPath());
                    szPlaneSrc += szPlaneFileName;
                    CString szPlaneDst(ptInit->GetActualPath());	// mac: GetApplicationPath
                    szPlaneDst += szPlaneFileName;
													// mac: CFile::Copy(szPlaneSrc, szPlaneDst);
					CopyFile ((LPCTSTR)szPlaneSrc,	// pointer to name of an existing file 
							(LPCTSTR)szPlaneDst,	// pointer to filename to copy to 
								FALSE);				//   BOOL bFailIfExists = FALSE

					
                                                        // copy loc data here...
                    CFileFind finder;
                    CString szExt("krd");
					CString szSearchPath = ptInit->GetOldActualPath() + "*." + szExt;
                    BOOL bWorking = finder.FindFile((LPCTSTR)szSearchPath);
                    while (bWorking)
                    {
                        bWorking = finder.FindNextFile();
                        CString szFile = finder.GetFileName();		// Germany.krd
                        CString szFoundExt = CInitDoc::GetExtFromPath(szFile);		// krd
                        if (szFoundExt.CompareNoCase(szExt) == 0)
                        {
                            CString szLocSrc(finder.GetFilePath());
                            CString szLocDst(ptInit->GetActualPath());	// mac: GetApplicationPath
                            szLocDst += szFile;
															// mac: CFile::Copy(szLocSrc, szLocDst);
							CopyFile ((LPCTSTR)szLocSrc,	// pointer to name of an existing file 
							(LPCTSTR)szLocDst,				// pointer to filename to copy to 
								FALSE);						//   BOOL bFailIfExists = FALSE

                        }
                    }


								// copy old elev array descriptions into new PFelev.ela
                    CString szElaFile;
                    szElaFile.LoadString(IDS_ELEV_ARRAY_FILE);	// "PFelev.ela"
                    CString szOldDescrPath(ptInit->GetOldActualPath());
                    szOldDescrPath += szElaFile;  

					CString szNewDescrPath(ptInit->GetActualPath());	// mac: GetApplicationPath
                    szNewDescrPath += szElaFile;       
                    CString szNewDataPath(ptInit->GetActualPath());
                    szNewDataPath += "elev\\";
                    ImportElevArray(szOldDescrPath, szNewDescrPath, szNewDataPath); 

                                                  // copy (icao) elev data here...
                    CString szElevFile;
                    szElevFile.LoadString(IDS_ELEV_FILE);	// "PFelev.lev"
                    CString szElevSrc(ptInit->GetOldActualPath());
                    szElevSrc += szElevFile;  
                    CString szElevDst(ptInit->GetActualPath());
                    szElevDst += szElevFile;         
													// mac: CFile::Copy(szElevSrc, szElevDst, 'PFEl', 'Prfl');
					CopyFile ((LPCTSTR)szElevSrc,	// pointer to name of an existing file 
							(LPCTSTR)szElevDst,				// pointer to filename to copy to 
								FALSE);						//   BOOL bFailIfExists = FALSE

                                                    
                                                    // copy sea elev color table here...
                    CString szSeaColTab;
                    szSeaColTab.LoadString(IDS_SEA_ELEV_FILE);	// "SeaElev.ctb"
                    CString szSeaColTabSrc(ptInit->GetOldActualPath());
                    szSeaColTabSrc += szSeaColTab;  
                    CString szSeaColTabDst(ptInit->GetActualPath());
                    szSeaColTabDst += szSeaColTab;     
													// mac: CFile::Copy(szSeaColTabSrc, szSeaColTabDst, 'PFct', 'Prfl');
 					CopyFile ((LPCTSTR)szSeaColTabSrc,	// pointer to name of an existing file 
							(LPCTSTR)szSeaColTabDst,	// pointer to filename to copy to 
								FALSE);					//   BOOL bFailIfExists = FALSE

					
                                                    // copy flight elev color table here...
                    CString szFlightColTab;
                    szFlightColTab.LoadString(IDS_FLIGHT_ELEV_FILE);	// "FlightElev.ctb"
                    CString szFlightColTabSrc(ptInit->GetOldActualPath());
                    szFlightColTabSrc += szFlightColTab;  
                    CString szFlightColTabDst(ptInit->GetActualPath());
                    szFlightColTabDst += szFlightColTab;     
														// mac: CFile::Copy(szFlightColTabSrc, szFlightColTabDst, 'PFct', 'Prfl');
 					CopyFile ((LPCTSTR)szFlightColTabSrc,	// pointer to name of an existing file 
							(LPCTSTR)szFlightColTabDst,	// pointer to filename to copy to 
								FALSE);					//   BOOL bFailIfExists = FALSE

                }
            }
        }
        else
        {			// user doesn't like to copy old data
            bUpdateWithoutOldData = TRUE;
											// reset name, loc and sernum
            ptInit->SetCustName ("");
			ptInit->SetCustLoc ("");
            ptInit->SetSerNum ("******");
		}
    
                                    // => ask for (name, loc and) serial number
        CPersonalDlg GetNamesDlg(NULL, ptInit);
        if(GetNamesDlg.DoModal() == IDOK)	// stores result in ptInit
        {			// create PF.ini
                    // if location entered was keywoard, create new base PF.ini
            CString szLoc = ptInit->GetCustLoc();
            if (szLoc.Compare ("Borntuchen") == 0)
            {		// create new ini file
                ptInit->SetCustName ("Your Name");
                ptInit->SetCustLoc ("Your City");
           //     ptInit->SetCustName ("Ihr Name");
           //     ptInit->SetCustLoc ("Ihr Wohnort");
                ptInit->SetSerNum ("******");
				ptInit->SetVers (0);			// store name, loc and sernum only
                ptInit->OnSaveDocument (szIniFile);	// don't continue, let bInitAvailable=FALSE
                AfxMessageBox ("Ini-File created!!");
            }
            else
            {		// use entered (name, loc and) serial number to store in PF.ini
                bInitAvailable = ptInit->OnSaveDocument (szIniFile);   
            }
        }
        
        if (bInitAvailable)
        {
                                    // now ask user, whether he likes to use old data
			if (AfxMessageBox(IDS_HAVENEWLOC, MB_YESNO) == IDYES)
            {	// IDS_HAVENEWLOC "Haben Sie mit diesem Update neue Ortsdaten erhalten?"
                bNewLocDataReceived = TRUE;
            }
    
            if (bUpdateWithoutOldData || bNewLocDataReceived)
            {		// user has to copy his *.krd files manually into ./Contents/MacOS/*.krd 
                //"Whlen Sie ""Ortsdaten - Berichtigen"", bevor Sie mit PreFlight arbeiten!";
                AfxMessageBox(IDS_DO_UPDATE_LOC);
            }
        }
    }
    
    return bInitAvailable;
}


/************************************************************************
 *  PF.cpp    				I n i t I n s t a n c e						*
 ************************************************************************/
BOOL CPfApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.


#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Softwareentwicklung Heinz Luedert"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	bMMText		= FALSE;
	bDemo		= FALSE;			   /* flag is TRUE if demo mode is active	*/

    ptInit 			= new CInitDoc; 
    ptLocDoc		= new CLocDoc;  
    ptPlaneDoc		= new CPlaneDoc;  
    ptElevDoc		= new CElevDoc;  
    ptElevArrayDoc	= new CElevArrayDoc; 

	ptSeaElevColorDoc		= new CElevColorDoc(CElevColorDoc::SEA_BASED);
	ptFlightElevColorDoc	= new CElevColorDoc(CElevColorDoc::FLIGHT_BASED);

	CString szScMpFile;
	szScMpFile.LoadString(IDS_SCANNED_MAP_FILE);

	ptMet 			= new CMetDoc;
   	ptTrackDoc		= new CTrackDoc;
	ptFlPlDoc		= new CFlightPlanDoc ("FlPlDoc.ini");
	ptScMpDoc		= new CScanMapDoc (szScMpFile);

	CString szIniFile = ptInit->GetPathName();

	CheckElevArrayPath();
    BOOL bInitAvailable = this->DoCheckIniFile(ptInit, szIniFile);    
    
    if (bInitAvailable) 
 		{
	    CInitDlg InitDlg(NULL, ptInit, ptLocDoc, ptPlaneDoc, ptElevDoc, ptElevArrayDoc, 
			ptSeaElevColorDoc, ptFlightElevColorDoc); 
	    InitDlg.DoModal();  	
	   	}	
    else{						// stop application here
        CString szText;
        szText.LoadString (IDS_CANNOT_START);
        AfxMessageBox ((LPCSTR)szText); 
        delete ptInit;
        delete ptLocDoc;  
        delete ptPlaneDoc;  
		delete ptElevDoc;
		delete ptElevArrayDoc;

		delete ptSeaElevColorDoc;
		delete ptFlightElevColorDoc;

        delete ptMet;
		delete ptTrackDoc;
		delete ptFlPlDoc;
		delete ptScMpDoc;
        exit(0);
        }
         
    ptFontTool 	= ptInit->GetFontPtr();
    ptDim 		= ptInit->GetDimPtr();
    ptLoad		= ptInit->GetLoadPtr();
    ptCalc		= ptInit->GetCalcPtr();
    ptAppend	= ptInit->GetAppendixPtr();
	
	if (CInitDoc::FileExists(ptFlPlDoc->GetFullPath()))
	 	ptFlPlDoc->OnOpenDocument (ptFlPlDoc->GetFullPath());

	if (CInitDoc::FileExists(ptScMpDoc->GetPathName()))
	 	ptScMpDoc->OnOpenDocument (ptScMpDoc->GetPathName());


	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_WAYFRAME,
		RUNTIME_CLASS(CWayDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CCourseView));	 // initializing View
	AddDocTemplate(pDocTemplate);

// add second CSingleDocTemplate here if necessary
//	pDocTemplate = new CSingleDocTemplate(
//		IDR_WAYFRAME,				   // IDR_TRACKFRAME
//		RUNTIME_CLASS(CTrackDoc),
//		RUNTIME_CLASS(CMainFrame),     // main SDI frame window
//		RUNTIME_CLASS(CTrackView));
//	AddDocTemplate(pDocTemplate);


	// Enable DDE Execute open
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();

	ptInit->SetMainWndPtr((CFrameWnd*)m_pMainWnd);

	// begin for switch btn views:
      CView* pActiveView = ((CFrameWnd*) m_pMainWnd)->GetActiveView();
      m_pOldView = pActiveView;
      m_pCourseView = (CView*) new CCourseView;
	  m_pMapView    = (CView*) new CRouteView;
	  m_pScanMapView= (CView*) new CScanMapView;
	  m_pElevView   = (CView*) new CElevView;
	  m_pFuelView   = (CView*) new CFuelView;
	  m_pFlPlView   = (CView*) new CFlPlView;
	  m_pWayView    = (CView*) new CWayView;
	  m_pPlaneView	= (CView*) new CPlaneView;
	  m_pLocView	= (CView*) new CLocView;

 	  m_pTrackView	= (CView*) new CTrackView;
 	  m_pAltView	= (CView*) new CAltView;
 	  m_pSpeedView	= (CView*) new CSpeedView;


		if (ptScMpDoc != NULL)
		{
			ptScMpDoc->SetViewPtr ((CScanMapView*)m_pScanMapView);

			short nMapInd = ptScMpDoc->GetActMapIndex();
			if (nMapInd >= 0)							// load last used map
	 			ptScMpDoc->ActivateMap (nMapInd);	// needs valid m_ptScMpView!!
		}


	  CDocument* pCurrentDoc =
         ((CFrameWnd*) m_pMainWnd)->GetActiveDocument();

      // Initialize a CCreateContext to point to the active document.
      // With this context, the new view is added to the document
      // when the view is created in CView::OnCreate().
      CCreateContext newContext;
      newContext.m_pNewViewClass = NULL;
      newContext.m_pNewDocTemplate = NULL;
      newContext.m_pLastView = NULL;
      newContext.m_pCurrentFrame = NULL;
      newContext.m_pCurrentDoc = pCurrentDoc;

      // The ID of the initial active view is AFX_IDW_PANE_FIRST.
      // Incrementing this value by one for additional views works
      // in the standard document/view case but the technique cannot
      // be extended for the CSplitterWnd case.
      UINT viewID = AFX_IDW_PANE_FIRST + 1;
      CRect rect(0, 0, 0, 0); // gets resized later

      // Create the new view. In this example, the view persists for
      // the life of the application. The application automatically
      // deletes the view when the application is closed.
      m_pCourseView->Create(NULL, "Course View", WS_CHILD, rect,
                              m_pMainWnd, viewID, &newContext);

      viewID = AFX_IDW_PANE_FIRST + 2;
	  m_pMapView->Create(NULL, "Map View", WS_CHILD, rect,
	                             m_pMainWnd, viewID, &newContext);

	  viewID = AFX_IDW_PANE_FIRST + 3;
	  m_pElevView->Create(NULL, "Elev View", WS_CHILD, rect,
                              m_pMainWnd, viewID, &newContext);

	  viewID = AFX_IDW_PANE_FIRST + 4;
      m_pFuelView->Create(NULL, "Fuel View", WS_CHILD, rect,
                              m_pMainWnd, viewID, &newContext);

	  viewID = AFX_IDW_PANE_FIRST + 5;
      m_pFlPlView->Create(NULL, "Flight Plan View", WS_CHILD, rect,
                              m_pMainWnd, viewID, &newContext);

	  viewID = AFX_IDW_PANE_FIRST + 6;
      m_pWayView->Create(NULL, "Way View", WS_CHILD, rect,
                             m_pMainWnd, viewID, &newContext);

	  viewID = AFX_IDW_PANE_FIRST + 7;
      m_pPlaneView->Create(NULL, "Plane View", WS_CHILD, rect,
                              m_pMainWnd, viewID, &newContext);

	  viewID = AFX_IDW_PANE_FIRST + 8;
      m_pTrackView->Create(NULL, "Track View", WS_CHILD, rect,
                              m_pMainWnd, viewID, &newContext);

	  viewID = AFX_IDW_PANE_FIRST + 9;
      m_pAltView->Create(NULL, "Alt View", WS_CHILD, rect,
                             m_pMainWnd, viewID, &newContext);

	  viewID = AFX_IDW_PANE_FIRST + 10;
      m_pSpeedView->Create(NULL, "Speed View", WS_CHILD, rect,
                             m_pMainWnd, viewID, &newContext);

      viewID = AFX_IDW_PANE_FIRST + 11;
      m_pScanMapView->Create(NULL, "Scan Map View", WS_CHILD, rect,
                             m_pMainWnd, viewID, &newContext);

      viewID = AFX_IDW_PANE_FIRST + 12;
      m_pLocView->Create(NULL, "Loc View", WS_CHILD, rect,
                              m_pMainWnd, viewID, &newContext);


      // When a document template creates a view, the WM_INITIALUPDATE
      // message is sent automatically. However, this code must
      // explicitly send the message, as follows.
   //   m_pWayView->SendMessage(WM_INITIALUPDATE, 0, 0);
		m_pMapView->SendMessage(WM_INITIALUPDATE, 0, 0);
		m_pScanMapView->SendMessage(WM_INITIALUPDATE, 0, 0);
		m_pElevView->SendMessage(WM_INITIALUPDATE, 0, 0);

		m_pTrackView->SendMessage(WM_INITIALUPDATE, 0, 0);
		m_pAltView->SendMessage(WM_INITIALUPDATE, 0, 0);
		m_pSpeedView->SendMessage(WM_INITIALUPDATE, 0, 0);

	// end for switch btn views:

	  return TRUE;
}

/************************************************************************
 *  PF.cpp    		 		S w i t c h V i e w 						*
 ************************************************************************/
CView* CPfApp::SwitchView(CView* pNewView)
{
CView* pActiveView = ((CFrameWnd*) m_pMainWnd)->GetActiveView();

// Exchange view window ID's so RecalcLayout() works.
#ifndef _WIN32
	UINT temp = ::GetWindowWord(pActiveView->m_hWnd, GWW_ID);
	::SetWindowWord(pActiveView->m_hWnd, GWW_ID,
					::GetWindowWord(pNewView->m_hWnd, GWW_ID));
	::SetWindowWord(pNewView->m_hWnd, GWW_ID, temp);
#else
	UINT temp = ::GetWindowLong(pActiveView->m_hWnd, GWL_ID);
	::SetWindowLong(pActiveView->m_hWnd, GWL_ID,
					::GetWindowLong(pNewView->m_hWnd, GWL_ID));
	::SetWindowLong(pNewView->m_hWnd, GWL_ID, temp);
#endif

pActiveView->ShowWindow(SW_HIDE);
pNewView->ShowWindow(SW_SHOW);
((CFrameWnd*) m_pMainWnd)->SetActiveView(pNewView);
((CFrameWnd*) m_pMainWnd)->RecalcLayout();
pNewView->Invalidate();
return pActiveView;
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CPfApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}



/////////////////////////////////////////////////////////////////////////////
// CPfApp commands

/************************************************************************
 *  PF.cpp    	    		E x i t I n s t a n c e						*
 ************************************************************************/
int CPfApp::ExitInstance() 
{
	// TODO: Add your specialized code here and/or call the base class
CString szIniFile = ptInit->GetPathName();
ptInit->OnSaveDocument(szIniFile); 
ptFlPlDoc->OnSaveDocument (ptFlPlDoc->GetFullPath());
ptScMpDoc->OnSaveDocument (ptScMpDoc->GetPathName());


delete ptMet;    
delete ptLocDoc;  
delete ptPlaneDoc;
delete ptElevDoc;
delete ptElevArrayDoc;

delete ptSeaElevColorDoc;
delete ptFlightElevColorDoc;

delete ptTrackDoc;
delete ptFlPlDoc;
delete ptScMpDoc;
delete ptInit;

// to detect memory leaks, remove comment from next line:
//_CrtDumpMemoryLeaks();

	
	return CWinApp::ExitInstance();
}

