// Pf.h : main header file for the PreFlight application
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#if !defined(AFX_PF30_H__587F6A07_F1A8_11D1_BFB4_AFAC529C17B9__INCLUDED_)
#define AFX_PF30_H__587F6A07_F1A8_11D1_BFB4_AFAC529C17B9__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "..\CppTools\Defines.h"
#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CPfApp:
// See Pf30.cpp for the implementation of this class
//

#define pi 3.1415926

class CInitDoc;
class CPfApp : public CWinApp
{
public:
	CView* m_pOldView;

	CView* m_pCourseView;
	CView* m_pMapView;
	CView* m_pElevView;
	CView* m_pFuelView;
	CView* m_pFlPlView;
	CView* m_pWayView;
	CView* m_pPlaneView;
	CView* m_pLocView;
	CView* m_pScanMapView;

	CView* m_pTrackView;
	CView* m_pAltView;
	CView* m_pSpeedView;

private:
	void CheckElevArrayPath();
	void ConvertElevArrayPath(CString szNewDescrPath, CString szNewDataPath);
	void ImportElevArray(CString szOldDescrPath, CString szNewDescrPath, 
                    CString szNewDataPath);

	BOOL DoCheckIniFile(CInitDoc* ptInit, CString szIniFile);

public:
	CView* SwitchView (CView* pNewView);
	CView* GetScMpViewPtr() { return m_pScanMapView; }
	CPfApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPfApp)
	public:
	virtual void AddToRecentFileList(LPCTSTR lpszPathName);
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(CPfApp)
	afx_msg void OnAppAbout();
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PF30_H__587F6A07_F1A8_11D1_BFB4_AFAC529C17B9__INCLUDED_)
