// PlAltDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "DimDoc.h"  
#include "WayPoint.h"       
#include "PlAltDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc* ptDim;

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPlAltDlg 


CPlAltDlg::CPlAltDlg(CWnd* pParent, CWayPoint* ptWpt)
	: CDlgTool(CPlAltDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPlAltDlg)
	m_szName = _T("");
	m_lPlannedAlt = -1;
	m_nAltDim = 0;
	//}}AFX_DATA_INIT

m_ptWpt		= ptWpt;

this->SetPlAltBoxData(m_ptWpt);
}

/************************************************************************
 *  PlAltDlg.cpp	  	S e t P l A l t B o x D a t a					*
 ************************************************************************/
void CPlAltDlg::SetPlAltBoxData (CWayPoint* ptWayPt)
{  
m_nAltDim = ptDim->GetPUIndex (ALTITUDE, ptWayPt->GetAltDim());
m_szName 		= ptWayPt->GetNameForRte();
m_lPlannedAlt	= ptWayPt->GetPlannedAlt();
}	

/************************************************************************
 *  PlAltDlg.cpp	  		 G e t P l A l t B o x D a t a				*
 ************************************************************************/
BOOL CPlAltDlg::GetPlAltBoxData (CWayPoint* ptWayPt)
{  
BOOL	bOK = FALSE;

bOK = (m_szName.GetLength() > 0);

if (bOK)
	{
	ptWayPt->SetName (m_szName);
	ptWayPt->SetAltDim(ptDim->GetPUDim (ALTITUDE, m_nAltDim));
	ptWayPt->SetPlannedAlt (m_lPlannedAlt);
	}

return bOK;
}	


void CPlAltDlg::DoDataExchange(CDataExchange* pDX)
{
this->ActivateDimGroups();
 
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPlAltDlg)
	DDX_Text(pDX, ID_PANAME, m_szName);
	DDV_MaxChars(pDX, m_szName, 17);
	DDX_Alt(pDX, ID_PAPLALT, m_lPlannedAlt);
	DDX_CBIndex(pDX, ID_PAALTDIM, m_nAltDim);
	//}}AFX_DATA_MAP

if (pDX->m_bSaveAndValidate)
	{        
	this->GetPlAltBoxData (m_ptWpt);     
    }
}


BEGIN_MESSAGE_MAP(CPlAltDlg, CDlgTool)
	//{{AFX_MSG_MAP(CPlAltDlg)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CPlAltDlg 

BOOL CPlAltDlg::OnInitDialog() 
{
           // value DlgID,	dim DlgID
this->AddDimGroup (ID_PAPLALT, ID_PAALTDIM);

this->FillDimPU (ID_PAALTDIM, ALTITUDE);

	// TODO: Zustzliche Initialisierung hier einfgen
	CDlgTool::OnInitDialog();
	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

/************************************************************************
 *  PlAltDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CPlAltDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
