// PlPlnDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "PlaneDoc.h"
#include "PlPlnDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPlaneFlPlDlg 


CPlaneFlPlDlg::CPlaneFlPlDlg(CWnd* pParent, CPlane* ptPlane)
	: CDialog(CPlaneFlPlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPlaneFlPlDlg)
	m_szEquipment = _T("");
	m_bEmRadioELBA = FALSE;
	m_bEmRadioUHF = FALSE;
	m_bEmRadioVHF = FALSE;
	m_szIdent = _T("");
	m_szPlaneCol = _T("");
	m_szPlaneType = _T("");
	m_nSSR = -1;
	//}}AFX_DATA_INIT

m_ptPlane = ptPlane;
m_szEquipment = "N";
m_szPlaneType.LoadString (IDS_ZZZZ);
}

/************************************************************************
 *  PlPlnDlg.cpp	  		 	S e t D a t a  							*
 ************************************************************************/
void CPlaneFlPlDlg::SetData (CPlane* ptPlane)
{  
m_szIdent		= ptPlane->GetIdent();
m_szPlaneType	= ptPlane->GetType();
m_szEquipment	= ptPlane->GetEquipment();
m_szPlaneCol	= ptPlane->GetColor();

m_nSSR			= (short)ptPlane->GetSSRType ();		
m_bEmRadioUHF	= ptPlane->HasEmRadioUHF (); 
m_bEmRadioVHF	= ptPlane->HasEmRadioVHF (); 
m_bEmRadioELBA	= ptPlane->HasEmRadioELBA ();
}	

/************************************************************************
 *  PlPlnDlg.cpp	  			G e t D a t a  							*
 ************************************************************************/
void CPlaneFlPlDlg::GetData (CPlane* ptPlane)
{            
ptPlane->SetIdent(m_szIdent);           	
ptPlane->SetType(m_szPlaneType);            	
ptPlane->SetEquipment(m_szEquipment);       	
ptPlane->SetColor(m_szPlaneCol);           	
                               	
ptPlane->SetSSRType ((SSRTYPE)m_nSSR);	
ptPlane->SetEmRadioUHF (m_bEmRadioUHF);     	
ptPlane->SetEmRadioVHF (m_bEmRadioVHF);     	
ptPlane->SetEmRadioELBA(m_bEmRadioELBA);    	
}	



void CPlaneFlPlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPlaneFlPlDlg)
	DDX_Text(pDX, IDC_PP_EQUIPMENT, m_szEquipment);
	DDV_MaxChars(pDX, m_szEquipment, 6);
	DDX_Check(pDX, IDC_PP_ER_ELBA, m_bEmRadioELBA);
	DDX_Check(pDX, IDC_PP_ER_UHF, m_bEmRadioUHF);
	DDX_Check(pDX, IDC_PP_ER_VHF, m_bEmRadioVHF);
	DDX_Text(pDX, IDC_PP_IDENT, m_szIdent);
	DDV_MaxChars(pDX, m_szIdent, 7);
	DDX_Text(pDX, IDC_PP_PLANECOLOR, m_szPlaneCol);
	DDV_MaxChars(pDX, m_szPlaneCol, 128);
	DDX_Text(pDX, IDC_PP_PLANETYPE, m_szPlaneType);
	DDV_MaxChars(pDX, m_szPlaneType, 4);
	DDX_CBIndex(pDX, IDC_PP_SSR, m_nSSR);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPlaneFlPlDlg, CDialog)
	//{{AFX_MSG_MAP(CPlaneFlPlDlg)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CPlaneFlPlDlg 

/************************************************************************
 *  PlPlnDlg.cpp	  			O n I n i t D i a l o g					*
 ************************************************************************/
BOOL CPlaneFlPlDlg::OnInitDialog() 
{
this->SetData (m_ptPlane);

	CDialog::OnInitDialog();
	
	// TODO: Zustzliche Initialisierung hier einfgen
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

/************************************************************************
 *  PlPlnDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CPlaneFlPlDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
